/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.providers.ElementTreeContentProviderUIFolder;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementTreeContentProvider
implements ITreeContentProvider {
    private static final String PKG_NAME_CONTENT = "Content";
    private static final String PKG_NAME_CORE_CONTENT = "CoreContent";
    private static final String PKG_NAME_CATEGORIES = "Categories";
    private static final String PKG_NAME_DISCIPLINES = "Disciplines";
    private static final String PKG_NAME_DOMAINS = "Domains";
    private static final String PKG_NAME_WORK_PRODUCT_TYPES = "WP Types";
    private static final String PKG_NAME_ROLESETS = "RoleSets";
    private static final String PKG_NAME_TOOLS = "Tools";
    private static final String PKG_NAME_CUSTOM_CATEGORIES = "CustomCategories";
    private static final String PKG_NAME_CAPABILITY_PATTERNS = "CapabilityPatterns";
    private static final String PKG_NAME_DELIVERY_PROCESSES = "DeliveryProcesses";
    private static final String METHOD_CONTENT = LibraryUIResources.elementTCProvider_methodContent;
    private static final String CONTENT_PACKAGES = LibraryUIResources.elementTCProvider_contentPackages;
    private static final String STANDARD_CATEGORIES = LibraryUIResources.elementTCProvider_standardCategories;
    private static final String DISCIPLINES = LibraryUIResources.elementTCProvider_disciplines;
    private static final String DOMAINS = LibraryUIResources.elementTCProvider_domains;
    private static final String WORK_PRODUCT_TYPES = LibraryUIResources.elementTCProvider_workProductTypes;
    private static final String ROLESETS = LibraryUIResources.elementTCProvider_roleSets;
    private static final String TOOLS = LibraryUIResources.elementTCProvider_tools;
    private static final String CUSTOM_CATEGORIES = LibraryUIResources.elementTCProvider_customCategories;
    private static final String PROCESSES = LibraryUIResources.elementTCProvider_processes;
    private static final String CAPABILITY_PATTERNS = LibraryUIResources.elementTCProvider_capabilityPatterns;
    private static final String DELIVERY_PROCESSES = LibraryUIResources.elementTCProvider_deliveryProcesses;
    private static final Object[] EMPTY_LIST = new Object[0];
    private TreeViewer treeViewer;
    private Map<Object, Set<Object>> elementMap = new HashMap<Object, Set<Object>>();

    public Object[] getChildren(Object parentElement) {
        if (this.elementMap == null) {
            return EMPTY_LIST;
        }
        Set<Object> children = this.elementMap.get(parentElement);
        if (children == null) {
            return EMPTY_LIST;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        ProcessPackage processPackage;
        if (element instanceof MethodPlugin) {
            return null;
        }
        if (element instanceof ElementTreeContentProviderUIFolder) {
            return ((ElementTreeContentProviderUIFolder)element).getParent();
        }
        if (element instanceof ProcessPackage) {
            ProcessPackage processPackage2 = (ProcessPackage)element;
            EObject parent = processPackage2.eContainer();
            if (parent instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)parent;
                return processComponent.getProcess();
            }
            return parent;
        }
        if (element instanceof MethodPackage) {
            MethodPackage methodPackage = (MethodPackage)element;
            EObject parent = methodPackage.eContainer();
            if (parent instanceof MethodPlugin) {
                return parent;
            }
            MethodPackage parentPackage = methodPackage.getParentPackage();
            return parentPackage;
        }
        if (element instanceof Artifact) {
            Artifact artifact = (Artifact)element;
            Artifact containerArtifact = artifact.getContainerArtifact();
            if (containerArtifact != null) {
                return containerArtifact;
            }
            return UmaUtil.getContentPackage((EObject)artifact);
        }
        if (element instanceof Practice) {
            Practice practice = (Practice)element;
            return practice.getContainer();
        }
        if (element instanceof Discipline) {
            Discipline discipline = (Discipline)element;
            return discipline.getContainer();
        }
        if (element instanceof Domain) {
            Domain domain = (Domain)element;
            return domain.getContainer();
        }
        if (element instanceof ContentElement) {
            return UmaUtil.getContentPackage((EObject)((ContentElement)element));
        }
        if (element instanceof Process) {
            Process process = (Process)element;
            ProcessPackage parent = (ProcessPackage)process.eContainer();
            if (parent != null) {
                return parent.eContainer();
            }
        } else if (element instanceof Activity) {
            ProcessPackage parentPackage;
            ProcessPackage processPackage3 = UmaUtil.getProcessPackage((EObject)((ProcessElement)element));
            if (processPackage3 != null && (parentPackage = (ProcessPackage)processPackage3.getParentPackage()) != null) {
                if (parentPackage instanceof ProcessComponent) {
                    ProcessComponent processComponent = (ProcessComponent)parentPackage;
                    return processComponent.getProcess();
                }
                List processElements = parentPackage.getProcessElements();
                for (ProcessElement processElement : processElements) {
                    if (!(processElement instanceof Activity) || !processElement.getName().equals(parentPackage.getName())) continue;
                    return processElement;
                }
            }
        } else if (element instanceof ProcessElement && (processPackage = UmaUtil.getProcessPackage((EObject)((ProcessElement)element))) != null) {
            if (processPackage instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)processPackage;
                return processComponent.getProcess();
            }
            List processElements = processPackage.getProcessElements();
            for (ProcessElement processElement : processElements) {
                if (!(processElement instanceof Activity) || !processElement.getName().equals(processPackage.getName())) continue;
                return processElement;
            }
            return processPackage;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void clear() {
        this.treeViewer.refresh();
    }

    public void dispose() {
    }

    public abstract Object getContentSource();

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.treeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.treeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.getContentSource(), child) && refreshViewer) {
            this.treeViewer.add(this.getContentSource(), child);
        }
    }

    protected boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.elementMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.elementMap.put(parent, children);
        }
        return children.add(child);
    }

    protected void replace(Object parent, Object child, Object newChild) {
        this.insert(newChild, false);
        this.elementMap.put(newChild, this.elementMap.get(child));
        this.elementMap.remove(child);
        Set<Object> children = this.elementMap.get(parent);
        children.remove(child);
    }

    protected abstract void remove(Object var1, boolean var2);

    protected void removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.elementMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    protected void insertUIFolders(MethodPlugin element) {
        ElementTreeContentProviderUIFolder methodContentFolder = new ElementTreeContentProviderUIFolder(METHOD_CONTENT, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/Content")), element);
        ElementTreeContentProviderUIFolder processesFolder = new ElementTreeContentProviderUIFolder(PROCESSES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/Processes")), element);
        Object[] methodPackages = this.getChildren(element);
        int j = 0;
        while (j < methodPackages.length) {
            Object methodPackage = methodPackages[j];
            if (methodPackage instanceof ContentPackage && ((ContentPackage)methodPackage).getName().equals(PKG_NAME_CONTENT)) {
                Object[] packages = this.getChildren(methodPackage);
                int k = 0;
                while (k < packages.length) {
                    Object pkg = packages[k];
                    if (pkg instanceof ContentPackage) {
                        if (((ContentPackage)pkg).getName().equals(PKG_NAME_CORE_CONTENT)) {
                            this.replace(element, pkg, new ElementTreeContentProviderUIFolder(CONTENT_PACKAGES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/MethodPackages")), methodContentFolder));
                        } else if (((ContentPackage)pkg).getName().equals(PKG_NAME_CATEGORIES)) {
                            ElementTreeContentProviderUIFolder standardCategoriesFolder = new ElementTreeContentProviderUIFolder(STANDARD_CATEGORIES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/StandardCategories")), methodContentFolder);
                            ElementTreeContentProviderUIFolder customCategoriesFolder = new ElementTreeContentProviderUIFolder(CUSTOM_CATEGORIES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/CustomCategories")), methodContentFolder);
                            Object[] contentPackages = this.getChildren(pkg);
                            int l = 0;
                            while (l < contentPackages.length) {
                                Object contentPackage = contentPackages[l];
                                if (contentPackage instanceof ContentPackage) {
                                    String pkgName = ((ContentPackage)contentPackage).getName();
                                    if (pkgName.equals(PKG_NAME_CUSTOM_CATEGORIES)) {
                                        this.insert(customCategoriesFolder, false);
                                        this.elementMap.put(customCategoriesFolder, this.elementMap.get(contentPackage));
                                    } else if (pkgName.equals(PKG_NAME_DISCIPLINES)) {
                                        this.insert(standardCategoriesFolder, false);
                                        this.replace(element, contentPackage, new ElementTreeContentProviderUIFolder(DISCIPLINES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/Disciplines")), standardCategoriesFolder));
                                    } else if (pkgName.equals(PKG_NAME_DOMAINS)) {
                                        this.insert(standardCategoriesFolder, false);
                                        this.replace(element, contentPackage, new ElementTreeContentProviderUIFolder(DOMAINS, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/Domains")), standardCategoriesFolder));
                                    } else if (pkgName.equals(PKG_NAME_WORK_PRODUCT_TYPES)) {
                                        this.insert(standardCategoriesFolder, false);
                                        this.replace(element, contentPackage, new ElementTreeContentProviderUIFolder(WORK_PRODUCT_TYPES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProductTypes")), standardCategoriesFolder));
                                    } else if (pkgName.equals(PKG_NAME_ROLESETS)) {
                                        this.insert(standardCategoriesFolder, false);
                                        this.replace(element, contentPackage, new ElementTreeContentProviderUIFolder(ROLESETS, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles")), standardCategoriesFolder));
                                    } else if (pkgName.equals(PKG_NAME_TOOLS)) {
                                        this.insert(standardCategoriesFolder, false);
                                        this.replace(element, contentPackage, new ElementTreeContentProviderUIFolder(TOOLS, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools")), standardCategoriesFolder));
                                    }
                                }
                                ++l;
                            }
                            this.elementMap.remove(pkg);
                        }
                    } else if (pkg instanceof ProcessPackage && ((ProcessPackage)pkg).getName().equals(PKG_NAME_CAPABILITY_PATTERNS)) {
                        this.replace(element, pkg, new ElementTreeContentProviderUIFolder(CAPABILITY_PATTERNS, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns")), processesFolder));
                    }
                    ++k;
                }
                Set<Object> children = this.elementMap.get(element);
                children.remove(methodPackage);
            } else if (methodPackage instanceof ProcessPackage && ((ProcessPackage)methodPackage).getName().equals(PKG_NAME_DELIVERY_PROCESSES)) {
                this.replace(element, methodPackage, new ElementTreeContentProviderUIFolder(DELIVERY_PROCESSES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses")), processesFolder));
            }
            ++j;
        }
    }

    protected void insertUIFolders(Object inputElement) {
        Object[] elements = this.getChildren(inputElement);
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof MethodPlugin) {
                this.insertUIFolders((MethodPlugin)element);
            }
            ++i;
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public Map<Object, Set<Object>> getElementMap() {
        return this.elementMap;
    }
}

