/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.NestedCommandExcecutor;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IOppositeFeatureLoader;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public class TypeConverter {
    private static final Comparator activityFeatureComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 == UmaPackage.Literals.BREAKDOWN_ELEMENT__SUPER_ACTIVITIES) {
                return -1;
            }
            return 0;
        }
    };

    public static final EObject convert(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, Set modifiedResources) {
        TypeConversionCommand cmd = TypeConverter.createTypeConversionCommand(object, newType, oldFeatureToNewFeatureMap, featureComparator);
        Collection<Resource> resources = cmd.getModifiedResources();
        if (!resources.isEmpty()) {
            Resource[] resourceArray = new Resource[resources.size()];
            resources.toArray(resourceArray);
            IStatus status = Services.getAccessController().checkModify(resourceArray, ExtensionManager.getDefaultUserInteractionHandler().getUIContext());
            if (!status.isOK()) {
                Messenger.INSTANCE.showError(LibraryResources.convertActivityError_title, null, status);
                return null;
            }
        }
        try {
            cmd.execute();
            modifiedResources.addAll(cmd.getModifiedResources());
            EObject eObject = (EObject)cmd.getResult().iterator().next();
            return eObject;
        }
        finally {
            cmd.dispose();
        }
    }

    public static final TypeConversionCommand createTypeConversionCommand(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator) {
        return TypeConverter.createTypeConversionCommand(object, newType, oldFeatureToNewFeatureMap, featureComparator, false, false);
    }

    public static final TypeConversionCommand createTypeConversionCommand(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, boolean removeIncomingReferences, boolean removeVariability) {
        TypeConversionCommand cmd = new TypeConversionCommand(object);
        EObject newObject = TypeConverter.prepareConvert(object, newType, oldFeatureToNewFeatureMap, featureComparator, removeIncomingReferences, removeVariability, cmd);
        EObject container = object.eContainer();
        if (container != null) {
            EReference ref = object.eContainmentFeature();
            if (ref.isMany()) {
                List list = (List)container.eGet((EStructuralFeature)ref);
                int index = list.indexOf(object);
                cmd.commandList().add(0, new SetCommand(null, container, (EStructuralFeature)ref, (Object)newObject, index));
            } else {
                cmd.commandList().add(0, new SetCommand(null, container, (EStructuralFeature)ref, (Object)newObject));
            }
        }
        cmd.setResult(Collections.singletonList(newObject));
        return cmd;
    }

    private static ContentResourceScanner createScanner(EObject object) {
        if (object instanceof ContentDescription && !(object instanceof BreakdownElementDescription)) {
            File oldResourcePath = new File(ResourceHelper.getFolderAbsolutePath((MethodElement)((MethodElement)object)));
            String rootContentpath = ResourceHelper.getElementPath((MethodElement)((MethodElement)object));
            ContentResourceScanner scanner = new ContentResourceScanner(oldResourcePath, null, rootContentpath, null);
            return scanner;
        }
        return null;
    }

    public static final EObject prepareConvert(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, boolean removeIncomingReferences, boolean removeVariability, TypeConversionCommand compoundCommand) {
        return TypeConverter.prepareConvert(object, newType, oldFeatureToNewFeatureMap, featureComparator, removeIncomingReferences, removeVariability, compoundCommand, 0);
    }

    private static final EObject prepareConvert(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, boolean removeIncomingReferences, boolean removeVariability, TypeConversionCommand compoundCommand, int level) {
        MethodElement me;
        Collection oppositeFeatures;
        EObject newObject = UmaFactory.eINSTANCE.create(newType);
        if (object instanceof MethodElement && !(oppositeFeatures = (me = (MethodElement)object).getOppositeFeatures()).isEmpty()) {
            List<EObject> collection = Collections.singletonList(object);
            for (IOppositeFeatureLoader loader : ExtensionManager.getOppositeFeatureLoaders()) {
                loader.loadOppositeFeatures(collection);
            }
            if (level == 0) {
                LibraryUtil.loadAllSkipContents((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
            }
            Map referencerToFeatureListMap = AssociationHelper.getReferenceMap((MethodElement)me);
            for (Map.Entry entry : referencerToFeatureListMap.entrySet()) {
                EObject referencer = (EObject)entry.getKey();
                for (EReference feature : (Collection)entry.getValue()) {
                    if (!removeIncomingReferences && feature.getEType().isInstance((Object)newObject)) {
                        if (feature.isMany()) {
                            List list = (List)referencer.eGet((EStructuralFeature)feature);
                            int index = list.indexOf(object);
                            compoundCommand.append((Command)new SetCommand(null, referencer, (EStructuralFeature)feature, (Object)newObject, index));
                            continue;
                        }
                        compoundCommand.append((Command)new SetCommand(null, referencer, (EStructuralFeature)feature, (Object)newObject));
                        continue;
                    }
                    if (feature.isMany()) {
                        compoundCommand.append((Command)new RemoveCommand(null, referencer, (EStructuralFeature)feature, (Object)object));
                        continue;
                    }
                    compoundCommand.append((Command)new SetCommand(null, referencer, (EStructuralFeature)feature, feature.getDefaultValue()));
                }
            }
        }
        EList newObjectFeatures = newType.getEAllStructuralFeatures();
        ArrayList objectFeatures = new ArrayList(object.eClass().getEAllStructuralFeatures());
        if (removeVariability) {
            objectFeatures.remove(UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT);
            objectFeatures.remove(UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE);
        }
        if (featureComparator != null) {
            Collections.sort(objectFeatures, featureComparator);
        }
        ContentResourceScanner scanner = TypeConverter.createScanner(object);
        for (Object feature : objectFeatures) {
            String str;
            String newName;
            if (!newObjectFeatures.contains(feature)) {
                Object f;
                feature = oldFeatureToNewFeatureMap != null ? ((f = oldFeatureToNewFeatureMap.get(feature)) != null && newObjectFeatures.contains(f) ? (EStructuralFeature)f : null) : null;
            }
            if (feature == null || !feature.isChangeable()) continue;
            boolean featureHandled = false;
            if (feature instanceof EReference) {
                EReference oppositeRef;
                EReference ref = (EReference)feature;
                if (ref == UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION) {
                    if (ContentDescriptionFactory.hasPresentation((MethodElement)((MethodElement)object))) {
                        ContentDescription content = (ContentDescription)object.eGet((EStructuralFeature)ref);
                        EClass contentDescType = ContentDescriptionFactory.getContentDescriptionType((EClass)newType);
                        if (contentDescType != null && contentDescType != content.eClass()) {
                            EObject newContent = TypeConverter.prepareConvert((EObject)content, contentDescType, null, null, removeIncomingReferences, removeVariability, compoundCommand, level + 1);
                            EObject container = content.eContainer();
                            if (container != null) {
                                compoundCommand.append((Command)new SetCommand(null, object, (EStructuralFeature)ref, null));
                                Resource resource = content.eResource();
                                if (resource != null) {
                                    compoundCommand.modifiedResources.add(content.eResource());
                                }
                            }
                            content = (ContentDescription)newContent;
                        } else {
                            compoundCommand.resourceCopyTasks.add(new ResourceCopyTask(TypeConverter.createScanner((EObject)content), (MethodElement)content, null, ""));
                        }
                        compoundCommand.append((Command)new SetCommand(null, newObject, (EStructuralFeature)ref, (Object)content));
                    }
                    featureHandled = true;
                } else if (!ref.isContainment() && ref.getEOpposite() != null && (oppositeRef = ref.getEOpposite()).isMany()) {
                    Object value = object.eGet((EStructuralFeature)ref);
                    if (value != null) {
                        if (ref.isMany()) {
                            for (EObject otherEnd : (Collection)value) {
                                List list = (List)otherEnd.eGet((EStructuralFeature)oppositeRef);
                                int index = list.indexOf(object);
                                compoundCommand.append((Command)new SetCommand(null, otherEnd, (EStructuralFeature)oppositeRef, (Object)newObject, index));
                            }
                        } else {
                            EObject otherEnd = (EObject)value;
                            List list = (List)otherEnd.eGet((EStructuralFeature)oppositeRef);
                            int index = list.indexOf(object);
                            compoundCommand.append((Command)new SetCommand(null, otherEnd, (EStructuralFeature)oppositeRef, (Object)newObject, index));
                        }
                    }
                    featureHandled = true;
                }
            }
            if (featureHandled) continue;
            Object value = object.eGet(feature);
            if (feature == UmaPackage.Literals.NAMED_ELEMENT__NAME && (newName = TypeConverter.checkName(object, newType)) != null) {
                value = newName;
            }
            if (scanner != null && value instanceof String && object instanceof MethodElement && !StrUtil.isBlank((String)(str = (String)value))) {
                compoundCommand.resourceCopyTasks.add(new ResourceCopyTask(scanner, (MethodElement)object, str, ""));
            }
            compoundCommand.append((Command)new SetCommand(null, newObject, feature, value));
        }
        return newObject;
    }

    public static Activity convertActivity(Activity oldActivity, EClass newType) {
        if (newType == oldActivity.eClass()) {
            return null;
        }
        HashSet modifiedResources = new HashSet();
        Activity newActivity = (Activity)TypeConverter.convert((EObject)oldActivity, newType, null, activityFeatureComparator, modifiedResources);
        URI uri = PersistenceUtil.getProxyURI((EObject)newActivity);
        ((InternalEObject)oldActivity).eSetProxyURI(uri);
        if (!modifiedResources.isEmpty()) {
            ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                for (Resource res : modifiedResources) {
                    persister.save(res);
                }
                persister.commit();
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, NLS.bind((String)LibraryResources.saveConvertedActivityError_msg, (Object)newActivity.getName()), LibraryResources.error_reason, (Throwable)e);
                persister.rollback();
            }
        }
        return newActivity;
    }

    public static EClass getActivityType(int typeID) {
        switch (typeID) {
            case 53: {
                return UmaPackage.Literals.ACTIVITY;
            }
            case 68: {
                return UmaPackage.Literals.ITERATION;
            }
            case 69: {
                return UmaPackage.Literals.PHASE;
            }
        }
        return null;
    }

    private static String checkName(EObject object, EClass newType) {
        NamedElement e;
        IValidator validator;
        String msg;
        if (object instanceof NamedElement && (msg = (validator = IValidatorFactory.INSTANCE.createNameValidator((Object)(e = (NamedElement)object).eContainer(), e, newType)).isValid(e.getName())) != null) {
            String featureTxt = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String title = LibraryEditResources.resolveNameConflictDialog_title;
            String dlgMsg = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)featureTxt), (Object)e.getName());
            String currentValue = (String)e.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator inputValidator = new IInputValidator(){

                public String isValid(String newText) {
                    return validator.isValid(newText);
                }
            };
            InputDialog inputDlg = new InputDialog(MsgBox.getDefaultShell(), title, dlgMsg, currentValue, inputValidator);
            if (inputDlg.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDlg.getValue();
        }
        return null;
    }

    private static class ResourceCopyTask {
        ContentResourceScanner scanner;
        MethodElement owner;
        String content;
        String contentPath;

        public ResourceCopyTask(ContentResourceScanner scanner, MethodElement owner, String content, String contentPath) {
            this.scanner = scanner;
            this.owner = owner;
            this.content = content;
            this.contentPath = contentPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeConversionCommand
    extends CompoundCommand
    implements IResourceAwareCommand {
        private Collection<?> result;
        private EObject object;
        private HashSet<Resource> modifiedResources;
        private boolean gotModifiedResources;
        private List<ResourceCopyTask> resourceCopyTasks;
        private Resource resource;
        private Collection illegalReferencers;
        private NestedCommandExcecutor nestedCommandExcecutor;

        public TypeConversionCommand(EObject object) {
            this.object = object;
            this.modifiedResources = new HashSet();
            this.resource = object.eResource();
            if (this.resource != null) {
                this.modifiedResources.add(this.resource);
            }
            this.resourceCopyTasks = new ArrayList<ResourceCopyTask>();
            this.nestedCommandExcecutor = new NestedCommandExcecutor((Command)this);
        }

        public void dispose() {
            if (this.illegalReferencers != null) {
                this.illegalReferencers.clear();
            }
            if (this.modifiedResources != null) {
                this.modifiedResources.clear();
            }
            if (this.resourceCopyTasks != null) {
                this.resourceCopyTasks.clear();
            }
            if (this.nestedCommandExcecutor != null) {
                this.nestedCommandExcecutor.dispose();
            }
            super.dispose();
        }

        public Collection getIllegalReferencers() {
            if (this.illegalReferencers == null) {
                this.getModifiedResources();
            }
            return this.illegalReferencers;
        }

        public void copyResources() {
            if (!this.resourceCopyTasks.isEmpty()) {
                for (ResourceCopyTask t : this.resourceCopyTasks) {
                    File newResourcePath = new File(ResourceHelper.getAbsoluteElementResourcePath((MethodElement)t.owner));
                    t.scanner.setTargetRootPath(newResourcePath);
                    if (t.content != null) {
                        t.scanner.resolveResources(t.owner, t.content, t.contentPath);
                        continue;
                    }
                    for (EAttribute attribute : t.owner.eClass().getEAllAttributes()) {
                        Object value = t.owner.eGet((EStructuralFeature)attribute);
                        if (!(value instanceof String)) continue;
                        t.scanner.resolveResources(t.owner, (String)value, t.contentPath);
                    }
                }
            }
        }

        public Collection<Resource> getModifiedResources() {
            if (!this.gotModifiedResources) {
                this.illegalReferencers = new HashSet();
                for (Command cmd : this.commandList) {
                    EObject value;
                    Resource ownerResource;
                    EObject owner;
                    if (cmd instanceof RemoveCommand) {
                        RemoveCommand removeCommand = (RemoveCommand)cmd;
                        owner = removeCommand.getOwner();
                        ownerResource = owner.eResource();
                        if (ownerResource != null && ownerResource != this.resource) {
                            this.modifiedResources.add(ownerResource);
                        }
                        if (ownerResource == null || owner == this.object || UmaUtil.isContainedBy((EObject)owner, (Object)this.object)) continue;
                        this.illegalReferencers.add(owner);
                        continue;
                    }
                    if (!(cmd instanceof SetCommand)) continue;
                    SetCommand setCommand = (SetCommand)cmd;
                    owner = setCommand.getOwner();
                    ownerResource = owner.eResource();
                    if (ownerResource != null && ownerResource != this.resource && setCommand.getValue() instanceof EObject && ((value = (EObject)setCommand.getValue()) != this.object || !UmaUtil.isContainedBy((EObject)value, (Object)this.object))) {
                        this.modifiedResources.add(ownerResource);
                    }
                    if (ownerResource == null || owner == this.object || UmaUtil.isContainedBy((EObject)owner, (Object)this.object) || setCommand.getValue() != setCommand.getFeature().getDefaultValue()) continue;
                    this.illegalReferencers.add(owner);
                }
                for (Object obj : this.illegalReferencers) {
                    Resource res;
                    if (!(obj instanceof MethodElement) || (res = ((MethodElement)obj).eResource()) == null) continue;
                    this.modifiedResources.add(res);
                }
                this.gotModifiedResources = true;
            }
            this.modifiedResources.addAll(this.nestedCommandExcecutor.getModifiedResources());
            return this.modifiedResources;
        }

        private void setResult(Collection<?> result) {
            this.result = result;
        }

        public Collection<?> getResult() {
            return this.result;
        }

        public void execute() {
            super.execute();
            this.nestedCommandExcecutor.executeNestedCommands();
        }

        public void undo() {
            this.nestedCommandExcecutor.undoNestedCommands();
            super.undo();
        }

        private List<Command> commandList() {
            return this.commandList;
        }
    }
}

