/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.views.ProcessTreeUIFolder;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProcessTreeContentProvider
implements ITreeContentProvider {
    protected static final String CAPABILITY_PATTERNS = LibraryUIResources.capabilityPattern_text_plural;
    protected static final String DELIVERY_PROCESSES = LibraryUIResources.deliveryProcess_text_plural;
    protected static final Object[] EMPTY_LIST = new Object[0];
    protected Map<MethodPlugin, ProcessTreeUIFolder> capabilityPatternUIFolders = new HashMap<MethodPlugin, ProcessTreeUIFolder>();
    protected Map<MethodPlugin, ProcessTreeUIFolder> deliveryProcessUIFolders = new HashMap<MethodPlugin, ProcessTreeUIFolder>();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MethodLibrary) {
            ArrayList<MethodPlugin> children = new ArrayList<MethodPlugin>();
            List plugins = ((MethodLibrary)parentElement).getMethodPlugins();
            for (MethodPlugin plugin : plugins) {
                List processes = TngUtil.getAllProcesses((MethodPlugin)plugin);
                if (processes.size() <= 0) continue;
                children.add(plugin);
            }
            return children.toArray();
        }
        if (parentElement instanceof MethodPlugin) {
            ProcessTreeUIFolder deliveryProcessUIFolder;
            MethodPlugin plugin = (MethodPlugin)parentElement;
            ProcessTreeUIFolder capabilityPatternUIFolder = this.capabilityPatternUIFolders.get(plugin);
            if (capabilityPatternUIFolder == null) {
                capabilityPatternUIFolder = new ProcessTreeUIFolder(CAPABILITY_PATTERNS, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns")), parentElement);
                this.capabilityPatternUIFolders.put(plugin, capabilityPatternUIFolder);
            }
            if ((deliveryProcessUIFolder = this.deliveryProcessUIFolders.get(plugin)) == null) {
                deliveryProcessUIFolder = new ProcessTreeUIFolder(DELIVERY_PROCESSES, ExtendedImageRegistry.getInstance().getImage(LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses")), parentElement);
                this.deliveryProcessUIFolders.put(plugin, deliveryProcessUIFolder);
            }
            return new Object[]{capabilityPatternUIFolder, deliveryProcessUIFolder};
        }
        if (parentElement instanceof ProcessTreeUIFolder) {
            ProcessTreeUIFolder uiFolder = (ProcessTreeUIFolder)parentElement;
            MethodPlugin plugin = (MethodPlugin)uiFolder.getParent();
            if (uiFolder.getName() == CAPABILITY_PATTERNS) {
                return LibraryServiceUtil.getCapabilityPatterns((MethodPlugin)plugin).toArray();
            }
            return LibraryServiceUtil.getDeliveryProcesses((MethodPlugin)plugin).toArray();
        }
        return EMPTY_LIST;
    }

    public Object getParent(Object element) {
        if (element instanceof ProcessTreeUIFolder) {
            return ((ProcessTreeUIFolder)element).getParent();
        }
        if (element instanceof CapabilityPattern) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((CapabilityPattern)element));
            return this.capabilityPatternUIFolders.get(plugin);
        }
        if (element instanceof DeliveryProcess) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((DeliveryProcess)element));
            return this.deliveryProcessUIFolders.get(plugin);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.capabilityPatternUIFolders.clear();
        this.deliveryProcessUIFolders.clear();
    }

    public void dispose() {
    }
}

