/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;

public class DirectoryValidator {
    public static boolean checkAndCreateDir(String dir, String title, String errorMsg) {
        boolean answer = false;
        File file = new File(dir);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                answer = LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, LibraryUIResources.bind(LibraryUIResources.deleteFilesConfirmation_msg, dir));
                if (answer) {
                    try {
                        answer = FileUtil.deleteAllFiles((String)file.getAbsolutePath());
                        if (!answer) {
                            LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.bind(LibraryUIResources.deleteFilesError_reason, dir));
                        }
                    }
                    catch (Exception e) {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.bind(LibraryUIResources.deleteFilesError_reason, dir), (Throwable)e);
                        answer = false;
                    }
                }
            } else {
                answer = true;
            }
        } else {
            try {
                if (!file.mkdirs()) {
                    LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.bind(LibraryUIResources.createPathError_reason, dir));
                    answer = false;
                } else {
                    answer = true;
                }
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, errorMsg, LibraryUIResources.bind(LibraryUIResources.createPathError_reason, dir), (Throwable)e);
                answer = false;
            }
        }
        return answer;
    }

    public static boolean checkAndCreateDir(String dir, String title, String errorMsg, boolean allowCurrentLibPath) {
        String currentLibPath;
        if (!allowCurrentLibPath && (currentLibPath = LibraryService.getInstance().getCurrentMethodLibraryLocation()) != null) {
            String targetPathFileStr = new File(dir).getAbsolutePath();
            String libPathFileStr = new File(currentLibPath).getAbsolutePath();
            if (libPathFileStr.equals(targetPathFileStr)) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, LibraryUIResources.overrideCurrentLibraryError_msg0);
                return false;
            }
        }
        return DirectoryValidator.checkAndCreateDir(dir, title, errorMsg);
    }
}

