/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.dialogs.LibraryBackupDialog;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class LibraryBackupUtil {
    private String path = null;

    public static void promptBackupCurrentLibrary(Shell shell, ILibraryService service) {
        MethodLibrary lib = service.getCurrentMethodLibrary();
        if (lib != null && lib.getMethodPlugins().isEmpty() && lib.getPredefinedConfigurations().isEmpty()) {
            return;
        }
        String libPathStr = service.getCurrentMethodLibraryLocation();
        File libPath = new File(libPathStr);
        new LibraryBackupUtil().doBackup(shell, libPath, service);
    }

    public static void promptBackupLibrary(Shell shell, File libPath) {
        new LibraryBackupUtil().doBackup(shell, libPath, null);
    }

    private void doBackup(final Shell shell, final File libPath, ILibraryService service) {
        this.path = null;
        final ILibraryService fservice = service;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String backupPath;
                String message;
                String title;
                LibraryBackupDialog dlg;
                Shell s = shell;
                if (s == null) {
                    s = MsgBox.getDefaultShell();
                }
                if (s == null) {
                    s = new Shell(MsgBox.getDisplay());
                }
                if ((dlg = new LibraryBackupDialog(s, title = LibraryUIResources.backupLibraryDialog_title, message = LibraryUIResources.backupLibraryDialog_text, backupPath = String.valueOf(libPath.getAbsolutePath()) + ".backup")).open() == 0) {
                    LibraryBackupUtil.this.path = dlg.getPath();
                }
                ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(s);
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        monitor.beginTask(LibraryUIResources.backingUpLibraryTask_name, -1);
                        if (LibraryBackupUtil.this.path != null) {
                            if (fservice == null) {
                                LibraryBackupUtil.backup(libPath, new File(LibraryBackupUtil.this.path));
                            } else {
                                fservice.getCurrentLibraryManager().backupMethodLibrary(LibraryBackupUtil.this.path);
                            }
                        }
                    }
                };
                try {
                    pmDialog.run(true, false, op);
                }
                catch (Exception e) {
                    LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        });
    }

    public static void backup(final File source, final File dest) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String excludes = ".lock";
                    LayoutResources.copyDir((File)source, (File)dest, (String)"**", (String)excludes);
                }
                catch (RuntimeException e) {
                    LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        };
        UserInteractionHelper.runWithProgress((Runnable)runnable, (String)LibraryUIResources.backingUpLibraryTask_name);
    }
}

