/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.internal.wizards.NewLibraryWizardPageContribution;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPage;
import org.osgi.framework.Bundle;

public class NewLibraryWizardPageFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library.ui";
    public static final String EXTENSION_POINT_NAME = "newLibraryWizardPages";
    private static boolean debug = LibraryUIPlugin.getDefault().isDebugging();
    private static NewLibraryWizardPageFactory instance = null;
    private Map<String, NewLibraryWizardPageContribution> wizardPageProviders = new HashMap<String, NewLibraryWizardPageContribution>();
    private Map<String, NewLibraryWizardPage> wizardPages = new HashMap<String, NewLibraryWizardPage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NewLibraryWizardPageFactory getInstance() {
        if (instance != null) return instance;
        Class<NewLibraryWizardPageFactory> clazz = NewLibraryWizardPageFactory.class;
        synchronized (NewLibraryWizardPageFactory.class) {
            if (instance != null) return instance;
            instance = new NewLibraryWizardPageFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NewLibraryWizardPageFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry;
        IExtensionPoint extensionPoint;
        if (debug) {
            DebugTrace.print((Object)this, (String)"init");
        }
        if ((extensionPoint = (extensionRegistry = Platform.getExtensionRegistry()).getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String className = configElement.getAttribute("class");
                        String typeId = configElement.getAttribute("type");
                        String title = configElement.getAttribute("title");
                        String description = configElement.getAttribute("description");
                        if (debug) {
                            DebugTrace.print((Object)this, (String)"init", (String)("configElement, class=" + className + ", type=" + typeId + ", title=" + title + ", description=" + description));
                        }
                        if (className != null && className.trim().length() > 0 && typeId != null && typeId.trim().length() > 0 && title != null && title.trim().length() > 0 && description != null && description.trim().length() > 0 && !this.wizardPageProviders.containsKey(typeId)) {
                            NewLibraryWizardPageContribution provider = new NewLibraryWizardPageContribution(bundle, className, typeId, title, description);
                            this.wizardPageProviders.put(typeId, provider);
                        }
                    }
                    catch (Exception e) {
                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public NewLibraryWizardPage createWizardPage(String pageId, String typeId) {
        NewLibraryWizardPage wizardPage = this.wizardPages.get(typeId);
        if (wizardPage != null) {
            return wizardPage;
        }
        NewLibraryWizardPageContribution provider = this.wizardPageProviders.get(typeId);
        if (provider != null) {
            Bundle bundle = provider.getBundle();
            String className = provider.getClassName();
            Class[] argClass = new Class[]{String.class};
            Object[] argValue = new Object[]{pageId};
            try {
                Class wizardPageClass = bundle.loadClass(className);
                Constructor constructor = wizardPageClass.getConstructor(argClass);
                wizardPage = (NewLibraryWizardPage)((Object)constructor.newInstance(argValue));
                wizardPage.setTitle(provider.getTitle());
                wizardPage.setDescription(provider.getDescription());
                this.wizardPages.put(typeId, wizardPage);
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return wizardPage;
    }

    public NewLibraryWizardPage getWizardPage(String typeId) {
        return this.wizardPages.get(typeId);
    }
}

