/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.edit.configuration.PracticeSubgroupItemProvider;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodConfigurationPropUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.ElementLayoutExtender;
import org.eclipse.epf.library.layout.elements.SummaryPageLayout;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.realization.RealizationManagerFactory;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelperDelegate {
    private boolean generateHtmlMode = false;
    private boolean publishingMode = false;
    private boolean authoringPerspective = false;
    private MethodConfiguration config;
    private boolean loadForBrowsingNeeded = true;
    private boolean autoSyncedByBrowsing = false;
    private Map<MethodElement, Set<CustomCategory>> dynamicCustomCategoriesMap;
    private boolean supportingInAuthoringMode = false;
    private IPerspectiveListener perspectiveListener;
    private ILibraryServiceListener libServiceListener = new LibraryServiceListener(){

        public void configurationSet(MethodConfiguration newConfig) {
            ConfigHelperDelegate.this.addPerspectiveListener();
            if (ConfigHelperDelegate.this.config == newConfig) {
                return;
            }
            ConfigHelperDelegate.this.handleConfigOrPersepctiveChange();
            ConfigHelperDelegate.this.config = newConfig;
        }
    };

    public ConfigHelperDelegate() {
        LibraryService.getInstance().addListener(this.libServiceListener);
        IRealizationManager mgr = RealizationManagerFactory.getInstance().newRealizationManager(null);
        LibraryEditUtil.getInstance().setDefaultRealizationManager(mgr);
    }

    protected boolean hasDynamicElements(CustomCategory cc) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)cc, (String)"include");
        return prop != null;
    }

    public void buildDynamicCustomCategoriesMap(MethodConfiguration config) {
        try {
            if (config == null) {
                return;
            }
            ConfigurationHelper.getDelegate().loadUserDefinedType();
            this.dynamicCustomCategoriesMap = new HashMap<MethodElement, Set<CustomCategory>>();
            ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(config);
            HashSet<CustomCategory> set = new HashSet<CustomCategory>();
            MethodElementPropUtil.getMethodElementPropUtil();
            for (MethodPlugin plugin : config.getMethodPluginSelection()) {
                for (CustomCategory cc : TngUtil.getAllCustomCategories((MethodPlugin)plugin)) {
                    if ((cc = (CustomCategory)ConfigurationHelper.getCalculatedElement((MethodElement)cc, realizer)) == null || !this.hasDynamicElements(cc)) continue;
                    set.add(cc);
                }
            }
            for (CustomCategory cc : set) {
                for (MethodElement element : ConfigurationHelper.calc0nFeatureValue((MethodElement)cc, (EStructuralFeature)UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), realizer)) {
                    Set<CustomCategory> ccSet = this.dynamicCustomCategoriesMap.get(element);
                    if (ccSet == null) {
                        ccSet = new HashSet<CustomCategory>();
                        this.dynamicCustomCategoriesMap.put(element, ccSet);
                    }
                    ccSet.add(cc);
                }
            }
        }
        catch (Throwable e) {
            LibraryPlugin.getDefault().getLogger().logError(e);
        }
    }

    public void clearDynamicCustomCategoriesMap() {
        this.dynamicCustomCategoriesMap = null;
    }

    public Set<CustomCategory> getDynamicCustomCategories(MethodElement element) {
        return this.dynamicCustomCategoriesMap == null ? null : this.dynamicCustomCategoriesMap.get(element);
    }

    public boolean isSystemPackage(MethodPlugin plugin, MethodPackage pkg) {
        return TngUtil.getAllSystemPackages((MethodPlugin)plugin).contains(pkg);
    }

    public void loadOppositeFeatures(ILibraryResourceSet resouceSet, List<OppositeFeature> oppositeFeatures, MethodElement element) {
        HashSet<String> GUIDs = new HashSet<String>();
        GUIDs.add(element.getGuid());
        resouceSet.loadOppositeFeatures(oppositeFeatures, GUIDs);
    }

    public boolean isOwnerSelected(MethodElement element, MethodConfiguration config, boolean checkSubtracted) {
        Process owningProc;
        Activity base;
        List subtractedCategories;
        ILibraryManager libraryManager;
        if (config instanceof Scope) {
            return ((Scope)config).inScope(element);
        }
        MethodLibrary library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
        ILibraryManager iLibraryManager = libraryManager = library == null ? null : LibraryService.getInstance().getLibraryManager(library);
        if (libraryManager != null) {
            return LibraryService.getInstance().getConfigurationManager(config).getConfigurationData().isOwnerSelected(element, checkSubtracted);
        }
        if (element == null) {
            return false;
        }
        if (config == null || ConfigurationHelper.isDescriptionElement(element)) {
            return true;
        }
        if (checkSubtracted && (subtractedCategories = config.getSubtractedCategory()).size() > 0) {
            for (ContentCategory cc : subtractedCategories) {
                if (cc == element) {
                    return false;
                }
                if (cc instanceof CustomCategory) {
                    if (!((CustomCategory)cc).getCategorizedElements().contains(element)) continue;
                    return false;
                }
                System.out.println("TODO, isOwnerSelected: not implemented yet");
            }
        }
        if (element instanceof MethodLibrary || element instanceof MethodConfiguration) {
            return true;
        }
        if (element instanceof MethodPlugin) {
            List plugins = config.getMethodPluginSelection();
            return plugins != null && plugins.contains(element);
        }
        if (element instanceof Activity && (base = (Activity)((Activity)element).getVariabilityBasedOnElement()) != null && base != element && (owningProc = TngUtil.getOwningProcess((BreakdownElement)base)) != null && owningProc != element && !ConfigurationHelper.inConfig((MethodElement)owningProc, config, checkSubtracted)) {
            return false;
        }
        EObject pkg = LibraryUtil.getSelectable((EObject)element);
        if (pkg instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)pkg)) {
            MethodPlugin plugin = LibraryUtil.getMethodPlugin(pkg);
            return ConfigurationHelper.inConfig((MethodElement)plugin, config, checkSubtracted);
        }
        List pkgs = config.getMethodPackageSelection();
        if (pkgs == null) {
            return false;
        }
        if (pkg instanceof ProcessPackage) {
            while (pkg != null && !(pkg instanceof ProcessComponent) && !pkgs.contains(pkg)) {
                pkg = pkg.eContainer();
            }
        }
        return pkg != null && pkgs.contains(pkg);
    }

    public void loadOppositeFeatures(Map map, List oppositeFeatures, Set deletedGUIDs) {
        int max = oppositeFeatures.size() - 1;
        if (max < 0) {
            return;
        }
        HashSet elements = new HashSet(map.values());
        HashSet loadedElements = new HashSet();
        while (!elements.isEmpty()) {
            for (Object obj : elements) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                MultiResourceEObject mrEObject = (MultiResourceEObject)element;
                int i = max;
                while (i > -1) {
                    OppositeFeature oppositeFeature = (OppositeFeature)oppositeFeatures.get(i);
                    EStructuralFeature eFeature = oppositeFeature.getTargetFeature();
                    if (eFeature.getContainerClass().isInstance(element)) {
                        if (eFeature.isMany()) {
                            InternalEList list = (InternalEList)element.eGet(eFeature);
                            if (!list.isEmpty()) {
                                boolean resolve = false;
                                Iterator iterator = list.basicIterator();
                                while (iterator.hasNext()) {
                                    String guid;
                                    Object e = (InternalEObject)iterator.next();
                                    if (!e.eIsProxy() || !deletedGUIDs.contains(guid = e.eProxyURI().fragment())) continue;
                                    resolve = true;
                                    break;
                                }
                                if (resolve) {
                                    HashSet deletedElements = new HashSet();
                                    for (Object o : list) {
                                        if (!(o instanceof MethodElement) || !deletedGUIDs.contains(((MethodElement)o).getGuid())) continue;
                                        deletedElements.add(o);
                                    }
                                    for (Object e : deletedElements) {
                                        if (oppositeFeature.isMany()) {
                                            mrEObject.oppositeAdd(oppositeFeature, e);
                                            continue;
                                        }
                                        mrEObject.getOppositeFeatureMap().put(oppositeFeature, e);
                                    }
                                }
                            }
                        } else {
                            String guid;
                            InternalEObject e;
                            Object value = element.eGet(eFeature, false);
                            if (value instanceof InternalEObject && (e = (InternalEObject)value).eIsProxy() && deletedGUIDs.contains(guid = e.eProxyURI().fragment())) {
                                Object o = element.eGet(eFeature);
                                if (oppositeFeature.isMany()) {
                                    mrEObject.oppositeAdd(oppositeFeature, o);
                                } else {
                                    mrEObject.getOppositeFeatureMap().put(oppositeFeature, o);
                                }
                            }
                        }
                    }
                    --i;
                }
            }
            loadedElements.addAll(elements);
            elements = new HashSet(map.values());
            elements.removeAll(loadedElements);
        }
    }

    public String generateHtml(Object raw_element, HtmlBuilder htmlBuilder) {
        ResourceHelper.birt_publishing = false;
        this.loadForBrowsing(raw_element);
        IElementLayout layout = null;
        String file_url = "about:blank";
        Object element = LibraryUtil.unwrap(raw_element);
        try {
            this.setGenerateHtmlMode(true);
            if (raw_element instanceof ActivityWrapperItemProvider) {
                ActivityWrapperItemProvider wrapper = (ActivityWrapperItemProvider)raw_element;
                Object proc = wrapper.getTopItem();
                if (element instanceof MethodElement && proc instanceof Process) {
                    String path = AbstractProcessElementLayout.getPath((BreakdownElementWrapperItemProvider)wrapper);
                    layout = htmlBuilder.getLayoutManager().createLayout((MethodElement)element, (Process)proc, path);
                    file_url = htmlBuilder.generateHtml(layout);
                }
            } else if (raw_element instanceof PracticeSubgroupItemProvider) {
                PracticeSubgroupItemProvider provider = (PracticeSubgroupItemProvider)raw_element;
                layout = new SummaryPageLayout(htmlBuilder.getLayoutManager(), (MethodElement)provider.getPractice(), provider.getPrefix(), provider.getText(null), (List)provider.getChildren(null), provider.getText(null));
                ((SummaryPageLayout)layout).setHtmlBuilder(htmlBuilder);
                file_url = htmlBuilder.generateHtml(layout);
            } else if (element instanceof MethodElement) {
                file_url = htmlBuilder.generateHtml((MethodElement)element);
            }
        }
        finally {
            this.setGenerateHtmlMode(false);
        }
        if (file_url == null) {
            file_url = "about:blank";
        } else {
            if (!(SWT.getPlatform().equals("win32") || file_url.startsWith("file://") || file_url.equals("about:blank"))) {
                file_url = "file://" + file_url;
            }
            if (layout instanceof AbstractProcessElementLayout) {
                file_url = String.valueOf(file_url) + ((AbstractProcessElementLayout)layout).getQueryString();
            }
        }
        ResourceHelper.birt_publishing = true;
        return file_url;
    }

    public ElementLayoutExtender newElementLayoutExtender(AbstractElementLayout layout) {
        return null;
    }

    public void configViewRefreshNotified() {
    }

    public void debugDump(String msg) {
        System.out.println("LD> " + this.getClass() + ".debugDump: " + msg);
    }

    public boolean isPublishingMode() {
        return this.publishingMode;
    }

    public void setPublishingMode(boolean publishingMode) {
        this.publishingMode = publishingMode;
    }

    public boolean isAuthoringPerspective() {
        return this.authoringPerspective;
    }

    public void setAuthoringPerspective(boolean authoringPerspective) {
        this.authoringPerspective = authoringPerspective;
    }

    public boolean isAuthoringMode() {
        return this.isAuthoringPerspective();
    }

    public boolean isSupportingInAuthoringMode() {
        return this.supportingInAuthoringMode;
    }

    public void setSupportingInAuthoringMode(boolean supportingInAuthoringMode) {
        this.supportingInAuthoringMode = supportingInAuthoringMode;
    }

    private void addPerspectiveListener() {
        if (this.perspectiveListener != null) {
            return;
        }
        IWorkbenchWindow window = LibraryUtil.getActiveWorkbenchWindow();
        if (window != null) {
            this.perspectiveListener = new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor desc) {
                    ConfigHelperDelegate.this.handleConfigOrPersepctiveChange();
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor desc, String id) {
                    ConfigHelperDelegate.this.handleConfigOrPersepctiveChange();
                }
            };
            window.addPerspectiveListener(this.perspectiveListener);
        }
    }

    protected void loadForBrowsing(Object raw_element) {
        if (!this.loadForBrowsingNeeded) {
            return;
        }
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (config != null && !BrowsingLayoutSettings.INSTANCE.isIgnoreDynamicParents()) {
            this.buildDynamicCustomCategoriesMap(config);
        }
        if (raw_element instanceof BreakdownElement || raw_element instanceof ActivityWrapperItemProvider) {
            if (config == null) {
                LibraryUtil.loadAll(LibraryService.getInstance().getCurrentMethodLibrary());
            } else {
                LibraryUtil.loadAllPlugins(config);
                IRealizationManager mgr = this.getRealizationManager(config);
                if (mgr != null) {
                    mgr.updateAllProcesseModels();
                    this.setAutoSyncedByBrowsing(true);
                }
            }
        }
        this.loadForBrowsingNeeded = false;
    }

    public IRealizationManager getRealizationManager(MethodConfiguration config) {
        if (config == null || config instanceof Scope) {
            return null;
        }
        IConfigurationManager configMgr = LibraryService.getInstance().getConfigurationManager(config);
        return configMgr == null ? null : configMgr.getRealizationManager();
    }

    private void handleConfigOrPersepctiveChange() {
        this.loadForBrowsingNeeded = true;
        ConfigurationHelper.getDelegate().loadUserDefinedType();
        this.clearDynamicCustomCategoriesMap();
    }

    public boolean canBeConfigFree(Process proc) {
        return true;
    }

    protected boolean isLoadForBrowsingNeeded() {
        return this.loadForBrowsingNeeded;
    }

    public void setLoadForBrowsingNeeded(boolean loadForBrowsingNeeded) {
        this.loadForBrowsingNeeded = loadForBrowsingNeeded;
    }

    public boolean isAutoSyncedByBrowsing() {
        return this.autoSyncedByBrowsing;
    }

    public void setAutoSyncedByBrowsing(boolean autoSyncedByBrowsing) {
        this.autoSyncedByBrowsing = autoSyncedByBrowsing;
    }

    public ConfigurationData getConfigurationData(MethodConfiguration config) {
        ConfigurationData configData;
        if (config == null) {
            return null;
        }
        IConfigurationManager configMgr = LibraryService.getInstance().getConfigurationManager(config);
        ConfigurationData configurationData = configData = configMgr == null ? null : configMgr.getConfigurationData();
        if (configData == null) {
            LibraryPlugin.getDefault().getLogger().logError("getConfigurationData() == null for: " + config.getName());
        }
        return configData;
    }

    public SupportingElementData getSupportingElementData(MethodConfiguration config) {
        if (config == null) {
            return null;
        }
        IConfigurationManager configMgr = LibraryService.getInstance().getConfigurationManager(config);
        return configMgr == null ? null : configMgr.getSupportingElementData();
    }

    public boolean makeClosure(MethodConfiguration config) {
        return false;
    }

    public void loadUserDefinedType() {
    }

    public boolean additionShowConfigSelectMenu(IWorkbenchPage activePage) {
        return false;
    }

    public boolean filterOutEmptyCategories() {
        if (this.isAuthoringMode()) {
            return false;
        }
        return !this.isPublishingMode();
    }

    public void fixupLoadCheckPackages(MethodLibrary lib) {
        if (lib == null) {
            return;
        }
        HashMap<MethodPlugin, Set<MethodPackage>> map = new HashMap<MethodPlugin, Set<MethodPackage>>();
        for (MethodConfiguration config : lib.getPredefinedConfigurations()) {
            this.fixupLoadCheckPackages(map, config);
        }
    }

    public void fixupLoadCheckPackages(MethodConfiguration config) {
        this.fixupLoadCheckPackages(null, config);
    }

    private void fixupLoadCheckPackages(Map<MethodPlugin, Set<MethodPackage>> map, MethodConfiguration config) {
        MethodConfigurationPropUtil propUtil = MethodConfigurationPropUtil.getMethodConfigurationPropUtil();
        MethodElementExt.MethodConfigurationExt ext = propUtil.getMethocConfigurationExt(config);
        if (ext == null || ext.isLoadCheckPackagesCalled()) {
            return;
        }
        ext.setLoadCheckPackagesCalled(true);
        if (!this.needFixupLoadCheckPackages(config)) {
            return;
        }
        if (map == null) {
            map = new HashMap<MethodPlugin, Set<MethodPackage>>();
        }
        HashSet<MethodPackage> selectedPkgs = new HashSet<MethodPackage>(config.getMethodPackageSelection());
        HashSet<MethodPackage> toAddCheckPkgs = new HashSet<MethodPackage>();
        for (MethodPlugin plugin : config.getMethodPluginSelection()) {
            Set<MethodPackage> loadCheckPkgs = map.get(plugin);
            if (loadCheckPkgs == null) {
                loadCheckPkgs = new HashSet<MethodPackage>();
                map.put(plugin, loadCheckPkgs);
            }
            this.collectLoadCheckPkgs(plugin.getMethodPackages(), loadCheckPkgs);
            toAddCheckPkgs.addAll(loadCheckPkgs);
        }
        Set doneSet = propUtil.getDoneLoadCheckPkgs(config);
        toAddCheckPkgs.removeAll(doneSet);
        HashSet<MethodPackage> handkedSet = new HashSet<MethodPackage>();
        for (MethodPackage pkg : toAddCheckPkgs) {
            if (!handkedSet.add(pkg) || !this.checkParentPackage(handkedSet, config, selectedPkgs, pkg, toAddCheckPkgs)) continue;
            this.addToConfig(config, selectedPkgs, pkg);
        }
    }

    public boolean needFixupLoadCheckPackages(MethodConfiguration config) {
        return config != null;
    }

    private void addToConfig(MethodConfiguration config, Set<MethodPackage> selectedPkgs, MethodPackage pkg) {
        config.getMethodPackageSelection().add(pkg);
        selectedPkgs.add(pkg);
    }

    private boolean checkParentPackage(Set<MethodPackage> handkedSet, MethodConfiguration config, Set<MethodPackage> selectedPkgs, MethodPackage pkg, Set<MethodPackage> toAddCheckPkgs) {
        EObject container = pkg.eContainer();
        if (!(container instanceof MethodPackage)) {
            return false;
        }
        MethodPackage parentPkg = (MethodPackage)container;
        if (selectedPkgs.contains(parentPkg)) {
            return true;
        }
        if (!toAddCheckPkgs.contains(parentPkg)) {
            return false;
        }
        if (handkedSet.add(parentPkg) && this.checkParentPackage(handkedSet, config, selectedPkgs, parentPkg, toAddCheckPkgs)) {
            this.addToConfig(config, selectedPkgs, parentPkg);
        }
        return false;
    }

    private void collectLoadCheckPkgs(List<MethodPackage> pkgList, Set<MethodPackage> loadCheckPkgs) {
        PropUtil propUtil = PropUtil.getPropUtil();
        for (MethodPackage pkg : pkgList) {
            Boolean b = propUtil.getBooleanValue((MethodElement)pkg, "pkg_loadCheck");
            if (b != null && b.booleanValue()) {
                loadCheckPkgs.add(pkg);
            }
            this.collectLoadCheckPkgs(pkg.getChildPackages(), loadCheckPkgs);
        }
    }

    public boolean isGenerateHtmlMode() {
        return this.generateHtmlMode;
    }

    public void setGenerateHtmlMode(boolean generateHtmlMode) {
        this.generateHtmlMode = generateHtmlMode;
    }

    public boolean browseOrPublishMode() {
        return this.isPublishingMode() || this.isGenerateHtmlMode();
    }
}

