/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationProperties;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.DependencyManager;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.util.MethodElementProperties;
import org.eclipse.epf.library.edit.util.MethodElementPropertyMgr;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.realization.RealizationManagerFactory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.util.Scope;

public class ConfigurationManager
implements IConfigurationManager {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodConfiguration config;
    private ConfigurationData configData;
    private SupportingElementData supportingElementData;
    private ConfigurationProperties configProps;
    protected MethodLibrary library;
    protected ILibraryManager libraryManager;
    protected DependencyManager dependencyManager;
    protected ElementLayoutManager layoutManager;
    protected ConfigurationClosure closure;
    protected AdapterFactoryContentProvider afcp;
    private IRealizationManager realizationManager;

    public ConfigurationManager(MethodConfiguration config) {
        this.config = config;
        this.configData = ConfigurationData.newConfigurationData(config);
        if (!ConfigurationData.ignoreSupportingPlugin) {
            this.supportingElementData = this.configData.newSupportingElementData();
        }
        this.configProps = new ConfigurationProperties(config);
        MethodElementPropertyMgr.getInstance().register((MethodElement)config, (MethodElementProperties)this.configProps);
        if (config instanceof Scope) {
            this.library = LibraryService.getInstance().getCurrentMethodLibrary();
        } else {
            this.library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
            if (this.library == null) {
                this.library = LibraryService.getInstance().getCurrentMethodLibrary();
            }
        }
        this.libraryManager = LibraryService.getInstance().getLibraryManager(this.library);
        this.afcp = new AdapterFactoryContentProvider((AdapterFactory)this.libraryManager.getAdapterFactory());
        this.dependencyManager = new DependencyManager(this.library, config);
        if (config == null) {
            this.layoutManager = new ElementLayoutManager();
        } else {
            this.layoutManager = new ElementLayoutManager(config);
            this.realizationManager = RealizationManagerFactory.getInstance().newRealizationManager(config);
        }
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    public ConfigurationData getConfigurationData() {
        return this.configData;
    }

    public SupportingElementData getSupportingElementData() {
        return this.supportingElementData;
    }

    public MethodLibrary getMethodLibrary() {
        return this.library;
    }

    public AdapterFactory getAdapterFactory() {
        return this.libraryManager.getAdapterFactory();
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return this.afcp;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ElementLayoutManager getElementLayoutManager() {
        if (this.layoutManager != null) {
            this.layoutManager.buildPublishDir(null);
        }
        return this.layoutManager;
    }

    public ConfigurationClosure getConfigurationClosure() {
        return this.closure;
    }

    public void makeConfigurationClosure() {
        if (this.closure != null) {
            this.closure.fixErrors();
        }
    }

    public List getMethodPlugins() {
        return this.library.getMethodPlugins();
    }

    public void dispose() {
        this.configData.dispose();
        this.configData = null;
        this.config = null;
        this.library = null;
        this.libraryManager = null;
        this.dependencyManager = null;
        if (this.layoutManager != null) {
            this.layoutManager.clear();
        }
        this.layoutManager = null;
        this.closure = null;
        MethodElementPropertyMgr.getInstance().unregister((MethodElement)this.config);
        this.configProps = null;
        if (this.realizationManager != null) {
            this.realizationManager.dispose();
            this.realizationManager = null;
        }
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configProps;
    }

    public IRealizationManager getRealizationManager() {
        return this.realizationManager;
    }
}

