/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.library.ConfigHelperDelegate;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.navigator.ConfigContentPackageItemProvider;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.util.DebugUtil;
import org.eclipse.epf.library.edit.util.MethodConfigurationPropUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationData {
    public static boolean ignoreSupportingPlugin = false;
    private static boolean localDebug = false;
    private static boolean profiling = false;
    private MethodConfiguration config;
    private Map<String, MethodElement> substractedElemMap = new HashMap<String, MethodElement>();
    private Map<String, MethodElement> addedElemMap = new HashMap<String, MethodElement>();
    private boolean needUpdateChanges = true;
    private Map<String, ContentCategory> originalSubstracted;
    private Map<String, ContentCategory> orignalAdded;
    private ILibraryManager libraryManager;
    private Adapter configListener;
    private ILibraryChangeListener libListener;
    private boolean enableUpdate = true;
    private SupportingElementData supportingElementData;
    private Set<MethodPackage> elementsUnslectedPkgs;

    public MethodConfiguration getConfig() {
        return this.config;
    }

    public static ConfigurationData newConfigurationData(MethodConfiguration config) {
        Object obj = ExtensionHelper.create(ConfigurationData.class, (Object)config);
        if (obj instanceof ConfigurationData) {
            return (ConfigurationData)obj;
        }
        return new ConfigurationData(config);
    }

    public ConfigurationData(MethodConfiguration config) {
        this.config = config;
        this.elementsUnslectedPkgs = MethodConfigurationPropUtil.getMethodConfigurationPropUtil().getElementsUnslectedPkgs(config);
        this.configListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (ConfigurationData.this.isNeedUpdateChanges()) {
                    return;
                }
                int type = msg.getEventType();
                if (type == 3 || type == 5 || type == 4 || type == 6) {
                    ConfigurationData.this.setNeedUpdateChanges(true);
                }
            }
        };
        config.eAdapters().add((Object)this.configListener);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                ConfigurationData.this.handleLibraryChange(option, changedItems);
            }
        };
        MethodLibrary library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
        this.libraryManager = LibraryService.getInstance().getLibraryManager(library);
        if (this.libraryManager != null) {
            this.libraryManager.addListener(this.libListener);
        }
    }

    protected void handleLibraryChange(int option, Collection changedItems) {
        if (this.isNeedUpdateChanges()) {
            return;
        }
        for (Object item : changedItems) {
            if (!(item instanceof ContentCategory)) continue;
            this.setNeedUpdateChanges(true);
            return;
        }
    }

    protected boolean getUpdatingChanges() {
        return this.originalSubstracted != null && this.orignalAdded != null;
    }

    private void updateChanges() {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (!this.isNeedUpdateChanges()) {
            return;
        }
        if (this.getUpdatingChanges()) {
            return;
        }
        long t = 0L;
        if (profiling) {
            System.out.println("LD> updateChanges_() -> ");
            t = System.currentTimeMillis();
        }
        this.updateChanges_();
        if (profiling) {
            t = System.currentTimeMillis() - t;
            System.out.println("LD> updateChanges_() <- time: " + t);
            System.out.println("");
        }
    }

    private void updateChanges_() {
        boolean changed;
        ConfigurationHelper.getDelegate().fixupLoadCheckPackages(this.getConfig());
        this.substractedElemMap.clear();
        this.addedElemMap.clear();
        List subList = this.config.getSubtractedCategory();
        List addList = this.config.getAddedCategory();
        if (subList.isEmpty() && addList.isEmpty()) {
            if (localDebug) {
                System.out.println("LD> subList/addList are empty.");
            }
            return;
        }
        this.originalSubstracted = this.convertToMap(subList);
        this.orignalAdded = this.convertToMap(addList);
        if (localDebug) {
            DebugUtil.print((String)"originalSubstracted: ", null, this.originalSubstracted.values(), (int)2);
            DebugUtil.print((String)"orignalAdded: ", null, this.orignalAdded.values(), (int)2);
        }
        if ((changed = this.remove(this.originalSubstracted, this.orignalAdded)) && localDebug) {
            DebugUtil.print((String)"orignalAdded after remove: ", null, this.orignalAdded.values(), (int)2);
        }
        Map<String, ContentCategory> calSubstracted = (Map<String, ContentCategory>)((HashMap)this.originalSubstracted).clone();
        Map<String, ContentCategory> calAdded = (Map<String, ContentCategory>)((HashMap)this.orignalAdded).clone();
        changed = this.handleContributors(calSubstracted, true);
        if (changed && localDebug) {
            DebugUtil.print((String)"calSubstracted after handleContributors: ", null, calSubstracted.values(), (int)2);
        }
        if ((changed = this.handleContributors(calAdded, false)) && localDebug) {
            DebugUtil.print((String)"calAdded after handleContributors: ", null, calAdded.values(), (int)2);
        }
        calSubstracted = this.handleReplacers(calSubstracted, true);
        calAdded = this.handleReplacers(calAdded, false);
        if (localDebug) {
            DebugUtil.print((String)"calSubstracted: ", null, calSubstracted.values(), (int)2);
            DebugUtil.print((String)"calAdded: ", null, calAdded.values(), (int)2);
        }
        if ((changed = this.remove(calSubstracted, calAdded)) && localDebug) {
            DebugUtil.print((String)"calAdded after remove: ", null, this.orignalAdded.values(), (int)2);
        }
        if (calSubstracted != null) {
            this.updateElementMap(calSubstracted.values(), this.substractedElemMap);
        }
        if (calAdded != null) {
            this.updateElementMap(calAdded.values(), this.addedElemMap);
        }
        if (localDebug) {
            DebugUtil.print((String)"substractedElemMap: ", null, this.substractedElemMap.values(), (int)2);
            DebugUtil.print((String)"addedElemMap: ", null, this.addedElemMap.values(), (int)2);
        }
        this.setNeedUpdateChanges(false);
        this.originalSubstracted = null;
        this.orignalAdded = null;
    }

    private boolean remove(Map<String, ContentCategory> sourceMap, Map<String, ContentCategory> targetMap) {
        if (sourceMap == null || sourceMap.isEmpty() || targetMap == null || targetMap.isEmpty()) {
            return false;
        }
        boolean ret = false;
        Iterator<String> it = sourceMap.keySet().iterator();
        while (it.hasNext()) {
            ContentCategory cc = targetMap.remove(it.next());
            if (cc == null) continue;
            ret = true;
        }
        return ret;
    }

    private boolean handleContributors(Map<String, ContentCategory> map, boolean substracted) {
        if (map == null) {
            return false;
        }
        ArrayList addedList = new ArrayList();
        for (ContentCategory cc : map.values()) {
            List contributers = ConfigurationHelper.getContributors((VariabilityElement)cc, this.config);
            addedList.addAll(contributers);
        }
        for (ContentCategory cc : addedList) {
            map.put(cc.getGuid(), cc);
        }
        return !addedList.isEmpty();
    }

    private Map<String, ContentCategory> handleReplacers(Map<String, ContentCategory> originals, boolean substracted) {
        if (originals == null || originals.isEmpty()) {
            return originals;
        }
        HashMap<String, ContentCategory> ret = new HashMap<String, ContentCategory>();
        for (ContentCategory cc : originals.values()) {
            VariabilityElement replacer = ConfigurationHelper.getReplacer((VariabilityElement)cc, this.config);
            boolean toKeep = true;
            if (replacer != null) {
                toKeep = false;
                VariabilityElement nestedReplacer = replacer;
                while (nestedReplacer != null) {
                    replacer = nestedReplacer;
                    nestedReplacer = ConfigurationHelper.getReplacer(nestedReplacer, this.config);
                }
                if (substracted && this.originalSubstracted.containsKey(replacer.getGuid())) {
                    toKeep = true;
                }
            }
            if (!toKeep) continue;
            ret.put(cc.getGuid(), cc);
        }
        return ret;
    }

    private Map<String, ContentCategory> convertToMap(Collection<ContentCategory> collection) {
        if (collection == null || collection.isEmpty()) {
            return new HashMap<String, ContentCategory>();
        }
        LinkedHashMap<String, ContentCategory> map = new LinkedHashMap<String, ContentCategory>();
        this.fillMap(collection, map);
        return map;
    }

    private void fillMap(Collection<ContentCategory> collection, Map<String, ContentCategory> map) {
        for (ContentCategory cc : collection) {
            if (map.containsKey(cc.getGuid())) continue;
            map.put(cc.getGuid(), cc);
        }
    }

    private Collection<? extends ContentCategory> getChildCC(ContentCategory cc) {
        if (cc instanceof CustomCategory) {
            return ((CustomCategory)cc).getSubCategories();
        }
        if (cc instanceof Discipline) {
            return ((Discipline)cc).getSubdiscipline();
        }
        if (cc instanceof DisciplineGrouping) {
            return ((DisciplineGrouping)cc).getDisciplines();
        }
        if (cc instanceof Domain) {
            return ((Domain)cc).getSubdomains();
        }
        boolean cfr_ignored_0 = cc instanceof RoleSet;
        if (cc instanceof RoleSetGrouping) {
            return ((RoleSetGrouping)cc).getRoleSets();
        }
        boolean cfr_ignored_1 = cc instanceof WorkProductType;
        return null;
    }

    private void updateElementMap(Collection<ContentCategory> ccList, Map<String, MethodElement> elementMap) {
        if (ccList == null || ccList.isEmpty()) {
            return;
        }
        HashSet<String> seens = new HashSet<String>();
        for (ContentCategory cc : ccList) {
            if (!seens.contains(cc.getGuid())) {
                this.addToElementMap(cc, elementMap);
            }
            seens.add(cc.getGuid());
        }
    }

    private Collection<MethodElement> getElements(ContentCategory cc) {
        ArrayList<MethodElement> elements = new ArrayList<MethodElement>();
        elements.addAll(cc.getAssets());
        elements.addAll(cc.getChecklists());
        elements.addAll(cc.getConceptsAndPapers());
        elements.addAll(cc.getExamples());
        elements.addAll(cc.getGuidelines());
        elements.addAll(cc.getSupportingMaterials());
        if (cc instanceof CustomCategory) {
            elements.addAll(((CustomCategory)cc).getSubCategories());
            elements.addAll(((CustomCategory)cc).getCategorizedElements());
        } else if (cc instanceof Discipline) {
            elements.addAll(((Discipline)cc).getReferenceWorkflows());
            elements.addAll(((Discipline)cc).getSubdiscipline());
            elements.addAll(((Discipline)cc).getTasks());
        } else if (cc instanceof DisciplineGrouping) {
            elements.addAll(((DisciplineGrouping)cc).getDisciplines());
        } else if (cc instanceof Domain) {
            elements.addAll(((Domain)cc).getSubdomains());
            elements.addAll(((Domain)cc).getWorkProducts());
        } else if (cc instanceof RoleSet) {
            elements.addAll(((RoleSet)cc).getRoles());
        } else if (cc instanceof RoleSetGrouping) {
            elements.addAll(((RoleSetGrouping)cc).getRoleSets());
        } else if (cc instanceof Tool) {
            elements.addAll(((Tool)cc).getToolMentors());
        } else if (cc instanceof WorkProductType) {
            elements.addAll(((WorkProductType)cc).getWorkProducts());
        }
        return this.getUniqueCollection(elements);
    }

    private Collection<MethodElement> getUniqueCollection(Collection<MethodElement> elements) {
        LinkedHashSet<MethodElement> ret = new LinkedHashSet<MethodElement>();
        for (MethodElement element : elements) {
            if (ret.contains(element)) continue;
            ret.add(element);
        }
        return ret;
    }

    public boolean isOwnerSelected(MethodElement element, boolean checkSubtracted) {
        ConfigHelperDelegate delegate;
        IRealizationManager mgr;
        boolean ret = this.isOwnerSelected_(element, checkSubtracted);
        if (BrowsingLayoutSettings.INSTANCE.isExcludeUnusedWPDs() && ret && element instanceof WorkProductDescriptor && (mgr = (delegate = ConfigurationHelper.getDelegate()).getRealizationManager(this.getConfig())) != null && delegate.browseOrPublishMode() && PropUtil.getPropUtil().isExcludedFromPublish(element)) {
            ret = false;
        }
        if (localDebug) {
            System.out.println("LD> isOwnerSelected: " + ret + ", " + DebugUtil.toString((MethodElement)element, (int)2));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOwnerSelected_(MethodElement element, boolean checkSubtracted) {
        Process owningProc;
        Activity base;
        if (element == null) {
            return false;
        }
        if (ConfigurationHelper.isDescriptionElement(element)) {
            return true;
        }
        ConfigurationClosure.ProcessNodeLock lock = ConfigurationClosure.processNodeLock;
        if (lock.getLockingThread() != null && lock.getLockingThread() != Thread.currentThread()) {
            ConfigurationClosure.ProcessNodeLock processNodeLock = lock;
            synchronized (processNodeLock) {
                Thread tread = lock.getLockingThread();
                System.out.println("LD> updated locking thread: " + tread);
            }
        }
        if (this.getUpdatingChanges()) {
            if (this.originalSubstracted.containsKey(element.getGuid()) || this.orignalAdded.containsKey(element.getGuid())) {
                return true;
            }
        } else {
            this.updateChanges();
            if (checkSubtracted) {
                if (this.isElementSubtracted(element)) {
                    return false;
                }
                if (element instanceof VariabilityElement && this.contributedBaseInSubstracted((VariabilityElement)element)) {
                    return false;
                }
            }
            if (this.isElementAdded(element)) {
                VariabilityElement base2;
                return !(element instanceof Activity) || (base2 = ((Activity)element).getVariabilityBasedOnElement()) == null || base2 == element || ConfigurationHelper.inConfig((MethodElement)base2, this.config, checkSubtracted);
            }
            boolean isLibOrPluginOrConfig = element instanceof MethodLibrary || element instanceof MethodConfiguration || element instanceof MethodPlugin;
            SupportingElementData seData = this.getSupportingElementData();
            if (!isLibOrPluginOrConfig && seData != null && !seData.bypassLogic()) {
                MethodPlugin plugin;
                if (seData.isNeedUpdateChanges()) {
                    seData.updateChanges();
                }
                if (seData.isEnabled() && ((plugin = UmaUtil.getMethodPlugin((EObject)element)) != null && plugin.isSupporting() || seData.inSupportingPackage(element))) {
                    if (!this.config.getMethodPluginSelection().contains(plugin)) {
                        return false;
                    }
                    int ix = seData.checkInConfigIndex(element);
                    if (ix == 1 || ix == 2) {
                        return ix == 1;
                    }
                }
            }
        }
        if (element instanceof MethodLibrary || element instanceof MethodConfiguration) {
            return true;
        }
        if (element instanceof MethodPlugin) {
            List plugins = this.config.getMethodPluginSelection();
            return plugins != null && plugins.contains(element);
        }
        if (element instanceof Activity && (base = (Activity)((Activity)element).getVariabilityBasedOnElement()) != null && base != element && (owningProc = TngUtil.getOwningProcess((BreakdownElement)base)) != null && owningProc != element && !ConfigurationHelper.inConfig((MethodElement)owningProc, this.config, checkSubtracted)) {
            return false;
        }
        EObject pkg = LibraryUtil.getSelectable((EObject)element);
        if (pkg instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)pkg)) {
            MethodPlugin plugin = LibraryUtil.getMethodPlugin(pkg);
            return ConfigurationHelper.inConfig((MethodElement)plugin, this.config, checkSubtracted);
        }
        List pkgs = this.config.getMethodPackageSelection();
        if (pkgs == null) {
            return false;
        }
        if (pkg instanceof ProcessPackage) {
            EObject pkg_old = pkg;
            while (pkg != null && !(pkg instanceof ProcessComponent) && !pkgs.contains(pkg)) {
                pkg = pkg.eContainer();
            }
            if (pkg == null) {
                pkg = pkg_old;
            }
        }
        return pkg != null && pkgs.contains(pkg) && (!(pkg instanceof MethodPackage) || !this.elementsUnslected((MethodPackage)pkg));
    }

    private boolean contributedBaseInSubstracted(VariabilityElement ve) {
        if (ve.getVariabilityType() != VariabilityType.CONTRIBUTES) {
            return false;
        }
        VariabilityElement base = ve.getVariabilityBasedOnElement();
        if (base == null) {
            return false;
        }
        if (this.substractedElemMap.containsKey(base.getGuid())) {
            return true;
        }
        if (ConfigurationHelper.inConfig((MethodElement)base, this.config, true)) {
            return this.contributedBaseInSubstracted(base);
        }
        return false;
    }

    private void addToElementMap(ContentCategory cc, Map<String, MethodElement> elementMap) {
        Collection<MethodElement> elementList = this.getElements(cc);
        for (MethodElement element : elementList) {
            elementMap.put(element.getGuid(), element);
        }
    }

    public void dispose() {
        if (this.elementsUnslectedPkgs != null) {
            this.elementsUnslectedPkgs.clear();
            this.elementsUnslectedPkgs = null;
        }
        this.config.eAdapters().remove((Object)this.configListener);
        if (this.libraryManager != null) {
            this.libraryManager.removeListener(this.libListener);
        }
    }

    protected boolean isNeedUpdateChanges() {
        return this.needUpdateChanges;
    }

    public void setNeedUpdateChanges(boolean needUpdateChanges) {
        this.needUpdateChanges = needUpdateChanges;
        if (localDebug) {
            System.out.println("LD> setNeedUpdateChanges: " + needUpdateChanges);
        }
    }

    private boolean isEnableUpdate() {
        return this.enableUpdate;
    }

    public void setEnableUpdate(boolean enableUpdate) {
        this.enableUpdate = enableUpdate;
        if (localDebug) {
            System.out.println("LD> setEnableUpdate: " + enableUpdate);
        }
    }

    public Collection<MethodElement> getAddedElements() {
        return this.addedElemMap.values();
    }

    public Collection<MethodElement> getSubtractedElements() {
        return this.substractedElemMap.values();
    }

    public boolean isElementSubtracted(MethodElement element) {
        return this.substractedElemMap.containsKey(element.getGuid());
    }

    public boolean isElementAdded(MethodElement element) {
        return this.addedElemMap.containsKey(element.getGuid());
    }

    private SupportingElementData getSupportingElementData() {
        if (this.supportingElementData == null) {
            this.supportingElementData = LibraryService.getInstance().getConfigurationManager(this.config).getSupportingElementData();
        }
        return this.supportingElementData;
    }

    public boolean isSubstracted(MethodElement element) {
        if (this.getUpdatingChanges()) {
            throw new UnsupportedOperationException();
        }
        this.updateChanges();
        if (this.isElementSubtracted(element)) {
            return true;
        }
        return element instanceof VariabilityElement && this.contributedBaseInSubstracted((VariabilityElement)element);
    }

    public boolean elementsUnslected(MethodPackage pkg) {
        if (ConfigContentPackageItemProvider.oldCode) {
            return false;
        }
        return this.elementsUnslectedPkgs == null ? false : this.elementsUnslectedPkgs.contains(pkg);
    }

    protected boolean hasAddedElements() {
        return this.addedElemMap != null && !this.addedElemMap.isEmpty();
    }

    protected boolean hasSubstractedElements() {
        return this.substractedElemMap != null && !this.substractedElemMap.isEmpty();
    }

    public boolean hasAddedElements(MethodPackage pkg) {
        if (!this.hasAddedElements()) {
            return false;
        }
        if (!(pkg instanceof ContentPackage)) {
            return false;
        }
        for (ContentElement element : ((ContentPackage)pkg).getContentElements()) {
            if (!this.isElementAdded((MethodElement)element)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubstractedElements(MethodPackage pkg) {
        if (!this.hasSubstractedElements()) {
            return false;
        }
        if (!(pkg instanceof ContentPackage)) {
            return false;
        }
        for (ContentElement element : ((ContentPackage)pkg).getContentElements()) {
            if (!this.isElementSubtracted((MethodElement)element)) continue;
            return true;
        }
        return false;
    }

    private boolean elementsUnslectedPkgsModified(Set<MethodPackage> updatedElementsUnslectedPkgs) {
        boolean updatedIsEmpty;
        boolean bl = updatedIsEmpty = updatedElementsUnslectedPkgs == null || updatedElementsUnslectedPkgs.isEmpty();
        if (this.elementsUnslectedPkgs == null || this.elementsUnslectedPkgs.isEmpty()) {
            return !updatedIsEmpty;
        }
        if (updatedIsEmpty) {
            return true;
        }
        if (this.elementsUnslectedPkgs.size() != updatedElementsUnslectedPkgs.size()) {
            return true;
        }
        for (MethodPackage pkg : updatedElementsUnslectedPkgs) {
            if (this.elementsUnslected(pkg)) continue;
            return true;
        }
        return false;
    }

    protected boolean storeElementsUnslectedPkgsProp(IActionManager actionManager, Set<MethodPackage> updatedElementsUnslectedPkgs) {
        if (ConfigContentPackageItemProvider.oldCode) {
            return false;
        }
        if (!this.elementsUnslectedPkgsModified(updatedElementsUnslectedPkgs)) {
            return false;
        }
        this.elementsUnslectedPkgs = updatedElementsUnslectedPkgs;
        MethodConfigurationPropUtil propUtil = MethodConfigurationPropUtil.getMethodConfigurationPropUtil((IActionManager)actionManager);
        propUtil.setElementsUnslectedPkgsProp(this.config, this.elementsUnslectedPkgs);
        return true;
    }

    public String getSelectionInfo(Object selectedElement) {
        if (selectedElement instanceof MethodElement) {
            return ((MethodElement)selectedElement).getBriefDescription();
        }
        return "";
    }

    public String debugSelString() {
        return "";
    }

    public SupportingElementData newSupportingElementData() {
        return new SupportingElementData(this.getConfig());
    }

    public void setBeingEdit(boolean b) {
        this.setBeingEdit(b, false);
    }

    public void setBeingEdit(boolean b, boolean editorDirty) {
    }

    public void updatePackageSelections(IActionManager actionManager, Set<MethodPackage> elementsUnslectedPkgs, Collection<MethodPackage> toggleToUncheckPkgs, Collection<MethodPackage> toggleToCheckPkgs) {
        this.storeElementsUnslectedPkgsProp(actionManager, elementsUnslectedPkgs);
    }

    public boolean isSuppressed(MethodElement element) {
        return false;
    }

    static /* synthetic */ boolean access$0() {
        return localDebug;
    }
}

