/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.configuration.CategoriesItemProvider;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.Log;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFilter
extends AdapterImpl
implements IConfigurator {
    protected MethodConfiguration methodConfig;
    private boolean discardContributors = true;
    public static Object isEmptyCheckLock = new Object();

    public ConfigurationFilter(MethodConfiguration methodConfig) {
        this.methodConfig = methodConfig;
    }

    public ConfigurationFilter(MethodConfiguration methodConfig, boolean discardContributors) {
        this(methodConfig);
        this.discardContributors = discardContributors;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            if (obj instanceof MethodPlugin) {
                MethodPlugin plugin = (MethodPlugin)obj;
                if (MethodPluginPropUtil.getMethodPluginPropUtil().getCustomizedParent(plugin) != null) {
                    return false;
                }
            }
            return true;
        }
        obj = LibraryUtil.unwrap(obj);
        if (this.methodConfig instanceof Scope && obj instanceof MethodElement) {
            return ((Scope)this.methodConfig).inScope((MethodElement)obj);
        }
        if ((ElementRealizer.isExtendReplaceEnabled() || obj instanceof VariabilityElement && ConfigurationHelper.isExtendReplacer((VariabilityElement)obj)) && FeatureValue.isBlankIndicator(obj)) {
            return false;
        }
        if (obj instanceof MethodPackage) {
            return this.methodConfig.getMethodPackageSelection().contains(obj);
        }
        if (obj instanceof MethodElement) {
            return ConfigurationHelper.canShow((MethodElement)obj, this.methodConfig);
        }
        if (obj instanceof ItemProviderAdapter) {
            return true;
        }
        if (Log.DEBUG) {
            System.out.println("Object filtered: " + (obj == null ? null : obj.toString()));
        }
        return false;
    }

    public Collection getChildren(Object obj, EStructuralFeature childFeature) {
        if (this.methodConfig == null) {
            return null;
        }
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig);
        realizer.setDiscardContributor(this.discardContributors);
        if (childFeature != null && childFeature.isMany() && obj instanceof MethodElement) {
            List value = ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, childFeature, realizer);
            return value;
        }
        return null;
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.methodConfig;
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.methodConfig = config;
    }

    protected void resolveElementVariabilityList(VariabilityElement element, VariabilityInfo info, boolean includeBase, ElementRealizer realizer) {
        if (this.methodConfig == null) {
            return;
        }
        this.resolveElementContributors(element, info, realizer);
        if (ConfigurationHelper.isExtender(element)) {
            List values;
            VariabilityElement base = element.getVariabilityBasedOnElement();
            VariabilityElement e = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)base, realizer);
            if (includeBase && !(values = info.getInheritanceList()).contains(e)) {
                values.add(e);
            }
            this.resolveElementVariabilityList(e, info, includeBase, realizer);
        }
    }

    protected void resolveElementContributors(VariabilityElement element, VariabilityInfo info, ElementRealizer realizer) {
        List items = ConfigurationHelper.getContributors(element, this.methodConfig);
        if (items != null && items.size() > 0) {
            for (VariabilityElement e : items) {
                List values = info.getContributors();
                if (!values.contains(e)) {
                    values.add(e);
                }
                this.resolveElementVariabilityList(e, info, false, realizer);
            }
        }
    }

    public VariabilityInfo getVariabilityInfo(VariabilityElement ve) {
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig, true, true);
        return this.getVariabilityInfo(ve, realizer);
    }

    protected VariabilityInfo getVariabilityInfo(VariabilityElement ve, ElementRealizer realizer) {
        VariabilityElement e = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)ve, realizer);
        if (e == null) {
            return null;
        }
        VariabilityInfo info = new VariabilityInfo(ve);
        info.getInheritanceList().add(e);
        this.resolveElementVariabilityList(e, info, true, realizer);
        return info;
    }

    public Object resolve(Object element) {
        if (element instanceof VariabilityElement) {
            ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig, true, true);
            return ConfigurationHelper.getCalculatedElement((MethodElement)element, realizer);
        }
        return element;
    }

    public IFilter getUncategorizedTaskFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof Task && ConfigurationHelper.calc0nFeatureValue((MethodElement)((Task)obj), AssociationHelper.Task_Disciplines, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getDomainUncategorizedWorkProductFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof WorkProduct && ConfigurationHelper.calc0nFeatureValue((MethodElement)((WorkProduct)obj), AssociationHelper.WorkProduct_Domains, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getWpTypeUncategorizedWorkProductFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof WorkProduct && ConfigurationHelper.calc0nFeatureValue((MethodElement)((WorkProduct)obj), AssociationHelper.WorkProduct_WorkProductTypes, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getUncategorizedRoleFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof Role && ConfigurationHelper.calc0nFeatureValue((MethodElement)((Role)obj), AssociationHelper.Role_RoleSets, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getUncategorizedToolMentorFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof ToolMentor && ConfigurationHelper.calc0nFeatureValue((MethodElement)((ToolMentor)obj), AssociationHelper.ToolMentor_Tools, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getDisciplinesFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                if (obj instanceof DisciplineGrouping) {
                    return true;
                }
                return obj instanceof Discipline && ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, AssociationHelper.Discipline_DisciplineGroupings, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getRoleSetsFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                if (obj instanceof RoleSetGrouping) {
                    return true;
                }
                return obj instanceof RoleSet && ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, AssociationHelper.RoleSet_RoleSetGrouppings, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IRealizationManager getRealizationManager() {
        MethodConfiguration c = this.getMethodConfiguration();
        return ConfigurationHelper.getDelegate().getRealizationManager(c);
    }

    public Collection<?> getModifiedChildren(Object parentObject, Collection children) {
        if (!ConfigurationHelper.getDelegate().filterOutEmptyCategories()) {
            return children;
        }
        if (children == null || children.isEmpty()) {
            return children;
        }
        boolean modified = false;
        ArrayList modifiedChildren = new ArrayList();
        if (parentObject instanceof CategoriesItemProvider || TngUtil.unwrap((Object)parentObject) instanceof ContentCategory) {
            for (Object child : children) {
                if (child instanceof ContentCategory) {
                    if (!this.isEmpty((ContentCategory)child)) {
                        modifiedChildren.add(child);
                        continue;
                    }
                    modified = true;
                    continue;
                }
                modifiedChildren.add(child);
            }
        }
        return modified ? modifiedChildren : children;
    }

    public boolean isEmpty(ContentCategory cc) {
        return this.isEmpty(cc, new HashMap<ContentCategory, Boolean>());
    }

    private boolean isEmpty(ContentCategory cc, Map<ContentCategory, Boolean> processedMap) {
        Boolean bvalue = processedMap.get(cc);
        if (bvalue == null) {
            Map map = MethodElementPropUtil.getMethodElementPropUtil().getExtendedPropertyMap((MethodElement)cc, true);
            try {
                map.put(isEmptyCheckLock, true);
                boolean b = this.isEmpty_(cc, processedMap);
                bvalue = b ? Boolean.TRUE : Boolean.FALSE;
                processedMap.put(cc, bvalue);
            }
            finally {
                map.remove(isEmptyCheckLock);
            }
        }
        return bvalue;
    }

    private boolean isEmpty_(ContentCategory cc, Map<ContentCategory, Boolean> processedMap) {
        List value;
        LibraryEditUtil util = LibraryEditUtil.getInstance();
        EReference ref = this.getCategorizedRef(cc);
        List list = value = ref == null ? null : util.calc0nFeatureValue((MethodElement)cc, (EStructuralFeature)ref, this.getMethodConfiguration());
        if (value instanceof List) {
            for (Object item : value) {
                if (item instanceof ContentCategory) continue;
                return false;
            }
        }
        List list2 = value = (ref = this.getSubCategoryRef(cc)) == null ? null : util.calc0nFeatureValue((MethodElement)cc, (EStructuralFeature)ref, this.getMethodConfiguration());
        if (value instanceof List) {
            for (Object item : value) {
                if (!(item instanceof ContentCategory) || this.isEmpty((ContentCategory)item, processedMap)) continue;
                return false;
            }
        }
        return true;
    }

    private EReference getSubCategoryRef(ContentCategory cc) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (cc instanceof CustomCategory) {
            return up.getCustomCategory_CategorizedElements();
        }
        if (cc instanceof Discipline) {
            return up.getDiscipline_Subdiscipline();
        }
        if (cc instanceof DisciplineGrouping) {
            return up.getDisciplineGrouping_Disciplines();
        }
        if (cc instanceof Domain) {
            return up.getDomain_Subdomains();
        }
        if (cc instanceof RoleSet) {
            return null;
        }
        if (cc instanceof RoleSetGrouping) {
            return up.getRoleSetGrouping_RoleSets();
        }
        if (cc instanceof Tool) {
            return null;
        }
        if (cc instanceof WorkProductType) {
            return null;
        }
        return null;
    }

    private EReference getCategorizedRef(ContentCategory cc) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (cc instanceof CustomCategory) {
            return up.getCustomCategory_CategorizedElements();
        }
        if (cc instanceof Discipline) {
            return up.getDiscipline_Tasks();
        }
        if (cc instanceof DisciplineGrouping) {
            return null;
        }
        if (cc instanceof Domain) {
            return up.getDomain_WorkProducts();
        }
        if (cc instanceof RoleSet) {
            return up.getRoleSet_Roles();
        }
        if (cc instanceof RoleSetGrouping) {
            return null;
        }
        if (cc instanceof Tool) {
            return up.getTool_ToolMentors();
        }
        if (cc instanceof WorkProductType) {
            return up.getWorkProductType_WorkProducts();
        }
        return null;
    }

    public ElementRealizer getRealizer() {
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig);
        return realizer;
    }
}

