/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TeamProfile;

public class ProcessConfigurator
extends ConfigurationFilter {
    private boolean checkOwningProcess;

    public ProcessConfigurator(MethodConfiguration methodConfig) {
        super(methodConfig);
    }

    public ProcessConfigurator(MethodConfiguration methodConfig, boolean checkOwningProcess) {
        this(methodConfig);
        this.checkOwningProcess = checkOwningProcess;
    }

    public void setMethodConfiguration(MethodConfiguration newConfig) {
        this.methodConfig = newConfig;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            return true;
        }
        if (obj instanceof BreakdownElement) {
            ElementRealizer realizer = this.getRealizer();
            return this.accept((BreakdownElement)obj, realizer);
        }
        return super.accept(obj);
    }

    protected boolean accept(BreakdownElement e, final ElementRealizer realizer) {
        if (e instanceof Milestone || e instanceof TeamProfile) {
            return true;
        }
        if (e instanceof Activity) {
            return ProcessUtil.accept((Activity)((Activity)e), (IFilter)new IFilter(){

                public boolean accept(Object obj) {
                    return obj instanceof MethodElement ? realizer.inConfig((MethodElement)obj) : true;
                }
            }, (boolean)this.checkOwningProcess);
        }
        if (e instanceof Descriptor) {
            MethodElement linked_obj = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)e));
            if (linked_obj == null || linked_obj.eIsProxy()) {
                return true;
            }
            linked_obj = ConfigurationHelper.getCalculatedElement(linked_obj, realizer);
            return realizer.inConfig(linked_obj);
        }
        return super.accept(e);
    }

    public IRealizationManager getRealizationManager() {
        MethodConfiguration c = LibraryService.getInstance().getCurrentMethodConfiguration();
        return ConfigurationHelper.getDelegate().getRealizationManager(c);
    }
}

