/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.closure.ElementError;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;

public class ConfigurationErrorMatrix {
    public static ElementError getError(MethodConfiguration config, ElementReference ref) {
        MethodElement e_ref = ref.getRefElement();
        ConfigurationData cData = ConfigurationHelper.getDelegate().getConfigurationData(config);
        if (cData != null && cData.isElementSubtracted(e_ref)) {
            return null;
        }
        if (ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement())) {
            return ConfigurationErrorMatrix.getVariabilityError(config, ref);
        }
        int errorLevel = 4;
        String messageId = LibraryResources.ElementError_missing_element;
        MethodElement e = ref.getElement();
        if (ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput())) {
            errorLevel = 1;
            messageId = LibraryResources.ElementError_missing_mandatory_input;
        } else if (ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output())) {
            errorLevel = 1;
            messageId = LibraryResources.ElementError_missing_output;
        } else if (ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy())) {
            errorLevel = 2;
            messageId = LibraryResources.ElementError_missing_primary_performer;
        } else if (ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor())) {
            errorLevel = 2;
            messageId = LibraryResources.ElementError_missing_responsible_for_workProduct;
        } else if (!(ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()) || ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput()) || ref.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRole_Modifies()))) {
            if (ConfigurationErrorMatrix.isBreakdownReference(e, e_ref)) {
                errorLevel = 4;
            } else if (!ConfigurationErrorMatrix.isGuidanceReference(e, e_ref)) {
                return null;
            }
        }
        String message = LibraryResources.bind((String)messageId, (Object[])new String[]{LibraryUtil.getTypePath(e), LibraryUtil.getTypePath(e_ref)});
        return new ElementError(config, errorLevel, message, e, e_ref, 16, messageId);
    }

    private static boolean isBreakdownReference(MethodElement e, MethodElement e_ref) {
        return (e_ref instanceof Task || e_ref instanceof Role || e_ref instanceof WorkProduct) && e instanceof BreakdownElement;
    }

    private static boolean isGuidanceReference(MethodElement e, MethodElement e_ref) {
        return (e instanceof Task || e instanceof Role || e instanceof WorkProduct) && e_ref instanceof Guidance;
    }

    private static ElementError getVariabilityError(MethodConfiguration config, ElementReference ref) {
        VariabilityElement e = (VariabilityElement)ref.getElement();
        VariabilityElement e_ref = (VariabilityElement)ref.getRefElement();
        if (e.getVariabilityBasedOnElement() != e_ref) {
            return null;
        }
        VariabilityType type = e.getVariabilityType();
        int errorLevel = 2;
        String messageId = LibraryResources.ElementError_missing_element;
        if (type == VariabilityType.CONTRIBUTES) {
            if (e instanceof ContentCategory || e instanceof Guidance) {
                errorLevel = 4;
            }
            messageId = LibraryResources.ElementError_contributor_missing_base;
        } else if (type == VariabilityType.EXTENDS) {
            messageId = LibraryResources.ElementError_extender_missing_base;
        } else if (type == VariabilityType.REPLACES || type == VariabilityType.EXTENDS_REPLACES) {
            messageId = LibraryResources.ElementError_replacer_missing_base;
        }
        String message = LibraryResources.bind((String)messageId, (Object[])new String[]{LibraryUtil.getTypePath((MethodElement)e), LibraryUtil.getTypePath((MethodElement)e_ref)});
        return new ElementError(config, errorLevel, message, e, e_ref, 16, messageId);
    }
}

