/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.configuration.closure.PackageDependency;
import org.eclipse.epf.library.configuration.closure.PackageReference;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodLibrary library;
    protected ILibraryManager libraryManager;
    protected Map dependencyMap = new HashMap();
    private ILibraryChangeListener libListener = null;
    private Set<VariabilityElement> replacerSet = new HashSet<VariabilityElement>();
    private MethodConfiguration config;

    public DependencyManager(MethodLibrary library, MethodConfiguration config) {
        this.library = library;
        this.libraryManager = LibraryService.getInstance().getLibraryManager(library);
        this.config = config;
        this.init();
    }

    private void reset() {
        this.dependencyMap = new HashMap();
        this.replacerSet = new HashSet<VariabilityElement>();
    }

    protected void init() {
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                if (option == 16) {
                    DependencyManager.this.reset();
                } else if ((option == 8 || option == 32) && changedItems != null && changedItems.size() > 0) {
                    DependencyManager.this.reset();
                }
            }
        };
        this.libraryManager.addListener(this.libListener);
    }

    public PackageDependency getDependency(MethodElement element) {
        if (!LibraryUtil.selectable((EObject)element)) {
            return null;
        }
        PackageDependency dependency = this.getDependency(element, false);
        if (dependency == null || !dependency.isLoaded()) {
            this.buildDependency(element);
        }
        return this.getDependency(element, false);
    }

    public void printDependency() {
        Iterator it = this.dependencyMap.values().iterator();
        while (it.hasNext()) {
            ((PackageDependency)it.next()).print();
        }
    }

    private void buildDependency(MethodElement element) {
        block7: {
            if (element == null) {
                return;
            }
            try {
                PackageDependency dependency = this.buildDependencyFor(element);
                boolean isProcess = element instanceof ProcessComponent;
                EList elements = element.eContents();
                if (elements != null) {
                    for (Object obj : elements) {
                        if (!(obj instanceof MethodElement)) continue;
                        MethodElement methodElement = (MethodElement)obj;
                        if (methodElement != null && !LibraryUtil.selectable((EObject)methodElement)) {
                            this.buildDependencyFor(methodElement);
                            continue;
                        }
                        if (!isProcess || !(methodElement instanceof ProcessPackage)) continue;
                        TreeIterator itt = methodElement.eAllContents();
                        while (itt.hasNext()) {
                            MethodElement m;
                            Object objj = itt.next();
                            if (!(objj instanceof MethodElement) || LibraryUtil.selectable((EObject)(m = (MethodElement)objj))) continue;
                            this.buildDependencyFor(m);
                        }
                    }
                }
                dependency.setLoaded(true);
            }
            catch (Exception e) {
                if (!debug) break block7;
                e.printStackTrace();
            }
        }
    }

    private PackageDependency buildDependencyFor(MethodElement element) {
        MethodElement selectableElement;
        SupportingElementData seData;
        if (element == null) {
            return null;
        }
        IConfigurationManager configMgr = LibraryService.getInstance().getConfigurationManager(this.config);
        if (configMgr != null && (seData = configMgr.getSupportingElementData()) != null && seData.isEnabled()) {
            seData.processVariabilityChildren(element, null);
        }
        if ((selectableElement = (MethodElement)LibraryUtil.getSelectable((EObject)element)) == null) {
            return null;
        }
        PackageDependency dependency = this.getDependency(selectableElement, true);
        dependency.removeReference(element);
        List properties = LibraryUtil.getStructuralFeatures(element, true);
        int i = 0;
        while (i < properties.size()) {
            Object value;
            EReference feature;
            EStructuralFeature f = (EStructuralFeature)properties.get(i);
            if (!(!(f instanceof EReference) || (feature = (EReference)f).isContainer() || feature.isContainment() || element instanceof Task && feature == UmaPackage.eINSTANCE.getTask_Steps() || element instanceof TaskDescriptor && feature == UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps() || (value = TypeDefUtil.getInstance().eGet((EObject)element, (EStructuralFeature)feature)) == null)) {
                MethodElement refElement = null;
                List values = null;
                int count = 0;
                if (feature.isMany()) {
                    values = (List)value;
                    if (values.size() > 0) {
                        refElement = (MethodElement)values.get(count);
                    }
                } else if (value instanceof MethodElement) {
                    refElement = (MethodElement)value;
                    if (this.replacerSet != null && feature == UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement()) {
                        VariabilityType type;
                        VariabilityElement ve = element instanceof VariabilityElement ? (VariabilityElement)element : null;
                        VariabilityType variabilityType = type = ve == null ? null : ve.getVariabilityType();
                        if (type == VariabilityType.EXTENDS_REPLACES || type == VariabilityType.REPLACES) {
                            this.replacerSet.add(ve);
                        }
                    }
                }
                while (refElement != null) {
                    MethodElement selectableRef;
                    boolean skip = false;
                    if (feature == UmaPackage.eINSTANCE.getRole_Modifies()) {
                        skip = true;
                    }
                    MethodElement methodElement = selectableRef = skip ? null : (MethodElement)LibraryUtil.getSelectable((EObject)refElement);
                    if (selectableRef != null) {
                        PackageReference pkgRef = dependency.getReference(selectableRef, true);
                        if (element == selectableElement && refElement == selectableRef) break;
                        ElementReference ref = pkgRef.getReference(element, refElement);
                        if (ref == null) {
                            ref = new ElementReference(element, refElement);
                            pkgRef.addReference(ref);
                        }
                        ref.addFeature((EStructuralFeature)feature);
                        this.getDependency(selectableRef, true).addDependent(selectableElement);
                    }
                    refElement = null;
                    if (values == null || ++count >= values.size()) continue;
                    refElement = (MethodElement)values.get(count);
                }
            }
            ++i;
        }
        return dependency;
    }

    private PackageDependency getDependency(MethodElement element, boolean create) {
        if (!LibraryUtil.selectable((EObject)element)) {
            if (debug) {
                System.out.println("Error, Selectable element required: " + element);
            }
            return null;
        }
        PackageDependency dependency = (PackageDependency)this.dependencyMap.get(element);
        if (dependency == null && create) {
            dependency = new PackageDependency(element);
            this.dependencyMap.put(element, dependency);
        }
        return dependency;
    }

    private void handleDeletedElement(Collection changedItems) {
        for (Object element : changedItems) {
            if (!(element instanceof MethodElement)) continue;
            this.removeReference((MethodElement)element);
        }
    }

    private void removeReference(MethodElement element) {
        PackageDependency dependency = null;
        MethodElement pkg = (MethodElement)LibraryUtil.getSelectable((EObject)element);
        if (pkg == null || (dependency = this.getDependency(pkg, false)) == null) {
            return;
        }
        dependency.removeReference(element);
    }

    public Set<VariabilityElement> getReplacerSet() {
        return this.replacerSet;
    }

    public void setReplacerSet(Set<VariabilityElement> replacerSet) {
        this.replacerSet = replacerSet;
    }

    public void dispose() {
        if (this.libraryManager != null) {
            this.libraryManager.removeListener(this.libListener);
        }
        this.library = null;
        this.libraryManager = null;
        this.dependencyMap = null;
        this.libListener = null;
        this.replacerSet = null;
        this.config = null;
    }
}

