/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

public class ErrorInfo {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 4;
    public static final int CHILD_ERROR = 8;
    public static final int CHILD_WARNING = 16;
    public static final int REFERENCE_TO = 16;
    public static final int REFERENCED_BY = 32;
    protected String category;
    protected int errorLevel;
    protected Object ownerElement;
    protected Object causeElement;
    protected String errorMessage;
    protected int relation = 0;
    private String messageId;

    public ErrorInfo(int errorLevel, String message, Object ownerElement, Object causeElement, int relation, String messageId) {
        this.ownerElement = ownerElement;
        this.causeElement = causeElement;
        this.errorLevel = errorLevel;
        this.errorMessage = message;
        this.relation = relation;
        this.messageId = messageId;
    }

    public int getRelation() {
        return this.relation;
    }

    public Object getOwnerElement() {
        return this.ownerElement;
    }

    public Object getCauseElement() {
        return this.causeElement;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public boolean isError() {
        return (this.errorLevel & 1) > 0;
    }

    public boolean isWarning() {
        return (this.errorLevel & 2) > 0;
    }

    public String getCategory() {
        return this.category;
    }

    public String getMessageId() {
        return this.messageId;
    }
}

