/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.diagram.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.diagram.providers.IDiagramIconProvider;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.swt.graphics.Image;

public class DiagramIconProviderManager {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.diagram.core";
    public static final String EXTENSION_POINT_NAME = "diagramIconProviders";
    public static final String CLASS_ATTRIB_NAME = "class";
    private static DiagramIconProviderManager instance;
    private ArrayList<IDiagramIconProvider> providers;

    private DiagramIconProviderManager() {
    }

    public static DiagramIconProviderManager getInstance() {
        if (instance == null) {
            instance = new DiagramIconProviderManager();
        }
        return instance;
    }

    public Image getIcon(EObject element, boolean smallIcon) {
        Image image = null;
        if (this.providers == null) {
            this.loadProviders();
        }
        if (element instanceof Role || element instanceof Task || element instanceof WorkProduct) {
            int index = 0;
            while (index < this.providers.size() && image == null) {
                IDiagramIconProvider iProvider = this.providers.get(index);
                image = iProvider.getImageForElement((MethodElement)element, false);
                ++index;
            }
        }
        return image;
    }

    private void loadProviders() {
        this.providers = new ArrayList();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        this.providers.add((IDiagramIconProvider)configElement.createExecutableExtension(CLASS_ATTRIB_NAME));
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

