/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publish.layout.LayoutPlugin;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlBuilder {
    private boolean debug = false;
    private Properties xslParams = null;
    private ElementLayoutManager mgr = null;
    private ElementLayoutManager internal_mgr = null;
    private boolean scanContent = true;
    private boolean showTreeBrowser = false;
    private String layoutXslRootPath = LayoutPlugin.getDefault().getLayoutXslPath();
    private Map<MethodElement, String> elementContentMap;

    public HtmlBuilder() {
        this(null);
    }

    public HtmlBuilder(ElementLayoutManager mgr) {
        this.init();
        this.setLayoutManager(mgr);
    }

    public void setElementContentMap(Map<MethodElement, String> elementContentMap) {
        this.elementContentMap = elementContentMap;
    }

    public void setLayoutXslRootPath(String path) {
        try {
            if (path != null && path.length() > 0) {
                this.layoutXslRootPath = path;
                if (!this.layoutXslRootPath.endsWith(File.separator)) {
                    this.layoutXslRootPath = String.valueOf(this.layoutXslRootPath) + File.separator;
                }
                File file = new File(this.layoutXslRootPath, "resources.properties");
                Locale locale = Locale.getDefault();
                String localFileName = I18nUtil.getLocalizedFile((String)file.getAbsolutePath(), (Locale)locale);
                if (localFileName != null) {
                    file = new File(localFileName);
                }
                if (file.exists()) {
                    this.xslParams.load(new FileInputStream(file));
                }
                PreferenceUtil.setXslProperties(this.xslParams);
            }
        }
        catch (IOException iOException) {}
    }

    protected void init() {
        this.debug = LibraryPlugin.getDefault().isDebugging();
        this.loadDefaultLayoutXsl();
    }

    public void addParam(String key, String value) {
        this.xslParams.put(key, value);
    }

    public void loadDefaultLayoutXsl() {
        this.layoutXslRootPath = LayoutPlugin.getDefault().getLayoutXslPath();
        try {
            this.xslParams = LayoutPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            this.xslParams.put("colon_with_space", LibraryResources.colon_with_space);
            PreferenceUtil.setXslProperties(this.xslParams);
        }
        catch (IOException iOException) {
            this.xslParams = null;
        }
    }

    public String getPublishDir() {
        return this.mgr == null ? null : this.mgr.getPublishDir();
    }

    public void setPublishDir(String dir) {
        if (this.mgr != null) {
            this.mgr.setPublishDir(dir);
        }
        this.getValidator().setPublishDir(dir);
    }

    public IContentValidator getValidator() {
        return this.mgr.getValidator();
    }

    public void enableTreeBrowser(boolean flag) {
        this.showTreeBrowser = flag;
    }

    public void enableContentScan(boolean scan) {
        this.scanContent = scan;
    }

    public boolean contentScanEnabled() {
        return this.scanContent;
    }

    public void setLayoutManager(ElementLayoutManager mgr) {
        this.mgr = mgr;
        if (this.mgr == null) {
            this.mgr = this.getDefaultLayoutManager();
        }
        this.getValidator().setPublishDir(this.getPublishDir());
    }

    private ElementLayoutManager getDefaultLayoutManager() {
        if (this.internal_mgr == null) {
            this.internal_mgr = new ElementLayoutManager();
        }
        return this.internal_mgr;
    }

    public ElementLayoutManager getLayoutManager() {
        if (this.mgr == null) {
            this.mgr = this.getDefaultLayoutManager();
        }
        return this.mgr;
    }

    public String generateHtml(MethodElement element) {
        String url = null;
        if (this.debug) {
            long startTime = System.currentTimeMillis();
            IElementLayout layout = this.getLayoutManager().getLayout(element, true);
            url = this.generateHtml(layout);
            long endTime = System.currentTimeMillis();
            System.out.println("Time taken to render HTML page for " + element.getName() + ": " + (endTime - startTime) + " ms");
        } else {
            IElementLayout layout = this.getLayoutManager().getLayout(element, true);
            url = this.generateHtml(layout);
        }
        return url;
    }

    public void generateHtml(String url) {
        IElementLayout layout = this.getLayoutManager().getLayout(url);
        this.generateHtml(layout);
    }

    public String generateHtml(IElementLayout layout) {
        long time_end;
        long mini_seconds;
        if (layout == null) {
            return "about:blank";
        }
        long time_start = Calendar.getInstance().getTimeInMillis();
        String elementPath = layout.getNoAdjustedElementPath().replace('/', File.separatorChar);
        String elementPathName = String.valueOf(elementPath) + layout.getFileName(".html");
        String filePath = String.valueOf(this.getPublishDir()) + elementPath;
        String html_file = String.valueOf(this.getPublishDir()) + elementPathName;
        try {
            StringBuffer xml = this.getXml(layout);
            File f = new File(filePath);
            if (!f.exists()) {
                f.mkdirs();
            }
            List layouts = layout.getLayouts();
            String xsl_uri = String.valueOf(this.layoutXslRootPath) + layout.getXslUrl();
            this.generateHtml(layout, xsl_uri, html_file, xml);
            if (layouts != null && layouts.size() > 0) {
                for (LayoutInfo info : layouts) {
                    xsl_uri = String.valueOf(this.layoutXslRootPath) + info.layout_xsl;
                    String file = String.valueOf(filePath) + info.fileName;
                    this.generateHtml(layout, xsl_uri, file, xml);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            html_file = null;
        }
        if ((mini_seconds = (time_end = Calendar.getInstance().getTimeInMillis()) - time_start) > 1000L) {
            String msg = String.valueOf(mini_seconds) + " mini-second(s) publishing element " + LibraryUtil.getTypeName(layout.getElement()) + "[" + elementPathName + "]";
            IContentValidator validator = this.getValidator();
            if (validator == null) {
                System.out.println(msg);
            } else {
                validator.logInfo(msg);
            }
        }
        if (html_file != null) {
            return html_file;
        }
        return "about:blank";
    }

    private void generateHtml(IElementLayout layout, String xsl_uri, String html_file, StringBuffer xml) {
        Exception th = null;
        if (layout == null) {
            return;
        }
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        try {
            DescriptorLayout dLayout;
            MethodElement linedElement;
            StringWriter sw = new StringWriter();
            if (this.getValidator().showLinkedPageForDescriptor() && layout instanceof DescriptorLayout && (linedElement = (dLayout = (DescriptorLayout)layout).getLinkedElement()) != null) {
                this.getValidator().addReferencedElement(dLayout.getElement(), linedElement);
                return;
            }
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)this.xslParams, (Writer)sw);
            sw.flush();
            String content = sw.getBuffer().toString();
            if (this.debug) {
                timer.stop();
                System.out.println(String.valueOf(timer.getTime()) + " mini seconds for xml/xslt transformation");
                timer.start();
            }
            content = ResourceHelper.validateContent(layout.getElement(), content, this.getValidator(), layout.getLayoutMgr().getConfiguration(), this.layoutXslRootPath);
            if (this.contentScanEnabled()) {
                this.getValidator().scanContent(layout, content);
            }
            content = this.getLayoutManager().getAdjustedElementPathStringValue(content);
            if (this.elementContentMap != null) {
                this.elementContentMap.put(layout.getElement(), content);
            }
            if (this.debug) {
                timer.stop();
                System.out.println(String.valueOf(timer.getTime()) + " mini seconds scanning content");
                timer.start();
            }
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(html_file), "utf-8");
            output.write(content);
            output.flush();
            output.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            th = e;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            th = e;
        }
        catch (IOException e) {
            e.printStackTrace();
            th = e;
        }
        catch (Exception e) {
            e.printStackTrace();
            th = e;
        }
        if (th != null) {
            this.getValidator().logError(layout.getElement(), "Error generating element content", th);
        }
    }

    private StringBuffer getXml(IElementLayout layout) {
        StringBuffer xml = new StringBuffer();
        XmlElement xmlElement = layout.getXmlElement(true);
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        xmlElement.setAttribute("lang", lang);
        if (this.showTreeBrowser) {
            xmlElement.setAttribute("showTreeBrowser", "true");
        }
        xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
        if (this.debug) {
            try {
                String xml_file = String.valueOf(this.getPublishDir()) + "xml" + File.separator;
                xml_file = String.valueOf(xml_file) + layout.getType() + "." + layout.getFileName(".xml");
                File xf = new File(xml_file);
                if (!xf.exists()) {
                    xf.getParentFile().mkdirs();
                    xf.createNewFile();
                }
                OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(xf), "utf-8");
                output.write(xml.toString());
                output.flush();
                output.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return xml;
    }

    public void dispose() {
        if (this.internal_mgr != null) {
            this.internal_mgr.clear();
            this.internal_mgr = null;
        }
        this.mgr = null;
    }
}

