/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publish.layout.LayoutPlugin;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.ProcessComponent;

public class LinkInfo {
    public static final String LINK_ATTR_CLASS = "class";
    public static final String LINK_ATTR_GUID = "guid";
    public static final String LINK_ATTR_HREF = "href";
    public static final String LINK_ATTR_KEY = "key";
    public static final String LINK_ATTR_TEXT = "text";
    public static final String LINK_ATTR_NAME = "name";
    private String linkedText = "";
    private MethodElement linkElement = null;
    private MethodElement ownerElement = null;
    private boolean isMissingReference = false;
    private Map<String, String> attributeMap = new LinkedHashMap<String, String>();
    private IContentValidator validator;
    private String pubDir;
    private String tag;
    private static MethodLibrary library;

    public LinkInfo(MethodElement owner, IContentValidator validator, String pubDir, String tag) {
        this.ownerElement = owner;
        this.validator = validator;
        this.pubDir = pubDir;
        this.tag = tag;
    }

    public boolean isElementLink() {
        return ResourceHelper.isElementLink(this.getElementLinkType());
    }

    public String getElementLinkType() {
        return this.getAttribute(LINK_ATTR_CLASS);
    }

    public String getGuid() {
        return this.getAttribute(LINK_ATTR_GUID);
    }

    public String getUrl() {
        return this.getAttribute(LINK_ATTR_HREF);
    }

    public String getLinkedText() {
        return this.linkedText;
    }

    public MethodElement getLinkedElement() {
        return this.linkElement;
    }

    public StringBuffer getHtml(boolean showBrokenLinks) {
        StringBuffer buffer = new StringBuffer();
        if (this.isMissingReference && this.pubDir != null) {
            String url = "";
            if (!showBrokenLinks) {
                buffer.append(this.linkedText);
                return buffer;
            }
            url = this.getMissingElementUrl();
            buffer.append("<img alt=\"\" src=\"" + ResourceHelper.getBackPath(this.ownerElement) + "images/no_rup.gif\">&#160;");
            this.setUrl(url);
        }
        buffer.append("<" + this.tag);
        for (Map.Entry<String, String> entry : this.attributeMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (LINK_ATTR_HREF.equals(key) && (value == null || value.length() == 0)) continue;
            buffer.append(" ").append(entry.getKey()).append("=").append("\"").append(entry.getValue()).append("\"");
        }
        buffer.append(">").append(this.linkedText).append("</" + this.tag + ">");
        return buffer;
    }

    public void validateLink(String attributes, String text, MethodConfiguration config) {
        String url;
        this.linkedText = text;
        Matcher m2 = ResourceHelper.p_tag_attributes.matcher(attributes);
        while (m2.find()) {
            String attrName = m2.group(1).trim().toLowerCase();
            String attrValue = "";
            if (m2.group(3) != null) {
                attrValue = m2.group(3).trim();
            } else if (m2.group(2) != null) {
                attrValue = m2.group(2).trim();
            }
            if (attrName.equals(LINK_ATTR_HREF)) {
                try {
                    attrValue = this.decode(attrValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.attributeMap.put(attrName, attrValue);
        }
        String guid = this.getGuid();
        if (guid == null && (guid = ResourceHelper.getGuidFromFileName(url = this.getUrl())) != null) {
            this.setGuid(guid);
        }
        this.validateElementUrl(config);
    }

    protected String decode(String str) throws UnsupportedEncodingException {
        if (NetUtil.isRawUrl((String)str)) {
            return str;
        }
        return URLDecoder.decode(str, "UTF-8");
    }

    private String getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    private void setGuid(String guid) {
        this.attributeMap.put(LINK_ATTR_GUID, guid);
    }

    public void setUrl(String url) {
        this.attributeMap.put(LINK_ATTR_HREF, url);
    }

    private void validateElementUrl(MethodConfiguration config) {
        String guid = this.getGuid();
        if (guid != null) {
            MethodElement e = null;
            e = LinkInfo.getMethodElement(guid);
            if (e instanceof ProcessComponent) {
                e = ((ProcessComponent)e).getProcess();
            }
            if (e instanceof MethodPackage || e instanceof MethodConfiguration || e instanceof MethodLibrary) {
                e = null;
                this.setUrl(null);
                return;
            }
            if (e != null) {
                if (config != null) {
                    MethodElement e1 = ConfigurationHelper.getCalculatedElement(e, config);
                    if (e1 != null) {
                        if (!this.validator.showBrokenLinks() && this.validator.isDiscarded(this.ownerElement, null, e1)) {
                            this.isMissingReference = true;
                            this.validator.logMissingReference(this.ownerElement, e1);
                        } else {
                            e = e1;
                        }
                    } else {
                        this.isMissingReference = true;
                        this.validator.logMissingReference(this.ownerElement, e);
                    }
                }
            } else {
                boolean toLog = true;
                if (this.ownerElement instanceof CustomCategory && MethodElementPropUtil.getMethodElementPropUtil().isTransientElement(this.ownerElement)) {
                    toLog = false;
                }
                if (toLog) {
                    this.isMissingReference = true;
                    this.validator.logMissingReference(this.ownerElement, guid, this.linkedText);
                }
            }
            if (e != null) {
                String text;
                guid = e.getGuid();
                this.setGuid(guid);
                String url = this.getUrl();
                if (url != null && !(url = url.trim()).toLowerCase().startsWith("javascript:")) {
                    url = ResourceHelper.getUrl(e, this.ownerElement, ".html", url);
                    this.setUrl(url);
                }
                if (this.isElementLink() && !this.tag.equals("area") && (text = ResourceHelper.getLinkText(e, this.getElementLinkType(), config)) != null) {
                    this.linkedText = text;
                }
                if (this.validator.isDiscarded(this.ownerElement, IContentValidator.elementUrlFeature, e, config)) {
                    this.isMissingReference = true;
                    this.validator.logMissingReference(this.ownerElement, e);
                    e = null;
                }
            }
            this.linkElement = e;
        }
    }

    public static MethodElement getMethodElement(String guid) {
        MethodElement e;
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && LinkInfo.getLibrary() == null) {
            e = manager.getMethodElement(guid);
        } else {
            e = LinkInfo.getMethodElement_(guid);
            if (e == null && manager != null) {
                e = manager.getMethodElement(guid);
            }
        }
        return e;
    }

    private String getMissingElementUrl() {
        if (!this.isMissingReference) {
            return "";
        }
        String url = null;
        url = "pages_not_installed/pages_not_installed.html";
        File f = new File(this.pubDir, url);
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        XmlElement xml = new XmlElement("Element");
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        xml.setAttribute("lang", lang);
        if (this.linkElement == null) {
            xml.setAttribute("invalidLink", "true").setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute(LINK_ATTR_NAME, this.linkedText);
        } else {
            xml.setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute("type", this.linkElement.getType().getName()).setAttribute(LINK_ATTR_NAME, this.linkElement.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)this.linkElement).getName());
        }
        String xslPath = LayoutResources.getDefaultXslPath("page_not_installed", null);
        this.saveHtml(xml, xslPath, f);
        return String.valueOf(ResourceHelper.getBackPath(this.ownerElement).replace(File.separatorChar, '/')) + url;
    }

    public void saveHtml(XmlElement xmlElement, String xsl_uri, File outputFile) {
        try {
            StringBuffer xml = new StringBuffer();
            xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8");
            Properties xslParams = LayoutPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static MethodElement getMethodElement_(String guid) {
        block4: {
            if (LinkInfo.getLibrary() != null) break block4;
            return null;
        }
        try {
            ILibraryResourceSet resourceSet = (ILibraryResourceSet)LinkInfo.getLibrary().eResource().getResourceSet();
            if (resourceSet != null) {
                return (MethodElement)resourceSet.getEObject(guid);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return null;
    }

    public static MethodLibrary getLibrary() {
        return library;
    }

    public static void setLibrary(MethodLibrary library) {
        LinkInfo.library = library;
    }
}

