/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.meta.ReferenceTable;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.ElementPropertyProviderManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.elements.ElementLayoutExtender;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedOpposite;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedSection;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.MetaElement;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.QualifiedReference;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementLayout
implements IElementLayout {
    public static boolean processDescritorsNewOption = false;
    public static final String TAG_REFERENCE = "reference";
    public static final String TAG_REFERENCELIST = "referenceList";
    public static final String TAG_SECTION = "section";
    public static final String TAG_RTE = "rte";
    public static final String TAG_TABLE = "table";
    public static final String TAG_ColumnList = "columnList";
    public static final String TAG_RowList = "rowList";
    public static final String TAG_Column = "column";
    public static final String TAG_Row = "row";
    public static final String TAG_Cell = "Cell";
    private static final String Att_ExtendeReference_1 = new String("ExtendedReference");
    private static final String Att_ExtendeReference_2 = new String("ExtendedReference");
    private static final String Att_ReferenceType = "referenceType";
    protected ElementLayoutManager layoutManager;
    protected MethodElement element;
    protected MethodElement ownerElement;
    protected String url = null;
    protected String elementPath = "";
    protected String backPath = "";
    protected List layouts = null;
    protected MethodElement targetElement = null;
    protected boolean showElementLink = true;
    protected boolean debug = LibraryPlugin.getDefault().isDebugging();
    private ElementLayoutExtender extender;
    private String noAdjustedElementPath;

    @Override
    public void setContentTarget(MethodElement targetElement) {
        this.targetElement = targetElement;
    }

    @Override
    public void setElementOwner(MethodElement owner) {
        this.ownerElement = owner;
    }

    @Override
    public void setShowElementLink(boolean show) {
        this.showElementLink = show;
    }

    public abstract void init(ElementLayoutManager var1, MethodElement var2);

    protected void __init(ElementLayoutManager layoutManager, MethodElement element) {
        this.layoutManager = layoutManager;
        this.element = element;
        if (!ConfigurationHelper.isDescriptionElement(element)) {
            MethodPlugin plugin;
            if (!(element instanceof MethodConfiguration || (plugin = LibraryUtil.getMethodPlugin((EObject)element)) != null && plugin.eContainer() != null)) {
                if (this.debug && this.getLayoutMgr().isPublishingMode()) {
                    System.out.println("Error: Element without a valid container: " + LibraryUtil.getTypeName(element));
                }
                LibraryUtil.getMethodPlugins(LibraryService.getInstance().getCurrentMethodLibrary());
            }
            this.buildPath();
            this.url = String.valueOf(this.elementPath) + this.getFileName(".html");
        }
        if (!(this.layoutManager.isPublishingMode() && !ConfigurationHelper.serverMode || element instanceof ContentDescription || element.eContainer() instanceof ContentDescription || element instanceof MethodConfiguration)) {
            try {
                Map<String, MethodElement> htmlElementMap;
                String path = String.valueOf(this.getFilePath()) + this.getFileName(".html");
                String html_file = String.valueOf(this.layoutManager.getPublishDir()) + path;
                File f = new File(html_file);
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
                if (ConfigurationHelper.serverMode && (htmlElementMap = layoutManager.getUriElementMap()) != null) {
                    htmlElementMap.put("/" + path, element);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.preloadOppositefeatures();
    }

    private void preloadOppositefeatures() {
        if (this.getLayoutMgr().isPublishingMode()) {
            return;
        }
        Resource res = this.element.eResource();
        if (res == null) {
            return;
        }
        ResourceSet resSet = res.getResourceSet();
        if (!(resSet instanceof ILibraryResourceSet)) {
            return;
        }
        ArrayList<OppositeFeature> oppositeFeatures = new ArrayList<OppositeFeature>();
        if (this.element instanceof Role) {
            oppositeFeatures.add(AssociationHelper.Role_RoleDescriptors);
        } else if (this.element instanceof Task) {
            oppositeFeatures.add(AssociationHelper.Task_TaskDescriptors);
        } else if (this.element instanceof WorkProduct) {
            oppositeFeatures.add(AssociationHelper.WorkProduct_WorkProductDescriptors);
        } else if (this.element instanceof Checklist) {
            oppositeFeatures.add(AssociationHelper.Checklist_BreakdownElements);
        } else if (this.element instanceof Concept || this.element instanceof Whitepaper) {
            oppositeFeatures.add(AssociationHelper.Concept_BreakdownElements);
        } else if (this.element instanceof Checklist) {
            oppositeFeatures.add(AssociationHelper.Checklist_BreakdownElements);
        } else if (this.element instanceof Example) {
            oppositeFeatures.add(AssociationHelper.Example_BreakdownElements);
        } else if (this.element instanceof Guideline) {
            oppositeFeatures.add(AssociationHelper.Guideline_BreakdownElements);
        } else if (this.element instanceof ReusableAsset) {
            oppositeFeatures.add(AssociationHelper.ReusableAsset_BreakdownElements);
        } else if (this.element instanceof Roadmap) {
            oppositeFeatures.add(AssociationHelper.Roadmap_Activites);
        } else if (this.element instanceof SupportingMaterial) {
            oppositeFeatures.add(AssociationHelper.SupportingMaterial_BreakdownElements);
        }
        if (oppositeFeatures.size() > 0) {
            ConfigurationHelper.getDelegate().loadOppositeFeatures((ILibraryResourceSet)resSet, oppositeFeatures, this.element);
        }
    }

    protected void setLayoutInfo(LayoutInfo info) {
        if (this.layouts == null) {
            this.layouts = new ArrayList();
        }
        this.layouts.add(info);
    }

    @Override
    public List getLayouts() {
        return this.layouts;
    }

    public LayoutInfo getLayoutInfo(String name) {
        if (this.layouts == null || this.layouts.size() == 0) {
            return null;
        }
        for (LayoutInfo info : this.layouts) {
            if (!info.name.equals(name)) continue;
            return info;
        }
        return null;
    }

    @Override
    public ElementLayoutManager getLayoutMgr() {
        return this.layoutManager;
    }

    @Override
    public MethodElement getElement() {
        return this.element;
    }

    @Override
    public String getType() {
        if (this.element instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)this.element))) {
            return "udt";
        }
        return this.element.getType().getName();
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public String getDisplayName() {
        return ConfigurationHelper.getPresentationName(this.element, this.getLayoutMgr().getConfiguration());
    }

    @Override
    public String getId() {
        return this.element.getGuid();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getBackPath() {
        return this.backPath;
    }

    @Override
    public String getFilePath() {
        return this.elementPath;
    }

    @Override
    public String getNoAdjustedElementPath() {
        return this.noAdjustedElementPath == null ? this.elementPath : this.noAdjustedElementPath;
    }

    @Override
    public String getFilePath(IElementLayout relativeTo) {
        return String.valueOf(relativeTo.getBackPath()) + this.getFilePath();
    }

    @Override
    public String getFileName(String ext) {
        MethodElement elementForElementPath = this.getElementForElementPath();
        return ResourceHelper.getFileName(elementForElementPath, ext);
    }

    @Override
    public String getXslUrl() {
        if (this.element instanceof ContentElement) {
            return LayoutResources.getXslUri(this.getType().toLowerCase(), "contentelement");
        }
        return LayoutResources.getXslUri(this.getType().toLowerCase(), null);
    }

    private void buildPath() {
        MethodElement elementForElementPath;
        String path;
        this.elementPath = "";
        this.backPath = "./";
        if (!(this.element instanceof MethodConfiguration) && !(this.element instanceof MethodLibrary) && (path = ResourceHelper.getElementPath(elementForElementPath = this.getElementForElementPath())) != null) {
            this.elementPath = path.replace(File.separatorChar, '/');
            this.backPath = ResourceHelper.getBackPath(elementForElementPath);
            this.noAdjustedElementPath = this.elementPath;
            this.elementPath = this.getLayoutMgr().getAdjustedElementPath(this.elementPath);
        }
    }

    protected MethodElement getElementForElementPath() {
        return this.element;
    }

    @Override
    public boolean needContentScan(String xslUrl) {
        return true;
    }

    protected IElementLayout getChildLayout(MethodElement child) {
        return this.layoutManager.getLayout(child, true);
    }

    protected void processChild(Object feature, XmlElement parent, MethodElement e, boolean includeReferences) {
        IElementLayout l;
        if (e != null && (l = this.getChildLayout(e)) != null) {
            boolean isContent;
            boolean bl = isContent = e instanceof MethodElement && ConfigurationHelper.isDescriptionElement(e);
            if (isContent) {
                if (this.targetElement != null) {
                    l.setContentTarget(this.targetElement);
                }
                l.setElementOwner(this.element);
            }
            XmlElement childXmlElement = l.getXmlElement(includeReferences);
            parent.addChild(childXmlElement);
            this.processGrandChild(feature, e, l, childXmlElement);
        }
    }

    protected void processChild(Object feature, XmlElement parent, List items, boolean includeReferences) {
        if (items != null && items.size() > 0) {
            for (Object e : items) {
                if (e instanceof MethodElement) {
                    IElementLayout l;
                    MethodElement me = (MethodElement)e;
                    if ((e = ConfigurationHelper.getCalculatedElement(me, this.layoutManager.getConfiguration())) == null || (l = this.getChildLayout(me)) == null) continue;
                    XmlElement childXmlElement = l.getXmlElement(ConfigurationHelper.isDescriptionElement(me) ? true : includeReferences);
                    this.modifyChildDisplayName(feature, childXmlElement, me);
                    parent.addChild(childXmlElement);
                    this.processGrandChild(feature, me, l, childXmlElement);
                    continue;
                }
                this.processNonMethodElementInProcessChild(e, feature, parent, includeReferences);
            }
        }
    }

    protected void modifyChildDisplayName(Object feature, XmlElement childXmlElement, MethodElement childElement) {
    }

    protected void processNonMethodElementInProcessChild(Object nonMethodElementChild, Object feature, XmlElement parent, boolean includeReferences) {
    }

    protected void processGrandChild(Object feature, MethodElement childElememt, IElementLayout childLayout, XmlElement childXmlElement) {
    }

    public void calculate0nReferences(XmlElement elementXml, boolean includeReferences) {
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature.isMany()) {
                    this.loadFeature(feature, elementXml, includeReferences);
                }
                ++i;
            }
        }
    }

    protected XmlElement getXmlElement() {
        XmlElement elementXml = new XmlElement("Element").setAttribute("Id", this.getId()).setAttribute("Type", this.getType()).setAttribute("TypeName", TngUtil.getTypeText((EObject)this.element)).setAttribute("Name", this.getName()).setAttribute("BackPath", this.getBackPath()).setAttribute("ShapeiconUrl", this.getShapeiconUrl()).setAttribute("DisplayName", this.getDisplayName()).setAttribute("NodeiconUrl", this.getNodeiconUrl());
        if (this.showElementLink) {
            elementXml.setAttribute("Url", this.getUrl());
        }
        if (this.getExtender() != null) {
            this.getExtender().addAttributes(elementXml);
        }
        return elementXml;
    }

    public void loadAttributes(XmlElement elementXml) {
        boolean isActivityAttribute = this.element instanceof Activity || this.element instanceof ContentDescription && (this.element.eContainer() instanceof Activity || this.ownerElement instanceof Activity);
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature p = (EStructuralFeature)features.get(i);
                if (p instanceof EAttribute) {
                    EAttribute attrib = (EAttribute)p;
                    String name = p.getName();
                    Object value = name.equals("presentationName") ? ConfigurationHelper.getPresentationName(this.element, this.layoutManager.getConfiguration()) : (isActivityAttribute && String.class.isAssignableFrom(attrib.getEAttributeType().getInstanceClass()) ? ConfigurationHelper.getActivityStringAttribute(this.element, this.ownerElement, attrib, this.getLayoutMgr().getConfiguration()) : this.getAttributeFeatureValue(p));
                    if (name.equals("briefDescription") && value instanceof String) {
                        MultiFileXMISaveImpl.MyEscape myEscape = new MultiFileXMISaveImpl.MyEscape();
                        value = myEscape.convert((String)value);
                        value = StrUtil.convertNewlinesToHTML((String)((String)value));
                    }
                    elementXml.newChild("attribute").setAttribute("name", name).setValue(value == null ? "" : value.toString());
                }
                ++i;
            }
            ElementPropertyProviderManager.getInstance().loadAdditionalElementProperties(this.element, elementXml);
        }
    }

    public Object getAttributeFeatureValue(EStructuralFeature feature) {
        Object value = ConfigurationHelper.calcAttributeFeatureValue(this.element, this.ownerElement, feature, this.layoutManager.getConfiguration());
        if (this.targetElement != null && value != null && value.toString().length() > 0) {
            String contentPath = ResourceHelper.getElementPath(this.element instanceof ContentDescription ? (this.ownerElement == null ? (MethodElement)this.element.eContainer() : this.ownerElement) : this.element);
            String backPath = ResourceHelper.getBackPath(this.targetElement instanceof ContentDescription ? (MethodElement)this.targetElement.eContainer() : this.targetElement);
            value = ResourceHelper.fixContentUrlPath(value.toString(), contentPath, backPath);
        }
        return value;
    }

    public void loadCopyright(XmlElement elementXml) {
        String copyright = ConfigurationHelper.getCopyrightText(this.element, this.layoutManager.getConfiguration());
        if (copyright != null && copyright.length() > 0) {
            elementXml.newChild("copyright").setValue(copyright);
        }
    }

    public void calculate01References(XmlElement elementXml, boolean includeReferences) {
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature p = (EStructuralFeature)features.get(i);
                EClassifier type = p.getEType();
                if (type instanceof EClass && !p.isMany()) {
                    this.loadFeature(p, elementXml, includeReferences);
                }
                ++i;
            }
        }
    }

    public void loadFeature(EStructuralFeature feature, XmlElement elementXml, boolean includeReferences) {
        if (this.isExcludeFeature(feature)) {
            return;
        }
        this.getFeatureValue(feature, elementXml, includeReferences);
    }

    public Object getFeatureValue(EStructuralFeature feature, XmlElement elementXml, boolean includeReferences) {
        if (!(feature.getEType() instanceof EClass)) {
            return null;
        }
        String name = feature.getName();
        if (!feature.isMany()) {
            MethodElement e = ConfigurationHelper.calc01FeatureValue(this.element, this.ownerElement, feature, this.layoutManager.getElementRealizer());
            if (e != null && e != this.element) {
                boolean showDetail;
                boolean bl = showDetail = ConfigurationHelper.isDescriptionElement(e) ? true : includeReferences;
                if (this.acceptFeatureValue(feature, (Object)e)) {
                    if (elementXml != null) {
                        this.processChild((Object)feature, elementXml.newChild(TAG_REFERENCE).setAttribute("name", name), e, showDetail);
                    }
                    return e;
                }
                return null;
            }
        } else if (feature.isMany()) {
            List pv = this.calc0nFeatureValue(this.element, this.ownerElement, feature, this.layoutManager.getElementRealizer());
            if (this.acceptFeatureValue(feature, (Object)pv)) {
                String sortValue;
                XmlElement childXml;
                if (elementXml != null && (childXml = this.addReferences(feature, elementXml, name, pv)) != null && (sortValue = CategorySortHelper.getCategorySortValue((MethodElement)this.element)) != null && sortValue.length() > 0) {
                    childXml.setAttribute("sortValue", sortValue);
                }
                return pv;
            }
            return null;
        }
        return null;
    }

    protected List calc0nFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, ownerElement, feature, this.layoutManager.getElementRealizer());
    }

    public void loadFeature(OppositeFeature feature, XmlElement elementXml, boolean includeReferences) {
        String name = feature.getName();
        if (!feature.isMany()) {
            MethodElement e = ConfigurationHelper.calc01FeatureValue(this.element, feature, this.layoutManager.getElementRealizer());
            if (e != null && e != this.element) {
                boolean showDetail;
                boolean bl = showDetail = ConfigurationHelper.isDescriptionElement(e) ? true : includeReferences;
                if (this.acceptFeatureValue(feature, (Object)e)) {
                    this.processChild((Object)feature, elementXml.newChild(TAG_REFERENCE).setAttribute("name", name), e, showDetail);
                }
            }
        } else if (feature.isMany()) {
            List pv;
            if (feature == AssociationHelper.ContentElement_Practices || feature == AssociationHelper.Activity_Pratices) {
                this.loadPractices(elementXml);
            }
            if (this.acceptFeatureValue(feature, (Object)(pv = this.calc0nFeatureValue(this.element, feature, this.layoutManager.getElementRealizer()))) && pv.size() > 0) {
                this.addReferences(feature, elementXml, name, pv);
            }
        }
    }

    private void loadPractices(XmlElement elementXml) {
        OppositeFeature feature;
        List list;
        if (!(this.element instanceof ContentElement) && !(this.element instanceof Activity)) {
            return;
        }
        ArrayList<EObject> resultList = new ArrayList<EObject>();
        EObject container = this.element.eContainer();
        if (container instanceof Practice && (container = ConfigurationHelper.getCalculatedElement((MethodElement)((Practice)container), this.layoutManager.getElementRealizer())) != null) {
            resultList.add(container);
        }
        if ((list = this.calc0nFeatureValue(this.element, feature = this.element instanceof Activity ? AssociationHelper.Activity_Pratices : AssociationHelper.ContentElement_Practices, this.layoutManager.getElementRealizer())) != null && !list.isEmpty()) {
            resultList.addAll(list);
        }
        int i = resultList.size() - 1;
        while (i >= 0) {
            MethodElement element = (MethodElement)resultList.get(i);
            if (!this.getPublishCategoryProperty(element)) {
                resultList.remove(i);
            }
            --i;
        }
        if (resultList.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getPresNameComparator();
            Collections.sort(resultList, comparator);
        }
        this.addReferences(feature, elementXml, "Practices", resultList);
    }

    protected List calc0nFeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, feature, this.layoutManager.getElementRealizer());
    }

    public void loadReferences(XmlElement elementXml, boolean includeReferences) {
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature.getEType() instanceof EClass) {
                    this.loadFeature(feature, elementXml, includeReferences);
                }
                ++i;
            }
        }
        ArrayList oppositeProperties = new ArrayList(this.element.getOppositeFeatures());
        for (OppositeFeature ofeature : oppositeProperties) {
            this.loadFeature(ofeature, elementXml, includeReferences);
        }
    }

    protected boolean isExcludeFeature(EStructuralFeature feature) {
        return false;
    }

    public void addReference(Object feature, XmlElement elementXml, String referenceName, MethodElement element) {
        this.processChild(feature, elementXml.newChild(TAG_REFERENCE).setAttribute("name", referenceName), element, false);
    }

    public XmlElement addReferences(Object feature, XmlElement elementXml, String referenceName, List items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        boolean excludeThisElement = false;
        if (feature == AssociationHelper.VariabilityElement_ImmediateVarieties) {
            excludeThisElement = true;
        }
        HashSet itemSet = new HashSet();
        ArrayList uniqueItems = new ArrayList();
        for (Object item : items) {
            if (itemSet.contains(item) || excludeThisElement && item == this.element) continue;
            itemSet.add(item);
            uniqueItems.add(item);
        }
        XmlElement childXml = elementXml.newChild(TAG_REFERENCELIST);
        if (feature instanceof ExtendedOpposite) {
            ExtendedOpposite opposite = (ExtendedOpposite)feature;
            childXml.setAttribute(Att_ReferenceType, "customOpposite");
            if (opposite.getLayout() != null && opposite.getLayout().length() > 0) {
                childXml.setAttribute("layout", opposite.getLayout());
            }
        }
        if (feature instanceof QualifiedReference) {
            QualifiedReference qRef = (QualifiedReference)feature;
            childXml.setAttribute("qualifierId", qRef.getId());
            childXml.setAttribute("qualifierName", qRef.getName());
        } else if (feature instanceof ExtendedReference) {
            ExtendedReference eRef = (ExtendedReference)feature;
            childXml.setAttribute("referenceId", eRef.getId());
            childXml.setAttribute("referenceName", eRef.getName());
            if (eRef.getContributeTo() != null) {
                childXml.setAttribute("contributeTo", eRef.getContributeTo());
            }
            if (referenceName == Att_ExtendeReference_1) {
                childXml.setAttribute("format", "immidate child list");
            } else if (referenceName == Att_ExtendeReference_2) {
                List list;
                for (QualifiedReference qRef : eRef.getQualifiedReferences()) {
                    list = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)qRef.getReference(), this.layoutManager.getElementRealizer());
                    if (list == null || list.isEmpty()) continue;
                    uniqueItems.removeAll(list);
                }
                this.processChild(feature, childXml.setAttribute("name", referenceName), uniqueItems, false);
                for (QualifiedReference qRef : eRef.getQualifiedReferences()) {
                    list = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)qRef.getReference(), this.layoutManager.getElementRealizer());
                    if (list == null || list.isEmpty()) continue;
                    this.addReferences(qRef, childXml, "Qualified references", list);
                }
                childXml.setAttribute("format", "nested list");
                return childXml;
            }
        }
        this.processChild(feature, childXml.setAttribute("name", referenceName), uniqueItems, false);
        return childXml;
    }

    @Override
    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = this.getXmlElement();
        if (includeReferences) {
            this.loadCopyright(elementXml);
            this.loadAttributes(elementXml);
            this.loadExtendedAttributes(elementXml);
            this.loadReferences(elementXml, false);
            this.loadUdtReferences(elementXml);
            this.loadQrReferences(elementXml);
            this.loadExtendedReferences(elementXml);
            this.loadExtendedOpposites(elementXml);
        }
        return elementXml;
    }

    protected void loadExtendedOpposites(XmlElement elementXml) {
        List<ExtendedOpposite> opposites = LibraryService.getInstance().getCurrentLibraryManager().getLoadedOpposites();
        if (opposites == null || opposites.isEmpty()) {
            return;
        }
        for (ExtendedOpposite opposite : opposites) {
            List list;
            if (!opposite.publish() || (list = this.calc0nFeatureValue(this.element, opposite.getOFeature(), this.layoutManager.getElementRealizer())) == null || list.isEmpty()) continue;
            this.addReferences(opposite, elementXml, opposite.getName(), list);
        }
    }

    public void loadUdtReferences(XmlElement elementXml) {
        List udtList = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)UmaUtil.MethodElement_UdtList, this.layoutManager.getElementRealizer());
        if (udtList != null && !udtList.isEmpty()) {
            this.addReferences(UmaUtil.MethodElement_UdtList, elementXml, "User defined type references", udtList);
        }
    }

    boolean skipExtendedSection(ModifiedTypeMeta meta, ExtendedSection section, MethodElement e) {
        if (!(e instanceof BreakdownElement)) {
            return false;
        }
        if (TypeDefUtil.getInstance().getLinkedElement(e) != null) {
            return false;
        }
        return meta.isLinkedSection(section);
    }

    public void loadExtendedAttributes(XmlElement elementXml) {
        if (this.ownerElement == null) {
            return;
        }
        PropUtil propUtil = PropUtil.getPropUtil();
        ModifiedTypeMeta meta = propUtil.getGlobalMdtMeta(this.ownerElement);
        if (meta == null) {
            return;
        }
        if (!meta.getAttributeSections().isEmpty()) {
            for (ExtendedSection section : meta.getAttributeSections()) {
                List attributes;
                if (this.skipExtendedSection(meta, section, this.ownerElement) || (attributes = section.getAttributes()) == null || attributes.isEmpty()) continue;
                XmlElement sectionXml = elementXml.newChild(TAG_SECTION);
                this.setXmlAttributes(section, sectionXml);
                boolean toRemoveSection = true;
                for (ExtendedAttribute eAtt : attributes) {
                    XmlElement attXml = sectionXml.newChild(TAG_RTE);
                    String value = (String)this.getAttributeFeatureValue((EStructuralFeature)eAtt.getAttribute());
                    if ("choice".equalsIgnoreCase(eAtt.getValueType())) {
                        for (MetaElement me : eAtt.getChoiceValues()) {
                            if (!me.getId().equals(value)) continue;
                            value = me.getTextContent();
                        }
                    } else if ("attachment".equalsIgnoreCase(eAtt.getValueType())) {
                        value = ResourceHelper.convertToRteString(value);
                    }
                    if (value != null && value.trim().length() > 0) {
                        toRemoveSection = false;
                    }
                    this.setXmlAttributes(eAtt, attXml);
                    attXml.setValue(value);
                }
                if (!toRemoveSection) continue;
                elementXml.removeChild(sectionXml);
            }
            return;
        }
        for (ExtendedSection section : meta.getRteSections()) {
            List attributes;
            if (this.skipExtendedSection(meta, section, this.ownerElement) || (attributes = section.getRtes()) == null || attributes.isEmpty()) continue;
            XmlElement sectionXml = elementXml.newChild(TAG_SECTION);
            this.setXmlAttributes(section, sectionXml);
            boolean toRemoveSection = true;
            for (ExtendedAttribute eAtt : attributes) {
                XmlElement attXml = sectionXml.newChild(TAG_RTE);
                String value = (String)this.getAttributeFeatureValue((EStructuralFeature)eAtt.getAttribute());
                if (value != null && value.trim().length() > 0) {
                    toRemoveSection = false;
                }
                this.setXmlAttributes(eAtt, attXml);
                attXml.setValue(value);
            }
            if (!toRemoveSection) continue;
            elementXml.removeChild(sectionXml);
        }
    }

    private void setXmlAttributes(ExtendedAttribute att, XmlElement xmlElement) {
        xmlElement.setAttribute("name", att.getName());
        xmlElement.setAttribute("id", att.getId());
    }

    public void loadExtendedReferences(XmlElement elementXml) {
        PropUtil propUtil = PropUtil.getPropUtil();
        ModifiedTypeMeta meta = propUtil.getGlobalMdtMeta(this.element);
        if (meta == null) {
            return;
        }
        ElementRealizer realizer = this.layoutManager.getElementRealizer();
        for (ExtendedSection section : meta.getReferenceSections()) {
            List references;
            if (this.skipExtendedSection(meta, section, this.element) || (references = section.getReferences()) == null || references.isEmpty()) continue;
            XmlElement sectionXml = elementXml.newChild(TAG_SECTION);
            this.setXmlAttributes(section, sectionXml);
            HashMap<ExtendedReference, List> tableRefMap = new HashMap<ExtendedReference, List>();
            List tables = section.getTables();
            if (tables != null && !tables.isEmpty()) {
                for (ExtendedTable table : tables) {
                    tableRefMap.put(table.getColumnReference(), Collections.EMPTY_LIST);
                    tableRefMap.put(table.getRowReference(), Collections.EMPTY_LIST);
                    tableRefMap.put(table.getCellReference(), Collections.EMPTY_LIST);
                }
            }
            boolean toRemoveSection = true;
            for (ExtendedReference eRef : references) {
                List list = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)eRef.getReference(), realizer);
                if (list == null || list.isEmpty()) continue;
                toRemoveSection = false;
                if (tableRefMap.containsKey(eRef)) {
                    tableRefMap.put(eRef, list);
                }
                if (!eRef.publish()) continue;
                this.addReferences(eRef, sectionXml, Att_ExtendeReference_1, list);
                this.addReferences(eRef, sectionXml, Att_ExtendeReference_2, list);
            }
            if (toRemoveSection) {
                elementXml.removeChild(sectionXml);
            }
            if (tables == null || tables.isEmpty()) continue;
            for (ExtendedTable table : tables) {
                String name;
                XmlElement cccXml;
                MethodElement r;
                MethodElement linkedElement;
                List colList = (List)tableRefMap.get(table.getColumnReference());
                List rowList = (List)tableRefMap.get(table.getRowReference());
                List cfr_ignored_0 = (List)tableRefMap.get(table.getCellReference());
                if (colList.isEmpty() || rowList.isEmpty()) continue;
                XmlElement cXml = sectionXml.newChild(TAG_TABLE);
                cXml.setAttribute("tableId", table.getId());
                cXml.setAttribute("tableName", table.getName());
                cXml.setAttribute("columnSplit", table.getColumnSplit());
                List colList0 = propUtil.getExtendedReferenceList(this.element, table.getColumnReference(), false);
                List rowList0 = propUtil.getExtendedReferenceList(this.element, table.getRowReference(), false);
                if (colList0 == null || colList0.isEmpty() || rowList0 == null || rowList0.isEmpty()) {
                    return;
                }
                ReferenceTable referenceTable = propUtil.getReferenceTable(this.element, table, false);
                if (referenceTable == null && this instanceof DescriptorLayout && (linkedElement = ((DescriptorLayout)this).getLinkedElement()) != null) {
                    referenceTable = propUtil.getReferenceTable(linkedElement, table, false);
                    colList0 = propUtil.getExtendedReferenceList(linkedElement, table.getColumnReference(), false);
                    rowList0 = propUtil.getExtendedReferenceList(linkedElement, table.getRowReference(), false);
                }
                HashMap<MethodElement, MethodElement> colMap = new HashMap<MethodElement, MethodElement>();
                HashMap<MethodElement, MethodElement> rowMap = new HashMap<MethodElement, MethodElement>();
                for (MethodElement e : colList0) {
                    r = ConfigurationHelper.getCalculatedElement(e, realizer);
                    if (r == null) continue;
                    colMap.put(r, e);
                }
                for (MethodElement e : rowList0) {
                    r = ConfigurationHelper.getCalculatedElement(e, realizer);
                    if (r == null) continue;
                    rowMap.put(r, e);
                }
                XmlElement ccXml = cXml.newChild(TAG_ColumnList);
                for (MethodElement e : colList) {
                    cccXml = ccXml.newChild(TAG_Column);
                    name = ConfigurationHelper.getPresentationName(e, this.layoutManager.getConfiguration());
                    cccXml.setAttribute("name", name);
                    this.addReference(table.getColumnReference().getReference(), cccXml, table.getColumnReference().getId(), e);
                }
                ccXml = cXml.newChild(TAG_RowList);
                for (MethodElement rowE : rowList) {
                    cccXml = ccXml.newChild(TAG_Row);
                    name = ConfigurationHelper.getPresentationName(rowE, this.layoutManager.getConfiguration());
                    cccXml.setAttribute("name", name);
                    this.addReference(table.getColumnReference().getReference(), cccXml, table.getColumnReference().getId(), rowE);
                    MethodElement rowE0 = (MethodElement)rowMap.get(rowE);
                    for (MethodElement colE : colList) {
                        MethodElement celE;
                        MethodElement colE0 = (MethodElement)colMap.get(colE);
                        MethodElement methodElement = celE = referenceTable == null ? null : referenceTable.getCellElement(rowE0, colE0);
                        if (celE != null) {
                            celE = ConfigurationHelper.getCalculatedElement(celE, realizer);
                        }
                        XmlElement ccccXml = cccXml.newChild(TAG_Cell);
                        name = celE == null ? "" : ConfigurationHelper.getPresentationName(celE, this.layoutManager.getConfiguration());
                        ccccXml.setAttribute("name", name);
                        if (celE == null) continue;
                        this.addReference(table.getCellReference().getReference(), ccccXml, table.getCellReference().getId(), celE);
                    }
                }
            }
        }
    }

    private void setXmlAttributes(ExtendedSection section, XmlElement xmlElement) {
        xmlElement.setAttribute("name", section.getName());
        String type = section.getType();
        if (type.equals("attribute")) {
            type = TAG_RTE;
        }
        xmlElement.setAttribute("type", type);
        xmlElement.setAttribute("id", section.getId());
        if (section.getLayout() != null && section.getLayout().length() > 0) {
            xmlElement.setAttribute("layout", section.getLayout());
        }
    }

    protected void loadQrReferences(XmlElement elementXml) {
    }

    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        return true;
    }

    protected boolean acceptFeatureValue(OppositeFeature feature, Object value) {
        if (feature == AssociationHelper.DescribableElement_CustomCategories) {
            if (value instanceof CustomCategory) {
                return this.getPublishCategoryProperty((MethodElement)value);
            }
            if (value instanceof List) {
                List items = (List)value;
                int i = 0;
                while (i < items.size()) {
                    MethodElement e = (MethodElement)items.get(i);
                    if (!this.getPublishCategoryProperty(e)) {
                        items.remove(i);
                        continue;
                    }
                    ++i;
                }
                return true;
            }
        }
        return true;
    }

    private boolean getPublishCategoryProperty(MethodElement e) {
        MethodElementProperty prop = TngUtil.getPublishCategoryProperty((MethodElement)e);
        if (prop == null) {
            return false;
        }
        String v = prop.getValue();
        return v != null && v.toString().equals("true");
    }

    @Override
    public String getShapeiconUrl() {
        URI uri = null;
        MethodElement uriInheritingBase = null;
        if (this.element instanceof DescribableElement && (uri = ((DescribableElement)this.element).getShapeicon()) == null && this.element instanceof VariabilityElement) {
            VariabilityElement[] uriInheritingBases = new VariabilityElement[1];
            uri = ConfigurationHelper.getInheritingUri((DescribableElement)this.element, uri, uriInheritingBases, this.getLayoutMgr().getConfiguration(), 1);
            uriInheritingBase = uriInheritingBases[0];
        }
        MethodElement element1 = uriInheritingBase == null ? this.element : uriInheritingBase;
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element1);
        String imageUrl = uri == null || resMgr == null ? this.getDefaultShapeiconUrl() : NetUtil.decodedFileUrl((String)uri.toString());
        if (!imageUrl.startsWith("images/")) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element1);
            if (plugin != null && !imageUrl.startsWith(plugin.getName())) {
                imageUrl = NetUtil.encodeFileURL((String)(String.valueOf(plugin.getName()) + "/" + imageUrl));
            }
            if (resMgr != null) {
                String decodedImageUrl = NetUtil.decodedFileUrl((String)imageUrl);
                File source = new File(resMgr.resolve(element1, decodedImageUrl));
                File dest = new File(this.getLayoutMgr().getPublishDir(), decodedImageUrl);
                FileUtil.copyFile((File)source, (File)dest);
            }
        }
        return imageUrl;
    }

    @Override
    public String getNodeiconUrl() {
        if (this.element instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)this.element))) {
            try {
                boolean debug = LibraryPlugin.getDefault().isDebugging();
                Logger logger = LibraryPlugin.getDefault().getLogger();
                String imagesPath = String.valueOf(this.getLayoutMgr().getPublishDir()) + "icons";
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData((Practice)this.element);
                String shapeIcon = (String)udtMeta.getRteNameMap().get("icon");
                if (debug) {
                    logger.logInfo("The udt shape icon get from meta: " + shapeIcon);
                }
                if (shapeIcon != null) {
                    File shapeIconFile = new File(NetUtil.decodedFileUrl((String)new URL(shapeIcon).getFile()));
                    if (debug) {
                        logger.logInfo("The udt shape icon file: " + shapeIconFile);
                    }
                    if (FileUtil.copyFileToDir((File)shapeIconFile, (String)imagesPath)) {
                        if (debug) {
                            logger.logInfo("Copy the udt shape icon succeed");
                        }
                        return "icons/" + shapeIconFile.getName();
                    }
                }
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return "";
    }

    public String getDefaultShapeiconUrl() {
        String type = this.element.getType().getName().toLowerCase();
        if (this.element instanceof CustomCategory) {
            CustomCategory cc = (CustomCategory)this.element;
            if (MethodElementPropUtil.getMethodElementPropUtil().isTransientElement((MethodElement)cc)) {
                if (cc.getName().equals("Roles")) {
                    type = "roleset";
                } else if (cc.getName().equals("Tasks")) {
                    type = "discipline";
                } else if (cc.getName().equals("Work Products")) {
                    type = "domain";
                } else if (cc.getName().equals("Guidance")) {
                    type = "guidances";
                } else if (cc.getName().equals("Processes")) {
                    type = "processes";
                }
            }
        }
        if (this.element instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)this.element))) {
            try {
                boolean debug = LibraryPlugin.getDefault().isDebugging();
                Logger logger = LibraryPlugin.getDefault().getLogger();
                String imagesPath = String.valueOf(this.getLayoutMgr().getPublishDir()) + "images";
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData((Practice)this.element);
                String shapeIcon = (String)udtMeta.getRteNameMap().get("shapeIcon");
                if (debug) {
                    logger.logInfo("The udt shape icon get from meta: " + shapeIcon);
                }
                if (shapeIcon != null) {
                    File shapeIconFile = new File(NetUtil.decodedFileUrl((String)new URL(shapeIcon).getFile()));
                    if (debug) {
                        logger.logInfo("The udt shape icon file: " + shapeIconFile);
                    }
                    if (FileUtil.copyFileToDir((File)shapeIconFile, (String)imagesPath)) {
                        if (debug) {
                            logger.logInfo("Copy the udt shape icon succeed");
                        }
                        return "images/" + shapeIconFile.getName();
                    }
                }
                type = "UDT";
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return LayoutResources.getDefaultShapeiconUrl(type);
    }

    @Override
    public String getDiagramiconUrl() {
        return "icons/" + this.element.getType().getName() + ".gif";
    }

    protected void loadWorkOrder(XmlElement elementXml) {
        EReference feature = UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor();
        List items = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)feature, this.layoutManager.getElementRealizer());
        XmlElement predecessorXml = elementXml.newChild(TAG_REFERENCELIST).setAttribute("name", feature.getName());
        if (items != null && items.size() > 0) {
            for (WorkOrder wo : items) {
                IElementLayout l;
                MethodElement me = ConfigurationHelper.calc01FeatureValue((MethodElement)wo, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkOrder_Pred(), this.layoutManager.getElementRealizer());
                if (me == null || (l = this.getChildLayout(me)) == null) continue;
                predecessorXml.addChild(l.getXmlElement(false));
            }
        }
    }

    protected void processDescriptors(XmlElement elementXml) {
        if (!this.getLayoutMgr().getValidator().showRelatedDescriptors()) {
            return;
        }
        OppositeFeature of = null;
        if (this.element instanceof Role) {
            of = AssociationHelper.Role_RoleDescriptors;
        } else if (this.element instanceof Task) {
            of = AssociationHelper.Task_TaskDescriptors;
        } else if (this.element instanceof WorkProduct) {
            of = AssociationHelper.WorkProduct_WorkProductDescriptors;
        }
        List descriptors = ConfigurationHelper.calc0nFeatureValue(this.element, of, this.layoutManager.getElementRealizer());
        XmlElement descListXml = elementXml.newChild(TAG_REFERENCELIST).setAttribute("name", "descriptors");
        this.addDescriptors(descriptors, descListXml);
    }

    private void addDescriptors(List descriptors, XmlElement descListXml) {
        int i = 0;
        while (i < descriptors.size()) {
            Descriptor desc = (Descriptor)descriptors.get(i);
            List parents = this.__getSuperActivities((BreakdownElement)desc);
            this.addDescriptor(descListXml, desc, parents, true);
            ++i;
        }
    }

    private void addDescriptor(XmlElement descListXml, Descriptor desc, List parents, boolean topLevelCall) {
        IElementLayout layout = this.getChildLayout((MethodElement)desc);
        XmlElement descXml = layout.getXmlElement(false);
        descListXml.addChild(descXml);
        if (desc instanceof WorkProductDescriptor && layout instanceof AbstractElementLayout) {
            AbstractElementLayout aLayout = (AbstractElementLayout)layout;
            EAttribute att = UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState();
            String value = (String)aLayout.getAttributeFeatureValue((EStructuralFeature)att);
            if (value != null && value.length() > 0) {
                descXml.newChild("attribute").setAttribute(att.getName(), value);
            }
            if ((value = (String)aLayout.getAttributeFeatureValue((EStructuralFeature)(att = UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState()))) != null && value.length() > 0) {
                descXml.newChild("attribute").setAttribute(att.getName(), value);
            }
        }
        boolean toProcessExtendedActs = processDescritorsNewOption && topLevelCall;
        HashSet<Activity> processedExtendedActSet = null;
        Set allLocalActSet = null;
        if (toProcessExtendedActs) {
            processedExtendedActSet = new HashSet<Activity>();
            allLocalActSet = this.getAllLocalActSet(parents);
        }
        int p = 0;
        while (p < parents.size()) {
            Activity act = (Activity)parents.get(p);
            layout = this.getChildLayout((MethodElement)act);
            XmlElement actXml = layout.getXmlElement(false);
            descXml.addChild(actXml);
            if (toProcessExtendedActs) {
                this.processExtendedAct(desc, descListXml, parents, p, act, processedExtendedActSet, allLocalActSet);
            }
            ++p;
        }
    }

    private Set getAllLocalActSet(List<Activity> bases) {
        MethodConfiguration config = this.getLayoutMgr().getConfiguration();
        HashSet<VariabilityElement> ret = new HashSet<VariabilityElement>();
        for (Activity act : bases) {
            ret.addAll(ConfigurationHelper.getLocalContributersAndReplacers((VariabilityElement)act, config));
        }
        return ret;
    }

    private void processExtendedAct(Descriptor desc, XmlElement descListXml, List parents, int p, Activity act, Set<Activity> processedExtendedActSet, Set<Activity> allLocalActSet) {
        MethodConfiguration config = this.getLayoutMgr().getConfiguration();
        List actExtenders = ConfigurationHelper.getExtenders((VariabilityElement)act, config);
        if (!actExtenders.isEmpty()) {
            for (Object obj : actExtenders) {
                Activity extAct = (Activity)obj;
                if (processedExtendedActSet.contains(extAct)) continue;
                processedExtendedActSet.add(extAct);
                List extenderParents = this.__getSuperActivities((BreakdownElement)extAct);
                extenderParents.add(extAct);
                boolean toAdd = true;
                if (p < parents.size() - 1) {
                    Activity superAct = extAct;
                    int pp = p + 1;
                    while (pp < parents.size()) {
                        Activity parent = (Activity)parents.get(pp);
                        if ((parent = this.checkLocalAct(allLocalActSet, superAct, parent)) == null) {
                            toAdd = false;
                            break;
                        }
                        extenderParents.add(parent);
                        ++pp;
                    }
                }
                if (!toAdd) continue;
                this.addDescriptor(descListXml, desc, extenderParents, false);
            }
        }
    }

    private Activity checkLocalAct(Set<Activity> allLocalActSet, Activity superAct, Activity parent) {
        for (BreakdownElement be : superAct.getBreakdownElements()) {
            if (!(be instanceof Activity)) continue;
            Activity actBe = (Activity)be;
            if (!allLocalActSet.contains(be) || parent != actBe.getVariabilityBasedOnElement()) continue;
            if (actBe.getVariabilityType() == VariabilityType.LOCAL_REPLACEMENT) {
                return null;
            }
            if (actBe.getVariabilityType() != VariabilityType.LOCAL_CONTRIBUTION) continue;
            return actBe;
        }
        return parent;
    }

    private List __getSuperActivities(BreakdownElement element) {
        ArrayList<Activity> items = new ArrayList<Activity>();
        Activity parent = element.getSuperActivities();
        while (parent != null) {
            if ((parent = (BreakdownElement)ConfigurationHelper.getCalculatedElement((MethodElement)parent, this.layoutManager.getElementRealizer())) == null) break;
            items.add(0, parent);
            if (LibraryUtil.isProcess((EObject)parent)) break;
            parent = parent.getSuperActivities();
        }
        return items;
    }

    protected boolean isBreakdownElement_Guidances(EStructuralFeature feature) {
        UmaPackage umaPkg = UmaPackage.eINSTANCE;
        if (feature == umaPkg.getBreakdownElement_Checklists()) {
            return true;
        }
        if (feature == umaPkg.getBreakdownElement_Concepts()) {
            return true;
        }
        if (feature == umaPkg.getBreakdownElement_Examples()) {
            return true;
        }
        if (feature == umaPkg.getBreakdownElement_Guidelines()) {
            return true;
        }
        if (feature == umaPkg.getBreakdownElement_ReusableAssets()) {
            return true;
        }
        return feature == umaPkg.getBreakdownElement_SupportingMaterials();
    }

    protected ElementLayoutExtender getExtender() {
        if (this.extender == null) {
            this.extender = ConfigurationHelper.getDelegate().newElementLayoutExtender(this);
        }
        return this.extender;
    }

    protected List<MethodElement> getTagQualifiedList(MethodConfiguration config, List<MethodElement> items) {
        ElementLayoutExtender extender = this.getExtender();
        if (extender == null) {
            return items;
        }
        return extender.getTagQualifiedList(config, items);
    }

    protected List addBreakdownElementsToContentElements(List contentElements, List breakdownElements) {
        if (!this.getLayoutMgr().getValidator().showRelatedDescriptors()) {
            return contentElements;
        }
        if (breakdownElements == null || breakdownElements.isEmpty()) {
            return contentElements;
        }
        if (contentElements == null || contentElements.isEmpty()) {
            return breakdownElements;
        }
        HashSet set = new HashSet(contentElements);
        for (Object obj : breakdownElements) {
            boolean toAdd = true;
            if (obj instanceof Descriptor) {
                MethodElement element = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)obj));
                if (set.contains(element = ConfigurationHelper.getCalculatedElement(element, this.layoutManager.getElementRealizer())) || set.contains(obj)) {
                    toAdd = false;
                }
            }
            if (!toAdd) continue;
            contentElements.add(obj);
            set.add(obj);
        }
        return contentElements;
    }
}

