/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.MilestonePropUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TaskDescriptorPropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkProductDescriptor;

public abstract class AbstractProcessElementLayout
extends AbstractElementLayout {
    protected Process owningProcess = null;
    protected String elementProcessPath = null;
    protected String relProcessPath = null;
    protected String[] paths = null;
    protected String displayName = null;

    public void init(ElementLayoutManager layoutManager, MethodElement element, Process owningProc, String path) {
        this.init(layoutManager, element);
        this.owningProcess = owningProc;
        this.elementProcessPath = path;
        if (this.owningProcess == null) {
            this.owningProcess = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)this.element));
        }
        if (LibraryUtil.isProcess((EObject)element)) {
            this.owningProcess = (Process)element;
            this.relProcessPath = this.elementProcessPath = AbstractProcessElementLayout.makePath(null, element);
        }
        if (this.elementProcessPath == null && this.element instanceof BreakdownElement) {
            this.elementProcessPath = AbstractProcessElementLayout.getPath((BreakdownElement)this.element);
        }
        this.paths = AbstractProcessElementLayout.getPathArray(this.elementProcessPath);
    }

    public void setRelativeProcessPath(String path) {
        this.relProcessPath = path;
    }

    public String getRelativeProcessPath() {
        return this.relProcessPath;
    }

    public String getQueryString() {
        return ElementLayoutManager.getQueryString(this.owningProcess.getGuid(), this.elementProcessPath);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            ConfigurableComposedAdapterFactory adapterFactory;
            Process proc = this.getOwningProcess();
            Suppression sup = this.getSuppression(proc);
            Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)(adapterFactory = this.layoutManager.getCBSAdapterFactory()));
            if (wrapper == null) {
                wrapper = this.element;
            }
            IBSItemProvider cfr_ignored_0 = (IBSItemProvider)adapterFactory.adapt(wrapper, ITreeItemContentProvider.class);
            this.displayName = ConfigurationHelper.getPresentationName(this.element, this.getLayoutMgr().getConfiguration());
        }
        return this.displayName;
    }

    protected Suppression getSuppression(Process proc) {
        return this.layoutManager.getSuppression(proc);
    }

    protected XmlElement getXmlElement() {
        XmlElement elementXml = super.getXmlElement();
        elementXml.setAttribute("queryString", this.getQueryString()).setAttribute("relProcessPath", this.relProcessPath);
        return elementXml;
    }

    protected Process getOwningProcess() {
        return this.owningProcess;
    }

    protected IElementLayout getLayout(ProcessElementItem item) {
        IElementLayout layout = this.layoutManager.createLayout(item.element, this.owningProcess, item.path);
        if (layout instanceof AbstractProcessElementLayout) {
            String relPath = AbstractProcessElementLayout.getRelativePath(item.path, this.elementProcessPath);
            ((AbstractProcessElementLayout)layout).setRelativeProcessPath(relPath);
        }
        return layout;
    }

    protected String getSuperActivityPath() {
        Activity act;
        String id;
        int i;
        if (this.element instanceof BreakdownElement && (i = this.elementProcessPath.indexOf(id = (act = ((BreakdownElement)this.element).getSuperActivities()).getGuid())) >= 0) {
            return this.elementProcessPath.substring(0, i + id.length());
        }
        return null;
    }

    public static String makePath(String parentPath, MethodElement element) {
        if (parentPath == null || parentPath.length() == 0) {
            return element.getGuid();
        }
        return String.valueOf(parentPath) + "," + element.getGuid();
    }

    public static String getPath(BreakdownElement element) {
        String path = element.getGuid();
        BreakdownElement act = element;
        Process proc = TngUtil.getOwningProcess((BreakdownElement)element);
        while (act != proc) {
            Activity superActs = act.getSuperActivities();
            if (superActs == null) break;
            act = superActs;
            path = String.valueOf(act.getGuid()) + "," + path;
        }
        return path;
    }

    public static String getPath(BreakdownElementWrapperItemProvider wrapper) {
        Object e = LibraryUtil.unwrap(wrapper);
        if (!(e instanceof MethodElement)) {
            return null;
        }
        Object topItem = wrapper.getTopItem();
        StringBuffer path = new StringBuffer();
        path.append(((MethodElement)e).getGuid());
        Object parent = wrapper;
        while (parent != null && parent != topItem) {
            if (parent instanceof BreakdownElement) {
                parent = ((BreakdownElement)parent).getSuperActivities();
                e = parent;
            } else {
                if (!(parent instanceof BreakdownElementWrapperItemProvider)) break;
                parent = parent.getParent(parent);
                e = LibraryUtil.unwrap(parent);
            }
            if (!(e instanceof MethodElement)) continue;
            path.insert(0, String.valueOf(((MethodElement)e).getGuid()) + ",");
        }
        return path.toString();
    }

    public static String getRelativePath(String path, String parentPath) {
        if (path == null) {
            return path;
        }
        if (path.startsWith(parentPath)) {
            return path.substring(parentPath.length());
        }
        return path;
    }

    public static String[] getPathArray(String path) {
        if (path == null) {
            return new String[0];
        }
        ArrayList<String> items = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            items.add(s);
        }
        String[] arr = new String[items.size()];
        items.toArray(arr);
        return arr;
    }

    public static String getOwningProcessGuidFromPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf(",");
        String guid = index < 0 ? path : path.substring(0, index);
        return guid;
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(",");
        if (index > 0) {
            return path.substring(0, index);
        }
        return null;
    }

    protected void modifyChildDisplayName(Object feature, XmlElement childXmlElement, MethodElement childElement) {
        if (!(this.element instanceof TaskDescriptor) && !(this.element instanceof Milestone)) {
            return;
        }
        if (!(childElement instanceof WorkProductDescriptor)) {
            return;
        }
        if (!(feature instanceof EReference)) {
            return;
        }
        EReference ref = (EReference)feature;
        if (!ref.isMany()) {
            return;
        }
        WorkProductDescriptor wpd = (WorkProductDescriptor)childElement;
        String displayName = childXmlElement.getAttribute("DisplayName");
        if (displayName == null) {
            return;
        }
        List states = null;
        if (this.element instanceof TaskDescriptor) {
            states = TaskDescriptorPropUtil.getTaskDescriptorPropUtil().getWpStates((TaskDescriptor)this.element, wpd, ref);
        } else if (this.element instanceof Milestone) {
            states = MilestonePropUtil.getMilestonePropUtil().getWpStates((Milestone)this.element, wpd, ref);
        }
        if (states != null && states.size() > 0) {
            String stateName = ((Constraint)states.get(0)).getBody();
            String newDisplayName = String.valueOf(displayName) + " [" + stateName + "]";
            childXmlElement.setAttribute("DisplayName", newDisplayName);
        }
    }
}

