/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class DescriptorDescriptionLayout
extends AbstractElementLayout {
    MethodElement descriptor;
    MethodElement linkedElement;
    AbstractElementLayout linkedDescriptionLayout = null;

    public DescriptorDescriptionLayout(MethodElement descriptor) {
        this.descriptor = descriptor;
    }

    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
        this.targetElement = this.descriptor;
        this.ownerElement = this.descriptor;
        if (this.descriptor instanceof TaskDescriptor) {
            this.linkedElement = ((TaskDescriptor)this.descriptor).getTask();
        } else if (this.descriptor instanceof RoleDescriptor) {
            this.linkedElement = ((RoleDescriptor)this.descriptor).getRole();
        } else if (this.descriptor instanceof WorkProductDescriptor) {
            this.linkedElement = ((WorkProductDescriptor)this.descriptor).getWorkProduct();
        }
        this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, layoutManager.getElementRealizer());
        if (this.linkedElement != null) {
            this.linkedDescriptionLayout = new GeneralLayout();
            this.linkedDescriptionLayout.init(layoutManager, (MethodElement)((DescribableElement)this.linkedElement).getPresentation());
            this.linkedDescriptionLayout.setContentTarget(this.descriptor);
            this.linkedDescriptionLayout.setElementOwner(this.linkedElement);
        }
    }

    public void loadAttributes(XmlElement elementXml) {
        Object value;
        String name;
        HashMap<String, Object> featureValueMap = new HashMap<String, Object>();
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature p = (EStructuralFeature)features.get(i);
                if (p instanceof EAttribute) {
                    String name2 = p.getName();
                    Object value2 = name2.equals("presentationName") ? ConfigurationHelper.getPresentationName(this.element, this.layoutManager.getConfiguration()) : this.getAttributeFeatureValue(p);
                    featureValueMap.put(name2, value2);
                }
                ++i;
            }
        }
        String refinedDescName = UmaPackage.eINSTANCE.getDescriptorDescription_RefinedDescription().getName();
        String mainDescName = UmaPackage.eINSTANCE.getContentDescription_MainDescription().getName();
        features = null;
        if (this.linkedDescriptionLayout != null && this.linkedDescriptionLayout.getElement() != null) {
            features = LibraryUtil.getStructuralFeatures(this.linkedDescriptionLayout.getElement());
        }
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature p = (EStructuralFeature)features.get(i);
                if (p instanceof EAttribute) {
                    name = p.getName();
                    if (name.equals(mainDescName)) {
                        name = refinedDescName;
                    }
                    if ((value = featureValueMap.get(name)) == null || value.toString().length() == 0) {
                        value = this.linkedDescriptionLayout.getAttributeFeatureValue(p);
                        featureValueMap.put(name, value);
                    }
                }
                ++i;
            }
        }
        for (Map.Entry entry : featureValueMap.entrySet()) {
            name = (String)entry.getKey();
            value = entry.getValue();
            elementXml.newChild("attribute").setAttribute("name", name).setValue(value == null ? "" : value.toString());
        }
    }
}

