/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.library.layout.elements.ActivityLayoutData;

public class ProcessLayoutData {
    Map activityMap = new HashMap();

    public ProcessLayoutData(String proc_guid) {
    }

    public boolean hasActivityLayout(String activity_path) {
        return this.activityMap.containsKey(activity_path);
    }

    public ActivityLayoutData createActivityLauoutData(String activity_path) {
        ActivityLayoutData data = (ActivityLayoutData)this.activityMap.get(activity_path);
        if (data == null) {
            data = new ActivityLayoutData(this, activity_path);
            this.activityMap.put(activity_path, data);
        }
        return data;
    }

    public Map getActivityLayoutDataMap() {
        return this.activityMap;
    }

    public void print(PrintWriter ps) {
        for (Map.Entry entry : this.activityMap.entrySet()) {
            String key;
            String activity_path = (String)entry.getKey();
            ActivityLayoutData data = (ActivityLayoutData)entry.getValue();
            if (data.ad_img_path != null) {
                key = String.valueOf(activity_path) + "Activity";
                this.printImgFile(ps, key, data.ad_img_path);
            }
            if (data.add_img_path != null) {
                key = String.valueOf(activity_path) + "ActivityDetail";
                this.printImgFile(ps, key, data.add_img_path);
            }
            if (data.wpd_img_path != null) {
                key = String.valueOf(activity_path) + "WPDependency";
                this.printImgFile(ps, key, data.wpd_img_path);
            }
            if (data.getSuppressedItems().size() <= 0) continue;
            for (String relPath : data.getSuppressedItems()) {
                String key2 = String.valueOf(activity_path) + relPath;
                this.printSuppressedItem(ps, key2);
            }
        }
    }

    private void printImgFile(PrintWriter ps, String key, String fileName) {
        String line = "contentPage.processPage.imageFiles[\"" + key + "\"]=\"" + fileName + "\"";
        ps.println(line);
    }

    private void printSuppressedItem(PrintWriter ps, String key) {
        String line = "contentPage.processPage.suppressedItems[\"" + key + "\"]=true";
        ps.println(line);
    }

    public void clear() {
        this.activityMap.clear();
    }
}

