/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDescriptorLayout
extends DescriptorLayout {
    public static final Collection<EStructuralFeature> extraFeaturesFromTask = Arrays.asList(UmaPackage.eINSTANCE.getTask_ToolMentors());

    @Override
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    @Override
    public XmlElement getXmlElement(boolean includeReferences) {
        return super.getXmlElement(includeReferences);
    }

    @Override
    public void loadReferences(XmlElement elementXml, boolean includeReferences) {
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature == UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()) {
                    this.processSteps(elementXml, includeReferences);
                } else if (feature == UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor()) {
                    super.loadWorkOrder(elementXml);
                } else if (feature.getEType() instanceof EClass) {
                    this.loadFeature(feature, elementXml, includeReferences);
                }
                ++i;
            }
        }
        elementXml.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        if (this.elementLayout != null && this.layoutManager.getValidator().showExtraInfoForDescriptors()) {
            for (EStructuralFeature feature : this.getExtraFeaturesFromContentElement()) {
                if (this.isSynReferece(feature)) continue;
                this.elementLayout.loadFeature(feature, elementXml, false);
            }
        }
    }

    private void processSteps(XmlElement elementXml, boolean includeReferences) {
        EReference feature = UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps();
        String feature_name = feature.getName();
        List items = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)feature, this.getLayoutMgr().getElementRealizer());
        XmlElement stepXml = elementXml.newChild("referenceList").setAttribute("name", feature_name);
        if (items != null && items.size() > 0) {
            for (Object e : items) {
                IElementLayout l;
                MethodElement me;
                if (!(e instanceof MethodElement) || (e = ConfigurationHelper.getCalculatedElement(me = (MethodElement)e, this.layoutManager.getConfiguration())) == null || (l = this.layoutManager.getLayout(me, true)) == null) continue;
                l.setContentTarget(this.element);
                stepXml.addChild(l.getXmlElement(ConfigurationHelper.isDescriptionElement(me) ? true : includeReferences));
            }
        }
    }

    @Override
    protected Collection<EStructuralFeature> getExtraFeaturesFromContentElement() {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>(extraFeaturesFromTask);
        features.addAll(super.getExtraFeaturesFromContentElement());
        return features;
    }

    @Override
    protected boolean isSuppressed(Suppression sup, EStructuralFeature feature, Object element) {
        if (element instanceof RoleDescriptor || element instanceof WorkProductDescriptor) {
            ConfigurableComposedAdapterFactory adapterFactory;
            String path = DescriptorLayout.makePath(this.elementProcessPath, (MethodElement)element);
            String[] paths = DescriptorLayout.getPathArray(path);
            Object wrapper = sup.getObjectByPath(paths, (AdapterFactory)(adapterFactory = this.layoutManager.getCBSAdapterFactory()));
            if (wrapper == null) {
                wrapper = element;
            }
            return sup.isSuppressed(wrapper, feature);
        }
        return super.isSuppressed(sup, feature, element);
    }
}

