/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.util.IXmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;

public class XmlElement
implements IXmlElement {
    public static final String BR = FileUtil.LINE_SEP;
    private static String NODE_ID = "nodeId";
    private String element_name = null;
    private String element_value = null;
    private Map attributes = new HashMap();
    private Map contents = new HashMap();
    private List children = new ArrayList();
    private String id = null;

    public XmlElement(String name) {
        this(name, null);
    }

    public XmlElement(String name, String id) {
        this.element_name = name;
        if (id == null) {
            id = this.getNodeId();
        }
        this.id = id;
        this.setAttribute(NODE_ID, this.id);
    }

    private String getNodeId() {
        int original_hash = this.toString().hashCode();
        long confusion = System.currentTimeMillis();
        int confusion_hash = (int)(confusion ^ confusion >>> 32);
        int result = original_hash + confusion_hash;
        return Integer.toHexString(result);
    }

    public XmlElement setAttribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String getAttribute(String name) {
        Object value = this.attributes.get(name);
        return value instanceof String ? (String)value : null;
    }

    public XmlElement setValue(String value) {
        this.element_value = value;
        return this;
    }

    public XmlElement setContent(String name, Object value) {
        this.contents.put(name, value);
        return this;
    }

    public XmlElement addChild(XmlElement child) {
        this.children.add(child);
        return this;
    }

    public XmlElement removeChild(XmlElement child) {
        if (this.children.remove(child)) {
            return child;
        }
        return null;
    }

    public XmlElement newChild(String name) {
        return this.newChild(name, null);
    }

    public XmlElement newChild(String name, String id) {
        XmlElement child = new XmlElement(name, id);
        this.children.add(child);
        return child;
    }

    public String getId() {
        return this.id;
    }

    public StringBuffer toXml() {
        StringBuffer buffer = new StringBuffer();
        if (this.contents.size() == 0 && this.children.size() == 0) {
            buffer.append(XmlHelper.getElement(this.element_name, this.element_value, this.attributes)).append(BR);
        } else {
            buffer.append(XmlHelper.beginElement(this.element_name, this.attributes)).append(BR);
            for (Map.Entry entry : this.contents.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    Iterator itList = ((List)value).iterator();
                    while (itList.hasNext()) {
                        buffer.append(XmlHelper.getElement(key, itList.next().toString(), null)).append(BR);
                    }
                    continue;
                }
                buffer.append(XmlHelper.getElement(key, value == null ? "" : value.toString(), null)).append(BR);
            }
            for (IXmlElement child : this.children) {
                buffer.append(child.toXml());
            }
            buffer.append(XmlHelper.endElement(this.element_name)).append(BR);
        }
        return buffer;
    }

    public void saveTo(String filePathName) {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHelper.XML_HEADER).append(this.toXml());
        try {
            OutputStreamWriter xw = new OutputStreamWriter((OutputStream)new FileOutputStream(filePathName), "utf-8");
            xw.write(xml.toString());
            xw.flush();
            xw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

