/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.realization.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.process.command.CustomizeDescriptorCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.realization.IRealizedDescriptor;
import org.eclipse.epf.library.edit.realization.IRealizedElement;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.realization.impl.RealizedBreakdownElement;
import org.eclipse.epf.library.realization.impl.RealizedDescriptor;
import org.eclipse.epf.library.realization.impl.RealizedElement;
import org.eclipse.epf.library.realization.impl.RealizedRoleDescriptor;
import org.eclipse.epf.library.realization.impl.RealizedTaskDescriptor;
import org.eclipse.epf.library.realization.impl.RealizedWorkProductDescriptor;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizationManager
implements IRealizationManager {
    private Map<MethodElement, IRealizedElement> elementMap;
    private MethodConfiguration config;
    private MethodConfiguration dynamicConfig;
    private boolean caching = false;
    private IPerspectiveListener perspectiveListener;
    private boolean localTiming = true;

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    private Map<MethodElement, IRealizedElement> getElementMap() {
        if (this.elementMap == null) {
            this.elementMap = new HashMap<MethodElement, IRealizedElement>();
        }
        return this.elementMap;
    }

    public RealizationManager(MethodConfiguration config) {
        this.config = config;
        this.init();
    }

    public void clearCacheData() {
        for (IRealizedElement element : this.getElementMap().values()) {
            ((RealizedElement)element).dispose();
        }
        this.elementMap = null;
    }

    public void dispose() {
        this.clearCacheData();
        IWorkbenchWindow window = LibraryUtil.getActiveWorkbenchWindow();
        if (window != null && this.perspectiveListener != null) {
            window.removePerspectiveListener(this.perspectiveListener);
        }
    }

    public MethodConfiguration getConfig() {
        if (this.config == null) {
            return this.dynamicConfig;
        }
        return this.config;
    }

    public IRealizedElement getRealizedElement(MethodElement element) {
        IRealizedElement rElement = this.getElementMap().get(element);
        if (rElement == null) {
            rElement = this.newRealizedElement(element);
            this.getElementMap().put(element, rElement);
        }
        return rElement;
    }

    public IRealizedElement removeRealizedElement(MethodElement element) {
        return this.getElementMap().remove(element);
    }

    private void init() {
        IWorkbenchWindow window = LibraryUtil.getActiveWorkbenchWindow();
        if (window != null) {
            this.perspectiveListener = new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor desc) {
                    RealizationManager.this.clearCacheData();
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor desc, String id) {
                    RealizationManager.this.clearCacheData();
                }
            };
            window.addPerspectiveListener(this.perspectiveListener);
        }
    }

    private IRealizedElement newRealizedElement(MethodElement element) {
        RealizedBreakdownElement rElement = null;
        if (element instanceof TaskDescriptor) {
            rElement = new RealizedTaskDescriptor((TaskDescriptor)element);
        } else if (element instanceof RoleDescriptor) {
            rElement = new RealizedRoleDescriptor((RoleDescriptor)element);
        } else if (element instanceof WorkProductDescriptor) {
            rElement = new RealizedWorkProductDescriptor((WorkProductDescriptor)element);
        } else if (element instanceof BreakdownElement) {
            rElement = new RealizedBreakdownElement((BreakdownElement)element);
        }
        rElement.setMgr(this);
        return rElement;
    }

    private MethodElement getLinkedElement(MethodElement element) {
        if (element instanceof RoleDescriptor) {
            return ((RoleDescriptor)element).getRole();
        }
        if (element instanceof WorkProductDescriptor) {
            return ((WorkProductDescriptor)element).getWorkProduct();
        }
        if (element instanceof TaskDescriptor) {
            return ((TaskDescriptor)element).getTask();
        }
        return PropUtil.getPropUtil().getLinkedElement(element);
    }

    public Descriptor getDescriptor(Descriptor referencingDes, Activity parentAct, MethodElement element, EReference feature) {
        Descriptor descriptor = this.getDescriptor_(referencingDes, parentAct, element, feature);
        if (feature == IRealizedDescriptor.ArtifactDescriptor_ContainedArtifacts) {
            return descriptor;
        }
        boolean oldDeliver = referencingDes.eDeliver();
        referencingDes.eSetDeliver(false);
        LibraryEditUtil libEditUtil = LibraryEditUtil.getInstance();
        try {
            if (feature.isMany()) {
                List listValue = (List)TypeDefUtil.getInstance().eGet((EObject)referencingDes, (EStructuralFeature)feature, true);
                if (listValue != null) {
                    listValue.add(descriptor);
                    libEditUtil.addOppositeFeature((MethodElement)referencingDes, (MethodElement)descriptor, (EStructuralFeature)feature);
                }
            } else {
                referencingDes.eSet((EStructuralFeature)feature, (Object)descriptor);
                libEditUtil.addOppositeFeature((MethodElement)referencingDes, (MethodElement)descriptor, (EStructuralFeature)feature);
            }
        }
        finally {
            referencingDes.eSetDeliver(oldDeliver);
        }
        return descriptor;
    }

    private Descriptor getDescriptor_(Descriptor referencingDes, Activity parentAct, MethodElement element, EReference feature) {
        if (parentAct == null) {
            return null;
        }
        Object foundDes = ProcessCommandUtil.getBestDescriptor((Object)element, (Activity)parentAct, (MethodConfiguration)this.getConfig());
        if (foundDes instanceof Descriptor) {
            return (Descriptor)foundDes;
        }
        foundDes = ProcessCommandUtil.getInheritedDescriptor((Object)element, (Activity)parentAct, (MethodConfiguration)this.getConfig());
        if (foundDes instanceof Descriptor) {
            return (Descriptor)foundDes;
        }
        RoleDescriptor descriptor = null;
        if (element instanceof Role) {
            RoleDescriptor rd = UmaFactory.eINSTANCE.createRoleDescriptor();
            rd.setRole((Role)element);
            descriptor = rd;
        } else if (element instanceof Task) {
            TaskDescriptor td = UmaFactory.eINSTANCE.createTaskDescriptor();
            td.setTask((Task)element);
            descriptor = td;
        } else if (element instanceof WorkProduct) {
            WorkProductDescriptor wpd = UmaFactory.eINSTANCE.createWorkProductDescriptor();
            wpd.setWorkProduct((WorkProduct)element);
            descriptor = wpd;
        }
        if (descriptor == null) {
            return null;
        }
        DescriptorPropUtil.getDesciptorPropUtil().setCreatedByReference((Descriptor)descriptor, true);
        String presentationName = element.getPresentationName();
        descriptor.setName(element.getName());
        descriptor.setPresentationName(StrUtil.isBlank((String)presentationName) ? element.getName() : presentationName);
        UmaUtil.generateGUID();
        descriptor.setBriefDescription(element.getBriefDescription());
        this.addToProcess(parentAct, (Descriptor)descriptor, feature);
        return descriptor;
    }

    private void addToProcess(Activity parent, Descriptor referencedDes, EReference feature) {
        UmaPackage up = UmaPackage.eINSTANCE;
        ProcessPackage pkg = (ProcessPackage)parent.eContainer();
        boolean oldParentDeliver = parent.eDeliver();
        boolean oldPkgDeliver = pkg.eDeliver();
        boolean oldReferencedDesDeliver = referencedDes.eDeliver();
        parent.eSetDeliver(false);
        pkg.eSetDeliver(false);
        try {
            parent.getBreakdownElements().add(referencedDes);
            pkg.getProcessElements().add(referencedDes);
            if (feature == up.getWorkProductDescriptor_DeliverableParts()) {
                referencedDes.eSetDeliver(false);
                referencedDes.setSuperActivities(null);
            }
        }
        finally {
            parent.eSetDeliver(oldParentDeliver);
            pkg.eSetDeliver(oldPkgDeliver);
            if (referencedDes.eDeliver() != oldReferencedDesDeliver) {
                referencedDes.eSetDeliver(oldReferencedDesDeliver);
            }
        }
    }

    public void updateProcessModel(Process proc) {
        this.clearCacheData();
        this.setCaching(true);
        this.updateProcessModel(proc, new HashSet<Activity>());
        this.clearCacheData();
        this.setCaching(false);
    }

    public void elementUpdateProcessModel(Process proc, Set<MethodElement> changedElementSet) {
        HashSet<Activity> actCollectedSet = new HashSet<Activity>();
        this.collectActivitiesToUpdate((Activity)proc, actCollectedSet, new HashSet<Activity>(), changedElementSet);
        HashSet<Activity> updatedActSet = new HashSet<Activity>();
        this.clearCacheData();
        this.setCaching(true);
        for (Activity act : actCollectedSet) {
            this.updateModelImpl(act, updatedActSet, false);
        }
        this.clearCacheData();
        this.setCaching(false);
    }

    private void collectActivitiesToUpdate(Activity act, Set<Activity> actCollectedSet, Set<Activity> actProcessedSet, Set<MethodElement> changedElementSet) {
        if (actProcessedSet.contains(act)) {
            return;
        }
        actProcessedSet.add(act);
        Activity baseAct = (Activity)act.getVariabilityBasedOnElement();
        if (baseAct != null) {
            this.collectActivitiesToUpdate(baseAct, actCollectedSet, actProcessedSet, changedElementSet);
        }
        List beList = act.getBreakdownElements();
        int i = 0;
        while (i < beList.size()) {
            MethodElement element;
            BreakdownElement be = (BreakdownElement)beList.get(i);
            if (!actCollectedSet.contains(act) && (element = this.getLinkedElement((MethodElement)be)) != null) {
                if (changedElementSet.contains(element)) {
                    actCollectedSet.add(act);
                } else if (be instanceof Descriptor && changedElementSet.contains(be)) {
                    actCollectedSet.add(act);
                }
            }
            if (be instanceof Activity) {
                this.collectActivitiesToUpdate((Activity)be, actCollectedSet, actProcessedSet, changedElementSet);
            }
            ++i;
        }
    }

    private void updateProcessModel(Process proc, Set<Activity> updatedActSet) {
        if (!ProcessUtil.isSynFree() && !ProcessScopeUtil.getInstance().isConfigFree(proc)) {
            return;
        }
        if (!this.canBeAutoSyned(proc)) {
            return;
        }
        long time = 0L;
        this.updateModelImpl((Activity)proc, updatedActSet, true);
    }

    public void updateActivityModel(Activity act) {
        if (act instanceof Process && !this.canBeAutoSyned((Process)act)) {
            return;
        }
        this.clearCacheData();
        this.setCaching(true);
        this.updateModelImpl(act, new HashSet<Activity>(), false);
        this.clearCacheData();
        this.setCaching(false);
    }

    /*
     * WARNING - void declaration
     */
    private void updateModelImpl(Activity act, Set<Activity> updatedActSet, boolean recursive) {
        void var12_19;
        Process proc;
        if (updatedActSet.contains(act)) {
            return;
        }
        updatedActSet.add(act);
        Activity baseAct = (Activity)act.getVariabilityBasedOnElement();
        if (baseAct != null) {
            this.updateModelImpl(baseAct, updatedActSet, recursive);
        }
        if (!(ProcessUtil.isSynFree() || (proc = ProcessUtil.getProcess((Activity)act)) != null && ProcessScopeUtil.getInstance().isConfigFree(proc))) {
            return;
        }
        if (this.config == null) {
            proc = ProcessUtil.getProcess((Activity)act);
            Scope scope = ProcessScopeUtil.getInstance().getScope(proc);
            this.dynamicConfig = scope != null ? scope : LibraryService.getInstance().getCurrentMethodConfiguration();
        }
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        HashSet<Descriptor> tdReferencedSet = new HashSet<Descriptor>();
        HashSet<Descriptor> seenSet = new HashSet<Descriptor>();
        ArrayList<Object> rdwpdList = new ArrayList<Object>();
        List beList = act.getBreakdownElements();
        HashSet localUseSet = new HashSet();
        int i = 0;
        while (i < beList.size()) {
            BreakdownElement breakdownElement = (BreakdownElement)beList.get(i);
            if (breakdownElement instanceof Activity) {
                if (recursive) {
                    this.updateModelImpl((Activity)breakdownElement, updatedActSet, recursive);
                }
            } else if (breakdownElement instanceof TaskDescriptor) {
                TaskDescriptor td = (TaskDescriptor)breakdownElement;
                Descriptor greenParent = propUtil.getGreenParentDescriptor((Descriptor)td);
                if (greenParent != null) {
                    CustomizeDescriptorCommand.updateFromGreenParent((Descriptor)greenParent, (Descriptor)td, (boolean)false);
                }
                this.collectAllReferences((Descriptor)td, tdReferencedSet, seenSet);
            } else if (breakdownElement instanceof RoleDescriptor) {
                RoleDescriptor rd = (RoleDescriptor)breakdownElement;
                rdwpdList.add(rd);
            } else if (breakdownElement instanceof WorkProductDescriptor) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)breakdownElement;
                rdwpdList.add(wpd);
            }
            if (breakdownElement instanceof Descriptor) {
                localUseSet.addAll(propUtil.getLocalUsedDescriptors((Descriptor)breakdownElement));
            }
            ++i;
        }
        HashSet<Descriptor> toRemovedSet = new HashSet<Descriptor>();
        for (Descriptor descriptor : rdwpdList) {
            this.collectAllReferences(descriptor, null, seenSet);
            if (descriptor instanceof TaskDescriptor || localUseSet.contains(descriptor) || !propUtil.isCreatedByReference(descriptor) || tdReferencedSet.contains(descriptor)) continue;
            toRemovedSet.add(descriptor);
        }
        for (Descriptor descriptor : toRemovedSet) {
            if (ProcessUtil.checkDescriptorReferences(toRemovedSet, (Descriptor)descriptor)) continue;
            act.getBreakdownElements().remove(descriptor);
        }
        beList = act.getBreakdownElements();
        boolean bl = false;
        while (var12_19 < beList.size()) {
            BreakdownElement be = (BreakdownElement)beList.get((int)var12_19);
            if (be instanceof Descriptor) {
                RealizedDescriptor rdes = (RealizedDescriptor)this.getRealizedElement((MethodElement)be);
                rdes.updateStringValues();
            } else {
                RealizedBreakdownElement rBe = (RealizedBreakdownElement)this.getRealizedElement((MethodElement)be);
                rBe.updateAndGetAllReferenced();
                rBe.updateStringValues();
            }
            ++var12_19;
        }
    }

    private void collectAllReferences(Descriptor des, Set<Descriptor> collectingSet, Set<Descriptor> seenSet) {
        if (seenSet.contains(des)) {
            return;
        }
        seenSet.add(des);
        RealizedDescriptor rdes = (RealizedDescriptor)this.getRealizedElement((MethodElement)des);
        Set<Descriptor> references = rdes.updateAndGetAllReferenced();
        if (collectingSet != null) {
            collectingSet.addAll(references);
        }
        for (Descriptor ref : references) {
            this.collectAllReferences(ref, collectingSet, seenSet);
        }
    }

    public void updateAllProcesseModels() {
        boolean oldLocalTiming = this.localTiming;
        long time = 0L;
        HashSet<Activity> updatedActSet = new HashSet<Activity>();
        this.clearCacheData();
        this.setCaching(true);
        for (Process proc : LibraryEditUtil.getInstance().collectProcessesFromConfig(this.getConfig())) {
            this.updateProcessModel(proc, updatedActSet);
        }
        this.clearCacheData();
        this.setCaching(false);
    }

    private boolean canBeAutoSyned(Process proc) {
        boolean ret = ConfigurationHelper.getDelegate().canBeConfigFree(proc);
        return ret;
    }
}

