/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.realization.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.realization.IRealizedBreakdownElement;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.realization.impl.RealizedElement;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizedBreakdownElement
extends RealizedElement
implements IRealizedBreakdownElement {
    public RealizedBreakdownElement(BreakdownElement element) {
        super((MethodElement)element);
    }

    protected ContentElement getLinkedElement() {
        MethodElement element = this.getRawLinkedElement();
        if (!(element instanceof ContentElement)) {
            return null;
        }
        return (ContentElement)ConfigurationHelper.getCalculatedElement(element, this.getConfig());
    }

    protected MethodElement getRawLinkedElement() {
        return PropUtil.getPropUtil().getLinkedElement(this.getElement());
    }

    public Set<Descriptor> updateAndGetAllReferenced() {
        return this.updateExtendedReferences();
    }

    private Set<Descriptor> updateExtendedReferences() {
        Set<Descriptor> set = this.updateExtendedReferences_();
        this.markWpdsReferenced(set);
        return set;
    }

    private Set<Descriptor> updateExtendedReferences_() {
        HashSet<Descriptor> set = new HashSet<Descriptor>();
        ContentElement element = this.getLinkedElement();
        if (element == null) {
            return set;
        }
        ModifiedTypeMeta meta = PropUtil.getPropUtil().getGlobalMdtMeta((MethodElement)element);
        if (meta == null) {
            return set;
        }
        DefaultElementRealizer.newElementRealizer(this.getConfig());
        for (ExtendedReference eRef : meta.getReferences()) {
            Set<Descriptor> descriptors = this.updateExtendedReference(eRef);
            if (descriptors.isEmpty()) continue;
            set.addAll(descriptors);
        }
        return set;
    }

    protected void markWpdsReferenced(Collection<? extends Descriptor> descriptors) {
        if (descriptors == null) {
            return;
        }
        for (Descriptor descriptor : descriptors) {
            if (!(descriptor instanceof WorkProductDescriptor)) continue;
            PropUtil.getPropUtil().setExcludedFromPublish((MethodElement)descriptor, false);
        }
    }

    protected Set<Descriptor> updateExtendedReference(ExtendedReference eRef) {
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.getConfig());
        List elementList = ConfigurationHelper.calc0nFeatureValue((MethodElement)this.getLinkedElement(), (EStructuralFeature)eRef.getReference(), realizer);
        Object value = TypeDefUtil.getInstance().eGet((EObject)this.getElement(), (EStructuralFeature)eRef.getReference(), true);
        if (value instanceof List) {
            List dList = (List)value;
            dList.clear();
            if (elementList != null && !elementList.isEmpty()) {
                if (this.getDescriptor() != null && eRef.getContributeTo() != null) {
                    HashSet<Descriptor> set = new HashSet<Descriptor>();
                    Activity parentAct = this.getDescriptor().getSuperActivities();
                    if (parentAct == null) {
                        return set;
                    }
                    int i = 0;
                    while (i < elementList.size()) {
                        Object item = elementList.get(i);
                        if (item instanceof Role || item instanceof WorkProduct) {
                            Descriptor des = this.getMgr().getDescriptor(this.getDescriptor(), parentAct, (MethodElement)item, eRef.getReference());
                            set.add(des);
                        }
                        ++i;
                    }
                    return set;
                }
                dList.addAll(elementList);
            }
        }
        return Collections.EMPTY_SET;
    }

    protected Descriptor getDescriptor() {
        return null;
    }

    public void updateStringValues() {
        ContentElement element = this.getLinkedElement();
        if (element == null) {
            return;
        }
        ModifiedTypeMeta meta = PropUtil.getPropUtil().getGlobalMdtMeta((MethodElement)element);
        if (meta == null) {
            return;
        }
        for (ExtendedAttribute eAtt : meta.getRtes()) {
            this.getFeatureValue_((EStructuralFeature)eAtt.getAttribute());
        }
        for (ExtendedAttribute eAtt : meta.getAttributes()) {
            this.getFeatureValue_((EStructuralFeature)eAtt.getAttribute());
        }
    }

    @Override
    public Object getFeatureValue(EStructuralFeature feature) {
        return this.getFeatureValue_(feature);
    }

    private Object getFeatureValue_(EStructuralFeature feature) {
        if (TypeDefUtil.getInstance().getAssociatedExtendedAttribute(feature) == null) {
            return null;
        }
        return this.getContentFeatureValue(feature);
    }

    private Object getContentFeatureValue(EStructuralFeature feature) {
        if (this.getLinkedElement() == null) {
            return null;
        }
        if (!ContentDescriptionFactory.hasPresentation((MethodElement)this.getLinkedElement())) {
            return null;
        }
        EStructuralFeature elementFeature = null;
        if (TypeDefUtil.getInstance().getAssociatedExtendedAttribute(feature) != null) {
            elementFeature = feature;
        }
        if (elementFeature != null) {
            Object value = null;
            if (this.getDescribableElement().getPresentation() != null) {
                try {
                    value = TypeDefUtil.getInstance().eGet((EObject)this.getDescribableElement().getPresentation(), feature);
                }
                catch (Throwable e) {
                    LibraryPlugin.getDefault().getLogger().logError(e);
                    return null;
                }
            }
            if (this.getLinkedElement() == null || this.getLinkedElement().getPresentation() == null) {
                return value;
            }
            Object linkedValue = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)this.getLinkedElement().getPresentation(), elementFeature, this.getConfig());
            if (linkedValue == null && value != null || linkedValue != null && !linkedValue.equals(value)) {
                TypeDefUtil.getInstance().eSet((EObject)this.getDescribableElement().getPresentation(), feature, linkedValue);
            }
            return linkedValue;
        }
        return null;
    }

    protected DescribableElement getDescribableElement() {
        if (this.getElement() instanceof DescribableElement) {
            return (DescribableElement)this.getElement();
        }
        return null;
    }
}

