/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.realization.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.realization.IRealizedDescriptor;
import org.eclipse.epf.library.edit.realization.IRealizedElement;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.realization.impl.RealizedBreakdownElement;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizedDescriptor
extends RealizedBreakdownElement
implements IRealizedDescriptor,
IRealizedElement {
    private static Set<EStructuralFeature> featureSet = new HashSet<EStructuralFeature>();
    private static Map<EStructuralFeature, EStructuralFeature> contentFeatureMap = new HashMap<EStructuralFeature, EStructuralFeature>();

    static {
        UmaPackage up = UmaPackage.eINSTANCE;
        featureSet.add((EStructuralFeature)up.getNamedElement_Name());
        featureSet.add((EStructuralFeature)up.getMethodElement_PresentationName());
        featureSet.add((EStructuralFeature)up.getMethodElement_BriefDescription());
        contentFeatureMap.put((EStructuralFeature)up.getDescriptorDescription_RefinedDescription(), (EStructuralFeature)up.getContentDescription_MainDescription());
        contentFeatureMap.put((EStructuralFeature)up.getContentDescription_KeyConsiderations(), (EStructuralFeature)up.getContentDescription_KeyConsiderations());
    }

    public RealizedDescriptor(Descriptor descriptor) {
        super((BreakdownElement)descriptor);
    }

    @Override
    public boolean handleFeature(EStructuralFeature feature) {
        return featureSet.contains(feature);
    }

    private Object getContentFeatureValue(EStructuralFeature feature) {
        if (this.getLinkedElement() == null) {
            return null;
        }
        EStructuralFeature elementFeature = contentFeatureMap.get(feature);
        if (elementFeature != null) {
            Object value = null;
            if (this.getDescriptor().getPresentation() != null) {
                try {
                    value = this.getDescriptor().getPresentation().eGet(feature);
                }
                catch (Throwable e) {
                    LibraryPlugin.getDefault().getLogger().logError(e);
                    return null;
                }
            }
            if (this.getLinkedElement() == null || this.getLinkedElement().getPresentation() == null) {
                return value;
            }
            DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
            if (propUtil.isValueReplaced(feature, this.getDescriptor())) {
                return value;
            }
            Descriptor greenParent = propUtil.getGreenParentDescriptor(this.getDescriptor());
            Object linkedValue = greenParent == null ? ConfigurationHelper.calcAttributeFeatureValue((MethodElement)this.getLinkedElement().getPresentation(), (MethodElement)this.getLinkedElement(), elementFeature, this.getConfig()) : greenParent.getPresentation().eGet(feature);
            if (linkedValue == null && value != null || linkedValue != null && !linkedValue.equals(value)) {
                this.getDescriptor().getPresentation().eSet(feature, linkedValue);
            }
            return linkedValue;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFeatureValue(EStructuralFeature feature) {
        Object value = super.getFeatureValue(feature);
        if (value != null) {
            return value;
        }
        return this.getFeatureValue_(feature);
    }

    private Object getFeatureValue_(EStructuralFeature feature) {
        if (contentFeatureMap.containsKey(feature)) {
            return this.getContentFeatureValue(feature);
        }
        if (feature instanceof EAttribute) {
            Object value = this.getDescriptor().eGet(feature);
            if (this.getLinkedElement() == null) {
                return value;
            }
            DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
            if (propUtil.isValueReplaced(feature, this.getDescriptor())) {
                return value;
            }
            Descriptor greenParent = propUtil.getGreenParentDescriptor(this.getDescriptor());
            Object linkedValue = greenParent == null ? this.calcAttributeFeatureValue((MethodElement)this.getLinkedElement(), feature, this.getConfig()) : greenParent.eGet(feature);
            if (linkedValue == null && value != null || linkedValue != null && !linkedValue.equals(value)) {
                this.getDescriptor().eSet(feature, linkedValue);
            }
            return linkedValue;
        }
        return null;
    }

    private Object calcAttributeFeatureValue(MethodElement linkedElement, EStructuralFeature feature, MethodConfiguration config) {
        if (feature == UmaPackage.eINSTANCE.getMethodElement_PresentationName()) {
            return ConfigurationHelper.getPresentationName(linkedElement, config);
        }
        return ConfigurationHelper.calcAttributeFeatureValue((MethodElement)this.getLinkedElement(), feature, this.getConfig());
    }

    @Override
    public Object getOFeatureValue(OppositeFeature ofeature) {
        return super.getOFeatureValue(ofeature);
    }

    @Override
    protected ContentElement getLinkedElement() {
        MethodElement element = this.getRawLinkedElement();
        if (element == null) {
            return null;
        }
        return (ContentElement)ConfigurationHelper.getCalculatedElement(element, this.getConfig());
    }

    @Override
    protected MethodElement getRawLinkedElement() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Descriptor getDescriptor() {
        return (Descriptor)this.getElement();
    }

    protected List<? extends Descriptor> getDescriptorList(EReference elementFeature, EReference[] descriptorFeatures) {
        DescriptorPropUtil propUtil;
        Set localUsedDescriptors;
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.getConfig());
        EReference dFeature = descriptorFeatures[0];
        EReference cfr_ignored_0 = descriptorFeatures[1];
        ContentElement element = this.getLinkedElement();
        if (element == null) {
            return ConfigurationHelper.calc0nFeatureValue((MethodElement)this.getDescriptor(), (EStructuralFeature)dFeature, realizer);
        }
        List elementList = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)elementFeature, realizer);
        ArrayList<Descriptor> resultDescriptorList = new ArrayList<Descriptor>();
        EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature(dFeature);
        Set<MethodElement> excludeElements = this.getExcludeOrAddtionalRefSet(this.getDescriptor(), eRef, realizer);
        LinkedHashSet<MethodElement> elementSet = new LinkedHashSet<MethodElement>();
        if (elementList != null) {
            for (MethodElement elem : elementList) {
                if (excludeElements.contains(elem)) continue;
                elementSet.add(elem);
            }
        }
        if (!(localUsedDescriptors = (propUtil = DescriptorPropUtil.getDesciptorPropUtil()).getLocalUsedDescriptors(this.getDescriptor(), dFeature)).isEmpty()) {
            for (Descriptor des : localUsedDescriptors) {
                MethodElement localUseElement = this.getLinkedElement(des);
                if (localUseElement == null || (localUseElement = ConfigurationHelper.getCalculatedElement(localUseElement, this.getConfig())) == null || excludeElements.contains(localUseElement)) continue;
                elementSet.add(localUseElement);
            }
        }
        List descriptorList = ConfigurationHelper.calc0nFeatureValue((MethodElement)this.getDescriptor(), (EStructuralFeature)dFeature, realizer);
        for (Descriptor des : descriptorList) {
            MethodElement me = this.getLinkedElement(des);
            if (me == null || propUtil.localUse(des, this.getDescriptor(), dFeature)) {
                resultDescriptorList.add(des);
                if (me == null) continue;
                elementSet.remove(me);
                continue;
            }
            if (!elementSet.contains(me)) continue;
            resultDescriptorList.add(des);
            elementSet.remove(me);
        }
        if (elementSet.isEmpty()) {
            return this.processResultDescriptorList(resultDescriptorList, dFeature);
        }
        Activity parentAct = this.getDescriptor().getSuperActivities();
        if (parentAct == null) {
            return this.processResultDescriptorList(resultDescriptorList, dFeature);
        }
        Descriptor referencingDes = this.getDescriptor();
        for (MethodElement me : elementSet) {
            Descriptor des = this.getMgr().getDescriptor(referencingDes, parentAct, me, dFeature);
            Activity checkParentAct = parentAct;
            while (!(checkParentAct instanceof Process)) {
                checkParentAct = checkParentAct.getSuperActivities();
            }
            Process p = (Process)checkParentAct;
            if (p.getDefaultContext() == null && (me instanceof Role || me instanceof WorkProduct)) {
                des.setGuid(String.valueOf(referencingDes.getGuid()) + me.getGuid());
            }
            resultDescriptorList.add(des);
        }
        return this.processResultDescriptorList(resultDescriptorList, dFeature);
    }

    private List<Descriptor> processResultDescriptorList(List<Descriptor> resultDescriptorList, EReference dFeature) {
        List listValue;
        if (dFeature.isMany() && (listValue = (List)this.getDescriptor().eGet((EStructuralFeature)dFeature)) != null && !listValue.isEmpty()) {
            HashSet<Descriptor> resultSet = new HashSet<Descriptor>(resultDescriptorList);
            LibraryEditUtil libEditUtil = LibraryEditUtil.getInstance();
            boolean oldDeliver = this.getDescriptor().eDeliver();
            this.getDescriptor().eSetDeliver(false);
            try {
                int i = listValue.size() - 1;
                while (i >= 0) {
                    Descriptor des = (Descriptor)listValue.get(i);
                    if (!resultSet.contains(des)) {
                        listValue.remove(i);
                        libEditUtil.removeOppositeFeature((MethodElement)this.getDescriptor(), (MethodElement)des, (EStructuralFeature)dFeature);
                    }
                    --i;
                }
            }
            finally {
                this.getDescriptor().eSetDeliver(oldDeliver);
            }
        }
        return resultDescriptorList;
    }

    private MethodElement getLinkedElement(Descriptor des) {
        MethodElement element = DescriptorPropUtil.getDesciptorPropUtil().getLinkedElement(des);
        if (element == null) {
            return null;
        }
        return ConfigurationHelper.getCalculatedElement(element, this.getConfig());
    }

    @Override
    public Set<Descriptor> updateAndGetAllReferenced() {
        this.getGuidances();
        return super.updateAndGetAllReferenced();
    }

    protected void addToSet(Set<Descriptor> set, List<? extends Descriptor> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        set.addAll(list);
    }

    @Override
    public void updateStringValues() {
        super.updateStringValues();
        for (EStructuralFeature feature : featureSet) {
            this.getFeatureValue_(feature);
        }
        for (EStructuralFeature feature : contentFeatureMap.keySet()) {
            this.getFeatureValue_(feature);
        }
    }

    protected Set<MethodElement> getExcludeOrAddtionalRefSet(Descriptor des, EReference eRef, ElementRealizer realizer) {
        LinkedHashSet<MethodElement> set = new LinkedHashSet<MethodElement>();
        if (!ProcessUtil.isSynFree()) {
            return set;
        }
        if (des == null) {
            return set;
        }
        try {
            Set<MethodElement> rawSet = this.getRawExcludeOrAddtionalRefSet(des, eRef, realizer.getConfiguration(), true);
            for (MethodElement elem : rawSet) {
                MethodElement realized = ConfigurationHelper.getCalculatedElement(elem, realizer);
                if (realized == null) continue;
                set.add(realized);
            }
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return set;
    }

    private Set<MethodElement> getRawExcludeOrAddtionalRefSet(Descriptor des, EReference eRef, MethodConfiguration config, boolean topLevelCall) {
        List list;
        LinkedHashSet<MethodElement> refSet = new LinkedHashSet<MethodElement>();
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        Descriptor greenParent = propUtil.getGreenParentDescriptor(des);
        if (greenParent != null && ConfigurationHelper.inConfig((MethodElement)greenParent, config)) {
            Set<MethodElement> parentSet = this.getRawExcludeOrAddtionalRefSet(greenParent, eRef, config, false);
            refSet.addAll(parentSet);
            list = propUtil.getGreenRefDeltaList(des, eRef, false);
            if (list != null && !list.isEmpty()) {
                refSet.removeAll(list);
            }
            if ((list = propUtil.getGreenRefDeltaList(des, eRef, true)) != null && !list.isEmpty()) {
                refSet.addAll(list);
            }
        }
        list = (List)des.eGet((EStructuralFeature)eRef);
        if (greenParent == null && list != null && !list.isEmpty()) {
            refSet.addAll(list);
        }
        if (topLevelCall && greenParent != null && list.size() != refSet.size()) {
            list.clear();
            list.addAll(refSet);
        }
        return refSet;
    }

    public List<Guidance> getGuidances() {
        UmaPackage up = UmaPackage.eINSTANCE;
        ArrayList<Guidance> resultList = new ArrayList<Guidance>();
        Map refMap = LibraryEditUtil.getInstance().getGuidanceRefMap(this.getLinkedElementType());
        if (refMap == null) {
            return resultList;
        }
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.getConfig());
        Set<MethodElement> excludeList = this.getExcludeOrAddtionalRefSet(this.getDescriptor(), up.getDescriptor_GuidanceExclude(), realizer);
        Set<MethodElement> addtionList = this.getExcludeOrAddtionalRefSet(this.getDescriptor(), up.getDescriptor_GuidanceAdditional(), realizer);
        for (Map.Entry entry : refMap.entrySet()) {
            List<Guidance> subList = this.calculateGuidances((EReference)entry.getKey(), (EReference)entry.getValue(), excludeList, addtionList);
            resultList.addAll(subList);
        }
        return resultList;
    }

    private List<Guidance> calculateGuidances(EReference eRef, EReference dRef, Collection<MethodElement> excludeList, Collection<MethodElement> addtionList) {
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.getConfig());
        ContentElement element = this.getLinkedElement();
        if (element == null) {
            return ConfigurationHelper.calc0nFeatureValue((MethodElement)this.getDescriptor(), (EStructuralFeature)dRef, realizer);
        }
        List elementGuidanceList = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)eRef, realizer);
        LinkedHashSet<Guidance> resultGuidanceSet = new LinkedHashSet<Guidance>();
        if (addtionList != null) {
            for (MethodElement me : addtionList) {
                Guidance g = (Guidance)me;
                if (eRef == UmaUtil.MethodElement_UdtList) {
                    if (!PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)g)) continue;
                    resultGuidanceSet.add(g);
                    continue;
                }
                if (!eRef.getEType().isInstance((Object)g)) continue;
                resultGuidanceSet.add(g);
            }
        }
        if (!elementGuidanceList.isEmpty()) {
            resultGuidanceSet.addAll(elementGuidanceList);
            if (excludeList != null && !excludeList.isEmpty()) {
                resultGuidanceSet.removeAll(excludeList);
            }
        }
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        ArrayList<Guidance> resultGuidanceList = new ArrayList<Guidance>();
        boolean oldDeliver = this.getDescriptor().eDeliver();
        try {
            LibraryEditUtil libEditUtil = LibraryEditUtil.getInstance();
            this.getDescriptor().eSetDeliver(false);
            List desCuidanceList = (List)propUtil.eGet((EObject)this.getDescriptor(), (EStructuralFeature)dRef, true);
            int i = desCuidanceList.size() - 1;
            while (i >= 0) {
                boolean keepInList = resultGuidanceSet.remove(desCuidanceList.get(i));
                if (!keepInList) {
                    Guidance g = (Guidance)desCuidanceList.remove(i);
                    libEditUtil.removeOppositeFeature((MethodElement)this.getDescriptor(), (MethodElement)g, (EStructuralFeature)dRef);
                }
                --i;
            }
            if (!resultGuidanceSet.isEmpty()) {
                HashSet desGuidanceSet = new HashSet();
                desGuidanceSet.addAll(desCuidanceList);
                for (Guidance g : resultGuidanceSet) {
                    if (desGuidanceSet.contains(g)) continue;
                    desCuidanceList.add(g);
                    libEditUtil.addOppositeFeature((MethodElement)this.getDescriptor(), (MethodElement)g, (EStructuralFeature)dRef);
                }
            }
            if (dRef == UmaUtil.MethodElement_UdtList) {
                try {
                    propUtil.storeReferences((MethodElement)this.getDescriptor(), false);
                }
                catch (Exception e) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
            resultGuidanceList.addAll(desCuidanceList);
        }
        finally {
            this.getDescriptor().eSetDeliver(oldDeliver);
        }
        return resultGuidanceList;
    }

    private EClass getLinkedElementType() {
        if (this.getDescriptor() instanceof TaskDescriptor) {
            return UmaPackage.eINSTANCE.getTask();
        }
        if (this.getDescriptor() instanceof RoleDescriptor) {
            return UmaPackage.eINSTANCE.getRole();
        }
        if (this.getDescriptor() instanceof WorkProductDescriptor) {
            return UmaPackage.eINSTANCE.getWorkProduct();
        }
        throw new UnsupportedOperationException();
    }
}

