/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.realization.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.realization.IRealizedTaskDescriptor;
import org.eclipse.epf.library.realization.impl.RealizedDescriptor;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizedTaskDescriptor
extends RealizedDescriptor
implements IRealizedTaskDescriptor {
    private static Set<EStructuralFeature> featureSet = new HashSet<EStructuralFeature>();

    static {
        UmaPackage up = UmaPackage.eINSTANCE;
        featureSet.add((EStructuralFeature)up.getTaskDescriptor_PerformedPrimarilyBy());
        featureSet.add((EStructuralFeature)up.getTaskDescriptor_MandatoryInput());
        featureSet.add((EStructuralFeature)up.getTaskDescriptor_AdditionallyPerformedBy());
        featureSet.add((EStructuralFeature)up.getTaskDescriptor_Output());
        featureSet.add((EStructuralFeature)up.getTaskDescriptor_SelectedSteps());
    }

    public RealizedTaskDescriptor(TaskDescriptor td) {
        super((Descriptor)td);
    }

    @Override
    public boolean handleFeature(EStructuralFeature feature) {
        if (featureSet.contains(feature)) {
            return true;
        }
        return super.handleFeature(feature);
    }

    @Override
    public Object getFeatureValue(EStructuralFeature feature) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (feature == up.getTaskDescriptor_PerformedPrimarilyBy()) {
            return this.getPerformedPrimarilyBy();
        }
        if (feature == up.getTaskDescriptor_MandatoryInput()) {
            return this.getMandatoryInput();
        }
        if (feature == up.getTaskDescriptor_AdditionallyPerformedBy()) {
            return this.getAdditionallyPerformedBy();
        }
        if (feature == up.getTaskDescriptor_Output()) {
            return this.getOutput();
        }
        if (feature == up.getTaskDescriptor_SelectedSteps()) {
            return this.getSelectedSteps();
        }
        return super.getFeatureValue(feature);
    }

    public List<RoleDescriptor> getPerformedPrimarilyBy() {
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference tdReference = up.getTaskDescriptor_PerformedPrimarilyBy();
        List<? extends Descriptor> rdList = (List<? extends Descriptor>)this.getCachedValue((EStructuralFeature)tdReference);
        if (rdList == null) {
            EReference[] tdFeatures = new EReference[]{tdReference, up.getTaskDescriptor_PerformedPrimarilyByExcluded()};
            rdList = this.getDescriptorList(up.getTask_PerformedBy(), tdFeatures);
            this.storeCachedValue((EStructuralFeature)tdReference, rdList);
        }
        return rdList;
    }

    public List<RoleDescriptor> getAdditionallyPerformedBy() {
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference tdReference = up.getTaskDescriptor_AdditionallyPerformedBy();
        List<? extends Descriptor> rdList = (List<? extends Descriptor>)this.getCachedValue((EStructuralFeature)tdReference);
        if (rdList == null) {
            EReference[] tdFeatures = new EReference[]{tdReference, up.getTaskDescriptor_AdditionallyPerformedByExclude()};
            rdList = this.getDescriptorList(up.getTask_AdditionallyPerformedBy(), tdFeatures);
            this.storeCachedValue((EStructuralFeature)tdReference, rdList);
        }
        return rdList;
    }

    public List<WorkProductDescriptor> getMandatoryInput() {
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference tdReference = up.getTaskDescriptor_MandatoryInput();
        List<? extends Descriptor> wpdList = (List<? extends Descriptor>)this.getCachedValue((EStructuralFeature)tdReference);
        if (wpdList == null) {
            EReference[] tdFeatures = new EReference[]{tdReference, up.getTaskDescriptor_MandatoryInputExclude()};
            wpdList = this.getDescriptorList(up.getTask_MandatoryInput(), tdFeatures);
            this.storeCachedValue((EStructuralFeature)tdReference, wpdList);
        }
        this.markWpdsReferenced((Collection<? extends Descriptor>)wpdList);
        return wpdList;
    }

    public List<WorkProductDescriptor> getOptionalInput() {
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference tdReference = up.getTaskDescriptor_OptionalInput();
        List<? extends Descriptor> wpdList = (List<? extends Descriptor>)this.getCachedValue((EStructuralFeature)tdReference);
        if (wpdList == null) {
            EReference[] tdFeatures = new EReference[]{tdReference, up.getTaskDescriptor_OptionalInputExclude()};
            wpdList = this.getDescriptorList(up.getTask_OptionalInput(), tdFeatures);
            this.storeCachedValue((EStructuralFeature)tdReference, wpdList);
        }
        this.markWpdsReferenced((Collection<? extends Descriptor>)wpdList);
        return wpdList;
    }

    public List<Section> getSelectedSteps() {
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference dFeature = up.getTaskDescriptor_SelectedSteps();
        List<Section> stepList = (List<Section>)this.getCachedValue((EStructuralFeature)dFeature);
        if (stepList == null) {
            stepList = this.calculateSelectedSteps();
        }
        return stepList;
    }

    private List<Section> calculateSelectedSteps() {
        Set<MethodElement> excludeElements;
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference dFeature = up.getTaskDescriptor_SelectedSteps();
        up.getTaskDescriptor_SelectedStepsExclude();
        EReference elementFeature = up.getTask_Steps();
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.getConfig());
        ContentElement element = this.getLinkedElement();
        if (element == null) {
            return ConfigurationHelper.calc0nFeatureValue((MethodElement)this.getDescriptor(), (EStructuralFeature)dFeature, realizer);
        }
        ArrayList elementStepList = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)elementFeature, realizer);
        if (elementStepList == null) {
            elementStepList = new ArrayList();
        }
        if (!elementStepList.isEmpty() && (excludeElements = this.getExcludeOrAddtionalRefSet(this.getDescriptor(), up.getTaskDescriptor_SelectedStepsExclude(), realizer)) != null && !excludeElements.isEmpty()) {
            elementStepList.removeAll(excludeElements);
        }
        boolean same = true;
        List valueList = ((TaskDescriptor)this.getDescriptor()).getSelectedSteps();
        if (elementStepList.size() == valueList.size()) {
            int i = 0;
            while (i < valueList.size()) {
                if (valueList.get(i) != elementStepList.get(i)) {
                    same = false;
                    break;
                }
                ++i;
            }
        } else {
            same = false;
        }
        if (!same) {
            valueList.clear();
            if (!elementStepList.isEmpty()) {
                valueList.addAll(elementStepList);
            }
        }
        return valueList;
    }

    public List<WorkProductDescriptor> getOutput() {
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference tdReference = up.getTaskDescriptor_Output();
        List<? extends Descriptor> wpdList = (List<? extends Descriptor>)this.getCachedValue((EStructuralFeature)tdReference);
        if (wpdList == null) {
            EReference[] tdFeatures = new EReference[]{tdReference, up.getTaskDescriptor_OutputExclude()};
            wpdList = this.getDescriptorList(up.getTask_Output(), tdFeatures);
            this.storeCachedValue((EStructuralFeature)tdReference, wpdList);
        }
        this.markWpdsReferenced((Collection<? extends Descriptor>)wpdList);
        return wpdList;
    }

    @Override
    protected MethodElement getRawLinkedElement() {
        return this.getTaskDescriptor().getTask();
    }

    private TaskDescriptor getTaskDescriptor() {
        return (TaskDescriptor)this.getElement();
    }

    @Override
    public Set<Descriptor> updateAndGetAllReferenced() {
        HashSet<Descriptor> referenced = new HashSet<Descriptor>();
        this.addToSet(referenced, this.getPerformedPrimarilyBy());
        this.addToSet(referenced, this.getMandatoryInput());
        this.addToSet(referenced, this.getAdditionallyPerformedBy());
        this.addToSet(referenced, this.getOptionalInput());
        this.addToSet(referenced, this.getOutput());
        this.getSelectedSteps();
        Set<Descriptor> superSet = super.updateAndGetAllReferenced();
        referenced.addAll(superSet);
        return referenced;
    }
}

