/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.realization.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.realization.IRealizedWorkProductDescriptor;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.realization.impl.RealizedDescriptor;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizedWorkProductDescriptor
extends RealizedDescriptor
implements IRealizedWorkProductDescriptor {
    private static Set<EStructuralFeature> featureSet = new HashSet<EStructuralFeature>();

    static {
        UmaPackage up = UmaPackage.eINSTANCE;
        featureSet.add((EStructuralFeature)up.getWorkProductDescriptor_DeliverableParts());
    }

    public RealizedWorkProductDescriptor(WorkProductDescriptor wpd) {
        super((Descriptor)wpd);
    }

    @Override
    public boolean handleFeature(EStructuralFeature feature) {
        if (featureSet.contains(feature)) {
            return true;
        }
        return super.handleFeature(feature);
    }

    @Override
    protected MethodElement getRawLinkedElement() {
        return this.getWorkProductDescriptor().getWorkProduct();
    }

    private WorkProductDescriptor getWorkProductDescriptor() {
        return (WorkProductDescriptor)this.getElement();
    }

    public List<WorkProductDescriptor> getDeliverableParts() {
        if (!(this.getLinkedElement() instanceof Deliverable)) {
            return Collections.EMPTY_LIST;
        }
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference wpdReference = up.getWorkProductDescriptor_DeliverableParts();
        List<? extends Descriptor> wpdList = (List<? extends Descriptor>)this.getCachedValue((EStructuralFeature)wpdReference);
        if (wpdList == null) {
            EReference[] wpdFeatures = new EReference[]{wpdReference, up.getWorkProductDescriptor_DeliverablePartsExclude()};
            wpdList = this.getDescriptorList(up.getDeliverable_DeliveredWorkProducts(), wpdFeatures);
            this.storeCachedValue((EStructuralFeature)wpdReference, wpdList);
        }
        return wpdList;
    }

    public List<WorkProductDescriptor> getContainedArtifacts() {
        if (!(this.getLinkedElement() instanceof Artifact)) {
            return Collections.EMPTY_LIST;
        }
        UmaPackage up = UmaPackage.eINSTANCE;
        EReference wpdReference = ArtifactDescriptor_ContainedArtifacts;
        ArrayList<WorkProductDescriptor> wpdList = (ArrayList<WorkProductDescriptor>)this.getCachedValue((EStructuralFeature)wpdReference);
        if (wpdList == null) {
            Activity parentAct;
            wpdList = new ArrayList<WorkProductDescriptor>();
            ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.getConfig());
            List elementList = ConfigurationHelper.calc0nFeatureValue((MethodElement)this.getLinkedElement(), (EStructuralFeature)up.getArtifact_ContainedArtifacts(), realizer);
            if (elementList != null && !elementList.isEmpty() && (parentAct = this.getDescriptor().getSuperActivities()) != null) {
                for (MethodElement me : elementList) {
                    WorkProductDescriptor des = (WorkProductDescriptor)this.getMgr().getDescriptor(this.getDescriptor(), parentAct, me, wpdReference);
                    wpdList.add(des);
                }
            }
            this.storeCachedValue((EStructuralFeature)wpdReference, wpdList);
        }
        if (!PropUtil.getPropUtil().isExcludedFromPublish((MethodElement)this.getDescriptor())) {
            this.markWpdsReferenced(wpdList);
        }
        return wpdList;
    }

    @Override
    public Set<Descriptor> updateAndGetAllReferenced() {
        HashSet<Descriptor> referenced = new HashSet<Descriptor>();
        this.addToSet(referenced, this.getDeliverableParts());
        this.addToSet(referenced, this.getContainedArtifacts());
        Set<Descriptor> superSet = super.updateAndGetAllReferenced();
        referenced.addAll(superSet);
        return referenced;
    }

    @Override
    public Object getFeatureValue(EStructuralFeature feature) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (feature == up.getWorkProductDescriptor_DeliverableParts()) {
            return this.getDeliverableParts();
        }
        return super.getFeatureValue(feature);
    }
}

