/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.common.AbstractActivator;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.osgi.util.NLS;

public class LibraryModificationHelper {
    ActionManager actionMgr = null;

    public ActionManager getActionManager() {
        if (this.actionMgr != null) {
            return this.actionMgr;
        }
        this.actionMgr = new ActionManager(){

            public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
                if (LibraryModificationHelper.canUpdate(object)) {
                    return super.doAction(actionType, object, feature, value, index);
                }
                return false;
            }

            protected void save(Resource resource) {
            }
        };
        return this.actionMgr;
    }

    public void dispose() {
        if (this.actionMgr != null) {
            this.actionMgr.dispose();
            this.actionMgr = null;
        }
    }

    public static boolean canUpdate(EObject object) {
        return LibraryModificationHelper.canUpdate(object, null);
    }

    public static boolean canUpdate(EObject object, Object context) {
        IStatus status = TngUtil.checkEdit((EObject)object, (Object)context);
        if (status.isOK()) {
            return true;
        }
        String msg = NLS.bind((String)LibraryResources.LibraryModificationHelper_cannotUpdate, (Object)TngUtil.getTypeText((EObject)object), (Object)object.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name()));
        LibraryPlugin.getDefault().getMsgCallback().displayWarning((AbstractActivator)LibraryPlugin.getDefault(), LibraryResources.warningDlg_title, msg, TngUtil.getMessage((IStatus)status));
        return false;
    }

    public boolean isSaveNeeded() {
        return this.actionMgr != null && this.actionMgr.isSaveNeeded();
    }

    public void save() {
        if (this.actionMgr == null) {
            return;
        }
        try {
            Collection modifiedResources = this.actionMgr.getModifiedResources();
            ILibraryPersister.FailSafeMethodLibraryPersister persister = this.getPersister(modifiedResources);
            for (Resource resource : modifiedResources) {
                try {
                    persister.save(resource);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)LibraryResources.errorDlg_saveError, (Object)(resource.getURI().isFile() ? resource.getURI().toFileString() : resource.getURI().toString()));
                    LibraryPlugin.getDefault().getMsgCallback().displayError((AbstractActivator)LibraryPlugin.getDefault(), LibraryResources.errorDlg_title, msg, (Throwable)e);
                }
            }
            try {
                persister.commit();
                this.actionMgr.saveIsDone();
            }
            catch (Exception e) {
                try {
                    persister.rollback();
                }
                catch (Throwable throwable) {
                    try {
                        LibraryService.getInstance().reopenCurrentMethodLibrary();
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ILibraryPersister.FailSafeMethodLibraryPersister getPersister(Collection resources) {
        for (Resource resource : resources) {
            ILibraryPersister persister;
            ResourceSet resourceSet = resource.getResourceSet();
            if (!(resourceSet instanceof ILibraryResourceSet) || (persister = ((ILibraryResourceSet)resourceSet).getPersister()) == null) continue;
            return persister.getFailSafePersister();
        }
        return null;
    }

    public static class CheckActionManager
    extends ActionManager {
        private Object context;

        public CheckActionManager(Object context) {
            this.context = context;
        }

        public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
            if (LibraryModificationHelper.canUpdate(object, this.context)) {
                return super.doAction(actionType, object, feature, value, index);
            }
            return false;
        }
    }
}

