/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaPackage;

public class ContentResourceScanner {
    protected static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    private File sourceRootPath;
    private File targetRootPath;
    private String rootContentPath;
    private IContentValidator validator;
    private List processedItems = new ArrayList();

    public ContentResourceScanner(File sourceRootPath, File targetRootPath, String rootContentPath) {
        this(sourceRootPath, targetRootPath, rootContentPath, null);
    }

    public ContentResourceScanner(File sourceRootPath, File targetRootPath, String rootContentPath, IContentValidator validator) {
        this.sourceRootPath = sourceRootPath;
        this.targetRootPath = targetRootPath;
        this.rootContentPath = rootContentPath;
        this.validator = validator;
    }

    public void setValidator(IContentValidator validator) {
        this.validator = validator;
    }

    public File getSourceRootPath() {
        return this.sourceRootPath;
    }

    public File getTargetRootPath() {
        return this.targetRootPath;
    }

    public void setTargetRootPath(File targetRootPath) {
        this.targetRootPath = targetRootPath;
    }

    public void resolveResources(String content, String contentPath) {
        this.resolveResources(null, content, contentPath);
    }

    public void resolveResources(MethodElement owner, String content, String contentPath) {
        this.processedItems.clear();
        ResourceHelper.resolveResources(owner, null, content, contentPath, this.sourceRootPath, this.targetRootPath, this.rootContentPath, this.processedItems, this.validator);
    }

    public String resolveResourcesPlugin(String content, String contentPath, String oldContentPath) {
        StringBuffer sb = new StringBuffer();
        try {
            Matcher m = ResourceHelper.p_image_ref.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                url = this.processResourceUrlPlugin(url, contentPath, oldContentPath);
                m.appendReplacement(sb, String.valueOf(m.group(1)) + url + m.group(4));
            }
            m.appendTail(sb);
            content = sb.toString();
            sb = new StringBuffer();
            m = ResourceHelper.p_link_ref_gen.matcher(content);
            while (m.find()) {
                Matcher m2;
                StringBuffer sbLink = new StringBuffer();
                String urltext = " " + m.group(2) + " ";
                if (ResourceHelper.getGuidFromUrl(urltext) != null || !(m2 = ResourceHelper.p_link_href_picker.matcher(urltext)).find()) continue;
                String url = m2.group(1).trim().replaceAll("\"", "");
                url = this.processResourceUrlPlugin(url, contentPath, oldContentPath);
                m2.appendReplacement(sbLink, String.valueOf(urltext.substring(m2.start(), m2.start(1))) + url + urltext.substring(m2.end(1), m2.end()));
                m2.appendTail(sbLink);
                m.appendReplacement(sb, String.valueOf(content.substring(m.start(), m.start(2))) + sbLink.toString() + content.substring(m.end(2), m.end()));
            }
            m.appendTail(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private String processResourceUrlPlugin(String url, String contentPath, String oldContentPath) {
        String imageFile = ResourceHelper.getFilePathFromUrl(url, oldContentPath);
        if (imageFile == null) {
            return url;
        }
        String newUrl = null;
        File source = new File(this.sourceRootPath.getParentFile(), imageFile);
        if (imageFile.indexOf(File.separator) != -1) {
            String oldPlugin = imageFile.substring(0, imageFile.indexOf(File.separator));
            String newPlugin = this.targetRootPath.getName();
            newUrl = url.replaceFirst(oldPlugin, newPlugin);
            imageFile = imageFile.substring(imageFile.indexOf(File.separator));
        }
        File dest = new File(this.targetRootPath, imageFile);
        FileManager.copyFile((File)source, (File)dest);
        return newUrl;
    }

    public void copyResources(EObject element) {
        if (element == null) {
            return;
        }
        if (element instanceof DescribableElement) {
            ContentDescription desc;
            String path;
            DescribableElement de = (DescribableElement)element;
            String elementPath = ResourceHelper.getElementPath((MethodElement)de);
            URI icon = de.getShapeicon();
            if (icon != null) {
                path = icon.getPath();
                FileUtil.copyFile((File)new File(this.getSourceRootPath(), path), (File)new File(this.getTargetRootPath(), path));
            }
            if ((icon = de.getNodeicon()) != null) {
                path = icon.getPath();
                FileUtil.copyFile((File)new File(this.getSourceRootPath(), path), (File)new File(this.getTargetRootPath(), path));
            }
            if ((desc = de.getPresentation()).eContainer() != null) {
                List features = LibraryUtil.getStructuralFeatures((MethodElement)desc, true);
                int i = 0;
                while (i < features.size()) {
                    Object value;
                    EStructuralFeature feature = (EStructuralFeature)features.get(i);
                    if (feature instanceof EAttribute && (value = TypeDefUtil.getInstance().eGet((EObject)desc, feature)) != null) {
                        if (feature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
                            List sections = (List)value;
                            Iterator it = sections.iterator();
                            while (it.hasNext()) {
                                String text = ((Section)it.next()).getSectionDescription();
                                this.resolveResources((MethodElement)de, text, elementPath);
                            }
                        } else if (feature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
                            String urls = value.toString().trim();
                            if (urls.length() != 0) {
                                StringTokenizer st = new StringTokenizer(urls, "|");
                                while (st.hasMoreTokens()) {
                                    String url = st.nextToken();
                                    FileUtil.copyFile((File)new File(this.getSourceRootPath(), String.valueOf(elementPath) + url), (File)new File(this.getTargetRootPath(), String.valueOf(elementPath) + url));
                                }
                            }
                        } else if (value instanceof String) {
                            this.resolveResources((MethodElement)de, value.toString(), elementPath);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

