/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.RestartableJob;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryProblemMonitor
extends RestartableJob
implements ILibraryChangeListener {
    public static final String UnresolvedBasedPluginMARKER_ID = String.valueOf(LibraryPlugin.getDefault().getId()) + ".unresolvedBasePlugins";
    public static final String Name = "name";
    public static final String Guid = "guid";
    public static final String UnresolvedBaseGuids = "unresolvedBaseGuids";
    private long delay = 30000L;
    private long restartDelay = 1000L;
    private boolean hasChange = false;
    private Thread monitorThread;
    private boolean stopMonitor = false;
    private MethodLibrary library;
    private Map<MethodPlugin, IMarker> pluginMarkerMap = new HashMap<MethodPlugin, IMarker>();

    public LibraryProblemMonitor() {
        super(LibraryResources.libraryProblemMonitor);
        LibraryServiceListener libServiceListener = new LibraryServiceListener(){

            public void librarySet(MethodLibrary lib) {
                ILibraryManager libMgr;
                ILibraryService libService = LibraryService.getInstance();
                if (LibraryProblemMonitor.this.library != null && LibraryProblemMonitor.this.library != lib && (libMgr = libService.getLibraryManager(LibraryProblemMonitor.this.library)) != null) {
                    libMgr.removeListener(LibraryProblemMonitor.this);
                }
                if (lib != null && lib != LibraryProblemMonitor.this.library) {
                    libMgr = libService.getLibraryManager(lib);
                    if (libMgr != null) {
                        libMgr.addListener(LibraryProblemMonitor.this);
                    }
                    LibraryProblemMonitor.this.kickToRun();
                }
                LibraryProblemMonitor.this.library = lib;
            }
        };
        LibraryService.getInstance().addListener(libServiceListener);
        this.startMonitor();
    }

    public void startMonitor() {
        Runnable runnable = new Runnable(){

            public void run() {
                while (!LibraryProblemMonitor.this.stopMonitor) {
                    try {
                        Thread.sleep(LibraryProblemMonitor.this.delay);
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                        return;
                    }
                    if (!LibraryProblemMonitor.this.hasChange) continue;
                    LibraryProblemMonitor.this.hasChange = false;
                    LibraryProblemMonitor.this.guardedSchedule(0L);
                }
            }
        };
        this.stopMonitor = false;
        if (this.monitorThread == null) {
            this.monitorThread = new Thread(runnable);
        }
        this.monitorThread.start();
    }

    public void stopMonitor() {
        this.stopMonitor = true;
    }

    @Override
    public void libraryChanged(int option, Collection<Object> changedItems) {
        if (changedItems != null && changedItems.size() > 0) {
            this.hasChange = true;
            this.enableToRestart();
        }
    }

    private void update() throws RestartableJob.RestartInterruptException {
        MethodLibrary lib;
        if (localDebug) {
            System.out.println("LD> update");
        }
        if ((lib = this.getLibrary()) == null) {
            return;
        }
        this.checkRestartInterruptException(this.restartDelay);
        this.cleanUp();
        ArrayList plugins = new ArrayList();
        plugins.addAll(lib.getMethodPlugins());
        HashSet pluginSet = new HashSet(plugins);
        for (MethodPlugin plugin : plugins) {
            this.checkRestartInterruptException(this.restartDelay);
            List baseList = plugin.getBases();
            boolean missing = false;
            for (MethodPlugin base : baseList) {
                this.checkRestartInterruptException(this.restartDelay);
                if (pluginSet.contains(base)) continue;
                if (!missing) {
                    if (localDebug) {
                        System.out.println("LD> plugin: " + plugin);
                        System.out.println("LD> " + plugin.getName() + " references unresolved bases:");
                    }
                    missing = true;
                }
                if (localDebug) {
                    System.out.println("LD> base: " + base);
                }
                this.addMissingBasePluginError(plugin, base);
            }
            if (!missing) continue;
            System.out.println("");
        }
    }

    private void addMissingBasePluginError(MethodPlugin plugin, MethodPlugin base) {
        IMarker marker = this.pluginMarkerMap.get(plugin);
        if (marker == null) {
            Resource res = plugin.eResource();
            if (res == null) {
                return;
            }
            URI containerURI = res.getURI();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(containerURI.toFileString());
            IFile file = workspace.getRoot().getFileForLocation((IPath)path);
            if (file == null) {
                return;
            }
            String location = containerURI != null ? containerURI.toFileString() : "";
            try {
                marker = file.createMarker(UnresolvedBasedPluginMARKER_ID);
                marker.setAttribute("severity", 2);
                marker.setAttribute(Name, (Object)plugin.getName());
                marker.setAttribute(Guid, (Object)plugin.getGuid());
                marker.setAttribute("location", (Object)location);
                marker.setAttribute(Guid, (Object)plugin.getGuid());
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (!(status instanceof IResourceStatus) || ((IResourceStatus)status).getCode() != 368) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            if (marker == null) {
                return;
            }
            if (localDebug) {
                System.out.println("LD> marker: " + marker);
            }
            this.pluginMarkerMap.put(plugin, marker);
        }
        String unresolvedBaseGuidsValue = null;
        try {
            String errMsg = String.valueOf(plugin.getName()) + " " + LibraryResources.references_unresolved_base_txt;
            unresolvedBaseGuidsValue = (String)marker.getAttribute(UnresolvedBaseGuids);
            if (unresolvedBaseGuidsValue == null || unresolvedBaseGuidsValue.length() == 0) {
                unresolvedBaseGuidsValue = base.getGuid();
                errMsg = String.valueOf(errMsg) + ": ";
            } else if (unresolvedBaseGuidsValue.indexOf(base.getGuid()) < 0) {
                unresolvedBaseGuidsValue = String.valueOf(unresolvedBaseGuidsValue) + ", " + base.getGuid();
                errMsg = String.valueOf(errMsg) + "plugins: ";
            }
            errMsg = String.valueOf(errMsg) + unresolvedBaseGuidsValue;
            marker.setAttribute("message", (Object)errMsg);
            marker.setAttribute(UnresolvedBaseGuids, (Object)unresolvedBaseGuidsValue);
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected IStatus restartableRun(IProgressMonitor monitor) throws RestartableJob.RestartInterruptException {
        this.update();
        return Status.OK_STATUS;
    }

    protected void resetToRestart() {
        if (localDebug) {
            System.out.println("LD> resetToRestart");
        }
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.pluginMarkerMap.isEmpty()) {
            return;
        }
        for (IMarker marker : this.pluginMarkerMap.values()) {
            try {
                marker.delete();
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        this.pluginMarkerMap = new HashMap<MethodPlugin, IMarker>();
    }

    public void kickToRun() {
        if (localDebug) {
            System.out.println("LD> kickToRun");
        }
        this.enableToRestart();
        this.guardedSchedule(0L);
    }

    public void fixProblem(IMarker marker) {
        try {
            if (marker.getType() != UnresolvedBasedPluginMARKER_ID) {
                return;
            }
            MethodLibrary lib = this.getLibrary();
            if (lib == null) {
                return;
            }
            HashMap<String, MethodPlugin> guidToPluginMap = new HashMap<String, MethodPlugin>();
            for (MethodPlugin plugin : lib.getMethodPlugins()) {
                guidToPluginMap.put(plugin.getGuid(), plugin);
            }
            String guid = (String)marker.getAttribute(Guid);
            MethodPlugin plugin = (MethodPlugin)guidToPluginMap.get(guid);
            if (plugin == null || plugin.eResource() == null) {
                return;
            }
            if (localDebug) {
                System.out.println("LD> fixProblem, plugin: " + plugin);
            }
            ArrayList bases = new ArrayList();
            bases.addAll(plugin.getBases());
            boolean modified = false;
            for (MethodPlugin base : bases) {
                if (guidToPluginMap.containsKey(base.getGuid())) continue;
                modified = true;
                plugin.getBases().remove(base);
            }
            if (!modified) {
                return;
            }
            Resource resource = plugin.eResource();
            ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getPersisterFor(resource).getFailSafePersister();
            try {
                persister.save(resource);
                persister.commit();
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                persister.rollback();
            }
            this.kickToRun();
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void dispose() {
        this.stopMonitor();
        this.cleanUp();
    }

    public MethodLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(MethodLibrary library) {
        this.library = library;
    }
}

