/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.configuration.MethodConfigurationItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.MethodLibraryPropUtil;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.EProperty;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.IMeVisitor;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.QualifiedReference;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUtil {
    public static boolean PUBLISH_MODE = false;
    public static Comparator<EClass> typeComparator = new Comparator<EClass>(){

        @Override
        public int compare(EClass o1, EClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static List<EClass> includedElementTypes;
    private static final Collection<EClass> excludedTypes;
    private static Adapter nameTrackPresentationNameMark;

    static {
        excludedTypes = Arrays.asList(UmaPackage.eINSTANCE.getBreakdownElement(), UmaPackage.eINSTANCE.getCompositeRole(), UmaPackage.eINSTANCE.getDescribableElement(), UmaPackage.eINSTANCE.getDescriptor(), UmaPackage.eINSTANCE.getFulfillableElement(), UmaPackage.eINSTANCE.getKind(), UmaPackage.eINSTANCE.getProcessComponentDescriptor(), UmaPackage.eINSTANCE.getProcessComponentInterface(), UmaPackage.eINSTANCE.getProcessElement(), UmaPackage.eINSTANCE.getProcessPlanningTemplate(), UmaPackage.eINSTANCE.getRoleDescriptor(), UmaPackage.eINSTANCE.getTaskDescriptor(), UmaPackage.eINSTANCE.getTeamProfile(), UmaPackage.eINSTANCE.getWorkBreakdownElement(), UmaPackage.eINSTANCE.getWorkOrder(), UmaPackage.eINSTANCE.getWorkProductDescriptor());
        nameTrackPresentationNameMark = new AdapterImpl();
    }

    public static String checkPluginName(MethodPlugin plugin, String newName) {
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        return IValidatorFactory.INSTANCE.createValidator((EObject)lib, UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, null, null, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME).isValid(newName);
    }

    public static boolean selectable(EObject element) {
        return element instanceof MethodLibrary || element instanceof MethodPlugin || element instanceof MethodPackage;
    }

    public static EObject getSelectable(EObject element) {
        if (element instanceof BreakdownElement) {
            EObject pkg = element.eContainer();
            while (pkg != null && !(pkg instanceof ProcessComponent)) {
                pkg = pkg.eContainer();
            }
            return pkg;
        }
        EObject parent = element;
        while (parent != null && !LibraryUtil.selectable(parent)) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public static MethodPlugin getMethodPlugin(EObject element) {
        return UmaUtil.getMethodPlugin((EObject)element);
    }

    public static String getName(Object element) {
        if (element == null) {
            return LibraryResources.unknown_text;
        }
        if (element instanceof MethodElement) {
            return LibraryUtil.getFullName((MethodElement)element);
        }
        return element.toString();
    }

    public static String getFullName(MethodElement element) {
        if (LibraryUtil.selectable((EObject)element)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(element.getName()).append("]");
            MethodElement parent = element;
            while ((parent = (MethodElement)parent.eContainer()) != null) {
                if (parent instanceof MethodLibrary) break;
                buffer.insert(0, "[" + parent.getName() + "].");
            }
            return buffer.toString();
        }
        return element.getName();
    }

    public static String getLocalizeTypeName(MethodElement element) {
        if (element == null) {
            return "";
        }
        if (element instanceof DescribableElement) {
            String nameStr = String.valueOf(TngUtil.getTypeText((EObject)element)) + LibraryResources.colon_with_space;
            nameStr = ((DescribableElement)element).getPresentationName() != null ? String.valueOf(nameStr) + "(" + ((DescribableElement)element).getPresentationName() + ") " + ((DescribableElement)element).getName() : String.valueOf(nameStr) + element.getName();
            return nameStr;
        }
        return LibraryUtil.getTypeName(element);
    }

    public static String getTypeName(MethodElement element) {
        return element == null ? "" : String.valueOf(element.getType().getName()) + ":" + element.getName();
    }

    public static String getTypePath(MethodElement element) {
        return element == null ? "" : String.valueOf(element.getType().getName()) + ":" + TngUtil.getLabelWithPath((Object)element);
    }

    public static List<MethodPlugin> getMethodPlugins(MethodLibrary library) {
        return new ArrayList<MethodPlugin>(library.getMethodPlugins());
    }

    public static List getMethodPluginGuids(MethodLibrary library) {
        ArrayList<String> items = new ArrayList<String>();
        List elements = library.getMethodPlugins();
        if (elements != null) {
            for (MethodPlugin element : elements) {
                items.add(element.getGuid());
            }
        }
        return items;
    }

    public static MethodPlugin getMethodPlugin(MethodLibrary library, String pluginGuid) {
        if (pluginGuid == null) {
            return null;
        }
        List elements = library.getMethodPlugins();
        if (elements != null) {
            for (MethodPlugin element : elements) {
                if (!pluginGuid.equals(element.getGuid())) continue;
                return element;
            }
        }
        return null;
    }

    public static MethodPlugin getMethodPluginByName(MethodLibrary library, String name) {
        if (name == null) {
            return null;
        }
        List elements = library.getMethodPlugins();
        if (elements != null) {
            for (MethodPlugin element : elements) {
                if (!name.equals(element.getName())) continue;
                return element;
            }
        }
        return null;
    }

    public static List getMethodPackages(MethodElement element) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        TreeIterator it = element.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof MethodPackage)) continue;
            items.add(e);
        }
        return items;
    }

    public static Object unwrap(Object obj) {
        return TngUtil.unwrap((Object)obj);
    }

    public static Command unwrap(Command cmd) {
        return TngUtil.unwrap((Command)cmd);
    }

    public static void detachFromResource(MethodLibrary importLibraty) {
        ResourceSet resSet = null;
        Resource res = importLibraty.eResource();
        if (res != null) {
            resSet = res.getResourceSet();
        }
        if (resSet != null) {
            TreeIterator it = resSet.getAllContents();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof MultiResourceEObject)) continue;
                ((MultiResourceEObject)obj).eSetResource(null);
            }
        }
        LibraryUtil.clearProxies((EObject)importLibraty);
    }

    public static void clearProxies(EObject element) {
        if (element.eIsProxy()) {
            LibraryUtil.setProxyURI(element, null);
        } else {
            TreeIterator it = element.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!o.eIsProxy()) continue;
                LibraryUtil.setProxyURI(o, null);
            }
        }
    }

    public static void setProxyURI(EObject obj, URI uri) {
        ((InternalEObject)obj).eSetProxyURI(uri);
    }

    public static Collection<Resource> getLoadedResources(MethodLibrary lib, Collection<Resource> excludes) {
        HashSet<Resource> loadedres = new HashSet<Resource>();
        for (Resource res : lib.eResource().getResourceSet().getResources()) {
            if (!res.isLoaded() || excludes != null && excludes.contains(res)) continue;
            loadedres.add(res);
        }
        return loadedres;
    }

    public static Collection<Resource> loadAll(MethodLibrary lib) {
        return LibraryUtil.loadAll(lib, null, false);
    }

    public static Collection<Resource> loadAll(MethodLibrary lib, boolean skipContent) {
        return LibraryUtil.loadAll(lib, null, skipContent);
    }

    public static Collection<Resource> loadAll(MethodLibrary lib, MethodConfiguration config) {
        return LibraryUtil.loadAll(lib, config, true);
    }

    public static Collection<Resource> loadAll(MethodLibrary lib, MethodConfiguration config, boolean skipContent) {
        if (lib == null) {
            lib = LibraryService.getInstance().getCurrentMethodLibrary();
        }
        Collection<Resource> loadedres = LibraryUtil.getLoadedResources(lib, null);
        MeVisitor meVisitor = new MeVisitor();
        if (config == null) {
            if (skipContent) {
                LibraryUtil.loadAllSkipContents(lib, meVisitor);
            } else {
                LibraryUtil.loadAllContained((MethodElement)lib);
            }
        } else {
            LibraryUtil.loadAllPlugins(config, meVisitor);
        }
        meVisitor.processElements();
        return LibraryUtil.getLoadedResources(lib, loadedres);
    }

    public static void loadAllContained(MethodElement me) {
        TreeIterator iter = me.eAllContents();
        while (iter.hasNext()) {
            try {
                EObject element = (EObject)iter.next();
                Iterator iterator = element.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public static void loadAllSkipContents(MethodLibrary lib) {
        MeVisitor meVisitor = new MeVisitor();
        LibraryUtil.loadAllSkipContents(lib, meVisitor);
        meVisitor.processElements();
    }

    public static void loadAllSkipContents(MethodLibrary lib, IMeVisitor vistor) {
        List pluigns = lib.getMethodPlugins();
        HashSet<MethodElement> processed = new HashSet<MethodElement>();
        for (MethodPlugin plugin : pluigns) {
            LibraryUtil.loadImmidiateChildren((MethodElement)plugin, true, processed, vistor);
        }
    }

    public static void loadAllPlugins(MethodConfiguration config) {
        MeVisitor meVisitor = new MeVisitor();
        LibraryUtil.loadAllPlugins(config, meVisitor);
        meVisitor.processElements();
    }

    public static void loadAllPlugins(MethodConfiguration config, IMeVisitor vistor) {
        boolean skipContent = true;
        List pluigns = config.getMethodPluginSelection();
        LibraryUtil.loadPlugins(vistor, skipContent, pluigns);
    }

    private static void loadPlugins(IMeVisitor vistor, boolean skipContent, Collection<MethodPlugin> pluigns) {
        HashSet<MethodElement> processed = new HashSet<MethodElement>();
        for (MethodPlugin plugin : pluigns) {
            if (skipContent) {
                LibraryUtil.loadImmidiateChildren((MethodElement)plugin, true, processed, vistor);
                continue;
            }
            LibraryUtil.loadAllContained((MethodElement)plugin);
        }
    }

    public static void loadPlugins(Collection<MethodPlugin> pluigns) {
        MeVisitor meVisitor = new MeVisitor();
        LibraryUtil.loadPlugins(meVisitor, true, pluigns);
        meVisitor.processElements();
    }

    private static void loadImmidiateChildren(MethodElement me, boolean skipContent, Set<MethodElement> processed, IMeVisitor vistor) {
        if (processed.contains(me)) {
            return;
        }
        if (vistor != null) {
            vistor.visit(me);
        }
        processed.add(me);
        EList refList = me.eClass().getEAllReferences();
        if (refList == null || refList.isEmpty()) {
            return;
        }
        for (EReference ref : refList) {
            if (skipContent && LibraryUtil.isContentRef(ref)) continue;
            Object obj = me.eGet((EStructuralFeature)ref);
            if (obj instanceof MethodElement) {
                LibraryUtil.loadImmidiateChildren((MethodElement)obj, skipContent, processed, vistor);
                continue;
            }
            if (!(obj instanceof List)) continue;
            List list = (List)obj;
            for (Object itemObj : list) {
                if (!(itemObj instanceof MethodElement)) continue;
                LibraryUtil.loadImmidiateChildren((MethodElement)itemObj, skipContent, processed, vistor);
            }
        }
    }

    public static boolean isContentRef(EReference ref) {
        if (ref == UmaPackage.eINSTANCE.getDescribableElement_Presentation()) {
            return true;
        }
        if (ref == UmaPackage.eINSTANCE.getTask_Steps()) {
            return true;
        }
        return ref == UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps();
    }

    public static void loadAllProcesses(MethodLibrary lib) {
        Iterator iter = lib.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            try {
                MethodPlugin plugin = (MethodPlugin)iter.next();
                TngUtil.getAllProcesses((MethodPlugin)plugin);
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().log(e);
            }
        }
    }

    public static void saveAll(MethodLibrary lib) throws Exception {
        LibraryUtil.saveLibrary(lib, true, false);
    }

    public static void saveLibrary(MethodLibrary lib, boolean saveAll, boolean refresh) throws Exception {
        ILibraryResourceSet libResourceSet = (ILibraryResourceSet)lib.eResource().getResourceSet();
        if (libResourceSet instanceof MultiFileResourceSetImpl) {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)libResourceSet;
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            HashMap<String, String> saveOptions = manager != null ? manager.getSaveOptions() : new HashMap<String, String>();
            Object old = saveOptions.get("REFRESH_NEW_RESOURCE");
            Object oldCheckModify = saveOptions.get("CHECK_MODIFY");
            try {
                saveOptions.put("REFRESH_NEW_RESOURCE", refresh ? "true" : "false");
                saveOptions.put("CHECK_MODIFY", "false");
                resourceSet.save(saveOptions, saveAll);
            }
            finally {
                saveOptions.put("REFRESH_NEW_RESOURCE", (String)old);
                saveOptions.put("CHECK_MODIFY", (String)oldCheckModify);
            }
        } else {
            libResourceSet.save(Collections.EMPTY_MAP);
        }
    }

    public static MethodLibrary loadLibrary(String libraryPath) throws Exception {
        ILibraryResourceSet resourceSet = PersistenceService.INSTANCE.createResourceSet("xmi");
        resourceSet.loadMethodLibraries(URI.createFileURI((String)libraryPath), Collections.EMPTY_MAP);
        return resourceSet.getFirstMethodLibrary();
    }

    public static File getLibraryRootPath(MethodLibrary lib) {
        Resource res = lib.eResource();
        if (res == null) {
            return null;
        }
        URI uri = res.getURI();
        String path = uri.toFileString();
        File f = new File(path);
        return f.getParentFile();
    }

    public static List getAllPackages(MethodPlugin plugin) {
        ArrayList allPkgs = new ArrayList();
        List pkgs = plugin.getMethodPackages();
        allPkgs.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), allPkgs);
        }
        return allPkgs;
    }

    public static void getAllChildPackages(MethodPackage pkg, List result) {
        List pkgs = pkg.getChildPackages();
        result.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), result);
        }
    }

    public static List<MethodConfiguration> getAssociatedConfigurations(MethodPlugin plugin) {
        HashSet<MethodConfiguration> allConfigs = new HashSet<MethodConfiguration>();
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)plugin);
        List procs = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process p : procs) {
            MethodConfiguration c = p.getDefaultContext();
            if (c != null && !(c instanceof Scope)) {
                allConfigs.add(c);
                allConfigs.addAll(p.getValidContext());
                continue;
            }
            if (lib == null) continue;
            for (MethodConfiguration config : lib.getPredefinedConfigurations()) {
                if (!ConfigurationHelper.inConfig((MethodElement)p, config)) continue;
                allConfigs.add(config);
            }
        }
        return new ArrayList<MethodConfiguration>(allConfigs);
    }

    private static void addUniqueItems(List from, List to) {
        if (from == null || to == null || from.size() == 0) {
            return;
        }
        for (Object o : from) {
            if (to.contains(o)) continue;
            to.add(o);
        }
    }

    public static void validateMethodConfiguration(IActionManager actionMgr, MethodConfiguration config) {
        TngUtil.validateMethodConfiguration((IActionManager)actionMgr, (MethodConfiguration)config);
    }

    public static void validateMethodConfiguration(MethodConfiguration config) {
        LibraryUtil.validateMethodConfiguration(null, config);
    }

    public static SupportingMaterial getCopyright(MethodElement element) {
        MethodPlugin p;
        SupportingMaterial sm = null;
        if (element instanceof MethodUnit) {
            sm = ((MethodUnit)element).getCopyrightStatement();
        } else if (element instanceof DescribableElement) {
            sm = ((DescribableElement)element).getPresentation().getCopyrightStatement();
        }
        if (sm == null && (p = LibraryUtil.getMethodPlugin((EObject)element)) != null) {
            sm = p.getCopyrightStatement();
        }
        return sm;
    }

    public static Collection getContainedElements(Object container, Collection elements) {
        if (container instanceof TransientGroupItemProvider) {
            container = ((TransientGroupItemProvider)container).getTarget();
        }
        ArrayList contained = new ArrayList();
        for (Object element : elements) {
            if (!(element instanceof EObject) || !UmaUtil.isContainedBy((EObject)((EObject)element), (Object)container)) continue;
            contained.add(element);
        }
        return contained;
    }

    public static boolean isIdentical(MethodElement oldObj, MethodElement newObj) {
        if (oldObj == null && newObj == null) {
            return true;
        }
        if (oldObj == null || newObj == null) {
            return false;
        }
        List features = LibraryUtil.getStructuralFeatures(oldObj);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                Object oldValue = oldObj.eGet(feature);
                Object newValue = newObj.eGet(feature);
                if (oldValue != null || newValue != null) {
                    if (oldValue == null || newValue == null) {
                        return false;
                    }
                    if (oldValue instanceof MethodElement) {
                        MethodElement olde = (MethodElement)oldValue;
                        if (olde.eContainer() == oldObj ? !LibraryUtil.isIdentical(olde, (MethodElement)newValue) : oldValue != newValue) {
                            return false;
                        }
                    } else if (oldValue instanceof List) {
                        List oldl = (List)oldValue;
                        List newl = (List)newValue;
                        if (oldl.size() != newl.size()) {
                            return false;
                        }
                        int x = 0;
                        while (x < oldl.size()) {
                            MethodElement olde;
                            Object o = oldl.get(x);
                            Object n = newl.get(x);
                            if (o instanceof MethodElement ? ((olde = (MethodElement)o).eContainer() == oldObj ? !LibraryUtil.isIdentical(olde, (MethodElement)n) : oldValue != newValue) : !o.equals(n)) {
                                return false;
                            }
                            ++x;
                        }
                    } else if (!oldValue.equals(newValue)) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isProcess(EObject e) {
        return e instanceof Process && e.eContainer() instanceof ProcessComponent;
    }

    public static List getValidViews(MethodConfiguration config) {
        ArrayList<ContentCategory> views = new ArrayList<ContentCategory>();
        for (ContentCategory view : config.getProcessViews()) {
            if (ConfigurationHelper.isContributor((VariabilityElement)view) || (view = (ContentCategory)ConfigurationHelper.getCalculatedElement((MethodElement)view, config)) == null || views.contains(view)) continue;
            views.add(view);
        }
        return views;
    }

    public static List getStructuralFeatures(MethodElement element, boolean addExtended) {
        Practice practice;
        PracticePropUtil practicePropUtil;
        UserDefinedTypeMeta meta;
        List list = LibraryUtil.getStructuralFeatures(element);
        if (!addExtended) {
            return list;
        }
        if (element instanceof Practice && (meta = (practicePropUtil = PracticePropUtil.getPracticePropUtil()).getUdtMeta(practice = (Practice)element)) != null && !meta.getQualifiedReferences().isEmpty()) {
            list.addAll(meta.getQualifiedReferences());
        }
        PropUtil propUtil = PropUtil.getPropUtil();
        list.add(UmaUtil.MethodElement_UdtList);
        ModifiedTypeMeta meta2 = propUtil.getGlobalMdtMeta(element);
        if (meta2 != null) {
            for (ExtendedReference eRef : meta2.getReferences()) {
                list.add(eRef.getReference());
                for (QualifiedReference qRef : eRef.getQualifiedReferences()) {
                    list.add(qRef.getReference());
                }
            }
        }
        if (!(element instanceof ContentDescription)) {
            return list;
        }
        EObject owner = element.eContainer();
        if (!(owner instanceof MethodElement)) {
            return list;
        }
        meta2 = propUtil.getGlobalMdtMeta((MethodElement)owner);
        if (meta2 == null) {
            return list;
        }
        for (ExtendedAttribute eAtt : meta2.getRtes()) {
            list.add(eAtt.getAttribute());
        }
        for (ExtendedAttribute eAtt : meta2.getAttributes()) {
            list.add(eAtt.getAttribute());
        }
        return list;
    }

    public static List getStructuralFeatures(MethodElement element) {
        List properties = element.getInstanceProperties();
        if (properties != null) {
            ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
            int i = 0;
            while (i < properties.size()) {
                EProperty property = (EProperty)properties.get(i);
                if (property != null) {
                    EStructuralFeature feature = property.getEStructuralFeature();
                    features.add(feature);
                }
                ++i;
            }
            return features;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<EClass> getIncludedElementTypes() {
        if (includedElementTypes != null) return includedElementTypes;
        Class<LibraryUtil> clazz = LibraryUtil.class;
        synchronized (LibraryUtil.class) {
            if (includedElementTypes != null) return includedElementTypes;
            includedElementTypes = new ArrayList<EClass>();
            for (EClassifier cls : UmaPackage.eINSTANCE.getEClassifiers()) {
                if (!(cls instanceof EClass) || !UmaPackage.eINSTANCE.getDescribableElement().isSuperTypeOf((EClass)cls)) continue;
                includedElementTypes.add((EClass)cls);
            }
            includedElementTypes.removeAll(excludedTypes);
            Collections.sort(includedElementTypes, typeComparator);
            includedElementTypes = Collections.unmodifiableList(includedElementTypes);
            // ** MonitorExit[var0] (shouldn't be in output)
            return includedElementTypes;
        }
    }

    public static List<DescribableElement> getIncludedElements(CustomCategory category, MethodConfiguration config) {
        ArrayList<DescribableElement> includedElements = new ArrayList<DescribableElement>();
        if (config == null) {
            return includedElements;
        }
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)category, (String)"include");
        EClassifier cls = prop == null ? null : UmaPackage.eINSTANCE.getEClassifier(prop.getValue());
        String udtId = null;
        if (cls == null && prop != null && LibraryUtil.isUdtTypeId(prop.getValue())) {
            udtId = UserDefinedTypeMeta.getPracticeUdtId((String)prop.getValue());
            cls = UmaPackage.eINSTANCE.getPractice();
        }
        if (cls instanceof EClass) {
            EClass eClass = (EClass)cls;
            if (UmaPackage.eINSTANCE.getDescribableElement().isSuperTypeOf(eClass)) {
                MethodLibrary lib = (MethodLibrary)config.eContainer();
                for (DescribableElement element : LibraryEditUtil.getInstance().getTypedElements((MethodElement)lib, eClass)) {
                    boolean toAdd = true;
                    if (udtId != null) {
                        UserDefinedTypeMeta meta;
                        toAdd = false;
                        if (element instanceof Practice && (meta = PracticePropUtil.getPracticePropUtil().getUdtMeta((Practice)element)) != null && meta.getId().equals(udtId)) {
                            toAdd = true;
                        }
                    } else if (eClass == UmaPackage.eINSTANCE.getPractice() && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)element)) {
                        toAdd = false;
                    }
                    if (!toAdd) continue;
                    includedElements.add(element);
                }
            }
        }
        return includedElements;
    }

    public static void addNameTrackPresentationNameMark(MethodElement element) {
        element.eAdapters().add((Object)nameTrackPresentationNameMark);
    }

    public static void removeNameTrackPresentationNameMark(MethodElement element) {
        element.eAdapters().remove((Object)nameTrackPresentationNameMark);
    }

    public static boolean hasNameTrackPresentationNameMark(MethodElement element) {
        for (Adapter adpter : element.eAdapters()) {
            if (adpter != nameTrackPresentationNameMark) continue;
            return true;
        }
        return false;
    }

    public static boolean markLibrarySynFree(MethodLibrary lib, boolean toSave) {
        boolean b = LibraryUtil.markLibrarySynFree(lib, toSave, true);
        return b;
    }

    public static boolean markLibrarySynFree(MethodLibrary lib, boolean toSave, boolean synFreeValue) {
        if (lib == null) {
            return true;
        }
        MethodLibraryPropUtil propUtil = MethodLibraryPropUtil.getMethodLibraryPropUtil();
        if (propUtil.isSynFree(lib) == synFreeValue) {
            return true;
        }
        List plugins = lib.getMethodPlugins();
        final ArrayList<Resource> resourcesToSave = new ArrayList<Resource>();
        if (toSave) {
            MethodPluginPropUtil pluginPropUtil = MethodPluginPropUtil.getMethodPluginPropUtil();
            int i = 0;
            while (i < plugins.size()) {
                Resource res;
                MethodPlugin plugin = (MethodPlugin)plugins.get(i);
                if (pluginPropUtil.isSynFree(plugin) != synFreeValue && (res = plugin.eResource()) != null) {
                    resourcesToSave.add(res);
                }
                ++i;
            }
            resourcesToSave.add(lib.eResource());
            if (!LibraryUtil.checkModify(resourcesToSave)) {
                return false;
            }
        }
        propUtil.setSynFree(lib, synFreeValue);
        int i = 0;
        while (i < plugins.size()) {
            LibraryUtil.markPluginSynFree((MethodPlugin)plugins.get(i), true, synFreeValue);
            ++i;
        }
        if (toSave) {
            SafeUpdateController.syncExec(new Runnable(){

                public void run() {
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                    try {
                        for (Resource res : resourcesToSave) {
                            persister.save(res);
                        }
                        persister.commit();
                    }
                    catch (Exception e) {
                        persister.rollback();
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
            });
        }
        return true;
    }

    public static boolean markPluginSynFree(MethodPlugin plugin, boolean toSave) {
        return LibraryUtil.markPluginSynFree(plugin, toSave, true);
    }

    public static boolean markPluginSynFree(final MethodPlugin plugin, boolean toSave, boolean synFreeValue) {
        if (plugin == null) {
            return true;
        }
        MethodPluginPropUtil propUtil = MethodPluginPropUtil.getMethodPluginPropUtil();
        if (propUtil.isSynFree(plugin) == synFreeValue) {
            return true;
        }
        if (toSave && plugin.eResource() != null) {
            ArrayList<Resource> resourcesToSave = new ArrayList<Resource>();
            resourcesToSave.add(plugin.eResource());
            if (!LibraryUtil.checkModify(resourcesToSave)) {
                return false;
            }
        }
        propUtil.setSynFree(plugin, synFreeValue);
        if (toSave && plugin.eResource() != null) {
            SafeUpdateController.syncExec(new Runnable(){

                public void run() {
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                    try {
                        persister.save(plugin.eResource());
                        persister.commit();
                    }
                    catch (Exception e) {
                        persister.rollback();
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
            });
        }
        return true;
    }

    private static boolean checkModify(List<Resource> resourcesToSave) {
        IStatus status = UserInteractionHelper.checkModify(resourcesToSave, (Object)Display.getCurrent().getActiveShell());
        return status.isOK();
    }

    public static List<Practice> getPractices(MethodConfiguration config) {
        boolean oldValue = MethodConfigurationItemProvider.isFinalOnGetChildrenCall();
        MethodConfigurationItemProvider.setFinalOnGetChildrenCall((boolean)true);
        List<Practice> list = null;
        try {
            list = LibraryUtil.getPractices_(config);
        }
        finally {
            MethodConfigurationItemProvider.setFinalOnGetChildrenCall((boolean)oldValue);
        }
        return list;
    }

    private static List<Practice> getPractices_(MethodConfiguration config) {
        ArrayList<Practice> practiceList = new ArrayList<Practice>();
        if (config == null) {
            return practiceList;
        }
        HashSet<Practice> practiceSet = new HashSet<Practice>();
        ConfigurationFilter filter = new ConfigurationFilter(config);
        AdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)filter);
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)config, ITreeItemContentProvider.class);
        GuidanceGroupingItemProvider guidanceGroupingItemProvider = null;
        for (Object child : adapter.getChildren((Object)config)) {
            if (!(child instanceof GuidanceGroupingItemProvider)) continue;
            guidanceGroupingItemProvider = (GuidanceGroupingItemProvider)child;
            break;
        }
        if (guidanceGroupingItemProvider != null) {
            GuidanceItemProvider practicesItemProvider = null;
            Collection children = guidanceGroupingItemProvider.getChildren(guidanceGroupingItemProvider);
            for (Object child : children) {
                GuidanceItemProvider ip;
                if (!(child instanceof GuidanceItemProvider) || (ip = (GuidanceItemProvider)child).getGuidanceFilter() != GuidanceGroupingItemProvider.practiceFilter) continue;
                practicesItemProvider = ip;
                break;
            }
            if (practicesItemProvider != null) {
                children = practicesItemProvider.getChildren(practicesItemProvider);
                for (Object child : children) {
                    if (!(child instanceof Practice) || practiceSet.contains(child)) continue;
                    Practice p = (Practice)child;
                    practiceList.add(p);
                    practiceSet.add(p);
                }
            }
        }
        return practiceList;
    }

    private static CustomCategory createCustomCategory(MethodPlugin plugin, CustomCategory parent, String name) {
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        CustomCategory cc = UmaFactory.eINSTANCE.createCustomCategory();
        pkg.getContentElements().add(cc);
        if (parent != null) {
            parent.getCategorizedElements().add(cc);
        } else {
            TngUtil.getRootCustomCategory((MethodPlugin)plugin).getCategorizedElements().add(cc);
        }
        cc.setName(name);
        cc.setPresentationName(name);
        cc.setGuid(EcoreUtil.generateUUID());
        return cc;
    }

    public static ConfigAndPlugin addTempConfigAndPluginToCurrentLibrary(List<Process> configFreeProcesses) {
        if (configFreeProcesses == null || configFreeProcesses.isEmpty()) {
            return null;
        }
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib == null) {
            return null;
        }
        MethodElementPropUtil proppUtil = MethodElementPropUtil.getMethodElementPropUtil();
        ConfigAndPlugin tempConfigAndPlugin = new ConfigAndPlugin();
        MethodConfiguration tempConfig = UmaFactory.eINSTANCE.createMethodConfiguration();
        tempConfig.setName("Generated_Configuration");
        MethodPlugin tempPlugin = null;
        CustomCategory defaultView = null;
        proppUtil.setTransientElement((MethodElement)tempConfig, true);
        try {
            tempPlugin = LibraryServiceUtil.createMethodPlugin("viewPlugin", null, null, null);
            proppUtil.setTransientElement((MethodElement)tempPlugin, true);
            tempConfigAndPlugin.plugin = tempPlugin;
            defaultView = LibraryUtil.createCustomCategory(tempPlugin, null, LibraryResources.configFreeProcessView_title);
            proppUtil.setTransientElement((MethodElement)defaultView, true);
            tempConfig.getMethodPluginSelection().add(tempPlugin);
            tempConfig.getMethodPackageSelection().addAll(UmaUtil.getAllMethodPackages((MethodPlugin)tempPlugin));
            tempConfig.getProcessViews().add(defaultView);
            tempConfig.setDefaultView((ContentCategory)defaultView);
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
        HashSet<Task> taskSet = new HashSet<Task>();
        HashSet<Role> roleSet = new HashSet<Role>();
        HashSet<WorkProduct> wpSet = new HashSet<WorkProduct>();
        HashSet<Guidance> guidanceSet = new HashSet<Guidance>();
        HashSet<MethodPlugin> addedPlugins = new HashSet<MethodPlugin>();
        for (Process proc : configFreeProcesses) {
            Scope scope = ProcessScopeUtil.getInstance().loadScope(proc);
            if (scope == null) continue;
            for (MethodPlugin plugin : scope.getMethodPluginSelection()) {
                if (addedPlugins.contains(plugin)) continue;
                addedPlugins.add(plugin);
                tempConfig.getMethodPluginSelection().add(plugin);
                tempConfig.getMethodPackageSelection().addAll(UmaUtil.getAllMethodPackages((MethodPlugin)plugin));
                TreeIterator it = plugin.eAllContents();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof Task) {
                        taskSet.add((Task)obj);
                        continue;
                    }
                    if (obj instanceof Role) {
                        roleSet.add((Role)obj);
                        continue;
                    }
                    if (obj instanceof WorkProduct) {
                        wpSet.add((WorkProduct)obj);
                        continue;
                    }
                    if (!(obj instanceof Guidance)) continue;
                    guidanceSet.add((Guidance)obj);
                }
            }
        }
        LibraryUtil.createSubGroup(tempPlugin, defaultView, taskSet, LibraryEditPlugin.INSTANCE.getString("_UI_Tasks_group"));
        LibraryUtil.createSubGroup(tempPlugin, defaultView, roleSet, LibraryEditPlugin.INSTANCE.getString("_UI_Roles_group"));
        LibraryUtil.createSubGroup(tempPlugin, defaultView, wpSet, LibraryEditPlugin.INSTANCE.getString("_UI_WorkProducts_group"));
        LibraryUtil.createSubGroup(tempPlugin, defaultView, guidanceSet, LibraryEditPlugin.INSTANCE.getString("_UI_Guidances_group"));
        LibraryUtil.createSubGroup(tempPlugin, defaultView, configFreeProcesses, LibraryEditPlugin.INSTANCE.getString("_UI_Processes_group"));
        boolean oldDeliver = lib.eDeliver();
        lib.eSetDeliver(false);
        try {
            lib.getPredefinedConfigurations().add(tempConfig);
        }
        finally {
            if (oldDeliver) {
                lib.eSetDeliver(oldDeliver);
            }
        }
        LibraryService.getInstance().getConfigurationManager(tempConfig);
        tempConfigAndPlugin.config = tempConfig;
        tempConfigAndPlugin.plugin = null;
        return tempConfigAndPlugin;
    }

    private static void createSubGroup(MethodPlugin tempPlugin, CustomCategory defaultView, Collection<? extends DescribableElement> elements, String name) {
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        if (elements != null && !elements.isEmpty()) {
            CustomCategory cc = LibraryUtil.createCustomCategory(tempPlugin, defaultView, name);
            propUtil.setTransientElement((MethodElement)cc, true);
            cc.setBriefDescription(LibraryResources.systemCreatedCustomCategory_brief);
            cc.getCategorizedElements().addAll(elements);
        }
    }

    public static void removeTempConfigAndPluginFromCurrentLibrary(ConfigAndPlugin tempConfigAndPlugin) {
        if (tempConfigAndPlugin == null) {
            return;
        }
        MethodConfiguration tempConfig = tempConfigAndPlugin.config;
        MethodPlugin tempPlugin = tempConfigAndPlugin.plugin;
        if (tempConfig == null && tempPlugin == null) {
            return;
        }
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib != null) {
            boolean oldDeliver = lib.eDeliver();
            lib.eSetDeliver(false);
            try {
                lib.getPredefinedConfigurations().remove(tempConfig);
                lib.getMethodPlugins().remove(tempPlugin);
            }
            finally {
                if (oldDeliver) {
                    lib.eSetDeliver(oldDeliver);
                }
            }
        }
        LibraryService.getInstance().removeConfigurationManager(tempConfig);
    }

    public static List<EReference> getGuidancesRefList(MethodElement element) {
        ArrayList<EReference> list = new ArrayList<EReference>();
        if (element != null) {
            for (EReference ref : element.eClass().getEAllReferences()) {
                if (!LibraryEditUtil.getInstance().isGuidanceListReference(ref)) continue;
                list.add(ref);
            }
        }
        return list;
    }

    public static List<? extends Guidance> getGuidances(MethodElement element, MethodConfiguration config) {
        ElementRealizer realizer = config == null ? null : DefaultElementRealizer.newElementRealizer(config);
        ArrayList<Guidance> guidanceList = new ArrayList<Guidance>();
        HashSet<Guidance> seen = new HashSet<Guidance>();
        for (EReference ref : LibraryUtil.getGuidancesRefList(element)) {
            List valueList;
            List list = valueList = realizer == null ? (List)element.eGet((EStructuralFeature)ref) : ConfigurationHelper.calc0nFeatureValue(element, (EStructuralFeature)ref, realizer);
            if (valueList == null || valueList.isEmpty()) continue;
            for (Guidance g : valueList) {
                if (seen.contains(g)) continue;
                seen.add(g);
                guidanceList.add(g);
            }
        }
        return guidanceList;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (ConfigurationHelper.serverMode) {
            return null;
        }
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                final IWorkbenchWindow[] windows = new IWorkbenchWindow[1];
                SafeUpdateController.syncExec(new Runnable(){

                    public void run() {
                        windows[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    }
                });
                window = windows[0];
            }
            return window;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isUdtTypeId(String typeId) {
        ILibraryManager mgr = LibraryService.getInstance().getCurrentLibraryManager();
        return LibraryUtil.isUdtTypeId(typeId, mgr);
    }

    private static boolean isUdtTypeId(String typeId, ILibraryManager mgr) {
        if (mgr == null) {
            return false;
        }
        String id = UserDefinedTypeMeta.getPracticeUdtId((String)typeId);
        return mgr.getUserDefineType(id) != null;
    }

    public static boolean isUnderSupporting(MethodElement element) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
        if (plugin == null) {
            return false;
        }
        if (plugin.isSupporting()) {
            return true;
        }
        EObject parent = LibraryUtil.getSelectable((EObject)element);
        if (parent instanceof ContentPackage) {
            MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
            return propUtil.isSupporting((ContentPackage)parent);
        }
        return false;
    }

    public static List<UserDefinedTypeMeta> getAllUDTMetas() {
        ArrayList<UserDefinedTypeMeta> result = new ArrayList<UserDefinedTypeMeta>();
        ILibraryManager libMgr = LibraryService.getInstance().getCurrentLibraryManager();
        if (libMgr != null) {
            Collection<UserDefinedTypeMeta> metas = libMgr.getUserDefinedTypes();
            if (metas != null) {
                result.addAll(metas);
            }
            Collections.sort(result, new UdtMetaComparator());
        }
        return result;
    }

    public static UserDefinedTypeMeta getUDTMetaFromId(String id) {
        List<UserDefinedTypeMeta> metas = LibraryUtil.getAllUDTMetas();
        for (UserDefinedTypeMeta meta : metas) {
            String metaId = (String)meta.getRteNameMap().get("typeId");
            if (!id.equals(metaId)) continue;
            return meta;
        }
        return null;
    }

    public static class ConfigAndPlugin {
        public MethodConfiguration config;
        public MethodPlugin plugin;
    }

    public static class MeVisitor
    implements IMeVisitor {
        private Set<MethodElement> elementsToProcess = new HashSet<MethodElement>();

        public void visit(MethodElement element) {
            PracticePropUtil practicePropUtil;
            UserDefinedTypeMeta meta;
            PropUtil propUtil = PropUtil.getPropUtil();
            if (element instanceof WorkProductDescriptor) {
                boolean b = DescriptorPropUtil.getDesciptorPropUtil().isCreatedByReference((Descriptor)((WorkProductDescriptor)element));
                propUtil.setExcludedFromPublish(element, b);
            }
            if (propUtil.getGlobalMdtMeta(element) != null) {
                this.elementsToProcess.add(element);
            } else if (propUtil.hasReferences(element)) {
                this.elementsToProcess.add(element);
            } else if (element instanceof Practice && (meta = (practicePropUtil = PracticePropUtil.getPracticePropUtil()).getUdtMeta((Practice)element)) != null && !meta.getQualifiedReferences().isEmpty()) {
                this.elementsToProcess.add(element);
            }
        }

        public void processElements() {
            PropUtil propUtil = PropUtil.getPropUtil();
            for (MethodElement element : this.elementsToProcess) {
                PracticePropUtil practicePropUtil;
                UserDefinedTypeMeta meta;
                ModifiedTypeMeta modifiedTypeMeta = propUtil.getGlobalMdtMeta(element);
                if (modifiedTypeMeta != null) {
                    for (ExtendedReference eRef : modifiedTypeMeta.getReferences()) {
                        propUtil.getExtendedReferenceList(element, eRef, false);
                        for (QualifiedReference qRef : eRef.getQualifiedReferences()) {
                            propUtil.getExtendedReferenceList(element, (ExtendedReference)qRef, false);
                        }
                    }
                }
                if (propUtil.hasReferences(element)) {
                    propUtil.getUdtList(element, false);
                    ModifiedTypeMeta meta2 = propUtil.getGlobalMdtMeta(element);
                    if (meta2 != null) {
                        QualifiedReference qRef;
                        qRef = meta2.getReferences().iterator();
                        while (qRef.hasNext()) {
                            ExtendedReference ref = (ExtendedReference)qRef.next();
                            propUtil.getExtendedReferenceList(element, ref, false);
                            for (ExtendedReference qref : ref.getQualifiedReferences()) {
                                propUtil.getExtendedReferenceList(element, qref, false);
                            }
                        }
                    }
                }
                if (!(element instanceof Practice) || (meta = (practicePropUtil = PracticePropUtil.getPracticePropUtil()).getUdtMeta((Practice)element)) == null || meta.getQualifiedReferences().isEmpty()) continue;
                for (EReference ref : meta.getQualifiedReferences()) {
                    practicePropUtil.getQReferenceListById(element, ref.getName(), false);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UdtMetaComparator
    implements Comparator<UserDefinedTypeMeta> {
        private UdtMetaComparator() {
        }

        @Override
        public int compare(UserDefinedTypeMeta obj1, UserDefinedTypeMeta obj2) {
            String name1 = (String)obj1.getRteNameMap().get("typeName");
            String name2 = (String)obj2.getRteNameMap().get("typeName");
            return name1.compareTo(name2);
        }
    }
}

