/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.provider.UmaEditPlugin;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;

public class ModelInfoKeyMap {
    private static boolean localDebug = false;
    private static ModelInfoKeyMap instance = new ModelInfoKeyMap();
    private Map<String, String> map = new HashMap<String, String>();

    private ModelInfoKeyMap() {
        this.map.put(this.getString("_UI_Task_mandatoryInput_feature"), "mandatoryInput");
        this.map.put(this.getString("_UI_Task_optionalInput_feature"), "optionalInput");
        this.map.put(this.getString("_UI_TaskDescriptor_externalInput_feature"), "externalInput");
        this.map.put(this.getString("_UI_Task_output_feature"), "output");
        this.map.put(this.getString("_UI_TaskDescriptor_performedPrimarilyBy_feature"), "performedPrimarilyBy");
        this.map.put(this.getString("_UI_TaskDescriptor_additionallyPerformedBy_feature"), "additionallyPerformedBy");
        this.map.put(this.getString("_UI_TaskDescriptor_assistedBy_feature"), "assistedBy");
        this.map.put(TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()), "ResponsibleFor");
        this.map.put(TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()), "Modifies");
        this.map.put(LibraryResources.ActivityLayout_primaryTasks_text, "primaryTasks");
        this.map.put(LibraryResources.ActivityLayout_additionalTasks_text, "additionalTasks");
        this.map.put(LibraryResources.ActivityLayout_assistTasks_text, "assistTasks");
        ModifiedTypeMeta taskMeta = TypeDefUtil.getMdtMeta((EClass)UmaPackage.eINSTANCE.getTask());
        ModifiedTypeMeta roleMeta = TypeDefUtil.getMdtMeta((EClass)UmaPackage.eINSTANCE.getRole());
        this.addForModifiedType(taskMeta);
        this.addForModifiedType(roleMeta);
    }

    private void addForModifiedType(ModifiedTypeMeta meta) {
        if (meta == null) {
            return;
        }
        for (ExtendedReference eRef : meta.getReferences()) {
            boolean w = "workproducts".equals(eRef.getContributeTo());
            boolean r = "roles".equals(eRef.getContributeTo());
            if (w || r) {
                this.map.put(eRef.getName(), eRef.getName());
            }
            if (!r) continue;
            String info = LibraryResources.bind((String)LibraryResources.ActivityLayout_performAs_text, (Object[])new String[]{eRef.getName()});
            this.map.put(info, info);
        }
    }

    public static ModelInfoKeyMap getInstance() {
        return instance;
    }

    private String getString(String uiKey) {
        return UmaEditPlugin.INSTANCE.getString(uiKey);
    }

    public String getModelInfoKey(String ModelInfo) {
        String ModelInfoKey = "";
        List strList = TngUtil.convertStringsToList((String)ModelInfo);
        for (String value : strList) {
            String key = this.map.get(value);
            if (key == null) continue;
            if (ModelInfoKey.length() > 0) {
                ModelInfoKey = String.valueOf(ModelInfoKey) + ", ";
            }
            ModelInfoKey = String.valueOf(ModelInfoKey) + key;
        }
        if (localDebug) {
            System.out.println("LD> ModelInfo: " + ModelInfo);
            System.out.println("LD> ModelInfoKey: " + ModelInfoKey);
            System.out.println("");
        }
        return ModelInfoKey;
    }
}

