/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.layout.elements.ActivityLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.FileNameGenerator;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publish.layout.LayoutPlugin;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class ResourceHelper {
    public static final String URL_BOOKMARK_INDICATOR = "#";
    public static final String URL_PARAMETER_INDICATOR = "?";
    public static final String URL_PARAMETER_PROCESS = "proc";
    public static final String URL_STR_JAVASCRIPT = "javascript:";
    public static final String URL_STR_MAILTO = "mailto:";
    public static final String URL_PARAMETER_PATH = "path";
    public static final String TAG_ATTR_NAME = "name";
    public static final String TAG_ATTR_KEY = "key";
    public static final String TAG_ATTR_TEXT = "text";
    public static final String TAG_ATTR_CLASS = "class";
    public static final String TAG_ATTR_GUID = "guid";
    public static final String TAG_ATTR_HREF = "href";
    public static final String TAG_ATTR_VALUE_INDEX = "index";
    public static final String FILE_EXT_HTML = ".html";
    public static final String FILE_EXT_HTM = ".htm";
    public static final String FILE_EXT_JPEG = ".jpeg";
    public static final String MISSING_PAGES_FOLDER = "pages_not_installed/";
    public static final String ELEMENT_LINK_CLASS_elementLink = "elementLink";
    public static final String ELEMENT_LINK_CLASS_elementLinkWithType = "elementLinkWithType";
    public static final String ELEMENT_LINK_CLASS_elementLinkWithUserText = "elementLinkWithUserText";
    public static final String RESOURCE_FOLDER = "resources";
    public static final Pattern p_html_file_name = Pattern.compile("(.*),(.*)\\.html");
    public static final Pattern p_link_ref = Pattern.compile("<a\\s+?(.*?)>(.*?)</a>", 34);
    public static final Pattern p_template_attachment_url = Pattern.compile("<a\\s+?href\\s*?=\\s*?\"(.*?)\"\\s*?>(.*?)</a>", 34);
    public static final Pattern p_area_ref = Pattern.compile("<area\\s+?(.*?)/?>", 34);
    public static final Pattern p_link_ref_gen = Pattern.compile("<(a|area)\\s+?([^>]*)>", 34);
    public static final Pattern p_link_type_picker = Pattern.compile("\\s*class\\s*?=\\s*?(.*?)\\s+", 34);
    public static final Pattern p_link_guid_picker = Pattern.compile("\\s*guid\\s*?=\\s*?(.*?)\\s+", 34);
    public static final Pattern p_link_href_picker = Pattern.compile("\\s*href\\s*?=\\s*?\"(.*?)\"\\s+", 34);
    public static final Pattern p_tag_ref = Pattern.compile("<([^>!]*)(\\n|\\r)([^>]*)>", 34);
    public static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    public static final Pattern p_href_ref = Pattern.compile("(<(a|area).*?href\\s*=\\s*\")(.*?)(\")", 34);
    public static final Pattern p_url_decoder = Pattern.compile("(<[^>]*?(src|href)\\s*=\\s*\")(.*?)(\"[^>]*?>)", 34);
    public static final Pattern p_tag_attributes = Pattern.compile("([\\S&&[^=]]+)\\s*=\\s*([\\S&&[^\"]]+|\"([\\S &&[^\"]]+)\")", 34);
    public static final Pattern p_css_ref = Pattern.compile(" url\\((.*?)\\)", 34);
    public static final String DIAGRAM_TYPE_WORKFLOW = "Activity";
    public static final String DIAGRAM_TYPE_ACTIVITY_DETAIL = "ActivityDetail";
    public static final String DIAGRAM_TYPE_WP_DEPENDENCY = "WPDependency";
    private static ILibraryResourceManager defaultResourceMgr;
    private static boolean showSkinResource;
    public static String LAYOUT_XSL_ROOT_PATH;
    public static boolean birt_publishing;
    private static final String EXTERNAL_URL_START_WITH;
    public static final Pattern p_external_url_startWith;

    static {
        showSkinResource = false;
        LAYOUT_XSL_ROOT_PATH = null;
        birt_publishing = true;
        EXTERNAL_URL_START_WITH = LayoutResources.getString("externalUrl_startWith");
        p_external_url_startWith = Pattern.compile("(" + EXTERNAL_URL_START_WITH + ")", 34);
    }

    public static synchronized void setDefaultResourceMgr(ILibraryResourceManager mgr) {
        defaultResourceMgr = mgr;
    }

    public static synchronized ILibraryResourceManager getDefaultResourceMgr() {
        return defaultResourceMgr;
    }

    public static ILibraryResourceManager getResourceMgr(MethodElement element) {
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)element);
        if (lib != null) {
            ILibraryManager libMgr = LibraryService.getInstance().getLibraryManager(lib);
            if (libMgr == null) {
                lib = LibraryService.getInstance().getCurrentMethodLibrary();
                libMgr = LibraryService.getInstance().getLibraryManager(lib);
            }
            if (libMgr == null) {
                return ResourceHelper.getDefaultResourceMgr();
            }
            return libMgr.getResourceManager();
        }
        return null;
    }

    public static String getPluginResourcePath(MethodElement element) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element);
        if (resMgr != null) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
            if (plugin == null) {
                return resMgr.getLogicalResourcePath(element);
            }
            return resMgr.getLogicalResourcePath((MethodElement)plugin);
        }
        return null;
    }

    public static String getElementResourcePath(MethodElement element) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element);
        if (resMgr != null) {
            return resMgr.getLogicalResourcePath(element);
        }
        return null;
    }

    public static String getAbsoluteElementResourcePath(MethodElement element) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element);
        if (resMgr != null) {
            return resMgr.getPhysicalResourcePath(element);
        }
        return null;
    }

    public static String getElementPath(MethodElement element) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element);
        if (resMgr != null) {
            return resMgr.getLogicalPath(element);
        }
        return null;
    }

    public static String getFolderAbsolutePath(MethodElement element) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element);
        if (resMgr != null) {
            return resMgr.getPhysicalPath(element);
        }
        return null;
    }

    public static String getBackPath(MethodElement element) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(element);
        if (resMgr != null) {
            return resMgr.getBackPath(element);
        }
        return "";
    }

    public static String getFileName(MethodElement element, String ext) {
        return ResourceHelper.getFileName(element, null, null, ext);
    }

    public static String getFileName(MethodElement element, String namePrefix, String nameSuffix, String ext) {
        return FileNameGenerator.INSTANCE.getFileName(element, namePrefix, nameSuffix, ext);
    }

    public static String getGuidFromFileName(String fileName) {
        return FileNameGenerator.INSTANCE.getGuidFromFileName(fileName);
    }

    public static MethodElement getElementFromFileName(String fileName) {
        ILibraryManager manager;
        String guid = ResourceHelper.getGuidFromFileName(fileName);
        if (guid != null && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            return manager.getMethodElement(guid);
        }
        return null;
    }

    public static String getUrl(MethodElement element, MethodElement refElement, String fileExt, String old_url) {
        String url = ResourceHelper.getUrl(element, refElement, fileExt);
        if (old_url != null) {
            int indx = old_url.indexOf(URL_BOOKMARK_INDICATOR);
            if (indx < 0) {
                indx = old_url.indexOf(URL_PARAMETER_INDICATOR);
            }
            if (indx >= 0) {
                url = String.valueOf(url) + old_url.substring(indx);
            }
        }
        return url;
    }

    public static String getUrl(MethodElement element, MethodElement refElement, String fileExt) {
        if (element == null) {
            return "";
        }
        if (refElement == null) {
            return String.valueOf(ResourceHelper.getElementPath(element).replace(File.separatorChar, '/')) + ResourceHelper.getFileName(element, fileExt);
        }
        return String.valueOf((String.valueOf(ResourceHelper.getBackPath(refElement)) + ResourceHelper.getElementPath(element)).replace(File.separatorChar, '/')) + ResourceHelper.getFileName(element, fileExt);
    }

    public static String getLinkText(MethodElement e, String linkType, MethodConfiguration config) {
        String linkedText = null;
        if (linkType != null && !ELEMENT_LINK_CLASS_elementLinkWithUserText.equalsIgnoreCase(linkType)) {
            if (ELEMENT_LINK_CLASS_elementLinkWithType.equalsIgnoreCase(linkType)) {
                linkedText = ResourceHelper.getElementLinkText(e, true, config);
            } else if (ELEMENT_LINK_CLASS_elementLink.equalsIgnoreCase(linkType)) {
                linkedText = ResourceHelper.getElementLinkText(e, false, config);
            }
        }
        return linkedText;
    }

    public static String getLinkText(MethodElement e, String linkType) {
        return ResourceHelper.getLinkText(e, linkType, null);
    }

    public static String getElementLinkText(MethodElement element, boolean withType) {
        return ResourceHelper.getElementLinkText(element, withType, null);
    }

    public static String getElementLinkText(MethodElement element, boolean withType, final MethodConfiguration config) {
        TngUtil.PresentationNameHelper pHelper = new TngUtil.PresentationNameHelper(){

            public String getPresentationName(MethodElement element) {
                if (element == null) {
                    return null;
                }
                String str = ConfigurationHelper.getPresentationName(element, config);
                return str;
            }
        };
        String text = TngUtil.getPresentationName((Object)element, (TngUtil.PresentationNameHelper)pHelper);
        if (withType) {
            if (showSkinResource) {
                File xslPath;
                if ((LAYOUT_XSL_ROOT_PATH == null || LAYOUT_XSL_ROOT_PATH.equals("")) && (xslPath = BrowsingLayoutSettings.INSTANCE.getXslPath()) != null) {
                    LAYOUT_XSL_ROOT_PATH = xslPath.getAbsolutePath();
                }
                Properties browsingResource = new Properties();
                File file = new File(LAYOUT_XSL_ROOT_PATH, "resources.properties");
                if (file.exists()) {
                    try {
                        browsingResource.load(new FileInputStream(file));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String type = ResourceHelper.getElementTypeText(element);
                String elementName = element.eClass().getName();
                String key = String.valueOf(elementName.substring(0, 1).toLowerCase()) + elementName.substring(1) + "Text";
                String value = browsingResource.getProperty(key);
                if (value != null) {
                    return String.valueOf(value) + LibraryResources.colon_with_space + text;
                }
                return String.valueOf(type) + LibraryResources.colon_with_space + text;
            }
            return String.valueOf(ResourceHelper.getElementTypeText(element)) + LibraryResources.colon_with_space + text;
        }
        return text;
    }

    public static String getElementTypeText(MethodElement element) {
        if (element == null) {
            return "";
        }
        return TngUtil.getTypeText((EObject)element);
    }

    public static String getElementLink(MethodElement element, boolean withType, String url) {
        String text = ResourceHelper.getElementLinkText(element, withType);
        String linkClass = ELEMENT_LINK_CLASS_elementLink;
        if (withType) {
            linkClass = ELEMENT_LINK_CLASS_elementLinkWithType;
        }
        return ResourceHelper.getElementLink(element, text, url, linkClass);
    }

    public static String getElementLink(MethodElement element, String text, String url) {
        return ResourceHelper.getElementLink(element, text, url, ELEMENT_LINK_CLASS_elementLinkWithUserText);
    }

    public static String getElementLink(MethodElement element, String text, String url, String linkClass) {
        return "<a class=\"" + linkClass + "\" " + ResourceHelper.getUrlText(url) + " guid=\"" + element.getGuid() + "\" >" + text + "</a>";
    }

    private static String getUrlText(String url) {
        if ((url = url == null ? "" : url.trim()).toLowerCase().startsWith(TAG_ATTR_HREF) || url.toLowerCase().indexOf(" href") > 0) {
            return url;
        }
        return "href=\"" + url + "\"";
    }

    public static String validateContent(MethodElement element, String source) {
        return ResourceHelper.validateContent(element, source, new DefaultContentValidator(), null, null);
    }

    public static boolean isElementLink(String linkType) {
        if (linkType == null || linkType.length() == 0) {
            return false;
        }
        return linkType.equalsIgnoreCase(ELEMENT_LINK_CLASS_elementLink) || linkType.equalsIgnoreCase(ELEMENT_LINK_CLASS_elementLinkWithType) || linkType.equalsIgnoreCase(ELEMENT_LINK_CLASS_elementLinkWithUserText);
    }

    public static String validateContent(MethodElement element, String source, IContentValidator validator, MethodConfiguration config, String layoutXslRootPath) {
        try {
            String urltext;
            String text;
            LAYOUT_XSL_ROOT_PATH = layoutXslRootPath;
            showSkinResource = true;
            source = ResourceHelper.validateTag(source);
            StringBuffer sb = new StringBuffer();
            Matcher m = p_link_ref.matcher(source);
            while (m.find()) {
                String linkedText;
                text = m.group();
                urltext = m.group(1);
                LinkInfo info = validator.validateLink(element, urltext, linkedText = m.group(2), config, "a");
                if (info != null) {
                    text = info.getHtml(validator.showBrokenLinks()).toString();
                    MethodElement e = info.getLinkedElement();
                    if (e != null) {
                        validator.addReferencedElement(element, e);
                    }
                }
                String replacement = text.replaceAll("file:///", "");
                replacement = replacement.replaceAll("file://", "");
                m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
            }
            m.appendTail(sb);
            if (element == null) {
                String string = sb.toString();
                return string;
            }
            source = sb.toString();
            m = p_area_ref.matcher(source);
            sb.setLength(0);
            while (m.find()) {
                text = m.group();
                urltext = m.group(1);
                LinkInfo info = validator.validateLink(element, urltext, "", config, "area");
                if (info != null) {
                    text = info.getHtml(false).toString();
                    MethodElement e = info.getLinkedElement();
                    if (e != null) {
                        validator.addReferencedElement(element, e);
                    }
                }
                String replacement = text.replaceAll("file:///", "");
                replacement = replacement.replaceAll("file://", "");
                m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
            }
            m.appendTail(sb);
            String string = ResourceHelper.decodeUrlsInContent(sb.toString());
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            LAYOUT_XSL_ROOT_PATH = null;
            showSkinResource = false;
        }
        return source;
    }

    public static String decodeUrlsInContent(String content) {
        try {
            StringBuffer sb = new StringBuffer();
            Matcher m = p_url_decoder.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                url = NetUtil.isRawUrl((String)url) ? ResourceHelper.restore(url) : URLDecoder.decode(url, "UTF-8");
                String text = String.valueOf(m.group(1)) + url + m.group(4);
                m.appendReplacement(sb, ResourceHelper.regExpEscape(text));
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return content;
        }
    }

    private static String restore(String url) {
        int index = url.indexOf("raw_URL_raw");
        return url.substring(0, index);
    }

    public static String regExpEscape(String text) {
        String newtext = StrUtil.escapeChar((String)text, (char)'\\');
        newtext = StrUtil.escapeChar((String)newtext, (char)'$');
        return newtext;
    }

    public static String fixElementUrl(MethodElement element, String urltext, MethodConfiguration config) {
        Matcher m = p_link_href_picker.matcher(" " + urltext + " ");
        StringBuffer sb = new StringBuffer();
        if (m.find()) {
            String guid;
            String url = m.group(1);
            String newurl = null;
            if (element != null && (guid = ResourceHelper.getGuidFromUrl(urltext)) != null) {
                MethodElement e;
                ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                MethodElement methodElement = e = manager != null ? manager.getMethodElement(guid) : null;
                if (e != null) {
                    if (config != null) {
                        e = ConfigurationHelper.getCalculatedElement(e, config);
                    }
                    newurl = ResourceHelper.getUrl(e, element, FILE_EXT_HTML, url);
                }
            }
            if (newurl != null && !newurl.equals(url)) {
                String replacement = " href=\"" + newurl + "\" ";
                m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
                m.appendTail(sb);
                return sb.toString();
            }
        }
        return urltext;
    }

    public static String getElementLinkType(String source) {
        Matcher m = p_link_type_picker.matcher(" " + source + " ");
        if (m.find()) {
            return m.group(1).trim().replaceAll("\"", "");
        }
        return null;
    }

    public static String getGuidFromUrl(String source) {
        Matcher m = p_link_guid_picker.matcher(" " + source + " ");
        if (m.find()) {
            return m.group(1).trim().replaceAll("\"", "");
        }
        m = p_link_href_picker.matcher(" " + source + " ");
        if (m.find()) {
            String href = m.group(1).trim().replaceAll("\"", "");
            return ResourceHelper.getGuidFromFileName(href);
        }
        return null;
    }

    public static String validateTag(String source) {
        StringBuffer sb = new StringBuffer();
        Matcher m = p_tag_ref.matcher(source);
        while (m.find()) {
            String text = m.group();
            String replacement = ResourceHelper.fixTagAttribute(text);
            m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String fixTagAttribute(String source) {
        return source.replaceAll("\\\r\\\n", " ").replaceAll("\\\r", " ").replaceAll("\\\n", " ");
    }

    public static URI getRelativeURI(URI uri, URI relativeTo) {
        URI relUri = relativeTo.relativize(uri);
        return relUri;
    }

    public static String getRelativePathToFileFromElement(MethodElement element, File attachment) {
        String elementLoc = ResourceHelper.getFolderAbsolutePath(element);
        return FileUtil.getRelativePath((File)attachment, (File)new File(elementLoc));
    }

    public static String getDiagramFilePathName(MethodElement e, String diagramType) {
        return String.valueOf(ResourceHelper.getElementResourcePath(e)) + FileNameGenerator.INSTANCE.getFileName(e, "", "_" + diagramType, FILE_EXT_JPEG);
    }

    public static String getXmlExportedDiagramImageFileName(MethodElement e, String diagramType, String format) {
        String str = String.valueOf(e.getName()) + " " + e.getGuid() + "_" + diagramType + format;
        return str;
    }

    public static boolean isAbsolutepath(String path) {
        if (path == null) {
            return false;
        }
        return path.startsWith("/") || path.startsWith(File.separator) || path.indexOf(":") > 0;
    }

    public static String getFilePathFromUrl(String url, String contentPath) {
        String filePath = url;
        if (ResourceHelper.isExternalLink(filePath) || filePath.startsWith(URL_STR_MAILTO) || filePath.startsWith(URL_BOOKMARK_INDICATOR)) {
            return null;
        }
        int index = filePath.indexOf("file:///");
        if (index == 0) {
            filePath = filePath.substring("file:///".length());
        }
        if ((index = filePath.indexOf("file://")) == 0) {
            filePath = filePath.substring("file://".length());
        }
        if (ResourceHelper.isAbsolutepath(filePath)) {
            return XMLUtil.unescape((String)NetUtil.decodedFileUrl((String)filePath));
        }
        File f = new File(contentPath);
        int start = 0;
        index = 0;
        while (f != null && (index = filePath.indexOf("../", start)) >= 0) {
            f = f.getParentFile();
            start = index + 3;
        }
        String rootFolder = "";
        if (f != null) {
            rootFolder = f.getPath();
        }
        if (rootFolder.length() > 0 && !rootFolder.endsWith(File.separator)) {
            rootFolder = String.valueOf(rootFolder) + File.separator;
        }
        String path = String.valueOf(rootFolder) + filePath.substring(start).replace('/', File.separatorChar);
        return XMLUtil.unescape((String)NetUtil.decodedFileUrl((String)path));
    }

    public static String fixContentUrlPath(String content, String contentPath, String backPath) {
        if (contentPath == null || backPath == null) {
            return content;
        }
        StringBuffer sb = new StringBuffer();
        try {
            Matcher m = p_image_ref.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                if ((url = ResourceHelper.resolveUrl(url, contentPath, backPath)) == null) continue;
                m.appendReplacement(sb, ResourceHelper.regExpEscape(String.valueOf(m.group(1)) + url + m.group(4)));
            }
            m.appendTail(sb);
            content = sb.toString();
            sb = new StringBuffer();
            m = p_link_ref_gen.matcher(content);
            while (m.find()) {
                Matcher m2;
                StringBuffer sbLink = new StringBuffer();
                String urltext = " " + m.group(2) + " ";
                if (ResourceHelper.getGuidFromUrl(urltext) != null || !(m2 = p_link_href_picker.matcher(urltext)).find()) continue;
                String url = m2.group(1).trim().replaceAll("\"", "");
                if (ResourceHelper.isExternalLink(url)) {
                    url = XMLUtil.unescape((String)NetUtil.decodedFileUrl((String)url));
                    if (birt_publishing && NetUtil.isRawUrl((String)url)) {
                        url = ResourceHelper.restore(url);
                    }
                } else {
                    url = ResourceHelper.resolveUrl(url, contentPath, backPath);
                }
                if (url == null) continue;
                String replacement = String.valueOf(urltext.substring(m2.start(), m2.start(1))) + url + urltext.substring(m2.end(1), m2.end());
                m2.appendReplacement(sbLink, ResourceHelper.regExpEscape(replacement));
                m2.appendTail(sbLink);
                replacement = String.valueOf(content.substring(m.start(), m.start(2))) + sbLink.toString() + content.substring(m.end(2), m.end());
                m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
            }
            m.appendTail(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static String resolveUrl(String url, String contentPath, String backPath) {
        String new_url = ResourceHelper.getFilePathFromUrl(url, contentPath);
        if (ResourceHelper.isAbsolutepath(new_url)) {
            return new_url;
        }
        if (new_url != null && !new_url.equals(url)) {
            if (backPath != null) {
                new_url = String.valueOf(backPath) + new_url;
            }
            return new_url.replace(File.separatorChar, '/');
        }
        return null;
    }

    public static boolean isExternalLink(String url) {
        if (url == null) {
            return false;
        }
        if ((url = url.toLowerCase()).startsWith("file://")) {
            return false;
        }
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("www.")) {
            return true;
        }
        Matcher m = p_external_url_startWith.matcher(url);
        if (m.find()) {
            return m.start(1) == 0;
        }
        return false;
    }

    public static boolean isJavascriptUrl(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith(URL_STR_MAILTO) || url.toLowerCase().startsWith(URL_STR_JAVASCRIPT);
    }

    public static String processResourceUrl(MethodElement owner, File resourceFile, String url, String contentPath, File sourceRootPath, File targetRootPath, String rootContentPath, List processedItems, IContentValidator validator) {
        String tmpPath;
        ILibraryResourceManager mgr;
        String imageFile;
        if (url == null || ResourceHelper.isExternalLink(url) || ResourceHelper.isJavascriptUrl(url) || url.startsWith(URL_BOOKMARK_INDICATOR)) {
            return url;
        }
        String guid = "";
        if (owner != null && (url.indexOf(guid = owner.getGuid()) >= 0 || ResourceHelper.isActivityTabUrl(url))) {
            return url;
        }
        int index = url.indexOf(URL_BOOKMARK_INDICATOR);
        if (index < 0) {
            index = url.indexOf(URL_PARAMETER_INDICATOR);
        }
        String url_tail = "";
        if (index > 0) {
            url_tail = url.substring(index);
            url = url.substring(0, index);
        }
        if ((imageFile = ResourceHelper.getFilePathFromUrl(url, contentPath)) == null) {
            if (validator != null) {
                validator.logMissingResource(owner, resourceFile, url);
            }
            return null;
        }
        if (imageFile.equalsIgnoreCase("index.htm") || imageFile.equalsIgnoreCase("index.html")) {
            return String.valueOf(url) + url_tail;
        }
        String newUrl = url;
        File source = new File(imageFile);
        if (source.exists()) {
            return String.valueOf(url) + url_tail;
        }
        boolean usePubRoot = true;
        String filePath = imageFile;
        if (rootContentPath != null && rootContentPath.length() > 0 && filePath.startsWith(rootContentPath)) {
            filePath = filePath.substring(rootContentPath.length());
            usePubRoot = false;
        }
        if (!(source = new File(sourceRootPath, filePath)).exists() && (mgr = ResourceHelper.getResourceMgr(owner)) != null && (tmpPath = mgr.resolve(owner, filePath)) != null) {
            source = new File(tmpPath);
        }
        if (!source.exists()) {
            source = new File(LayoutPlugin.getDefault().getLayoutPath(), filePath);
        }
        boolean calledFromGuidanceTypeConvert = false;
        File sourceRootParent = sourceRootPath.getParentFile();
        if (sourceRootParent.getName().equals("guidances")) {
            File targetRootParent = targetRootPath.getParentFile();
            if (targetRootParent != null) {
                targetRootParent = targetRootParent.getParentFile();
            }
            if (sourceRootParent.equals(targetRootParent)) {
                calledFromGuidanceTypeConvert = true;
                targetRootPath = targetRootPath.getParentFile();
            }
        }
        if (!calledFromGuidanceTypeConvert && usePubRoot && rootContentPath != null && rootContentPath.length() > 0) {
            File tmpf = new File(rootContentPath);
            while (tmpf != null) {
                tmpf = tmpf.getParentFile();
                targetRootPath = targetRootPath.getParentFile();
            }
        }
        File dest = new File(targetRootPath, filePath);
        if (source.exists()) {
            FileUtil.copyFile((File)source, (File)dest);
            if (imageFile.endsWith(FILE_EXT_HTM) || imageFile.endsWith(FILE_EXT_HTML)) {
                File f = new File(imageFile);
                try {
                    ResourceHelper.resolveResources(owner, f, FileUtil.readFile((File)source, (String)"UTF-8").toString(), f.getParent(), sourceRootPath, targetRootPath, rootContentPath, processedItems, validator);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (!dest.exists() && ResourceHelper.isValidFileUrl(url) && validator != null) {
            validator.logMissingResource(owner, resourceFile, url);
        }
        return String.valueOf(newUrl) + url_tail;
    }

    private static boolean isActivityTabUrl(String url) {
        return ActivityLayout.isActivityTabUrl(url);
    }

    private static boolean isValidFileUrl(String url) {
        return url != null && !url.equals("' + diagram_img + '");
    }

    public static void resolveResources(MethodElement owner, File resourceFile, String content, String contentPath, File sourceRootPath, File targetRootPath, String rootContentPath, List processedItems, IContentValidator validator) {
        try {
            Matcher m = p_image_ref.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                if (processedItems.contains(url)) continue;
                processedItems.add(url);
                ResourceHelper.processResourceUrl(owner, resourceFile, url, contentPath, sourceRootPath, targetRootPath, rootContentPath, processedItems, validator);
            }
            m = p_css_ref.matcher(content);
            while (m.find()) {
                String cssURL = m.group(1);
                if (processedItems.contains(cssURL)) continue;
                processedItems.add(cssURL);
                ResourceHelper.processResourceUrl(owner, resourceFile, cssURL, contentPath, sourceRootPath, targetRootPath, rootContentPath, processedItems, null);
            }
            m = p_link_ref_gen.matcher(content);
            while (m.find()) {
                String url;
                Matcher m2;
                String urltext = m.group(2);
                if (ResourceHelper.getGuidFromUrl(urltext) != null || !(m2 = p_link_href_picker.matcher(" " + urltext + " ")).find() || processedItems.contains(url = m2.group(1).trim().replaceAll("\"", ""))) continue;
                processedItems.add(url);
                ResourceHelper.processResourceUrl(owner, resourceFile, url, contentPath, sourceRootPath, targetRootPath, rootContentPath, processedItems, validator);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Map getTagAttributes(String attributesStr) {
        try {
            LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>(3);
            Matcher m2 = p_tag_attributes.matcher(attributesStr);
            while (m2.find()) {
                String attrName = m2.group(1).trim().toLowerCase();
                String attrValue = "";
                if (m2.group(3) != null) {
                    attrValue = m2.group(3).trim();
                } else if (m2.group(2) != null) {
                    attrValue = m2.group(2).trim();
                }
                if (attrName.equals(TAG_ATTR_HREF)) {
                    try {
                        attrValue = URLDecoder.decode(attrValue, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                attributeMap.put(attrName, attrValue);
            }
            return attributeMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map getAttributesFromLink(String link) {
        Matcher m = p_link_ref.matcher(link);
        if (m.find()) {
            String attributes = m.group(1);
            return ResourceHelper.getTagAttributes(attributes);
        }
        return null;
    }

    public static Map getAttributesFromLink(Pattern pattern, String link) {
        Matcher m = pattern.matcher(link);
        if (m.find()) {
            String attributes = m.group(1);
            return ResourceHelper.getTagAttributes(attributes);
        }
        return null;
    }

    public static String getAttributesAsString(Map attributeMap) {
        StringBuffer buf = new StringBuffer();
        for (String key : attributeMap.keySet()) {
            String value = (String)attributeMap.get(key);
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(String.valueOf(key) + "=\"" + value + "\"");
        }
        return buf.toString();
    }

    private static String getDiscardedElementURL(MethodElement ownerElement, MethodElement linkElement, String guid, String pubDir) {
        StringBuffer discardedElementURL = new StringBuffer();
        discardedElementURL.append(MISSING_PAGES_FOLDER).append("pages_not_installed").append(FILE_EXT_HTML);
        File outputFile = new File(pubDir, discardedElementURL.toString());
        File dir = outputFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        XmlElement xml = new XmlElement("Element");
        xml.setAttribute(TAG_ATTR_GUID, guid).setAttribute("type", linkElement.getType().getName()).setAttribute(TAG_ATTR_NAME, linkElement.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)linkElement).getName());
        String xslPath = LayoutResources.getDefaultXslPath("page_not_installed", null);
        try {
            StringBuffer xml2 = new StringBuffer();
            xml2.append(XmlHelper.XML_HEADER).append(xml.toXml());
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8");
            Properties xslParams = LayoutPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)xslPath, (String)xml2.toString(), (Properties)xslParams, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return String.valueOf(ResourceHelper.getBackPath(ownerElement).replace(File.separatorChar, '/')) + discardedElementURL.toString();
    }

    public static String validateRichTextContent(MethodElement element, String source, IContentValidator validator) {
        try {
            String urltext;
            String text;
            MethodConfiguration config = null;
            source = ResourceHelper.validateTag(source);
            StringBuffer sb = new StringBuffer();
            Matcher m = p_link_ref.matcher(source);
            while (m.find()) {
                String linkedText;
                text = m.group();
                urltext = m.group(1);
                LinkInfo info = validator.validateLink(element, urltext, linkedText = m.group(2), config, "a");
                if (info != null) {
                    text = info.getHtml(validator.showBrokenLinks()).toString();
                    MethodElement e = info.getLinkedElement();
                    if (e != null) {
                        validator.addReferencedElement(element, e);
                    }
                }
                String replacement = text.replaceAll("file:///", "");
                replacement = replacement.replaceAll("file://", "");
                m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
            }
            m.appendTail(sb);
            if (element == null) {
                return sb.toString();
            }
            source = sb.toString();
            m = p_area_ref.matcher(source);
            sb.setLength(0);
            while (m.find()) {
                text = m.group();
                urltext = m.group(1);
                LinkInfo info = validator.validateLink(element, urltext, "", config, "area");
                if (info != null) {
                    text = info.getHtml(validator.showBrokenLinks()).toString();
                    MethodElement e = info.getLinkedElement();
                    if (e != null) {
                        validator.addReferencedElement(element, e);
                    }
                }
                String replacement = text.replaceAll("file:///", "");
                replacement = replacement.replaceAll("file://", "");
                m.appendReplacement(sb, ResourceHelper.regExpEscape(replacement));
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (Exception ex) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
            return source;
        }
    }

    public static String getPluginPath(MethodElement e) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        return ResourceHelper.getFolderAbsolutePath((MethodElement)plugin);
    }

    public static String getPluginPath(MethodPlugin plugin) {
        return ResourceHelper.getFolderAbsolutePath((MethodElement)plugin);
    }

    public static String convertToRteString(String attachmentString) {
        String str = "<ul>";
        if (attachmentString != null && attachmentString.indexOf("<p/>") > 0) {
            attachmentString = attachmentString.replaceAll("<p/>", "|");
        }
        List attachmentList = TngUtil.convertGuidanceAttachmentsToList((String)attachmentString);
        for (String attachmentFile : attachmentList) {
            if (attachmentFile == null) continue;
            Matcher m = p_template_attachment_url.matcher(attachmentFile);
            if (!m.find()) {
                String fileName = FileUtil.getFileName((String)attachmentFile);
                str = String.valueOf(str) + "<li>";
                str = String.valueOf(str) + "<a  href=\"" + attachmentFile;
                str = String.valueOf(str) + "\" target=\"_blank\"; >" + fileName;
                str = String.valueOf(str) + "</a>";
                str = String.valueOf(str) + "</li>";
                continue;
            }
            String url = m.group(1);
            String fileName = m.group(2);
            str = String.valueOf(str) + "<li>";
            str = String.valueOf(str) + "<a  href=\"" + url;
            str = String.valueOf(str) + "\" target=\"_blank\"; >" + fileName;
            str = String.valueOf(str) + "</a>";
            str = String.valueOf(str) + "</li>";
        }
        str = String.valueOf(str) + "<ul>";
        return str;
    }
}

