/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.util.IResourceScanner;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceScanner
implements IResourceScanner {
    private static boolean localDebug = false;
    public static final Pattern p_src_ref = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    public static final Pattern p_href_ref = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    private MethodPlugin srcPlugin;
    private MethodPlugin tgtPlugin;
    private File srcPluginRoot;
    private File tgtPluginRoot;
    private File srcPluginRootParent;
    private File tgtPluginRootParent;
    private Map<File, File> fileMap;
    private Set<File> tgtFileSet;

    public ResourceScanner(MethodPlugin srcPlugin, MethodPlugin tgtPlugin) {
        this.init(srcPlugin, tgtPlugin);
    }

    public void init(MethodPlugin srcPlugin, MethodPlugin tgtPlugin) {
        this.srcPlugin = srcPlugin;
        this.tgtPlugin = tgtPlugin;
        if (srcPlugin == null || tgtPlugin == null) {
            this.srcPluginRoot = null;
            this.tgtPluginRoot = null;
            this.srcPluginRootParent = null;
            this.tgtPluginRootParent = null;
            this.fileMap = null;
            this.tgtFileSet = null;
            return;
        }
        File srcFile = new File(srcPlugin.eResource().getURI().toFileString());
        File tgtFile = new File(tgtPlugin.eResource().getURI().toFileString());
        this.srcPluginRoot = srcFile.getParentFile();
        this.tgtPluginRoot = tgtFile.getParentFile();
        this.srcPluginRootParent = this.srcPluginRoot.getParentFile();
        this.tgtPluginRootParent = this.tgtPluginRoot.getParentFile();
    }

    public String scan(MethodElement srcElement, MethodElement tgtElement, String source, EStructuralFeature feature) {
        String srcPath = ResourceHelper.getElementPath(srcElement);
        if (srcPath == null) {
            return source;
        }
        String tgtPath = ResourceHelper.getElementPath(tgtElement);
        if (tgtPath == null) {
            if (srcPath.indexOf(this.srcPlugin.getName()) == 0) {
                tgtPath = String.valueOf(this.tgtPlugin.getName()) + srcPath.substring(this.srcPlugin.getName().length());
            } else {
                return source;
            }
        }
        File srcFolder = new File(this.srcPluginRootParent, srcPath);
        File tgtFolder = new File(this.tgtPluginRootParent, tgtPath);
        StringBuffer sb = new StringBuffer();
        try {
            String replaceText;
            String tgtUrl;
            String url;
            String text;
            Matcher m = p_src_ref.matcher(source);
            while (m.find()) {
                text = m.group();
                url = m.group(1);
                tgtUrl = this.registerFileCopy(srcFolder, tgtFolder, url, srcElement, tgtElement);
                replaceText = text.replace(url, tgtUrl);
                m.appendReplacement(sb, Matcher.quoteReplacement(replaceText));
            }
            m.appendTail(sb);
            m = p_href_ref.matcher(sb.toString());
            sb = new StringBuffer();
            while (m.find()) {
                text = m.group();
                url = m.group(1);
                tgtUrl = this.registerFileCopy(srcFolder, tgtFolder, url, srcElement, tgtElement);
                replaceText = text.replace(url, tgtUrl);
                m.appendReplacement(sb, Matcher.quoteReplacement(replaceText));
            }
            m.appendTail(sb);
        }
        catch (Exception ex) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        return sb.toString();
    }

    public String registerFileCopy(String srcUrl) {
        return this.registerFileCopy(this.srcPluginRoot, this.tgtPluginRoot, srcUrl, null, null);
    }

    public String registerFileCopy(String srcUrl, MethodElement srcElement, MethodElement tgtElement) {
        String srcPath = ResourceHelper.getElementPath(srcElement);
        if (srcPath == null) {
            return srcUrl;
        }
        String tgtPath = ResourceHelper.getElementPath(tgtElement);
        if (tgtPath == null) {
            if (srcPath.indexOf(this.srcPlugin.getName()) == 0) {
                tgtPath = String.valueOf(this.tgtPlugin.getName()) + srcPath.substring(this.srcPlugin.getName().length());
            } else {
                return srcUrl;
            }
        }
        File srcFolder = new File(this.srcPluginRootParent, srcPath);
        File tgtFolder = new File(this.tgtPluginRootParent, tgtPath);
        return this.registerFileCopy(srcFolder, tgtFolder, srcUrl, srcElement, tgtElement);
    }

    protected String registerFileCopy(File srcFolder, File tgtFolder, String srcUrl, MethodElement srcElement, MethodElement tgtElement) {
        return this.registerFileCopy(srcFolder, tgtFolder, srcUrl);
    }

    private String registerFileCopy(File srcFolder, File tgtFolder, String srcUrl) {
        if (srcUrl == null) {
            return srcUrl;
        }
        String tgtUrl = srcUrl;
        int index = tgtUrl.indexOf("#");
        if (index >= 0) {
            tgtUrl = tgtUrl.substring(0, index);
        }
        if ((index = tgtUrl.indexOf("?")) >= 0) {
            tgtUrl = tgtUrl.substring(0, index);
        }
        if (tgtUrl.trim().length() == 0) {
            return srcUrl;
        }
        try {
            String decodedChild = null;
            try {
                decodedChild = NetUtil.decodeURL((String)srcUrl);
            }
            catch (Exception exception) {
                decodedChild = srcUrl;
            }
            File srcFile0 = new File(srcFolder, decodedChild);
            if (!srcFile0.isFile() || !srcFile0.exists()) {
                return srcUrl;
            }
            File srcFile = this.newFile(srcFolder, srcUrl);
            File tgtFile = this.newFile(tgtFolder, tgtUrl);
            if (srcFile.isFile() && srcFile.exists()) {
                if (tgtFile.exists() && tgtFile.lastModified() == srcFile.lastModified() && tgtFile.length() == srcFile.length()) {
                    return tgtUrl;
                }
                tgtUrl = this.getTargetUrl(srcFile, tgtFolder, tgtUrl);
                tgtFile = this.newFile(tgtFolder, tgtUrl);
                tgtUrl = this.registerFileCopyToMap(srcFile, tgtFile, tgtUrl);
            }
        }
        catch (Throwable e) {
            LibraryPlugin.getDefault().getLogger().logError(e);
        }
        return tgtUrl;
    }

    protected String registerFileCopyToMap(File srcFile0, File tgtFile0, String tgtUrl) {
        try {
            File srcFile = srcFile0.getCanonicalFile();
            File tgtFile = tgtFile0.getCanonicalFile();
            this.getFileMap().put(srcFile, tgtFile);
        }
        catch (IOException e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return tgtUrl;
    }

    private File newFile(File parent, String child) {
        String decodedChild;
        try {
            decodedChild = NetUtil.decodeURL((String)child);
        }
        catch (Exception exception) {
            decodedChild = child;
        }
        File file = new File(parent, decodedChild);
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return file;
        }
    }

    public void copyFiles() {
        if (localDebug) {
            System.out.println("LD> copyFiles: ");
        }
        for (Map.Entry<File, File> entry : this.getFileMap().entrySet()) {
            File srcFile = entry.getKey();
            File tgtFile = entry.getValue();
            FileManager.copyFile((File)srcFile, (File)tgtFile);
            tgtFile.setLastModified(srcFile.lastModified());
            if (!localDebug) continue;
            System.out.println("LD> srcFile: " + srcFile);
            System.out.println("LD> tgtFile: " + tgtFile);
            System.out.println("");
        }
    }

    private String getTargetUrl(File srcFile, File tgtFolder, String tgtUrl0) {
        boolean exists;
        String dot = ".";
        String url1 = tgtUrl0;
        String url2 = "";
        int ix = tgtUrl0.lastIndexOf(dot);
        int len = tgtUrl0.length();
        boolean addDot = false;
        if (ix > 0 && ix < len) {
            url1 = tgtUrl0.substring(0, ix);
            url2 = tgtUrl0.substring(ix + 1, len);
            addDot = true;
        }
        String tgtUrl = tgtUrl0;
        File tgtFile = this.newFile(tgtFolder, tgtUrl);
        String u = "_";
        int i = 1;
        while (!(exists = tgtFile.exists()) || tgtFile.lastModified() != srcFile.lastModified() || tgtFile.length() != srcFile.length()) {
            boolean inTgtSet = this.getTgtFileSet().contains(tgtFile);
            if (!exists && !inTgtSet) break;
            if (inTgtSet) {
                try {
                    File file = this.getFileMap().get(srcFile.getCanonicalFile());
                    if (file == null) {
                        boolean findEqual = false;
                        for (Map.Entry<File, File> entry : this.getFileMap().entrySet()) {
                            if (!entry.getValue().equals(tgtFile) || !FileUtil.binaryEqual((File)srcFile.getCanonicalFile(), (File)entry.getKey())) continue;
                            findEqual = true;
                            break;
                        }
                        if (findEqual) {
                            break;
                        }
                    } else if (file.equals(tgtFile.getCanonicalFile())) {
                        break;
                    }
                }
                catch (Exception e) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
            tgtUrl = String.valueOf(url1) + u + i;
            if (addDot) {
                tgtUrl = String.valueOf(tgtUrl) + dot + url2;
            }
            tgtFile = this.newFile(tgtFolder, tgtUrl);
            ++i;
        }
        try {
            tgtFile = tgtFile.getCanonicalFile();
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.getTgtFileSet().add(tgtFile);
        return tgtUrl;
    }

    public MethodPlugin getSrcPlugin() {
        return this.srcPlugin;
    }

    protected Map<File, File> getFileMap() {
        if (this.fileMap == null) {
            this.fileMap = new HashMap<File, File>();
        }
        return this.fileMap;
    }

    protected Set<File> getTgtFileSet() {
        if (this.tgtFileSet == null) {
            this.tgtFileSet = new HashSet<File>();
        }
        return this.tgtFileSet;
    }
}

