/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodLibraryPropUtil;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.ProcessPropUtil;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.DescriptorDescription;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class SynFreeProcessConverter {
    private boolean debug = false;
    private ElementRealizer realizer;
    private MethodConfiguration config;
    private Set<Resource> resouresToSave;
    private UmaPackage up = UmaPackage.eINSTANCE;

    private ElementRealizer getRealizer() {
        return this.realizer;
    }

    private void setRealizer(ElementRealizer realizer) {
        this.realizer = realizer;
    }

    public SynFreeProcessConverter() {
    }

    public SynFreeProcessConverter(MethodConfiguration config) {
        this.config = config;
    }

    private MethodConfiguration getConfig(Process proc) {
        return this.config == null ? proc.getDefaultContext() : this.config;
    }

    public void convertLibrary(MethodLibrary lib) throws Exception {
        this.convertLibrary(lib, true);
    }

    public void convertLibrary(MethodLibrary lib, boolean toSave) throws Exception {
        if (this.debug) {
            System.out.println("LD> Begin convertLibrary: " + lib);
            System.out.println("");
        }
        this.convertLibrary_(lib, toSave);
        if (this.debug) {
            System.out.println("LD> End convertLibrary: " + lib);
            System.out.println("");
        }
    }

    private void convertLibrary_(MethodLibrary lib, boolean toSave) throws Exception {
        if (lib == null) {
            return;
        }
        List plugins = lib.getMethodPlugins();
        if (toSave) {
            this.resouresToSave = new HashSet<Resource>();
        }
        int i = 0;
        while (i < plugins.size()) {
            this.convertPlugin((MethodPlugin)plugins.get(i), false);
            ++i;
        }
        MethodLibraryPropUtil propUtil = MethodLibraryPropUtil.getMethodLibraryPropUtil();
        propUtil.setSynFree(lib, true);
        if (toSave) {
            this.resouresToSave.add(lib.eResource());
            this.save();
        }
    }

    public void convertPlugin(MethodPlugin plugin, boolean toSave) throws Exception {
        Resource res;
        if (plugin == null) {
            return;
        }
        if (this.debug) {
            System.out.println("LD> convertPlugin: " + plugin);
            System.out.println("");
        }
        if (toSave) {
            this.resouresToSave = new HashSet<Resource>();
        }
        Set processes = LibraryEditUtil.getInstance().collectProcesses((MethodElement)plugin);
        for (Process proc : processes) {
            this.convertProcess(proc, false);
        }
        MethodPluginPropUtil propUtil = MethodPluginPropUtil.getMethodPluginPropUtil();
        propUtil.setSynFree(plugin, true);
        if (this.resouresToSave != null && (res = plugin.eResource()) != null) {
            this.resouresToSave.add(res);
        }
        if (toSave) {
            this.save();
        }
    }

    public void convertProcess(Process proc, boolean toSave) throws Exception {
        Resource res;
        if (proc == null) {
            return;
        }
        if (proc.getDefaultContext() == null) {
            ProcessScopeUtil.getInstance().loadScope(proc);
        }
        if (proc.getDefaultContext() == null) {
            return;
        }
        if (this.debug) {
            System.out.println("LD> convertProcess: " + proc);
            System.out.println("");
        }
        MethodConfiguration c = this.getConfig(proc);
        ElementRealizer r = DefaultElementRealizer.newElementRealizer(c);
        this.setRealizer(r);
        Set descriptors = LibraryEditUtil.getInstance().collectDescriptors(proc);
        if (toSave) {
            this.resouresToSave = new HashSet<Resource>();
        }
        for (Descriptor des : descriptors) {
            this.convert(proc, des);
        }
        ProcessPropUtil.getProcessPropUtil().setSynFree(proc, true);
        if (this.resouresToSave != null && (res = proc.eResource()) != null) {
            this.resouresToSave.add(res);
        }
        if (toSave) {
            this.save();
        }
    }

    private void convert(Process proc, Descriptor des) {
        boolean oldDeliver = des.eDeliver();
        try {
            if (oldDeliver) {
                des.eSetDeliver(false);
            }
            this.convert_(proc, des);
        }
        finally {
            if (oldDeliver) {
                des.eSetDeliver(oldDeliver);
            }
        }
    }

    private void convert_(Process proc, Descriptor des) {
        Resource res = des.eResource();
        if (res == null) {
            return;
        }
        if (this.debug) {
            System.out.println("LD> convert: " + des);
        }
        if (des instanceof TaskDescriptor) {
            this.convertTd(proc, (TaskDescriptor)des);
        } else if (des instanceof RoleDescriptor) {
            this.convertRd(proc, (RoleDescriptor)des);
        } else if (des instanceof WorkProductDescriptor) {
            this.convertWpd(proc, (WorkProductDescriptor)des);
        }
        this.convertGuidances(proc, des);
        this.convertTextAttributes(proc, des);
        if (this.resouresToSave != null) {
            this.resouresToSave.add(res);
        }
    }

    public static boolean equalsIgnoreSuffixNumber(String eString, String dString) {
        if (eString == null) {
            return dString == null;
        }
        if (dString == null) {
            return false;
        }
        if (dString.equals(eString)) {
            return true;
        }
        if (dString.startsWith(String.valueOf(eString) + "_")) {
            int ix = eString.length() + 1;
            String str = dString.substring(ix);
            try {
                int n = Integer.parseInt(str);
                return n >= 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private void convertTextAttributes(Process proc, Descriptor des) {
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        ContentElement element = (ContentElement)propUtil.getLinkedElement(des);
        if (element == null) {
            return;
        }
        if (propUtil.hasNoValue(des.getName())) {
            des.setName(element.getName());
        } else if (!SynFreeProcessConverter.equalsIgnoreSuffixNumber(element.getName(), des.getName())) {
            propUtil.setNameRepalce(des, true);
        }
        String elementStrValue = ConfigurationHelper.getPresentationName((MethodElement)element, this.getConfig(proc));
        if (propUtil.hasNoValue(des.getPresentationName())) {
            des.setPresentationName(element.getPresentationName());
        } else if (!SynFreeProcessConverter.equalsIgnoreSuffixNumber(element.getPresentationName(), des.getPresentationName())) {
            propUtil.setPresentationNameRepalce(des, true);
        }
        elementStrValue = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)element, (EStructuralFeature)this.up.getMethodElement_BriefDescription(), this.getConfig(proc));
        if (propUtil.hasNoValue(des.getBriefDescription())) {
            des.setBriefDescription(elementStrValue);
        } else if (!des.getBriefDescription().equals(elementStrValue)) {
            propUtil.setBriefDesRepalce(des, true);
        }
        ContentDescription ePrentation = element.getPresentation();
        DescriptorDescription dPrentation = (DescriptorDescription)des.getPresentation();
        boolean oldDeliver = dPrentation.eDeliver();
        try {
            if (oldDeliver) {
                dPrentation.eSetDeliver(false);
            }
            elementStrValue = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)ePrentation, (MethodElement)element, (EStructuralFeature)this.up.getContentDescription_MainDescription(), this.getConfig(proc));
            if (propUtil.hasNoValue(dPrentation.getRefinedDescription())) {
                dPrentation.setRefinedDescription(elementStrValue);
            } else if (!dPrentation.getRefinedDescription().equals(elementStrValue)) {
                propUtil.setMainDesRepalce(des, true);
            }
            elementStrValue = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)ePrentation, (MethodElement)element, (EStructuralFeature)this.up.getContentDescription_KeyConsiderations(), this.getConfig(proc));
            if (propUtil.hasNoValue(dPrentation.getKeyConsiderations())) {
                dPrentation.setKeyConsiderations(elementStrValue);
            } else if (!dPrentation.getKeyConsiderations().equals(elementStrValue)) {
                propUtil.setKeyConsiderRepalce(des, true);
            }
        }
        finally {
            if (oldDeliver) {
                dPrentation.eSetDeliver(oldDeliver);
            }
        }
    }

    private void convertTd(Process proc, TaskDescriptor td) {
        Task task = (Task)this.getLinkedElement((Descriptor)td);
        if (task == null) {
            return;
        }
        this.convertManyEReference(proc, (Descriptor)td, (MethodElement)task, this.up.getTaskDescriptor_PerformedPrimarilyBy(), this.up.getTaskDescriptor_PerformedPrimarilyByExcluded(), this.up.getTask_PerformedBy());
        this.convertManyEReference(proc, (Descriptor)td, (MethodElement)task, this.up.getTaskDescriptor_AdditionallyPerformedBy(), this.up.getTaskDescriptor_AdditionallyPerformedByExclude(), this.up.getTask_AdditionallyPerformedBy());
        this.convertManyEReference(proc, (Descriptor)td, (MethodElement)task, this.up.getTaskDescriptor_MandatoryInput(), this.up.getTaskDescriptor_MandatoryInputExclude(), this.up.getTask_MandatoryInput());
        this.convertManyEReference(proc, (Descriptor)td, (MethodElement)task, this.up.getTaskDescriptor_OptionalInput(), this.up.getTaskDescriptor_OptionalInputExclude(), this.up.getTask_OptionalInput());
        this.convertManyEReference(proc, (Descriptor)td, (MethodElement)task, this.up.getTaskDescriptor_Output(), this.up.getTaskDescriptor_OutputExclude(), this.up.getTask_Output());
        this.convertManyEReference(proc, (Descriptor)td, (MethodElement)task, this.up.getTaskDescriptor_SelectedSteps(), this.up.getTaskDescriptor_SelectedStepsExclude(), this.up.getTask_Steps());
    }

    private void convertManyEReference(Process proc, Descriptor ownerDescriptor, MethodElement ownerLinkedElement, EReference dFeature, EReference dFeatureExclude, EReference efeature) {
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        List elements = ConfigurationHelper.calc0nFeatureValue(ownerLinkedElement, (EStructuralFeature)efeature, this.getRealizer());
        List descriptors = ConfigurationHelper.calc0nFeatureValue((MethodElement)ownerDescriptor, (EStructuralFeature)dFeature, this.getRealizer());
        List excludeList = (List)ownerDescriptor.eGet((EStructuralFeature)dFeatureExclude);
        ArrayList<Descriptor> localList = new ArrayList<Descriptor>();
        HashSet elementSet = new HashSet();
        if (elements != null && !elements.isEmpty()) {
            elementSet.addAll(elements);
        }
        new ArrayList();
        HashSet<MethodElement> linkedElementSet = new HashSet<MethodElement>();
        if (descriptors != null) {
            for (MethodElement methodElement : descriptors) {
                if (methodElement instanceof Descriptor) {
                    Descriptor d = (Descriptor)methodElement;
                    MethodElement linkedElement = this.getLinkedElement(d);
                    if (linkedElement == null) {
                        localList.add(d);
                        continue;
                    }
                    linkedElementSet.add(linkedElement);
                    if (elementSet.contains(linkedElement)) {
                        propUtil.setCreatedByReference(d, true);
                        continue;
                    }
                    localList.add(d);
                    continue;
                }
                linkedElementSet.addAll(descriptors);
                break;
            }
        }
        for (MethodElement methodElement : elements) {
            if (linkedElementSet.contains(methodElement)) continue;
            excludeList.add(methodElement);
        }
        for (Descriptor descriptor : localList) {
            propUtil.addLocalUse(descriptor, ownerDescriptor, dFeature);
        }
    }

    private void convertGuidances(Process proc, Descriptor des) {
        MethodElement element = ProcessUtil.getAssociatedElement((Descriptor)des);
        if (element == null) {
            return;
        }
        Map refMap = LibraryEditUtil.getInstance().getGuidanceRefMap(SynFreeProcessConverter.getLinkedElementType(des));
        if (refMap == null) {
            return;
        }
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        HashSet elementGuidanceSet = new HashSet();
        HashSet descripGuidanceSet = new HashSet();
        for (Map.Entry entry : refMap.entrySet()) {
            List list;
            EReference elementRef = (EReference)entry.getKey();
            EReference descripRef = (EReference)entry.getValue();
            List elementValue = ConfigurationHelper.calc0nFeatureValue(element, (EStructuralFeature)elementRef, this.getRealizer());
            List descripValue = ConfigurationHelper.calc0nFeatureValue((MethodElement)des, (EStructuralFeature)descripRef, this.getRealizer());
            if (elementValue instanceof List) {
                Object rawDescripValue;
                list = elementValue;
                if (!list.isEmpty()) {
                    elementGuidanceSet.addAll(elementValue);
                }
                Object object = rawDescripValue = list.isEmpty() ? null : propUtil.eGet((EObject)des, (EStructuralFeature)descripRef, true);
                if (rawDescripValue instanceof List) {
                    List rawList = (List)rawDescripValue;
                    HashSet rewDescripGuidanceSet = new HashSet(rawList);
                    for (Guidance g : list) {
                        if (rewDescripGuidanceSet.contains(g)) continue;
                        rawList.add(g);
                    }
                }
            }
            if (!(descripValue instanceof List) || (list = descripValue).isEmpty()) continue;
            descripGuidanceSet.addAll(descripValue);
        }
        for (Guidance g : descripGuidanceSet) {
            if (elementGuidanceSet.contains(g)) continue;
            des.getGuidanceAdditional().add(g);
        }
    }

    private void convertRd(Process proc, RoleDescriptor rd) {
        Role role = (Role)this.getLinkedElement((Descriptor)rd);
        if (role == null) {
            return;
        }
        this.convertManyEReference(proc, (Descriptor)rd, (MethodElement)role, this.up.getRoleDescriptor_ResponsibleFor(), this.up.getRoleDescriptor_ResponsibleForExclude(), this.up.getRole_ResponsibleFor());
    }

    private void convertWpd(Process proc, WorkProductDescriptor wpd) {
        WorkProduct wp = (WorkProduct)this.getLinkedElement((Descriptor)wpd);
        if (wp == null) {
            return;
        }
        if (wp instanceof Deliverable) {
            this.convertManyEReference(proc, (Descriptor)wpd, (MethodElement)wp, this.up.getWorkProductDescriptor_DeliverableParts(), this.up.getWorkProductDescriptor_DeliverablePartsExclude(), this.up.getDeliverable_DeliveredWorkProducts());
        }
    }

    private void save() throws Exception {
        ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
        try {
            ArrayList<String> modifiedFiles = new ArrayList<String>();
            for (Resource res : this.resouresToSave) {
                String path = res.getURI().toFileString();
                modifiedFiles.add(path);
            }
            FileUtil.syncExecCheckModify(modifiedFiles);
            for (MultiFileXMIResourceImpl multiFileXMIResourceImpl : this.resouresToSave) {
                multiFileXMIResourceImpl.setModified(true);
                persister.save((Resource)multiFileXMIResourceImpl);
            }
            persister.commit();
        }
        catch (Exception e) {
            persister.rollback();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            String msg = "Cannot save file during converions. Likely caused by some file being read-only.";
            LibraryPlugin.getDefault().getLogger().logInfo(msg);
            throw e;
        }
    }

    private MethodElement getLinkedElement(Descriptor des) {
        MethodElement element = DescriptorPropUtil.getDesciptorPropUtil().getLinkedElement(des);
        if (element == null) {
            return null;
        }
        return ConfigurationHelper.getCalculatedElement(element, this.getRealizer());
    }

    public static EClass getLinkedElementType(Descriptor des) {
        if (des instanceof TaskDescriptor) {
            return UmaPackage.eINSTANCE.getTask();
        }
        if (des instanceof RoleDescriptor) {
            return UmaPackage.eINSTANCE.getRole();
        }
        if (des instanceof WorkProductDescriptor) {
            return UmaPackage.eINSTANCE.getWorkProduct();
        }
        throw new UnsupportedOperationException();
    }
}

