/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.jface.action.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedTypeContextMenuUtil {
    private static final UserDefinedTypeContextMenuUtil INSTNACE = new UserDefinedTypeContextMenuUtil();

    private UserDefinedTypeContextMenuUtil() {
    }

    public static UserDefinedTypeContextMenuUtil getInstance() {
        return INSTNACE;
    }

    public void addDescriptorsForUserDefinedType(Collection<Object> newChildDescriptors) {
        ILibraryManager libMgr = LibraryService.getInstance().getCurrentLibraryManager();
        Collection<UserDefinedTypeMeta> udtMetas = libMgr.getUserDefinedTypes();
        if (udtMetas == null) {
            return;
        }
        newChildDescriptors.add(new Separator());
        ArrayList<UserDefinedTypeMeta> udtMetaList = new ArrayList<UserDefinedTypeMeta>();
        for (UserDefinedTypeMeta udtMeta : udtMetas) {
            udtMetaList.add(udtMeta);
        }
        Collections.sort(udtMetaList, new UdtMetaComparator());
        try {
            for (UserDefinedTypeMeta udtMeta : udtMetaList) {
                Practice prac = UmaFactory.eINSTANCE.createPractice();
                PracticePropUtil.getPracticePropUtil().storeUtdData(prac, udtMeta);
                newChildDescriptors.add(new CommandParameter(null, (Object)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), (Object)prac));
            }
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UdtMetaComparator
    implements Comparator<UserDefinedTypeMeta> {
        private UdtMetaComparator() {
        }

        @Override
        public int compare(UserDefinedTypeMeta obj1, UserDefinedTypeMeta obj2) {
            String name1 = (String)obj1.getRteNameMap().get("typeName");
            String name2 = (String)obj2.getRteNameMap().get("typeName");
            return name1.compareTo(name2);
        }
    }
}

