/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.ValidationStatus;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.validation.ValidationAction;
import org.eclipse.epf.library.validation.ValidationManager;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.validation.LibraryEValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndeclaredDependencyCheck
extends ValidationAction {
    private Map<MethodPlugin, Set<MethodPlugin>> baseMap;
    private Map<MethodPlugin, Set<MethodPlugin>> problemPluginMap;
    private Map<String, Set<MethodElement>> problemElementMap;
    private boolean skipContent = true;

    public UndeclaredDependencyCheck(ValidationManager mgr) {
        super(mgr);
    }

    @Override
    public void run() {
        Set<MethodPlugin> pluginSet = this.getMgr().getPluginSet();
        if (pluginSet == null || pluginSet.isEmpty()) {
            return;
        }
        this.problemPluginMap = new HashMap<MethodPlugin, Set<MethodPlugin>>();
        this.problemElementMap = new HashMap<String, Set<MethodElement>>();
        this.baseMap = new HashMap<MethodPlugin, Set<MethodPlugin>>();
        Misc.clearCachedMap();
        for (MethodPlugin plugin : pluginSet) {
            HashSet baseSet = new HashSet();
            baseSet.addAll(Misc.getAllBase1((MethodPlugin)plugin));
            this.baseMap.put(plugin, baseSet);
        }
        Misc.clearCachedMap();
        HashSet<MethodElement> processed = new HashSet<MethodElement>();
        for (MethodPlugin plugin : pluginSet) {
            this.checkReferences((MethodElement)plugin, processed);
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.epf.library", 0, "", null);
        for (Map.Entry<MethodPlugin, Set<MethodPlugin>> entry : this.problemPluginMap.entrySet()) {
            MethodPlugin plugin = entry.getKey();
            Set<MethodPlugin> set = entry.getValue();
            String msg0 = LibraryResources.bind((String)LibraryResources.UndeclaredDep_MarkerTxt1, (Object[])new String[]{plugin.getName()});
            for (MethodPlugin p : set) {
                IMarker marker = this.getMgr().createMarker((MethodElement)plugin);
                String msg = String.valueOf(msg0) + " '" + p.getName() + "'";
                String key = String.valueOf(plugin.getGuid()) + p.getGuid();
                Set<MethodElement> elements = this.problemElementMap.get(key);
                if (elements != null && !elements.isEmpty()) {
                    String line2msg0;
                    String line2msg = line2msg0 = ". \n" + LibraryResources.UndeclaredDep_MarkerTxt2 + " ";
                    for (MethodElement e : elements) {
                        if (line2msg.length() > 155) {
                            line2msg = String.valueOf(line2msg) + " ... ";
                            break;
                        }
                        if (line2msg != line2msg0) {
                            line2msg = String.valueOf(line2msg) + "; ";
                        }
                        line2msg = String.valueOf(line2msg) + TngUtil.getLabelWithPath((Object)e);
                    }
                    msg = String.valueOf(msg) + line2msg;
                }
                try {
                    marker.setAttribute("message", (Object)msg);
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("location", (Object)TngUtil.getLabelWithPath((Object)plugin));
                    marker.setAttribute("validationType", (Object)"undeclaredDependancyCheck");
                    MarkerInfo markerInfo = new MarkerInfo(plugin, p, elements);
                    this.getMgr().addToMarkInfoMap(marker, markerInfo);
                    multiStatus.add((IStatus)new ValidationStatus(2, 0, LibraryResources.UndeclaredDep_MarkerTxt0, (Object)plugin, null));
                }
                catch (Exception e) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        LibraryEValidator.appendDiagnostics((IStatus)multiStatus, (DiagnosticChain)this.getMgr().getDiagnostics());
        this.problemPluginMap = null;
        this.problemElementMap = null;
        this.baseMap = null;
    }

    private void addToProblemPluginMap(MethodPlugin plugin, MethodPlugin referencedPlugin) {
        Set<MethodPlugin> set = this.problemPluginMap.get(plugin);
        if (set == null) {
            set = new HashSet<MethodPlugin>();
            this.problemPluginMap.put(plugin, set);
        }
        set.add(referencedPlugin);
    }

    private void checkReferences(MethodElement me, Set<MethodElement> processed) {
        if (processed.contains(me)) {
            return;
        }
        processed.add(me);
        MethodPlugin ownerPlugin = UmaUtil.getMethodPlugin((EObject)me);
        if (!this.getMgr().getPluginSet().contains(ownerPlugin)) {
            return;
        }
        Set<MethodPlugin> baseSet = this.baseMap.get(ownerPlugin);
        EList refList = me.eClass().getEAllReferences();
        if (refList == null || refList.isEmpty()) {
            return;
        }
        for (EReference ref : refList) {
            if (this.skipContent && LibraryUtil.isContentRef(ref) || ref == UmaPackage.eINSTANCE.getRole_Modifies() || ref == UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()) continue;
            Object obj = me.eGet((EStructuralFeature)ref);
            if (obj instanceof MethodElement) {
                MethodElement referenced = (MethodElement)obj;
                this.recordOneHit(me, ownerPlugin, baseSet, referenced);
                this.checkReferences(referenced, processed);
                continue;
            }
            if (!(obj instanceof List)) continue;
            List list = (List)obj;
            for (Object itemObj : list) {
                if (!(itemObj instanceof MethodElement)) continue;
                MethodElement referenced = (MethodElement)itemObj;
                this.recordOneHit(me, ownerPlugin, baseSet, referenced);
                this.checkReferences(referenced, processed);
            }
        }
    }

    private void recordOneHit(MethodElement me, MethodPlugin ownerPlugin, Set<MethodPlugin> baseSet, MethodElement referenced) {
        MethodPlugin referencedPlugin = UmaUtil.getMethodPlugin((EObject)referenced);
        if (referencedPlugin != null && referencedPlugin != ownerPlugin && !baseSet.contains(referencedPlugin)) {
            this.addToProblemPluginMap(ownerPlugin, referencedPlugin);
            String key = String.valueOf(ownerPlugin.getGuid()) + referencedPlugin.getGuid();
            Set<MethodElement> set = this.problemElementMap.get(key);
            if (set == null) {
                set = new HashSet<MethodElement>();
                this.problemElementMap.put(key, set);
            }
            set.add(me);
        }
    }

    @Override
    public void clearResults() {
    }

    public String addPluginFix(IMarker marker) {
        String emptyStr;
        block7: {
            MarkerInfo info;
            block6: {
                emptyStr = "";
                Object obj = this.getMgr().getMarkInfo(marker);
                MarkerInfo markerInfo = info = obj instanceof MarkerInfo ? (MarkerInfo)obj : null;
                if (info == null) {
                    return emptyStr;
                }
                if (info.referencing == null || info.referenced == null || info.referencing == info.referenced) {
                    return emptyStr;
                }
                if (Misc.isBaseOf((MethodPlugin)info.referencing, (MethodPlugin)info.referenced, new HashMap())) {
                    return LibraryEditResources.circular_dependency_error_msg;
                }
                info.referencing.getBases().add(info.referenced);
                Resource resource = info.referencing.eResource();
                if (resource == null) break block6;
                LibraryEditUtil.getInstance();
                if (LibraryEditUtil.save(Collections.singleton(resource))) break block7;
            }
            info.referencing.getBases().remove(info.referenced);
            LibraryPlugin.getDefault().getLogger().logError("addPluginFix falied at save");
            return emptyStr;
        }
        this.getMgr().removeFromMarkInfoMap(marker);
        return emptyStr;
    }

    public String removeReferenceFix(IMarker marker) {
        MarkerInfo info;
        String emptyStr = "";
        Object infoObj = this.getMgr().getMarkInfo(marker);
        MarkerInfo markerInfo = info = infoObj instanceof MarkerInfo ? (MarkerInfo)infoObj : null;
        if (info == null || info.referenced == null) {
            return emptyStr;
        }
        Set<MethodElement> offenderElements = info.offenderElements;
        if (offenderElements == null || offenderElements.isEmpty()) {
            return emptyStr;
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        for (MethodElement e : offenderElements) {
            Resource res = e.eResource();
            if (res == null) continue;
            resources.add(res);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        for (Resource res : resources) {
            pathList.add(res.getURI().toFileString());
        }
        IStatus status = FileManager.getInstance().checkModify(pathList.toArray(new String[pathList.size()]), LibraryPlugin.getDefault().getContext());
        if (!status.isOK()) {
            info.referencing.getBases().remove(info.referenced);
            LibraryPlugin.getDefault().getLogger().logError("addPluginFix falied at file check");
            return emptyStr;
        }
        for (MethodElement me : offenderElements) {
            EList refList = me.eClass().getEAllReferences();
            if (refList == null) continue;
            for (EReference ref : refList) {
                if (this.skipContent && LibraryUtil.isContentRef(ref) || ref == UmaPackage.eINSTANCE.getRole_Modifies()) continue;
                Object obj = me.eGet((EStructuralFeature)ref);
                if (obj instanceof MethodElement) {
                    MethodElement referenced = (MethodElement)obj;
                    if (info.referenced != UmaUtil.getMethodPlugin((EObject)referenced)) continue;
                    me.eSet((EStructuralFeature)ref, null);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                List list = (List)obj;
                int i = list.size() - 1;
                while (i >= 0) {
                    MethodElement referenced;
                    Object itemObj = list.get(i);
                    if (itemObj instanceof MethodElement && info.referenced == UmaUtil.getMethodPlugin((EObject)(referenced = (MethodElement)itemObj))) {
                        list.remove(i);
                    }
                    --i;
                }
            }
        }
        LibraryEditUtil.getInstance();
        if (!LibraryEditUtil.save(resources)) {
            info.referencing.getBases().remove(info.referenced);
            LibraryPlugin.getDefault().getLogger().logError("addPluginFix falied at save");
            return emptyStr;
        }
        this.getMgr().removeFromMarkInfoMap(marker);
        return emptyStr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MarkerInfo {
        MethodPlugin referencing;
        MethodPlugin referenced;
        Set<MethodElement> offenderElements;

        public MarkerInfo(MethodPlugin referencing, MethodPlugin referenced, Set<MethodElement> offenderElements) {
            this.referencing = referencing;
            this.referenced = referenced;
            this.offenderElements = offenderElements;
        }
    }
}

