/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.validation;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.validation.IValidationManager;
import org.eclipse.epf.library.validation.UndeclaredDependencyCheck;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.validation.LibraryEValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationManager
implements IValidationManager {
    private boolean nameCheck = false;
    private boolean circularDependancyCheck = false;
    private boolean undeclaredDependancyCheck = false;
    private IProgressMonitor progressMonitor;
    public static final String MARKER_ID = "org.eclipse.epf.library.validation";
    private UndeclaredDependencyCheck undeclaredDependencyCheck = this.newUndeclaredDependencyCheck();
    private ValidateAction emfValidateAction;
    private Map<IMarker, Object> markerInfoMap = new HashMap<IMarker, Object>();
    private DiagnosticChain diagnostics;
    public static final String validationType = "validationType";
    public static final String validationType_undeclaredDependancyCheck = "undeclaredDependancyCheck";
    private static ValidationManager instance;
    private Set<MethodPlugin> pluginSet;
    private static final Object dummyMarkInfo;

    static {
        dummyMarkInfo = new Object();
    }

    public DiagnosticChain getDiagnostics() {
        return this.diagnostics;
    }

    protected ValidationManager() {
    }

    public static IValidationManager getInstance() {
        if (instance == null) {
            Object obj = ExtensionHelper.create(ValidationManager.class, null);
            instance = obj instanceof ValidationManager ? (ValidationManager)obj : new ValidationManager();
        }
        return instance;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setNameCheck(boolean b) {
        this.nameCheck = b;
    }

    public void setCircularDependancyCheck(boolean b) {
        this.circularDependancyCheck = b;
    }

    public void setUndeclaredDependancyCheck(boolean b) {
        this.undeclaredDependancyCheck = b;
    }

    public boolean isNameCheck() {
        return this.nameCheck;
    }

    public boolean isCircularDependancyCheck() {
        return this.circularDependancyCheck;
    }

    public boolean isUndeclaredDepenancyCheck() {
        return this.undeclaredDependancyCheck;
    }

    public void clearAllMarkers() {
        for (IMarker marker : this.markerInfoMap.keySet()) {
            try {
                if (!marker.exists()) continue;
                marker.delete();
            }
            catch (CoreException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        this.markerInfoMap.clear();
        if (this.emfValidateAction != null) {
            this.emfValidateAction.updateSelection(null);
        }
    }

    public void validate(DiagnosticChain diagnostics, Object scope, IProgressMonitor progressMonitor) {
        this.diagnostics = diagnostics;
        this.progressMonitor = progressMonitor;
        this.initValidationScope(scope);
        try {
            this.clearAllMarkers();
            this.validate();
        }
        finally {
            this.progressMonitor = null;
            this.pluginSet = null;
        }
    }

    public Set<MethodPlugin> getPluginSet() {
        return this.pluginSet;
    }

    protected void initValidationScope(Object scope) {
        this.pluginSet = new LinkedHashSet<MethodPlugin>();
        if (scope instanceof MethodLibrary) {
            this.pluginSet.addAll(((MethodLibrary)scope).getMethodPlugins());
        } else if (scope instanceof List) {
            for (Object obj : (List)scope) {
                if (!(obj instanceof MethodPlugin)) continue;
                this.pluginSet.add((MethodPlugin)obj);
            }
        }
    }

    protected void validate() {
        this.clearResults();
        if (this.isUndeclaredDepenancyCheck()) {
            this.undeclaredDependencyCheck.run();
        }
    }

    private void clearResults() {
        this.undeclaredDependencyCheck.clearResults();
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        LibraryEValidator.appendDiagnostics((IStatus)status, (DiagnosticChain)diagnostics);
    }

    protected UndeclaredDependencyCheck newUndeclaredDependencyCheck() {
        return new UndeclaredDependencyCheck(this);
    }

    public IMarker createMarker(MethodElement element) {
        return this.createMarker(element, MARKER_ID);
    }

    public IMarker createMarker(MethodElement element, String markerId) {
        try {
            IFile file = ValidationManager.getFile(element);
            IMarker marker = file.createMarker(markerId);
            this.addToMarkInfoMap(marker, dummyMarkInfo);
            return marker;
        }
        catch (CoreException e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    private static IFile getFile(MethodElement element) {
        URI containerURI = element.eResource().getURI();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(containerURI.toFileString());
        IFile file = workspace.getRoot().getFileForLocation((IPath)path);
        return file;
    }

    public String UndeclaredDependencyCheckAddPluginFix(IMarker marker) {
        return this.undeclaredDependencyCheck.addPluginFix(marker);
    }

    public String UndeclaredDependencyCheckRemoveReferenceFix(IMarker marker) {
        return this.undeclaredDependencyCheck.removeReferenceFix(marker);
    }

    public void setEmfValidateAction(ValidateAction emfValidateAction) {
        this.emfValidateAction = emfValidateAction;
    }

    public void addToMarkInfoMap(IMarker marker, Object obj) {
        this.markerInfoMap.put(marker, obj);
    }

    public Object getMarkInfo(IMarker marker) {
        return this.markerInfoMap.get(marker);
    }

    public void removeFromMarkInfoMap(IMarker marker) {
        this.markerInfoMap.remove(marker);
        try {
            if (marker.exists()) {
                marker.delete();
            }
        }
        catch (CoreException e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }
}

