/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.map;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.migration.diagram.ad.map.ActivityMapNode;
import org.eclipse.epf.migration.diagram.ad.map.ActivityParameterMapeNode;
import org.eclipse.epf.migration.diagram.ad.map.DecisionNodeMap;
import org.eclipse.epf.migration.diagram.ad.map.FinalNodeMap;
import org.eclipse.epf.migration.diagram.ad.map.ForkNodeMap;
import org.eclipse.epf.migration.diagram.ad.map.InitialNodeMap;
import org.eclipse.epf.migration.diagram.ad.map.JoinNodeMap;
import org.eclipse.epf.migration.diagram.ad.map.MapNode;
import org.eclipse.epf.migration.diagram.ad.map.MergeNodeMap;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TaskDescriptor;

public class MapFactory {
    Map map = new HashMap();
    static MapFactory factory = null;

    public static MapFactory getInstance() {
        if (factory == null) {
            factory = new MapFactory();
        }
        return factory;
    }

    public MapNode create(Node node) {
        int classifier = node.eClass().getClassifierID();
        switch (classifier) {
            case 15: {
                return this.createWorkBreakDownElementNode(node);
            }
            case 6: {
                TypedNode typedNode = (TypedNode)node;
                if (typedNode.getType() == 2) {
                    EList incomingConnections = typedNode.getIncomingConnections();
                    if (incomingConnections.size() > 1) {
                        return this.createMergeNode(node);
                    }
                    return this.createDecisionNode(node);
                }
                if (typedNode.getType() == 3) {
                    return this.createInitialNode(node);
                }
                if (typedNode.getType() == 4) {
                    return this.createFinalNode(node);
                }
                if (typedNode.getType() == 1) {
                    EList incomingConnections = typedNode.getIncomingConnections();
                    if (incomingConnections.size() > 1) {
                        return this.createJoinNode(node);
                    }
                    return this.createForkNode(node);
                }
                if (typedNode.getType() == 6) {
                    return this.createFreeTextNode(node);
                }
            }
            case 1: {
                return this.createControlFlow(node);
            }
        }
        throw new IllegalArgumentException("The class '" + node.eClass().getName() + "' is not a valid classifier");
    }

    private MapNode createWorkBreakDownElementNode(Node node) {
        Object obj = node.getObject();
        if (obj instanceof Activity) {
            return new ActivityMapNode(node);
        }
        if (obj instanceof TaskDescriptor || obj instanceof Milestone) {
            return new ActivityParameterMapeNode(node);
        }
        return null;
    }

    private MapNode createFreeTextNode(Node node) {
        return null;
    }

    private MapNode createFinalNode(Node node) {
        return new FinalNodeMap(node);
    }

    private MapNode createInitialNode(Node node) {
        return new InitialNodeMap(node);
    }

    private MapNode createControlFlow(Node node) {
        return null;
    }

    private MapNode createMergeNode(Node node) {
        return new MergeNodeMap(node);
    }

    private MapNode createJoinNode(Node node) {
        return new JoinNodeMap(node);
    }

    private MapNode createDecisionNode(Node node) {
        return new DecisionNodeMap(node);
    }

    private MapNode createForkNode(Node node) {
        return new ForkNodeMap(node);
    }
}

