/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.map;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.epf.diagram.model.WorkProductNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.Property;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class MapUtil {
    public static Node createNotationNode_AD(Diagram diagram, Object obj) {
        ActivityNode umlNode;
        Node notationNode = null;
        ActivityNode activityNode = umlNode = obj instanceof ActivityNode ? (ActivityNode)obj : null;
        if (umlNode instanceof StructuredActivityNode) {
            String type = BridgeHelper.getEAnnotationType((EModelElement)umlNode, (String)"type");
            if (type.equalsIgnoreCase("Phase")) {
                notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1010).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4009).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            } else if (type.equalsIgnoreCase("Iteration")) {
                notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1011).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4010).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            } else {
                notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1007).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4005).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            }
            MapUtil.setDefaultFontStyle(notationNode);
        } else if (umlNode instanceof InitialNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1004).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4003).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (umlNode instanceof DecisionNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1005).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4004).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (umlNode instanceof MergeNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1002).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4002).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (umlNode instanceof ForkNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1003).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (umlNode instanceof JoinNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1006).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (umlNode instanceof FinalNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1001).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4001).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (umlNode instanceof ActivityParameterNode) {
            String type = BridgeHelper.getEAnnotationType((EModelElement)umlNode, (String)"type");
            if (type.equalsIgnoreCase("Milestone")) {
                notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1012).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4011).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            } else if (type.equalsIgnoreCase("Task")) {
                notationNode = ViewService.createNode((View)diagram, (EObject)umlNode, (String)new Integer(1009).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                ViewService.createNode((View)notationNode, (EObject)umlNode, (String)new Integer(4008).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            }
            MapUtil.setDefaultFontStyle(notationNode);
        }
        return notationNode;
    }

    public static Node createNotationNode_ADDorWPD(Diagram diagram, org.eclipse.epf.diagram.model.Node obj) {
        org.eclipse.epf.diagram.model.Node node;
        Node notationNode = null;
        Object object = node = obj instanceof org.eclipse.epf.diagram.model.Node ? obj : null;
        if (node instanceof RoleTaskComposite) {
            notationNode = ViewService.createNode((View)diagram, (EObject)node, (String)new Integer(1001).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (node instanceof WorkProductComposite) {
            notationNode = ViewService.createNode((View)diagram, (EObject)node, (String)new Integer(1002).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        } else if (node instanceof WorkProductNode) {
            notationNode = ViewService.createNode((View)diagram, (EObject)node, (String)new Integer(1001).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)notationNode, (EObject)node, (String)new Integer(4001).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        }
        MapUtil.setDefaultFontStyle(notationNode);
        return notationNode;
    }

    public static Node createText(Diagram diagram, org.eclipse.epf.diagram.model.Node node) {
        LineStyle lineStyle;
        Node text = ViewService.createNode((View)diagram, (String)ViewType.TEXT, (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        ViewService.createNode((View)text, (String)ViewType.DIAGRAM_NAME, (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        ViewService.createNode((View)text, (String)"Description", (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        GraphNode graphNode = (GraphNode)node.getObject();
        String description = "";
        Property prop = GraphicalDataHelper.getPropertyByKey((List)graphNode.getProperty(), (String)"free text");
        if (prop != null) {
            description = prop.getValue();
        }
        DescriptionStyle descStyle = (DescriptionStyle)text.getStyle(NotationPackage.Literals.DESCRIPTION_STYLE);
        descStyle.setDescription(description);
        IPreferenceStore store = (IPreferenceStore)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT.getPreferenceStore();
        FillStyle fillStyle = (FillStyle)text.getStyle(NotationPackage.Literals.FILL_STYLE);
        if (fillStyle != null) {
            RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"Appearance.fillColor");
            fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        }
        if ((lineStyle = (LineStyle)text.getStyle(NotationPackage.Literals.LINE_STYLE)) != null) {
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"Appearance.lineColor");
            lineStyle.setLineColor(FigureUtilities.RGBToInteger((RGB)lineRGB).intValue());
        }
        FontStyle fontStyle = (FontStyle)text.getStyle(NotationPackage.Literals.FONT_STYLE);
        Font oldFont = null;
        if (fontStyle != null) {
            String fontName = MapUtil.getPropertyValue(graphNode, "property_font_name");
            if (fontName == null) {
                fontName = TemplateConstants.DEFAULT_FONT_NAME;
            }
            String oldFontStyleStr = MapUtil.getPropertyValue(graphNode, "property_font_style");
            String fontHeightStr = MapUtil.getPropertyValue(graphNode, "property_font_height");
            String fontRed = MapUtil.getPropertyValue(graphNode, "property_font_red");
            String fontGreen = MapUtil.getPropertyValue(graphNode, "property_font_green");
            String fontBlue = MapUtil.getPropertyValue(graphNode, "property_font_blue");
            int red = 0;
            int green = 0;
            int blue = 0;
            if (fontName != null) {
                fontStyle.setFontName(fontName);
            }
            int oldFontStyle = 0;
            if (oldFontStyleStr != null) {
                oldFontStyle = new Integer(oldFontStyleStr);
                if (oldFontStyle == 1) {
                    fontStyle.setBold(true);
                }
                if (oldFontStyle == 2) {
                    fontStyle.setItalic(true);
                }
                if (oldFontStyle == 3) {
                    fontStyle.setBold(true);
                    fontStyle.setItalic(true);
                }
            }
            int fontHeight = 8;
            if (fontHeightStr != null) {
                fontHeight = new Integer(fontHeightStr);
            }
            fontStyle.setFontHeight(fontHeight);
            if (fontRed != null) {
                red = new Integer(fontRed);
            }
            if (fontGreen != null) {
                green = new Integer(fontGreen);
            }
            if (fontBlue != null) {
                blue = new Integer(fontBlue);
            }
            RGB fontRGB = new RGB(red, green, blue);
            fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
            oldFont = new Font(null, fontName, fontHeight, oldFontStyle);
        }
        Dimension d = FigureUtilities.getTextExtents((String)description, oldFont);
        if (oldFont != null) {
            oldFont.dispose();
        }
        if (d != null && d.width > 0 && node.getWidth() != -1) {
            int div = d.width / node.getWidth();
            int cfr_ignored_0 = d.width % node.getWidth();
            ++div;
        }
        int cfr_ignored_1 = d.height;
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        if (node.getWidth() == -1) {
            int textWidth = d.width;
            bounds.setWidth(textWidth);
        } else {
            bounds.setWidth(node.getWidth());
        }
        bounds.setX(node.getLocation().x);
        bounds.setY(node.getLocation().y);
        text.setLayoutConstraint((LayoutConstraint)bounds);
        return text;
    }

    public static Edge createEdge_AD(Node sourceNode, Node targetNode, ActivityEdge actEdge) {
        if (actEdge instanceof ControlFlow) {
            Edge edge = ViewService.createEdge((View)sourceNode, (View)targetNode, (EObject)actEdge, (String)new Integer(3001).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)edge, (EObject)actEdge, (String)new Integer(4012).toString(), (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            return edge;
        }
        return null;
    }

    public static Edge createEdge_WPD(Node sourceNode, Node targetNode, EObject actEdge) {
        if (actEdge instanceof Link) {
            Edge edge = ViewService.createEdge((View)sourceNode, (View)targetNode, (EObject)actEdge, (String)new Integer(3001).toString(), (PreferencesHint)WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)edge, (EObject)actEdge, (String)new Integer(3001).toString(), (PreferencesHint)WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            return edge;
        }
        return null;
    }

    public static Edge createEdge_ADD(Node sourceNode, Node targetNode, EObject actEdge) {
        if (actEdge instanceof Link) {
            Edge edge = ViewService.createEdge((View)sourceNode, (View)targetNode, (EObject)actEdge, (String)new Integer(3001).toString(), (PreferencesHint)ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            ViewService.createNode((View)edge, (EObject)actEdge, (String)new Integer(3001).toString(), (PreferencesHint)ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            return edge;
        }
        return null;
    }

    private static String getPropertyValue(GraphNode graphNode, String key) {
        Property prop = GraphicalDataHelper.getPropertyByKey((List)graphNode.getProperty(), (String)key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public static int getNoOfLines(Node node) {
        int noOfLines = 1;
        if (node.getElement() != null && node.getElement() instanceof NamedElement) {
            String text = ((NamedElement)node.getElement()).getName();
            Font f = TemplateConstants.DEFAULT_FONT;
            Dimension d = FigureUtilities.getTextExtents((String)text, (Font)f);
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            if (d != null && d.width > 0) {
                int div = d.width / bounds.getWidth();
                int mod = d.width % bounds.getWidth();
                if (mod != 0) {
                    ++div;
                }
                noOfLines = div;
            }
        }
        return noOfLines;
    }

    public static int getTextHeight(Node node) {
        Font f;
        String text;
        Dimension d;
        if (node.getElement() != null && node.getElement() instanceof NamedElement && (d = FigureUtilities.getTextExtents((String)(text = ((NamedElement)node.getElement()).getName()), (Font)(f = TemplateConstants.DEFAULT_FONT))) != null) {
            return d.height;
        }
        return 0;
    }

    public static String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append((float)p.preciseX);
        s.append(',');
        s.append((float)p.preciseY);
        s.append(')');
        return s.toString();
    }

    public static PrecisionPoint getAnchorRelativeLocation(Point p, Bounds bounds) {
        PrecisionPoint relLocation;
        Point temp = new Point(p);
        if (p.x < bounds.getX() || p.x > bounds.getX() + bounds.getWidth() || p.y < bounds.getY() || p.y > bounds.getY() + bounds.getHeight()) {
            if (p.x < bounds.getX() || p.x > bounds.getX() + bounds.getWidth()) {
                int n = temp.x = p.x < bounds.getX() ? bounds.getX() : bounds.getX() + bounds.getWidth();
            }
            if (p.y < bounds.getY() || p.y > bounds.getY() + bounds.getHeight()) {
                temp.y = p.y < bounds.getY() ? bounds.getY() : bounds.getY() + bounds.getHeight();
            }
            relLocation = new PrecisionPoint((double)(temp.x - bounds.getX()) / (double)bounds.getWidth(), (double)(temp.y - bounds.getY()) / (double)bounds.getHeight());
        } else {
            relLocation = new PrecisionPoint((double)(temp.x - bounds.getX()) / (double)bounds.getWidth(), (double)(temp.y - bounds.getY()) / (double)bounds.getHeight());
        }
        return relLocation;
    }

    private static void setDefaultFontStyle(Node notationNode) {
        FontStyle fontStyle = (FontStyle)notationNode.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (fontStyle != null) {
            String fontName = TemplateConstants.DEFAULT_FONT_NAME;
            if (fontName != null) {
                fontStyle.setFontName(fontName);
            }
            int fontHeight = 8;
            fontStyle.setFontHeight(fontHeight);
        }
    }
}

