/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.model.util.DiagramModelPreference;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ActivityDiagramPreferencePage
extends BasePreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    Composite composite;
    int NUM_COLUMN = 3;
    private static int MIN_TASKS_PER_ROW = 1;
    private static int MAX_TASKS_PER_ROW = 20;
    private Button ctrl_publish_unopen_activitydd;
    private Button ctrl_publish_ad_for_activity_extension;
    private Text tasksPerRowText;
    private Button ctrl_use_state_on_workproduct;

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group activityDiagramGroup = ActivityDiagramPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.preference_Activity_Diagram, (int)1);
        this.ctrl_publish_ad_for_activity_extension = ActivityDiagramPreferencePage.createCheckbox((Composite)activityDiagramGroup, (String)AuthoringUIResources.prompt_for_publish_extend_activity_diagram);
        Group activityDetailDiagramGroup = ActivityDiagramPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.preference_Activity_Detail_Diagram, (int)2);
        this.ctrl_publish_unopen_activitydd = ActivityDiagramPreferencePage.createCheckbox((Composite)activityDetailDiagramGroup, (String)AuthoringUIResources.promptfor_publish_unopen_activitydd_text, (int)2);
        ActivityDiagramPreferencePage.createLabel((Composite)activityDetailDiagramGroup, (String)AuthoringUIResources.add_TasksperRow);
        this.tasksPerRowText = ActivityDiagramPreferencePage.createEditableText((Composite)activityDetailDiagramGroup, (String)"");
        this.ctrl_use_state_on_workproduct = ActivityDiagramPreferencePage.createCheckbox((Composite)activityDetailDiagramGroup, (String)AuthoringUIResources.use_state_on_workproduct_text, (int)2);
        this.initializeValues();
        this.addListeners();
        return this.composite;
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        LibraryUIPlugin.getDefault().savePluginPreferences();
        PublishingUIPlugin.getDefault().updateLayoutSettings();
        AuthoringUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        AuthoringUIPreferences.setADDTasksPerRow((int)this.getTasksPerRow());
        LibraryUIPreferences.setPublishUnopenActivitydd((boolean)this.ctrl_publish_unopen_activitydd.getSelection());
        LibraryUIPreferences.setPublishADForActivityExtension((boolean)this.ctrl_publish_ad_for_activity_extension.getSelection());
        DiagramModelPreference.setUseStateOnWorkproduct((boolean)this.ctrl_use_state_on_workproduct.getSelection());
    }

    private void initializeDefaults() {
        this.ctrl_publish_unopen_activitydd.setSelection(false);
        this.ctrl_publish_ad_for_activity_extension.setSelection(true);
        this.tasksPerRowText.setText(String.valueOf(AuthoringUIPreferences.getDefaultADDTasksPerRow()));
        this.ctrl_use_state_on_workproduct.setSelection(false);
    }

    private void initializeValues() {
        this.ctrl_publish_unopen_activitydd.setSelection(LibraryUIPreferences.getPublishUnopenActivitydd());
        this.ctrl_publish_ad_for_activity_extension.setSelection(LibraryUIPreferences.getPublishADForActivityExtension());
        this.tasksPerRowText.setText(String.valueOf(AuthoringUIPreferences.getADD_TasksPerRow()));
        this.ctrl_use_state_on_workproduct.setSelection(DiagramModelPreference.getUseStateOnWorkproduct());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LibraryUIPlugin.getDefault().getPreferenceStore();
    }

    protected void addListeners() {
        this.tasksPerRowText.addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent e) {
        this.setErrorMessage(null);
        this.setValid(true);
        int value = 0;
        if (e.widget == this.tasksPerRowText && ((value = this.getTasksPerRow()) < MIN_TASKS_PER_ROW || value > MAX_TASKS_PER_ROW)) {
            this.setErrorMessage(AuthoringUIResources.bind((String)AuthoringUIResources.invalidTaskperRow_msg, (Object[])new Object[]{new Integer(MIN_TASKS_PER_ROW), new Integer(MAX_TASKS_PER_ROW)}));
            this.setValid(false);
        }
        this.updateApplyButton();
    }

    protected int getTasksPerRow() {
        return StrUtil.getIntValue((String)this.tasksPerRowText.getText().trim(), (int)0);
    }
}

