/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import java.util.List;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishingUIPreferences {
    private static final String PUBLISH_ENTIRE_CONFIG = "publishEntireConfig";
    private static final String PUBLISH_PROCESSES = "publishProcesses";
    private static final String PUBLISH_INCLUDE_BASE_PROCESS = "publishIncludeBaseProcess";
    private static final String TITLE = "title";
    private static final String BANNER_IMAGE = "bannerImage";
    private static final String ABOUT_HTML = "aboutHTML";
    private static final String FEEDBACK_URL = "feedbackURL";
    private static final String FORBIDDEN_CHARS = "fobiddenChars";
    private static final String INCLUDE_GLOSSARY = "includeGlossary";
    private static final String INCLUDE_INDEX = "includeIndex";
    private static final String CHECK_EXTERNAL_LINKS = "checkExternalLinks";
    private static final String CONVERT_BROKEN_LINKS = "convertBrokenLinks";
    private static final String LIGHT_WEIGHT_TREE = "lightWeightTree";
    private static final String EXTRA_DESCRIPTOR_INFO = "extraDescriptorInfo";
    private static final String SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR = "showLinkedElementForDescriptor";
    private static final String Ignore_Dynamic_Parents = "ignoreDynamicParents";
    private static final String Exclude_Unused_WPDs = "excludeUnusedWPDs";
    private static final String FULFILL_DESCRIPTOR_SLOT_BY_CONTENT = "fulfillDescriptorSlotByContent";
    private static final String PUBLISH_UNOPEN_ACTIVITY_DD = "publishUnopenActivityDD";
    private static final String PUBLISH_AD_FOR_ACTIVITY_EXTENSION = "publishADForActivityExtension";
    private static final String PUBLISH_PATH = "publishPath";
    private static final String PUBLISH_STATIC_WEB_SITE = "publishStaticWebSite";
    private static final String INCLUDE_SERVLET_SEARCH = "includeServletSearch";
    private static final String WEBAPP_NAME = "webAppName";
    private static final String INCLUDE_SEARCH = "includeSearch";
    private static final String INITIALIZED = "initialized";
    private static final String SHOW_RELATED_DESCRIPTORS = "showRelatedDescriptors";
    private static final String SHOW_RELATED_LINKS = "showRelatedLinks";
    private static final String SHOW_RELATED_DESCRIPTORS_OPTION = "showRelatedDescriptorsOption";
    private static final String SHOW_DESCRIPTORS_IN_NAVIGATIONTREE = "showDescriptorsInNavigationTree";
    private static final String DEFAULT_ACTIVITY_TAB = "defaultActivityTab";
    private static final String DEFAULT_PUBLISH_FOLDER_NAME = "Publish";
    private static String defaultTitle = null;
    private static String defaultBannerImage = null;
    private static String defaultAboutHTML = null;
    private static String defaultFeedbackURL = null;
    private static String defaultPublishPath = null;
    private static IPreferenceStore prefStore = PublishingUIPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(PUBLISH_ENTIRE_CONFIG, true);
        prefStore.setDefault(TITLE, PublishingUIPreferences.getDefaultTitle());
        prefStore.setDefault(BANNER_IMAGE, PublishingUIPreferences.getDefaultBannerImage());
        prefStore.setDefault(ABOUT_HTML, PublishingUIPreferences.getDefaultAboutHTML());
        prefStore.setDefault(FEEDBACK_URL, PublishingUIPreferences.getDefaultFeedbackURL());
        prefStore.setDefault(FORBIDDEN_CHARS, PublishingUIPreferences.getDefaultForbiddenChars());
        prefStore.setDefault(INCLUDE_GLOSSARY, false);
        prefStore.setDefault(INCLUDE_INDEX, false);
        prefStore.setDefault(CHECK_EXTERNAL_LINKS, false);
        prefStore.setDefault(CONVERT_BROKEN_LINKS, false);
        prefStore.setDefault(PUBLISH_UNOPEN_ACTIVITY_DD, false);
        prefStore.setDefault(PUBLISH_AD_FOR_ACTIVITY_EXTENSION, true);
        prefStore.setDefault(LIGHT_WEIGHT_TREE, true);
        prefStore.setDefault(EXTRA_DESCRIPTOR_INFO, PublishingUIPreferences.getDefaultExtraDescriptorInfo());
        prefStore.setDefault(SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR, PublishingUIPreferences.getDefaultShowLinkedElementForDescriptor());
        prefStore.setDefault(Ignore_Dynamic_Parents, PublishingUIPreferences.getDefaultIgnoreDynamicParents());
        prefStore.setDefault(Exclude_Unused_WPDs, PublishingUIPreferences.getDefaultExcludeUnusedWPDs());
        prefStore.setDefault(FULFILL_DESCRIPTOR_SLOT_BY_CONTENT, PublishingUIPreferences.getDefaultFulfillDescriptorSlotByContent());
        prefStore.setDefault(DEFAULT_ACTIVITY_TAB, "WBS");
        prefStore.setDefault(PUBLISH_PATH, PublishingUIPreferences.getDefaultPublishPath());
        prefStore.setDefault(PUBLISH_STATIC_WEB_SITE, false);
        prefStore.setDefault(INCLUDE_SERVLET_SEARCH, true);
        prefStore.setDefault(WEBAPP_NAME, "rmcwebsite");
        prefStore.setDefault(INCLUDE_SEARCH, true);
    }

    public static boolean getPublishEntireConfig(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_ENTIRE_CONFIG);
        }
        return prefStore.getBoolean(PUBLISH_ENTIRE_CONFIG);
    }

    public static void setPublishEntireConfig(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_ENTIRE_CONFIG, value);
    }

    public static void removePublishEntireConfig(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_ENTIRE_CONFIG);
    }

    public static List<String> getProcesses(String configId) {
        String guidStr = prefStore.getString(String.valueOf(configId) + PUBLISH_PROCESSES);
        return TngUtil.convertStringsToList((String)guidStr);
    }

    public static void setProcesses(String configId, List<String> guidList) {
        String guidStr = TngUtil.convertListToString(guidList);
        prefStore.setValue(String.valueOf(configId) + PUBLISH_PROCESSES, guidStr);
    }

    public static Boolean getIncludeBaseProcesses(String configId) {
        return prefStore.getBoolean(String.valueOf(configId) + PUBLISH_INCLUDE_BASE_PROCESS);
    }

    public static void setIncludeBaseProcesses(String configId, boolean value) {
        prefStore.setValue(String.valueOf(configId) + PUBLISH_INCLUDE_BASE_PROCESS, value);
    }

    public static String getDefaultTitle() {
        if (defaultTitle == null) {
            String url = PublishingUIPlugin.getDefault().getString(TITLE);
            if (url == null || url.length() == 0 || url.startsWith("[")) {
                url = "";
            }
            defaultTitle = url;
        }
        return defaultTitle;
    }

    public static String getTitle(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + TITLE);
        }
        return prefStore.getString(TITLE);
    }

    public static void setTitle(String configId, String title) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + TITLE, title);
    }

    public static void removeTitle(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + TITLE);
    }

    public static String getDefaultBannerImage() {
        if (defaultBannerImage == null) {
            String image = PublishingUIPlugin.getDefault().getString(BANNER_IMAGE);
            if (image == null || image.length() == 0 || image.startsWith("[")) {
                image = "";
            }
            defaultBannerImage = image;
        }
        return defaultBannerImage;
    }

    public static String getBannerImage(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + BANNER_IMAGE);
        }
        return prefStore.getString(BANNER_IMAGE);
    }

    public static void setBannerImage(String configId, String image) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + BANNER_IMAGE, image);
    }

    public static void removeBannerImage(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + BANNER_IMAGE);
    }

    public static String getDefaultAboutHTML() {
        if (defaultAboutHTML == null) {
            String file = PublishingUIPlugin.getDefault().getString(ABOUT_HTML);
            if (file == null || file.length() == 0 || file.startsWith("[")) {
                file = "";
            }
            defaultAboutHTML = file;
        }
        return defaultAboutHTML;
    }

    public static String getAboutHTML(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + ABOUT_HTML);
        }
        return prefStore.getString(ABOUT_HTML);
    }

    public static void setAboutHTML(String configId, String path) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + ABOUT_HTML, path);
    }

    public static void removeAboutHTML(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + ABOUT_HTML);
    }

    public static String getDefaultFeedbackURL() {
        if (defaultFeedbackURL == null) {
            defaultFeedbackURL = "http://www.published_website.com/feedback";
        }
        return defaultFeedbackURL;
    }

    public static String getDefaultForbiddenChars() {
        return "";
    }

    public static String getForbiddenChars() {
        return prefStore.getString(FORBIDDEN_CHARS);
    }

    public static void setForbiddenChars(String value) {
        prefStore.setValue(FORBIDDEN_CHARS, value);
    }

    public static String getFeedbackURL() {
        return prefStore.getString(FEEDBACK_URL);
    }

    public static void setFeedbackURL(String url) {
        prefStore.setValue(FEEDBACK_URL, url);
    }

    public static String getFeedbackURL(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + FEEDBACK_URL);
        }
        return prefStore.getString(FEEDBACK_URL);
    }

    public static void setFeedbackURL(String configId, String url) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + FEEDBACK_URL, url);
    }

    public static void removeFeedbackURL(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + FEEDBACK_URL);
    }

    public static boolean getIncludeGlossary(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_GLOSSARY);
        }
        return prefStore.getBoolean(INCLUDE_GLOSSARY);
    }

    public static void setIncludeGlossary(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_GLOSSARY, value);
    }

    public static void removeIncludeGlossary(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_GLOSSARY);
    }

    public static boolean getIncludeIndex(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_INDEX);
        }
        return prefStore.getBoolean(INCLUDE_INDEX);
    }

    public static void setIncludeIndex(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_INDEX, value);
    }

    public static void removeIncludeIndex(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_INDEX);
    }

    public static boolean getCheckExternalLinks(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + CHECK_EXTERNAL_LINKS);
        }
        return prefStore.getBoolean(CHECK_EXTERNAL_LINKS);
    }

    public static void setCheckExternalLinks(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + CHECK_EXTERNAL_LINKS, value);
    }

    public static void removeCheckExternalLinks(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + CHECK_EXTERNAL_LINKS);
    }

    public static boolean getConvertBrokenLinks(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + CONVERT_BROKEN_LINKS);
        }
        return prefStore.getBoolean(CONVERT_BROKEN_LINKS);
    }

    public static void setConvertBrokenLinks(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + CONVERT_BROKEN_LINKS, value);
    }

    public static void removeConvertBrokenLinks(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + CONVERT_BROKEN_LINKS);
    }

    public static boolean getPublishUnopenActivityDD(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_UNOPEN_ACTIVITY_DD);
        }
        return prefStore.getBoolean(PUBLISH_UNOPEN_ACTIVITY_DD);
    }

    public static void setPublishUnopenActivityDD(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_UNOPEN_ACTIVITY_DD, value);
    }

    public static void removePublishUnopenActivityDD(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_UNOPEN_ACTIVITY_DD);
    }

    public static boolean getPublishADForActivityExtension(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_AD_FOR_ACTIVITY_EXTENSION);
        }
        return prefStore.getBoolean(PUBLISH_AD_FOR_ACTIVITY_EXTENSION);
    }

    public static void setPublishADForActivityExtension(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_AD_FOR_ACTIVITY_EXTENSION, value);
    }

    public static void removePublishADForActivityExtension(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_AD_FOR_ACTIVITY_EXTENSION);
    }

    public static boolean getLightWeightTree(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + LIGHT_WEIGHT_TREE);
        }
        return prefStore.getBoolean(LIGHT_WEIGHT_TREE);
    }

    public static void setLightWeightTree(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + LIGHT_WEIGHT_TREE, value);
    }

    public static void removeLightWeightTree(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + LIGHT_WEIGHT_TREE);
    }

    public static boolean getDefaultExtraDescriptorInfo() {
        return false;
    }

    public static boolean getExtraDescriptorInfo() {
        return prefStore.getBoolean(EXTRA_DESCRIPTOR_INFO);
    }

    public static boolean getDefaultShowLinkedElementForDescriptor() {
        return false;
    }

    public static void setShowLinkedElementForDescriptor(boolean value) {
        prefStore.setValue(SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR, value);
    }

    public static boolean getShowLinkedElementForDescriptor() {
        return prefStore.getBoolean(SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR);
    }

    public static void setIgnoreDynamicParents(boolean value) {
        prefStore.setValue(Ignore_Dynamic_Parents, value);
    }

    public static boolean getDefaultIgnoreDynamicParents() {
        return true;
    }

    public static boolean getIgnoreDynamicParents() {
        return prefStore.getBoolean(Ignore_Dynamic_Parents);
    }

    public static void setExcludeUnusedWPDs(boolean value) {
        prefStore.setValue(Exclude_Unused_WPDs, value);
    }

    public static boolean getDefaultExcludeUnusedWPDs() {
        return false;
    }

    public static boolean getExcludeUnusedWPDs() {
        return prefStore.getBoolean(Exclude_Unused_WPDs);
    }

    public static void setExtraDescriptorInfo(boolean value) {
        prefStore.setValue(EXTRA_DESCRIPTOR_INFO, value);
    }

    public static boolean getDefaultFulfillDescriptorSlotByContent() {
        return false;
    }

    public static boolean getFulfillDescriptorSlotByContent() {
        return prefStore.getBoolean(FULFILL_DESCRIPTOR_SLOT_BY_CONTENT);
    }

    public static void setFulfillDescriptorSlotByContent(boolean value) {
        prefStore.setValue(FULFILL_DESCRIPTOR_SLOT_BY_CONTENT, value);
    }

    public static boolean getExtraDescriptorInfo(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + EXTRA_DESCRIPTOR_INFO);
        }
        return prefStore.getBoolean(EXTRA_DESCRIPTOR_INFO);
    }

    public static void setExtraDescriptorInfo(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + EXTRA_DESCRIPTOR_INFO, value);
    }

    public static void removeExtraDescriptorInfo(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + EXTRA_DESCRIPTOR_INFO);
    }

    public static String getDefaultPublishPath() {
        if (defaultPublishPath == null) {
            defaultPublishPath = System.getProperty("user.home");
            String appName = LibraryUIPreferences.getApplicationShortName();
            defaultPublishPath = appName != null && appName.length() > 0 ? String.valueOf(defaultPublishPath) + FileUtil.FILE_SEP + appName + FileUtil.FILE_SEP + DEFAULT_PUBLISH_FOLDER_NAME : String.valueOf(defaultPublishPath) + FileUtil.FILE_SEP + DEFAULT_PUBLISH_FOLDER_NAME;
        }
        return defaultPublishPath;
    }

    public static String getPublishPath() {
        return prefStore.getString(PUBLISH_PATH);
    }

    public static void setPublishPath(String path) {
        prefStore.setValue(PUBLISH_PATH, path);
    }

    public static String getPublishPath(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_PATH);
        }
        return prefStore.getString(PUBLISH_PATH);
    }

    public static void setPublishPath(String configId, String path) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_PATH, path);
    }

    public static void removePublishPath(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_PATH);
    }

    public static boolean getPublishStaticWebSite(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_STATIC_WEB_SITE);
        }
        return prefStore.getBoolean(PUBLISH_STATIC_WEB_SITE);
    }

    public static void setPublishStaticWebSite(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_STATIC_WEB_SITE, value);
    }

    public static void removePublishStaticWebSite(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + PUBLISH_STATIC_WEB_SITE);
    }

    public static boolean getIncludeServletSearch(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_SERVLET_SEARCH);
        }
        return prefStore.getBoolean(INCLUDE_SERVLET_SEARCH);
    }

    public static void setIncludeServletSearch(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_SERVLET_SEARCH, value);
    }

    public static void removeIncludeServletSearch(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_SERVLET_SEARCH);
    }

    public static boolean getIncludeSearch(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_SEARCH);
        }
        return prefStore.getBoolean(INCLUDE_SEARCH);
    }

    public static void setIncludeSearch(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_SEARCH, value);
    }

    public static void removeIncludeSearch(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INCLUDE_SEARCH);
    }

    public static String getWebAppName(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + WEBAPP_NAME);
        }
        return prefStore.getString(WEBAPP_NAME);
    }

    public static void setWebAppName(String configId, String name) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + WEBAPP_NAME, name);
    }

    public static void removeWebAppName(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + WEBAPP_NAME);
    }

    public static String getConfigPrefPrefix(String configId) {
        return String.valueOf(configId) + ".";
    }

    public static boolean getConfigPrefInitialized(String configId) {
        return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INITIALIZED);
    }

    public static void setConfigPrefInitialized(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INITIALIZED, value);
    }

    public static void removeConfigPrefInitialized(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + INITIALIZED);
    }

    public static boolean getShowRelatedDescriptors(String configId) {
        return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_DESCRIPTORS);
    }

    public static void setShowRelatedDescriptors(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_DESCRIPTORS, value);
    }

    public static void removeShowRelatedDescriptors(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_DESCRIPTORS);
    }

    public static boolean getShowRelatedLinks(String configId) {
        return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_LINKS);
    }

    public static void setShowRelatedLinks(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_LINKS, value);
    }

    public static void removeShowRelatedLinks(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_LINKS);
    }

    public static boolean getShowRelatedDescriptorsOption(String configId) {
        return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_DESCRIPTORS_OPTION);
    }

    public static void setShowRelatedDescriptorsOption(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_DESCRIPTORS_OPTION, value);
    }

    public static void removeShowRelatedDescriptorsOption(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_RELATED_DESCRIPTORS_OPTION);
    }

    public static boolean getShowDescriptorsInNavigationTree(String configId) {
        return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_DESCRIPTORS_IN_NAVIGATIONTREE);
    }

    public static void setShowDescriptorsInNavigationTree(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_DESCRIPTORS_IN_NAVIGATIONTREE, value);
    }

    public static void removeShowDescriptorsInNavigationTree(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_DESCRIPTORS_IN_NAVIGATIONTREE);
    }

    public static String getDefaultActivityTab(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getString(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + DEFAULT_ACTIVITY_TAB);
        }
        return prefStore.getString(DEFAULT_ACTIVITY_TAB);
    }

    public static void setDefaultActivityTab(String configId, String tabName) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + DEFAULT_ACTIVITY_TAB, tabName);
    }

    public static void setShowLinkedElementForDescriptor(String configId, boolean value) {
        prefStore.setValue(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR, value);
    }

    public static boolean getShowLinkedElementForDescriptor(String configId) {
        if (PublishingUIPreferences.getConfigPrefInitialized(configId)) {
            return prefStore.getBoolean(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR);
        }
        return prefStore.getBoolean(SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR);
    }

    public static void removeShowLinkedElementForDescriptor(String configId) {
        prefStore.setToDefault(String.valueOf(PublishingUIPreferences.getConfigPrefPrefix(configId)) + SHOW_LINKED_ELEMENT_FOR_DESCRIPTOR);
    }

    public static void saveAllPreferences() {
        PublishingUIPlugin.getDefault().savePluginPreferences();
    }
}

