/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RoleDiagramPreferencePage
extends BasePreferencePage
implements ModifyListener {
    private static int MIN_HORIZONTAL_SPACING = 50;
    private static int MAX_HORIZONTAL_SPACING = 200;
    private static int MIN_VERTICAL_SPACING = 25;
    private static int MAX_VERTICAL_SPACING = 100;
    private static int MIN_TEXT_LINES = 1;
    private static int MAX_TEXT_LINES = 5;
    private Composite composite;
    private Text horizonalSpacingText;
    private Text verticalSpacingText;
    private Text textLinesText;

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group elementSpacingGroup = RoleDiagramPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.elementSpacingGroup_text, (int)2);
        RoleDiagramPreferencePage.createLabel((Composite)elementSpacingGroup, (String)PublishingUIResources.tasksHorizonalSpacingLabel_text);
        this.horizonalSpacingText = RoleDiagramPreferencePage.createEditableText((Composite)elementSpacingGroup, (String)"", (int)25);
        RoleDiagramPreferencePage.createLabel((Composite)elementSpacingGroup, (String)PublishingUIResources.tasksVerticalSpacingLabel_text);
        this.verticalSpacingText = RoleDiagramPreferencePage.createEditableText((Composite)elementSpacingGroup, (String)"", (int)25);
        Group elementTextLabelGroup = RoleDiagramPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.elementTextLabelGroup_text, (int)2);
        RoleDiagramPreferencePage.createLabel((Composite)elementTextLabelGroup, (String)PublishingUIResources.maxLineOfTextLabel_text);
        this.textLinesText = RoleDiagramPreferencePage.createEditableText((Composite)elementTextLabelGroup, (String)"", (int)15);
        this.initControls();
        this.addListeners();
        return this.composite;
    }

    protected void initControls() {
        this.horizonalSpacingText.setText(String.valueOf(LibraryPreferences.getRoleDiagramHorizontalSpacing()));
        this.verticalSpacingText.setText(String.valueOf(LibraryPreferences.getRoleDiagramVerticalSpacing()));
        this.textLinesText.setText(String.valueOf(LibraryPreferences.getRoleDiagramMaximumTextLines()));
    }

    protected void addListeners() {
        this.horizonalSpacingText.addModifyListener((ModifyListener)this);
        this.verticalSpacingText.addModifyListener((ModifyListener)this);
        this.textLinesText.addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent e) {
        this.setErrorMessage(null);
        this.setValid(true);
        int value = 0;
        if (e.widget == this.horizonalSpacingText) {
            value = this.getHorizontalSpacing();
            if (value < MIN_HORIZONTAL_SPACING || value > MAX_HORIZONTAL_SPACING) {
                this.setErrorMessage(PublishingUIResources.bind((String)PublishingUIResources.invalidHorizonalSpacingError_msg, (Object[])new Object[]{new Integer(MIN_HORIZONTAL_SPACING), new Integer(MAX_HORIZONTAL_SPACING)}));
                this.setValid(false);
            }
        } else if (e.widget == this.verticalSpacingText) {
            value = this.getVerticalSpacing();
            if (value < MIN_VERTICAL_SPACING || value > MAX_VERTICAL_SPACING) {
                this.setErrorMessage(PublishingUIResources.bind((String)PublishingUIResources.invalidVerticalSpacingError_msg, (Object[])new Object[]{new Integer(MIN_VERTICAL_SPACING), new Integer(MAX_VERTICAL_SPACING)}));
                this.setValid(false);
            }
        } else if (e.widget == this.textLinesText && ((value = this.getMaximumTextLines()) < MIN_TEXT_LINES || value > MAX_TEXT_LINES)) {
            this.setErrorMessage(PublishingUIResources.bind((String)PublishingUIResources.invalidTextLinesError_msg, (Object[])new Object[]{new Integer(MIN_TEXT_LINES), new Integer(MAX_TEXT_LINES)}));
            this.setValid(false);
        }
        this.updateApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.horizonalSpacingText.setText("" + LibraryPreferences.getDefaultRoleDiagramHorizontalSpacing());
        this.verticalSpacingText.setText("" + LibraryPreferences.getDefaultRoleDiagramVerticalSpacing());
        this.textLinesText.setText("" + LibraryPreferences.getDefaultRoleDiagramMaximumTextLines());
    }

    public boolean performOk() {
        LibraryPreferences.setRoleDiagramHorizontalSpacing((int)this.getHorizontalSpacing());
        LibraryPreferences.setRoleDiagramVerticalSpacing((int)this.getVerticalSpacing());
        LibraryPreferences.setRoleDiagramMaximumTextLines((int)this.getMaximumTextLines());
        return true;
    }

    protected int getHorizontalSpacing() {
        return StrUtil.getIntValue((String)this.horizonalSpacingText.getText().trim(), (int)0);
    }

    protected int getVerticalSpacing() {
        return StrUtil.getIntValue((String)this.verticalSpacingText.getText().trim(), (int)0);
    }

    protected int getMaximumTextLines() {
        return StrUtil.getIntValue((String)this.textLinesText.getText().trim(), (int)0);
    }
}

