/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.edit.ui.UIHelper;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.publishing.ui.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.publishing.ui.wizards.PublishingOperation;
import org.eclipse.epf.publishing.ui.wizards.SelectConfigPage;
import org.eclipse.epf.publishing.ui.wizards.SelectContentPage;
import org.eclipse.epf.publishing.ui.wizards.SelectDestinationPage;
import org.eclipse.epf.publishing.ui.wizards.SelectPublishingOptionsPage;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PublishConfigWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = PublishConfigWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.publishing.ui.publishConfigWizard";
    protected SelectConfigPage selectConfigPage;
    protected SelectContentPage selectContentPage;
    protected SelectPublishingOptionsPage selectPublishingOptionsPage;
    protected SelectDestinationPage selectDestinationPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(PublishingUIResources.publishConfigWizard_title);
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.selectConfigPage = new SelectConfigPage();
            this.selectContentPage = new SelectContentPage();
            this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
            this.selectDestinationPage = new SelectDestinationPage();
            super.addPage((IWizardPage)this.selectConfigPage);
            super.addPage((IWizardPage)this.selectContentPage);
            super.addPage((IWizardPage)this.selectPublishingOptionsPage);
            super.addPage((IWizardPage)this.selectDestinationPage);
        } else {
            ArrayList<Object> wizardPages = new ArrayList<Object>();
            IWizardPage page = this.wizardExtender.getReplaceWizardPage(SelectConfigPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectConfigPage = new SelectConfigPage();
                wizardPages.add((Object)this.selectConfigPage);
            }
            page = this.wizardExtender.getReplaceWizardPage(SelectContentPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectContentPage = new SelectContentPage();
                wizardPages.add((Object)this.selectContentPage);
            }
            page = this.wizardExtender.getReplaceWizardPage(SelectPublishingOptionsPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
                wizardPages.add((Object)this.selectPublishingOptionsPage);
            }
            page = this.wizardExtender.getReplaceWizardPage(SelectDestinationPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectDestinationPage = new SelectDestinationPage();
                wizardPages.add((Object)this.selectDestinationPage);
            }
            super.getNewWizardPages(wizardPages);
            for (IWizardPage iWizardPage : wizardPages) {
                super.addPage(iWizardPage);
            }
            this.wizardExtender.initWizardPages(wizardPages);
        }
    }

    public IWizardPage getStartingPage() {
        IWizardPage page;
        IWizardPage iWizardPage = page = this.wizardExtender == null ? null : this.wizardExtender.getStartingPage();
        if (page != null) {
            return page;
        }
        return super.getStartingPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = null;
        nextPage = this.wizardExtender != null ? this.wizardExtender.getNextPage(page) : super.getNextPage(page);
        return nextPage;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodConfiguration.gif"));
    }

    public boolean performFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.doFinish();
        }
        PublishManager publisher = new PublishManager();
        boolean success = this.publishConfig(this.selectConfigPage.getSelectedConfig(), this.getPublishingOptions(), publisher);
        if (publisher != null) {
            publisher.dispose();
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean publishConfig(MethodConfiguration config, PublishOptions options, PublishManager publisher) {
        LibraryUtil.ConfigAndPlugin tempConfigAndPlugin;
        block17: {
            boolean bl;
            block16: {
                tempConfigAndPlugin = null;
                try {
                    if (this.checkAndCreateDir(options)) {
                        MethodConfiguration realConfig = config;
                        if (UmaUtil.getMethodLibrary((EObject)config) == null && options.isPublishProcess() && (tempConfigAndPlugin = LibraryUtil.addTempConfigAndPluginToCurrentLibrary((List)options.getProcesses())) != null && tempConfigAndPlugin.config != null) {
                            realConfig = tempConfigAndPlugin.config;
                        }
                        publisher.init(options.getPublishDir(), realConfig, options);
                        PublishingOperation operation = new PublishingOperation((AbstractPublishManager)publisher);
                        PublishProgressMonitorDialog dlg = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), publisher.getViewBuilder());
                        UIHelper.runWithProgress((IRunnableWithProgress)operation, (IRunnableContext)dlg, (boolean)true, (String)PublishingUIResources.publishConfigWizard_title);
                        bl = !publisher.getViewBuilder().isCanceled();
                        LibraryUtil.removeTempConfigAndPluginFromCurrentLibrary((LibraryUtil.ConfigAndPlugin)tempConfigAndPlugin);
                        if (this.selectPublishingOptionsPage != null) {
                            this.selectPublishingOptionsPage.savePreferences();
                        }
                        if (this.selectDestinationPage != null) {
                            this.selectDestinationPage.savePreferences();
                        }
                        if (this.selectContentPage != null) {
                            this.selectContentPage.savePreferences();
                        }
                        break block16;
                    }
                    LibraryUtil.removeTempConfigAndPluginFromCurrentLibrary(tempConfigAndPlugin);
                    break block17;
                }
                catch (Exception e) {
                    PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigWizard_title, PublishingUIResources.publishConfigError_msg, PublishingUIResources.publishConfigError_reason, (Throwable)e);
                    return true;
                }
            }
            String configId = config.getGuid();
            PublishingUIPreferences.setConfigPrefInitialized(configId, true);
            PublishingUIPreferences.saveAllPreferences();
            return bl;
        }
        if (this.selectPublishingOptionsPage != null) {
            this.selectPublishingOptionsPage.savePreferences();
        }
        if (this.selectDestinationPage != null) {
            this.selectDestinationPage.savePreferences();
        }
        if (this.selectContentPage != null) {
            this.selectContentPage.savePreferences();
        }
        String configId = config.getGuid();
        PublishingUIPreferences.setConfigPrefInitialized(configId, true);
        PublishingUIPreferences.saveAllPreferences();
        return false;
        finally {
            LibraryUtil.removeTempConfigAndPluginFromCurrentLibrary(tempConfigAndPlugin);
            if (this.selectPublishingOptionsPage != null) {
                this.selectPublishingOptionsPage.savePreferences();
            }
            if (this.selectDestinationPage != null) {
                this.selectDestinationPage.savePreferences();
            }
            if (this.selectContentPage != null) {
                this.selectContentPage.savePreferences();
            }
            configId = config.getGuid();
            PublishingUIPreferences.setConfigPrefInitialized(configId, true);
            PublishingUIPreferences.saveAllPreferences();
        }
    }

    public PublishOptions getPublishingOptions() {
        PublishOptions options = this.selectPublishingOptionsPage != null ? this.selectPublishingOptionsPage.getPublishingOptions() : new PublishOptions();
        if (this.selectContentPage != null) {
            boolean publishConfig = this.selectContentPage.getPublishConfigSelection();
            options.setPublishConfiguration(publishConfig);
            options.setPublishProcess(!publishConfig);
            if (!publishConfig) {
                options.setProcesses(this.selectContentPage.getSelectedProcesses());
            }
        }
        if (this.selectDestinationPage != null) {
            options.setPublishDir(this.selectDestinationPage.getPublishDirectory());
            if (!this.selectDestinationPage.getStaticWebSiteSelection() && options instanceof PublishHTMLOptions) {
                PublishHTMLOptions htmlOptions = (PublishHTMLOptions)options;
                htmlOptions.setPublishDynamicWebApp(true);
                htmlOptions.setDynamicWebAppName(this.selectDestinationPage.getWebAppName());
                htmlOptions.setIncludeServletSearch(this.selectDestinationPage.getIncludeSearchSelection());
            }
        }
        return options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkAndCreateDir(PublishOptions options) {
        File file;
        String dir = options.getPublishDir();
        String defaultPublishPath = PublishingUIPreferences.getDefaultPublishPath();
        boolean answer = false;
        IPath ecPath = Path.fromOSString((String)dir);
        if (!ecPath.isAbsolute()) {
            String path = String.valueOf(defaultPublishPath) + System.getProperty("file.separator") + dir;
            answer = PublishingUIPlugin.getDefault().getMsgDialog().displayPrompt(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.bind((String)PublishingUIResources.confirmPathDialog_text, (Object)path));
            if (!answer) return false;
            options.setPublishDir(dir);
        }
        if ((file = new File(dir)).exists()) {
            File[] files = file.listFiles();
            if (files == null || files.length <= 0) return true;
            boolean bl = answer = CommandLineRunUtil.getInstance().isNeedToRun() ? true : PublishingUIPlugin.getDefault().getMsgDialog().displayConfirmation(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.bind((String)PublishingUIResources.overwriteDialog_text, (Object)dir));
            if (!answer) return answer;
            try {
                answer = FileUtil.deleteAllFiles((String)file.getAbsolutePath());
                if (answer) return answer;
                PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.deleteFilesError_reason, (Object)dir));
                return false;
            }
            catch (Exception e) {
                PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.deleteFilesError_reason, (Object)dir), (Throwable)e);
                return false;
            }
        }
        try {
            answer = file.mkdirs();
        }
        catch (Exception e) {
            PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.createDirError_reason, (Object)file.getAbsolutePath()), (Throwable)e);
            return false;
        }
        if (answer) return answer;
        PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.createDirError_reason, (Object)file.getAbsolutePath()));
        return false;
    }
}

