/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import org.eclipse.epf.authoring.gef.viewer.ActivityDiagramService;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PublishProgressMonitorDialog
extends ProgressMonitorDialog {
    private Composite diagramViewerHolder;
    private AbstractViewBuilder viewBuilder;

    public PublishProgressMonitorDialog(Shell parent, AbstractViewBuilder viewBuilder) {
        super(parent);
        this.viewBuilder = viewBuilder;
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        if (this.viewBuilder != null) {
            this.diagramViewerHolder = new Composite(parent, 0);
            this.diagramViewerHolder.setLayoutData((Object)new GridData(1, 1));
            this.diagramViewerHolder.setLayout((Layout)new GridLayout());
            this.diagramViewerHolder.setVisible(false);
            ElementLayoutManager layoutMgr = this.viewBuilder.getLayoutMgr();
            String newDiagrams = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("PUBLISH_NEW_DIAGRAM");
            Boolean newDiagram = new Boolean(true);
            if (newDiagrams != null && newDiagrams.length() > 0) {
                newDiagram = new Boolean(newDiagrams);
            }
            if (newDiagram.booleanValue()) {
                DiagramImageService diagramService = new DiagramImageService(this.diagramViewerHolder, new File(layoutMgr.getPublishDir()));
                diagramService.setConfig(layoutMgr.getConfiguration());
                diagramService.setPublishedUnCreatedADD(this.viewBuilder.getOptions().isPublishUnopenADD());
                diagramService.setPublishADForActivityExtension(this.viewBuilder.getOptions().isPublishBaseAD());
                layoutMgr.setActivityDiagramService((IActivityDiagramService)diagramService);
            } else {
                ActivityDiagramService diagramService = new ActivityDiagramService(this.diagramViewerHolder, new File(layoutMgr.getPublishDir()));
                diagramService.setPublishedUnCreatedADD(this.viewBuilder.getOptions().isPublishUnopenADD());
                diagramService.setPublishADForActivityExtension(this.viewBuilder.getOptions().isPublishBaseAD());
                layoutMgr.setActivityDiagramService((IActivityDiagramService)diagramService);
            }
        }
        return ctrl;
    }

    public boolean close() {
        this.viewBuilder = null;
        return super.close();
    }
}

