/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class PublishingOperation
implements IRunnableWithProgress,
org.eclipse.epf.library.edit.util.IRunnableWithProgress {
    private static final String PUBLISH_CONFIG_ERROR_TITLE = PublishingUIResources.publishConfigDialog_title;
    private static final String PUBLISH_CONFIG_ERROR_MSG = PublishingUIResources.publishConfigError_msg;
    private static final String PUBLISH_CONFIG_ERROR_REASON = PublishingUIResources.publishConfigError_reason;
    private static final String PREVIEW_CONFIG_ERROR_TITLE = PublishingUIResources.previewConfigError_title;
    private static final String PREVIEW_CONFIG_ERROR_MSG = PublishingUIResources.previewConfigError_msg;
    private static final String VIEW_REPORT_ERROR_TITLE = PublishingUIResources.viewReportError_title;
    private static final String VIEW_REPORT_ERROR_MSG = PublishingUIResources.viewReportError_msg;
    private static final String OPEN_BROWSER_ERROR_REASON = PublishingUIResources.openBrowserError_reason;
    private static final String PUBLISH_CONFIG_CANCEL_MSG = PublishingUIResources.cancelPublishConfig_msg;
    private AbstractPublishManager publishMgr;
    private String published_url;
    private String report_url;
    private MsgDialog msgDialog;
    private Exception runException;

    public PublishingOperation(AbstractPublishManager publishMgr) {
        this.publishMgr = publishMgr;
        this.msgDialog = PublishingUIPlugin.getDefault().getMsgDialog();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.publishMgr.getViewBuilder();
    }

    public String getPublishedUrl() {
        return this.published_url;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this._runIt(monitor);
        }
        finally {
            this.publishMgr = null;
            this.msgDialog = null;
        }
    }

    private void _runIt(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.runException = null;
        try {
            monitor.setTaskName(PublishingResources.publishingConfigurationTask_name);
            this.publishMgr.publish(monitor);
            this.publishMgr.getViewBuilder().setCanceled(monitor.isCanceled());
            this.published_url = this.publishMgr.getPublishedUrl();
            this.report_url = this.publishMgr.getPublishReportUrl();
        }
        catch (Exception e) {
            this.runException = e;
        }
        final boolean canceled = monitor.isCanceled();
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String reason;
                if (canceled) {
                    PublishingOperation.this.msgDialog.displayInfo(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_CANCEL_MSG);
                    return;
                }
                if (PublishingOperation.this.report_url == null) {
                    PublishingOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishingOperation.this.runException);
                    return;
                }
                PublishOptions options = PublishingOperation.this.publishMgr.getViewBuilder().getOptions();
                boolean toOpenPublishedUri = false;
                if (options instanceof PublishHTMLOptions && !((PublishHTMLOptions)options).isPublishDynamicWebApp()) {
                    toOpenPublishedUri = true;
                    if (PublishingOperation.this.published_url == null) {
                        PublishingOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishingOperation.this.runException);
                        return;
                    }
                }
                if (toOpenPublishedUri && !PublishingOperation.this.openBrowser(PublishingOperation.this.published_url)) {
                    reason = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.published_url);
                    PublishingOperation.this.msgDialog.displayError(PREVIEW_CONFIG_ERROR_TITLE, PREVIEW_CONFIG_ERROR_MSG, reason);
                }
                if (!PublishingOperation.this.openSWTBrowser(PublishingOperation.this.report_url)) {
                    reason = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.report_url);
                    PublishingOperation.this.msgDialog.displayError(VIEW_REPORT_ERROR_TITLE, VIEW_REPORT_ERROR_MSG, reason);
                }
            }
        });
    }

    public boolean openSWTBrowser(String urlString) {
        boolean success = false;
        try {
            Shell shell = new Shell(Display.getDefault(), 1264);
            shell.setText(urlString);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            shell.setLayout((Layout)layout);
            Browser popup_browser = new Browser((Composite)shell, 0);
            popup_browser.setLayoutData((Object)new GridData(4, 4, true, true));
            popup_browser.setUrl(urlString);
            shell.open();
            success = true;
        }
        catch (Exception ex) {
            PublishingUIPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        return success;
    }

    public boolean openBrowser(String urlString) {
        boolean success;
        block7: {
            success = false;
            try {
                if (SWT.getPlatform().equals("win32")) {
                    success = Program.launch((String)urlString);
                    break block7;
                }
                success = true;
                IWebBrowser browser = null;
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    browser = browserSupport.getExternalBrowser();
                    if (browser != null) {
                        URL url = new File(urlString).toURL();
                        browser.openURL(url);
                    }
                }
                catch (PartInitException ex) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                }
                catch (MalformedURLException ex) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                }
            }
            catch (Exception e) {
                PublishingUIPlugin.getDefault().getLogger().logError((Throwable)e);
                success = false;
            }
        }
        return success;
    }
}

