/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.views.ProcessTreeContentProvider;
import org.eclipse.epf.library.ui.views.ProcessTreeLabelProvider;
import org.eclipse.epf.library.ui.views.ProcessTreeUIFolder;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.publishing.ui.wizards.ConfigFreeProcessPublishUtil;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectContentPage
extends BaseWizardPage
implements Listener {
    public static final String PAGE_NAME = SelectContentPage.class.getName();
    protected Button publishConfigRadioButton;
    protected Button publishProcessesRadioButton;
    protected CheckboxTreeViewer processViewer;
    protected Button includeBaseProcessesCheckbox;
    protected MethodConfiguration config;

    public SelectContentPage() {
        super(PAGE_NAME);
        this.setTitle(PublishingUIResources.selectContentWizardPage_title);
        this.setDescription(PublishingUIResources.selectContentWizardPage_text);
        this.setImageDescriptor(PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = SelectContentPage.createGridLayoutComposite((Composite)parent, (int)1);
        this.publishConfigRadioButton = SelectContentPage.createRadioButton((Composite)composite, (String)PublishingUIResources.publishConfigRadioButton_text, (int)1, (boolean)true);
        this.publishProcessesRadioButton = SelectContentPage.createRadioButton((Composite)composite, (String)PublishingUIResources.publishProcessesRadioButton_text, (int)1, (boolean)false);
        Composite processComposite = SelectContentPage.createChildGridLayoutComposite((Composite)composite, (int)1);
        this.processViewer = new CheckboxTreeViewer(processComposite);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.processViewer.getTree().setLayoutData((Object)gridData);
        this.processViewer.setLabelProvider((IBaseLabelProvider)new ProcessTreeLabelProvider());
        this.includeBaseProcessesCheckbox = SelectContentPage.createCheckbox((Composite)processComposite, (String)PublishingUIResources.includeBaseProcessesCheckboxLabel_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite);
    }

    protected void initControls() {
        String configId;
        String string = configId = this.config != null ? this.config.getGuid() : "";
        if (this.config != null && ConfigFreeProcessPublishUtil.getInstance().isSameMethodConfiguration(this.config)) {
            this.processViewer.setContentProvider((IContentProvider)new ProcessViewerOfConfigFreeContentProvider());
            this.publishConfigRadioButton.setEnabled(false);
            this.publishConfigRadioButton.setSelection(false);
            this.publishProcessesRadioButton.setSelection(true);
            this.processViewer.getControl().setEnabled(true);
            List<String> processIds = PublishingUIPreferences.getProcesses(configId);
            ArrayList<Process> processes = new ArrayList<Process>();
            if (processIds != null) {
                for (String guid : processIds) {
                    MethodElement e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                    if (!(e instanceof Process)) continue;
                    processes.add((Process)e);
                }
            }
            this.processViewer.setCheckedElements(processes.toArray());
            boolean includeBaseProcess = PublishingUIPreferences.getIncludeBaseProcesses(configId);
            this.includeBaseProcessesCheckbox.setSelection(includeBaseProcess);
            this.updateCheckedStates();
        } else {
            this.processViewer.setContentProvider((IContentProvider)new ProcessViewerContentProvider());
            boolean publishConfig = PublishingUIPreferences.getPublishEntireConfig(configId);
            this.publishConfigRadioButton.setEnabled(true);
            this.publishConfigRadioButton.setSelection(publishConfig);
            this.publishProcessesRadioButton.setSelection(!publishConfig);
            this.processViewer.getControl().setEnabled(!publishConfig);
            if (!publishConfig) {
                List<String> processIds = PublishingUIPreferences.getProcesses(configId);
                ArrayList<Process> processes = new ArrayList<Process>();
                if (processIds != null) {
                    for (String guid : processIds) {
                        MethodElement e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                        if (!(e instanceof Process)) continue;
                        processes.add((Process)e);
                    }
                }
                this.processViewer.setCheckedElements(processes.toArray());
            }
            boolean includeBaseProcess = PublishingUIPreferences.getIncludeBaseProcesses(configId);
            this.includeBaseProcessesCheckbox.setSelection(includeBaseProcess);
            this.updateCheckedStates();
        }
    }

    protected void addListeners() {
        this.publishConfigRadioButton.addListener(13, (Listener)this);
        this.publishProcessesRadioButton.addListener(13, (Listener)this);
        this.includeBaseProcessesCheckbox.addListener(13, (Listener)this);
        this.processViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object checkedElement = event.getElement();
                boolean checked = event.getChecked();
                SelectContentPage.this.processViewer.setChecked(checkedElement, checked);
                SelectContentPage.this.processViewer.setSubtreeChecked(checkedElement, checked);
                if (SelectContentPage.this.includeBaseProcessesCheckbox.getSelection()) {
                    SelectContentPage.this.selectBaseProcesses();
                }
                SelectContentPage.this.updateCheckedStates();
                SelectContentPage.this.setPageComplete(SelectContentPage.this.isPageComplete());
            }
        });
    }

    private void updateCheckedStates() {
        ITreeContentProvider cp = (ITreeContentProvider)this.processViewer.getContentProvider();
        if (this.config != null) {
            Object[] plugins = null;
            plugins = ConfigFreeProcessPublishUtil.getInstance().isSameMethodConfiguration(this.config) ? cp.getChildren((Object)LibraryService.getInstance().getCurrentMethodLibrary()) : cp.getChildren((Object)this.config);
            int i = 0;
            while (i < plugins.length) {
                Object[] uiFolders = cp.getChildren(plugins[i]);
                int totalUIFolders = uiFolders.length;
                int checkedUIFolders = 0;
                int j = 0;
                while (j < uiFolders.length) {
                    Object[] processes = cp.getChildren(uiFolders[j]);
                    int totalProcesses = processes.length;
                    int checkedProcesses = 0;
                    int k = 0;
                    while (k < processes.length) {
                        if (this.processViewer.getChecked(processes[k])) {
                            ++checkedProcesses;
                        }
                        ++k;
                    }
                    if (checkedProcesses == 0) {
                        this.processViewer.setGrayChecked(uiFolders[j], false);
                    } else if (checkedProcesses == totalProcesses) {
                        this.processViewer.setGrayed(uiFolders[j], false);
                        this.processViewer.setChecked(uiFolders[j], true);
                    } else {
                        this.processViewer.setGrayChecked(uiFolders[j], true);
                    }
                    if (this.processViewer.getChecked(uiFolders[j])) {
                        ++checkedUIFolders;
                    }
                    ++j;
                }
                if (checkedUIFolders == totalUIFolders) {
                    this.processViewer.setGrayed(plugins[i], false);
                    this.processViewer.setChecked(plugins[i], true);
                } else if (checkedUIFolders == 0) {
                    this.processViewer.setGrayChecked(plugins[i], false);
                } else {
                    this.processViewer.setGrayChecked(plugins[i], true);
                }
                ++i;
            }
        }
    }

    private void selectBaseProcesses() {
        List<Process> processes = this.getSelectedProcesses();
        ArrayList baseProcesses = new ArrayList();
        Iterator<Object> it = processes.iterator();
        while (it.hasNext()) {
            ConfigurationHelper.getBaseProcesses((Activity)((Activity)it.next()), (MethodConfiguration)this.config, baseProcesses);
        }
        for (Object element : baseProcesses) {
            this.processViewer.setChecked(element, true);
        }
    }

    public void handleEvent(Event event) {
        this.processViewer.getControl().setEnabled(this.publishProcessesRadioButton.getSelection());
        if (event.widget == this.includeBaseProcessesCheckbox) {
            this.selectBaseProcesses();
            this.updateCheckedStates();
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void onEnterPage(Object obj) {
        if (obj != null && obj instanceof String) {
            String configName = (String)obj;
            this.config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
            if (this.config != null) {
                this.processViewer.setInput((Object)this.config);
                this.initControls();
                this.processViewer.expandAll();
            } else {
                this.config = ConfigFreeProcessPublishUtil.getInstance().getMethodConfigurationForConfigFreeProcess();
                this.processViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
                this.initControls();
                this.processViewer.expandAll();
            }
        }
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.publishConfigRadioButton.getSelection()) {
            return true;
        }
        return this.getSelectedProcesses().size() > 0;
    }

    public Object getNextPageData() {
        return this.config;
    }

    public boolean getPublishConfigSelection() {
        return this.publishConfigRadioButton.getSelection();
    }

    public List<Process> getSelectedProcesses() {
        ArrayList<Process> processes = new ArrayList<Process>();
        Object[] selected = this.processViewer.getCheckedElements();
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (selected[i] instanceof Process) {
                    processes.add((Process)selected[i]);
                }
                ++i;
            }
        }
        return processes;
    }

    public void savePreferences() {
        if (this.config != null) {
            String configId = this.config.getGuid();
            boolean publishConfig = this.publishConfigRadioButton.getSelection();
            PublishingUIPreferences.setPublishEntireConfig(configId, publishConfig);
            if (publishConfig) {
                ArrayList<String> processIds = new ArrayList<String>();
                PublishingUIPreferences.setProcesses(configId, processIds);
            } else {
                ArrayList<String> processIds = new ArrayList<String>();
                for (Process process : this.getSelectedProcesses()) {
                    processIds.add(process.getGuid());
                }
                PublishingUIPreferences.setProcesses(configId, processIds);
            }
            PublishingUIPreferences.setIncludeBaseProcesses(configId, this.includeBaseProcessesCheckbox.getSelection());
        }
    }

    protected class ProcessViewerContentProvider
    extends ProcessTreeContentProvider {
        private List<MethodPackage> packages = new ArrayList<MethodPackage>();

        protected ProcessViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MethodConfiguration) {
                MethodConfiguration config = (MethodConfiguration)parentElement;
                ArrayList<MethodPlugin> children = new ArrayList<MethodPlugin>();
                this.packages = config.getMethodPackageSelection();
                List plugins = config.getMethodPluginSelection();
                for (MethodPlugin plugin : plugins) {
                    List processes = TngUtil.getAllProcesses((MethodPlugin)plugin);
                    if (processes.size() <= 0) continue;
                    children.add(plugin);
                }
                return children.toArray();
            }
            if (parentElement instanceof ProcessTreeUIFolder) {
                ProcessTreeUIFolder uiFolder = (ProcessTreeUIFolder)parentElement;
                MethodPlugin plugin = (MethodPlugin)uiFolder.getParent();
                if (uiFolder.getName() == CAPABILITY_PATTERNS) {
                    ArrayList<CapabilityPattern> selectedCapabilityPatterns = new ArrayList<CapabilityPattern>();
                    List capabilityPatterns = LibraryServiceUtil.getCapabilityPatterns((MethodPlugin)plugin);
                    for (CapabilityPattern cp : capabilityPatterns) {
                        ProcessPackage pkg = UmaUtil.getProcessPackage((EObject)cp);
                        if (!this.packages.contains(pkg)) continue;
                        selectedCapabilityPatterns.add(cp);
                    }
                    return selectedCapabilityPatterns.toArray();
                }
                ArrayList<DeliveryProcess> selectedDeliveryProcesses = new ArrayList<DeliveryProcess>();
                List deliveryProcesses = LibraryServiceUtil.getDeliveryProcesses((MethodPlugin)plugin);
                for (DeliveryProcess dp : deliveryProcesses) {
                    ProcessPackage pkg = UmaUtil.getProcessPackage((EObject)dp);
                    if (!this.packages.contains(pkg)) continue;
                    selectedDeliveryProcesses.add(dp);
                }
                return selectedDeliveryProcesses.toArray();
            }
            return super.getChildren(parentElement);
        }
    }

    protected class ProcessViewerOfConfigFreeContentProvider
    extends ProcessTreeContentProvider {
        protected ProcessViewerOfConfigFreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProcessTreeUIFolder) {
                Object[] children;
                ArrayList<Process> processes = new ArrayList<Process>();
                Object[] objectArray = children = super.getChildren(parentElement);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Process) {
                        Process process = (Process)obj;
                        if (ProcessScopeUtil.getInstance().isConfigFree(process)) {
                            processes.add(process);
                        }
                    }
                    ++n2;
                }
                return processes.toArray();
            }
            return super.getChildren(parentElement);
        }
    }
}

