/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp.ui;

import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.rcp.ui.MainActionBarAdvisor;
import org.eclipse.epf.rcp.ui.RCPUIPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.menus.CommandContributionItem;

public class MainWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    protected static String[] fileMenuRemovalList = new String[]{"org.eclipse.ui.openLocalFile", "org.eclipse.ui.edit.text.newTextEditor", "org.eclipse.ui.edit.text.openExternalFile", "converstLineDelimitersTo"};
    protected MainActionBarAdvisor mainActionBar;
    private static final String ANNOTATIONNAVIGATION_ID = "org.eclipse.ui.edit.text.actionSet.annotationNavigation";
    private static final String WORKINGSETACTIONSET_ID = "org.eclipse.ui.WorkingSetActionSet";
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            LibraryUIManager.setConfigurer((IWorkbenchWindowConfigurer)MainWorkbenchWindowAdvisor.this.getWindowConfigurer());
            LibraryUIManager.getInstance().checkConfigurationContribution();
            LibraryUIManager.getInstance().startupOpenLibrary();
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            page.hideActionSet(MainWorkbenchWindowAdvisor.WORKINGSETACTIONSET_ID);
            page.hideActionSet(MainWorkbenchWindowAdvisor.ANNOTATIONNAVIGATION_ID);
        }
    };

    public MainWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.mainActionBar = new MainActionBarAdvisor(configurer);
        return this.mainActionBar;
    }

    public void postWindowCreate() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Object data = configurer.getData("isRestoredWorkbench");
        if (data == null) {
            configurer.getWindow().getShell().setLocation(30, 30);
            configurer.getWindow().getShell().setSize(1024, 760);
        }
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(RCPUIPlugin.getDefault().getString("productName"));
    }

    public void postWindowOpen() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.getWindow().getShell().setImage(RCPUIPlugin.getDefault().getSharedImage("full/obj16/product.gif"));
        MenuManager fileMmenu = this.mainActionBar.getFileMenuManager();
        IContributionItem[] items = fileMmenu.getItems();
        int i = 0;
        while (i < items.length) {
            if (this.needToRemoveFrom(items[i].getId(), fileMenuRemovalList)) {
                fileMmenu.remove(items[i]);
            }
            ++i;
        }
        MenuManager helpMmenu = this.mainActionBar.getHelpMenuManager();
        items = helpMmenu.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            MenuManager item;
            if (items[i2] instanceof MenuManager && (item = (MenuManager)items[i2]).getId().equals("org.eclipse.update.ui.updateMenu")) {
                item.setVisible(false);
            }
            if (items[i2] instanceof CommandContributionItem && ((item = (CommandContributionItem)items[i2]).getId().equals("org.eclipse.equinox.p2.ui.sdk.update") || item.getId().equals("org.eclipse.equinox.p2.ui.sdk.install"))) {
                item.setVisible(false);
            }
            ++i2;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(this.perspectiveListener);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.hideActionSet(WORKINGSETACTIONSET_ID);
        page.hideActionSet(ANNOTATIONNAVIGATION_ID);
    }

    private boolean needToRemoveFrom(String id, String[] list) {
        boolean rc = false;
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(id)) {
                rc = true;
                break;
            }
            ++i;
        }
        return rc;
    }

    public void postWindowRestore() throws WorkbenchException {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setData("isRestoredWorkbench", (Object)"true");
    }

    public void openIntro() {
        super.openIntro();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Object data = configurer.getData("isRestoredWorkbench");
        if (data == null) {
            return;
        }
        IWorkbenchConfigurer wbConfig = this.getWindowConfigurer().getWorkbenchConfigurer();
        IIntroPart introPart = wbConfig.getWorkbench().getIntroManager().getIntro();
        wbConfig.getWorkbench().getIntroManager().setIntroStandby(introPart, true);
        if (!this.isIntroViewExistsInLastSession()) {
            this.closeIntroView();
        }
    }

    private boolean isIntroViewExistsInLastSession() {
        IPreferenceStore store = RCPUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("welcome_intro_view_exists");
    }

    private void closeIntroView() {
        try {
            IViewPart vp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.internal.introview");
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(vp);
        }
        catch (Exception exception) {}
    }
}

