/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.IMethodSearchInputExtension;
import org.eclipse.epf.search.ui.internal.IMethodSearchInputFactory;
import org.eclipse.epf.search.ui.internal.IMethodSearchScopeGroup;
import org.eclipse.epf.search.ui.internal.IMethodSearchScopeGroupFactory;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchQuery;
import org.eclipse.epf.search.ui.internal.MethodSearchScope;
import org.eclipse.epf.search.ui.internal.MethodSearchScopeViewer;
import org.eclipse.epf.search.ui.preferences.SearchUIPreferences;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSearchPage
extends DialogPage
implements ISearchPage {
    public static final String SEARCH_PAGE_ID = MethodSearchPage.class.getName();
    private static List<IMethodSearchInputFactory> searchInputFactories;
    private Combo searchStringCombo;
    private Combo namePatternCombo;
    private Button caseSensitiveCheckbox;
    private MethodSearchScopeViewer searchScopeViewer;
    private ISearchPageContainer container;
    private List<IMethodSearchInputExtension> additionalSearchInputs = new ArrayList<IMethodSearchInputExtension>();

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label searchStringLabel = new Label(composite, 0);
        searchStringLabel.setText(SearchUIResources.searchStringLabel_text);
        new Label(composite, 0);
        this.searchStringCombo = new Combo(composite, 0);
        this.searchStringCombo.setLayoutData((Object)new GridData(768));
        String savedSearchString = SearchUIPreferences.getSearchString();
        if (savedSearchString != null && savedSearchString.length() > 0) {
            this.searchStringCombo.setText(savedSearchString);
        }
        this.caseSensitiveCheckbox = new Button(composite, 32);
        this.caseSensitiveCheckbox.setText(SearchUIResources.caseSensitiveCheckbox_text);
        this.caseSensitiveCheckbox.setSelection(SearchUIPreferences.getCaseSensitive());
        Label elementNameLabel = new Label(composite, 0);
        elementNameLabel.setText(SearchUIResources.elementNameLabel_text);
        new Label(composite, 0);
        this.namePatternCombo = new Combo(composite, 0);
        this.namePatternCombo.setLayoutData((Object)new GridData(768));
        String savedNamePattern = SearchUIPreferences.getNamePattern();
        if (savedNamePattern != null && savedNamePattern.length() > 0) {
            this.namePatternCombo.setText(savedNamePattern);
        }
        this.namePatternCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodSearchPage.this.container.setPerformActionEnabled(MethodSearchPage.this.getSearchButtonEnabled());
            }
        });
        this.namePatternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MethodSearchPage.this.container.setPerformActionEnabled(MethodSearchPage.this.getSearchButtonEnabled());
            }
        });
        new Label(composite, 0);
        this.collectContributedSearchInputs(composite);
        this.searchScopeViewer = this.createSearchScopeGroup(composite).getSearchScopeViewer();
        this.container.setPerformActionEnabled(this.getSearchButtonEnabled());
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private IMethodSearchScopeGroup createSearchScopeGroup(Composite parent) {
        IMethodSearchScopeGroup group;
        Object ext = ExtensionManager.getExtension((String)SearchUIPlugin.getDefault().getId(), (String)"searchScopeGroupFactory");
        if (ext instanceof IMethodSearchScopeGroupFactory && (group = ((IMethodSearchScopeGroupFactory)ext).createSearchScopeGroup(parent)) != null) {
            return group;
        }
        Group searchScopeGroup = new Group(parent, 0);
        searchScopeGroup.setLayout((Layout)new GridLayout(1, false));
        GridData searchScopeGroupGridData = new GridData(1808);
        searchScopeGroupGridData.heightHint = 200;
        searchScopeGroup.setLayoutData((Object)searchScopeGroupGridData);
        searchScopeGroup.setText(SearchUIResources.scopeGroup_text);
        final MethodSearchScopeViewer viewer = new MethodSearchScopeViewer((Composite)searchScopeGroup, 2048);
        return new IMethodSearchScopeGroup(){

            public MethodSearchScopeViewer getSearchScopeViewer() {
                return viewer;
            }
        };
    }

    private static List<IMethodSearchInputFactory> getSearchInputFactories() {
        if (searchInputFactories == null) {
            searchInputFactories = new ArrayList<IMethodSearchInputFactory>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(SearchUIPlugin.getDefault().getId(), "searchInputFactories");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                Object ext = null;
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            String className = configElement.getAttribute("class");
                            if (className != null && (ext = bundle.loadClass(className).newInstance()) instanceof IMethodSearchInputFactory) {
                                searchInputFactories.add(ext);
                            }
                        }
                        catch (Exception e) {
                            SearchUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return searchInputFactories;
    }

    private void collectContributedSearchInputs(Composite parent) {
        for (IMethodSearchInputFactory factory : MethodSearchPage.getSearchInputFactories()) {
            try {
                IMethodSearchInputExtension searchInput = factory.createSearchInput(parent);
                if (searchInput == null) continue;
                this.additionalSearchInputs.add(searchInput);
            }
            catch (Exception e) {
                SearchUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public boolean performAction() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            SearchUIPlugin.getDefault().getMsgDialog().displayError(SearchUIResources.searchError_title, SearchUIResources.searchError_msg, SearchUIResources.searchError_reason);
            return false;
        }
        String searchString = this.searchStringCombo.getText().trim();
        String namePattern = this.namePatternCombo.getText().trim();
        if (StrUtil.isBlank((String)namePattern)) {
            namePattern = "*";
        }
        MethodSearchScope searchScope = this.searchScopeViewer.getSearchScope();
        MethodSearchInput searchInput = new MethodSearchInput(searchString, namePattern, this.caseSensitiveCheckbox.getSelection(), false, false, searchScope);
        if (!this.additionalSearchInputs.isEmpty()) {
            for (IMethodSearchInputExtension input : this.additionalSearchInputs) {
                searchInput.getAdditionalInput().putAll(input.getInput());
            }
        }
        MethodSearchQuery searchQuery = new MethodSearchQuery(searchInput);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
        SearchUIPreferences.setSearchString(this.searchStringCombo.getText());
        SearchUIPreferences.setNamePattern(this.namePatternCombo.getText());
        SearchUIPreferences.setCaseSensitive(this.caseSensitiveCheckbox.getSelection());
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public boolean performReplace() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private boolean getSearchButtonEnabled() {
        return true;
    }
}

